/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CostRecordQFilterHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.formplugin.calculate.in.FeeShareParent;

public class FeeShareQueryPlugin
extends FeeShareParent
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid mentryGrid = (EntryGrid)this.getView().getControl("mentry");
        mentryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid sentryGrid = (EntryGrid)this.getView().getControl("sentry");
        sentryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String key = event.getOperateKey();
        if ("query".equals(key)) {
            this.doQuery();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkEvent) {
        String fieldName = hyperLinkEvent.getFieldName();
        int index = hyperLinkEvent.getRowIndex();
        String billNum = "";
        BillShowParameter showParameter = new BillShowParameter();
        String formId = "";
        if ("me_billnum".equals(fieldName)) {
            billNum = this.getModel().getValue("me_billid", index).toString();
            formId = "ap_finapbill";
        } else {
            billNum = this.getModel().getValue("se_billid", index).toString();
            formId = "cal_costrecord_subentity";
        }
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)billNum);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void doQuery() {
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(true);
        this.bindMainEntryData();
        this.bindAsstEntryData();
    }

    protected QFilter getFilter(String billType, String filterGirdName) {
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"FeeShareQueryPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGirdName);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
        UserService userService = new UserService();
        filterBuilder.setUserService((IUserService)userService);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }

    public DataSet queryMainData() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(this.getFilter("ap_finapbill", "mainfiltergrid"));
        Long calorgId = this.getCalOrg();
        HashSet<Long> orgSet = new HashSet<Long>(16);
        orgSet.add(calorgId);
        String selectFileds = "number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number,bizorgentry.bizorg as ownerid";
        DynamicObjectCollection accountSysColls = AccountingSysHelper.getAccountingSysColls(new ArrayList(orgSet), (String)selectFileds);
        orgSet.clear();
        for (DynamicObject accountSysColl : accountSysColls) {
            orgSet.add(accountSysColl.getLong("ownerid"));
        }
        filters.add(new QFilter("org", "in", orgSet));
        QFilter perFeeFilter = new QFilter("billtypeid", "=", (Object)688848270033699840L);
        QFilter borrowFilter = new QFilter("billtypeid", "=", (Object)535203350950479872L);
        QFilter sourceFilter = new QFilter("sourcebilltype", "=", (Object)"");
        QFilter sourcePurFeeFilter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        filters.add(perFeeFilter.or(borrowFilter.and(sourceFilter.or(sourcePurFeeFilter))));
        filters.add(billStatusFilter);
        QFilter isAlloCateFilter = new QFilter("detailentry.isallocate", "=", (Object)"0");
        filters.add(isAlloCateFilter);
        Set<Object> expenseIdSet = this.getExpenseitemSet();
        QFilter expenseFilter = new QFilter("detailentry.expenseitem", "in", expenseIdSet);
        expenseFilter.or("detailentry.expenseitem", "=", (Object)0L);
        filters.add(expenseFilter);
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "queryMainData"), (String)"ap_finapbill", (String)this.getMainBillFields(), (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private Set<Object> getExpenseitemSet() {
        DynamicObjectCollection itemcol = QueryServiceHelper.query((String)"er_expenseitembill", (String)"expenseitem", (QFilter[])new QFilter("billtype.number", "=", (Object)"cal_costrecord_subentity").toArray());
        HashSet<Object> expenseIdSet = new HashSet<Object>();
        for (DynamicObject item : itemcol) {
            expenseIdSet.add(item.getLong("expenseitem"));
        }
        return expenseIdSet;
    }

    private void loadMainRowData(Row row, int rowIndex) {
        this.getModel().setValue("me_billid", row.get("id"), rowIndex);
        this.getModel().setValue("me_billentryid", row.get("detailentry.id"), rowIndex);
        this.getModel().setValue("me_settleorg", row.get("org"), rowIndex);
        this.getModel().setValue("me_expenseitemid", row.get("detailentry.expenseitem"), rowIndex);
        this.getModel().setValue("me_material", row.get("detailentry.material"), rowIndex);
        this.getModel().setValue("me_billnum", row.get("billno"), rowIndex);
        this.getModel().setValue("me_bizdate", row.get("bizdate"), rowIndex);
        this.getModel().setValue("me_bookdate", row.get("bookdate"), rowIndex);
        if (StringUtils.isNotBlank((Object)row.get("asstacttype"))) {
            this.getModel().setValue("me_cstype", row.get("asstacttype"), rowIndex);
            this.getModel().setValue("me_custsupplier", row.get("asstact"), rowIndex);
        }
        this.getModel().setValue("me_currency", row.get("currency"), rowIndex);
        this.getModel().setValue("me_localcurrency", row.get("basecurrency"), rowIndex);
        this.getModel().setValue("me_intercostamt", row.get("detailentry.intercostamt"), rowIndex);
        this.getModel().setValue("me_exratedate", row.get("exratedate"), rowIndex);
        this.getModel().setValue("me_amount", row.get("detailentry.e_amount"), rowIndex);
        this.getModel().setValue("me_taxamount", row.get("detailentry.e_pricetaxtotal"), rowIndex);
        this.getModel().setValue("me_billtype", row.get("billtypeid"), rowIndex);
        this.getModel().setValue("me_mainbilltype", row.get("detailentry.corebilltype"), rowIndex);
        this.getModel().setValue("me_mainbillno", row.get("detailentry.corebillno"), rowIndex);
        this.getModel().setValue("me_corebillid", row.get("detailentry.corebillid"), rowIndex);
        this.getModel().setValue("me_coreentryid", row.get("detailentry.corebillentryid"), rowIndex);
        this.getModel().setValue("me_reourcebilltype", row.get("sourcebilltype"), rowIndex);
        this.getModel().setValue("me_resourcebillnum", row.get("sourcebillno"), rowIndex);
        this.getModel().setValue("me_sourcebillid", row.get("sourcebillid"), rowIndex);
        Object srcBillEntryId = row.get("detailentry.e_sourcebillentryid");
        if (srcBillEntryId == null || StringUtils.isEmpty((CharSequence)srcBillEntryId.toString())) {
            srcBillEntryId = "0";
        }
        this.getModel().setValue("me_sourceentryid", (Object)Long.parseLong(srcBillEntryId.toString()), rowIndex);
    }

    public DataSet queryAsstData() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(this.getFilter("cal_costrecord", "asstfiltergrid"));
        filters.add(new QFilter("issplitcreate", "=", (Object)"0"));
        filters.add(new QFilter("calbilltype", "=", (Object)"IN"));
        filters.add(new QFilter("entry.ispresent", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("calorg", "=", (Object)this.getCalOrg()));
        List expenseBillTypes = CostRecordQFilterHelper.getMatchBilltype((String)"expensebilltype");
        filters.add(new QFilter("billtype", "in", (Object)expenseBillTypes));
        List<String> entityObjectList = this.getEntityOBj(expenseBillTypes);
        filters.add(new QFilter("bizentityobject.number", "in", entityObjectList));
        QFilter cacheFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        for (QFilter filter : filters) {
            cacheFilter.and(filter);
        }
        this.getPageCache().put("asstQfilter", cacheFilter.toSerializedString());
        filters.add(new QFilter("costaccount.ismainaccount", "=", (Object)"1"));
        filters.add(new QFilter("costaccount.enable", "=", (Object)"1"));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        filters.add(billStatusf);
        filters.add(new QFilter("ischargeoffed", "!=", (Object)"1"));
        filters.add(new QFilter("ischargeoff", "!=", (Object)"1"));
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "costRecordDataSet"), (String)"cal_costrecord", (String)FeeShareHelper.getCostRecordFields(), (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private List<String> getEntityOBj(List<Long> expenseBillTypes) {
        ArrayList<String> expenseBills = new ArrayList<String>();
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)"bos_billtype", (String)"id,number,billformid", (QFilter[])new QFilter("id", "in", expenseBillTypes).toArray());
        for (DynamicObject dynamicObject : billTypes) {
            expenseBills.add(dynamicObject.getString("billformid"));
        }
        return expenseBills;
    }

    private void loadAsstRowData(Row row, TableValueSetter vs) {
        String ownertype = "";
        long owner = 0L;
        if (StringUtils.isBlank((Object)row.get("entry.ownertype"))) {
            // empty if block
        }
        if (StringUtils.isNotBlank((Object)row.get("entry.ownertype"))) {
            ownertype = (String)row.get("entry.ownertype");
            owner = (Long)row.get("entry.owner");
        }
        vs.addRow(new Object[]{row.get("id"), row.get("entry.id"), row.get("id"), row.get("entry.id"), row.get("calorg"), row.getLong("costaccount.id"), row.get("billno"), row.get("billnumber"), row.get("bizdate"), row.get("bookdate"), row.get("supplier"), ownertype, owner, row.get("localcurrency"), row.get("entry.material"), row.get("entry.baseunit"), row.get("entry.baseqty"), row.get("entry.baseqty"), row.getBigDecimal("entry.fee"), row.getBigDecimal("entry.materialcost"), row.getBigDecimal("entry.totalsharefee"), row.get("billtype"), row.get("entry.mainbillentity"), row.get("entry.mainbillnumber"), row.get("entry.mainbillid"), row.get("entry.mainbillentryid"), row.get("entry.srcbillentity"), row.get("entry.srcbillnumber"), row.get("entry.srcbillid"), row.get("entry.srcbillentryid"), row.get("entry.calentryid"), row.get("isfivoucher")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindMainEntryData() {
        try (DataSet mainDataSet = this.queryMainData();){
            this.getModel().beginInit();
            this.getModel().deleteEntryData("mentry");
            Row row = null;
            while (mainDataSet.hasNext()) {
                row = mainDataSet.next();
                BigDecimal e_amount = row.getBigDecimal("detailentry.e_amount");
                BigDecimal e_pricetaxtotal = row.getBigDecimal("detailentry.e_pricetaxtotal");
                if (e_amount.compareTo(BigDecimal.ZERO) == 0 && e_pricetaxtotal.compareTo(BigDecimal.ZERO) == 0) continue;
                int rowIndex = this.getModel().createNewEntryRow("mentry");
                this.loadMainRowData(row, rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("mentry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAsstEntryData() {
        try (DataSet asstDataSet = this.queryAsstData();){
            IDataModel dataModel = this.getModel();
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            this.getModel().beginInit();
            this.getModel().deleteEntryData("sentry");
            Row row = null;
            TableValueSetter vs = this.getTAbleValueSetter();
            while (asstDataSet.hasNext()) {
                row = asstDataSet.next();
                this.loadAsstRowData(row, vs);
            }
            model.batchCreateNewEntryRow("sentry", vs);
            this.getModel().endInit();
            this.getView().updateView("sentry");
        }
    }

    private TableValueSetter getTAbleValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("se_billid", new Object[0]);
        vs.addField("se_billentryid", new Object[0]);
        vs.addField("costrecordheadid", new Object[0]);
        vs.addField("costrecordentryid", new Object[0]);
        vs.addField("se_calorg", new Object[0]);
        vs.addField("se_costaccount", new Object[0]);
        vs.addField("se_billnum", new Object[0]);
        vs.addField("se_billnumber", new Object[0]);
        vs.addField("se_bizdate", new Object[0]);
        vs.addField("se_bookdate", new Object[0]);
        vs.addField("se_supplier", new Object[0]);
        vs.addField("se_ownertype", new Object[0]);
        vs.addField("se_owner", new Object[0]);
        vs.addField("se_currency", new Object[0]);
        vs.addField("se_material", new Object[0]);
        vs.addField("se_baseunit", new Object[0]);
        vs.addField("se_qty", new Object[0]);
        vs.addField("se_verifyqty", new Object[0]);
        vs.addField("se_fee", new Object[0]);
        vs.addField("se_materialcost", new Object[0]);
        vs.addField("se_totalsharefee", new Object[0]);
        vs.addField("se_billtype", new Object[0]);
        vs.addField("se_mainbilltype", new Object[0]);
        vs.addField("se_mainbillnum", new Object[0]);
        vs.addField("se_corebillid", new Object[0]);
        vs.addField("se_coreentryid", new Object[0]);
        vs.addField("se_resourcebilltype", new Object[0]);
        vs.addField("se_resorcebillnum", new Object[0]);
        vs.addField("se_sourcebillid", new Object[0]);
        vs.addField("se_sourceentryid", new Object[0]);
        vs.addField("se_calentryid", new Object[0]);
        vs.addField("isfivoucher", new Object[0]);
        return vs;
    }
}

