/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.formplugin.calculate.in.FeeSharePrepare;
import kd.fi.cal.formplugin.calculate.in.FeeShareRelation;

public class FeeShareUpdateParams {
    private List<Object[]> finapBillParams = new ArrayList<Object[]>();
    private List<Object[]> isallocate = new ArrayList<Object[]>();
    private List<Object[]> recordTotalParams = new ArrayList<Object[]>();
    private List<Object[]> recordFeeParams = new ArrayList<Object[]>();
    private List<Object[]> costRecordDetailList = new ArrayList<Object[]>();
    private Set<Long> recordFeeEntryIdSet = new HashSet<Long>();
    private List<DynamicObject> shareRecordList = new ArrayList<DynamicObject>();
    private List<DynamicObject> verifyRecordDetailList = new ArrayList<DynamicObject>();
    private List<DynamicObject> costAdjustList = new ArrayList<DynamicObject>();
    private Collection<DynamicObject> costAdjustCollection = new ArrayList<DynamicObject>();
    private List<DynamicObject> stdCostDiffBillList = new ArrayList<DynamicObject>();
    private Collection<DynamicObject> stdCostDiffBillCollection = new ArrayList<DynamicObject>();
    private List<DynamicObject> totalSharefeeList = new ArrayList<DynamicObject>();
    private List<DynamicObject> costEstAdjustBillArray = new ArrayList<DynamicObject>();
    private List<DynamicObject> feeShareAdjustBillArray = new ArrayList<DynamicObject>();
    private List<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
    private List<DynamicObject> costEstStdCostDiffBillArray = new ArrayList<DynamicObject>();
    private List<DynamicObject> feeShareStdCostDiffBillArray = new ArrayList<DynamicObject>();
    private List<CostAdjustDetailParams> stdCostDiffBillParamsList = new ArrayList<CostAdjustDetailParams>();
    private Map<Long, Date> costAccountBeginDateMap = new HashMap<Long, Date>();

    public FeeShareUpdateParams(Long id) {
        this.addFinapBill(id);
    }

    private final void addFinapBill(Long id) {
        Object[] finapBillParam = new Object[]{id};
        this.finapBillParams.add(finapBillParam);
    }

    public List<DynamicObject> getTotalSharefeeList() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.totalSharefeeList);
        return unChangeList;
    }

    public Set<Long> getRecordFeeEntryIdSet() {
        HashSet<Long> unChangeSet = new HashSet<Long>();
        unChangeSet.addAll(this.recordFeeEntryIdSet);
        return unChangeSet;
    }

    public void setRecordFeeEntryIdSet(Long entryId) {
        this.recordFeeEntryIdSet.add(entryId);
    }

    public void addShareRecordList(DynamicObject shareRecord) {
        this.shareRecordList.add(shareRecord);
    }

    public List<Object[]> getFinapBillParams() {
        ArrayList<Object[]> unchangeParams = new ArrayList<Object[]>();
        unchangeParams.addAll(this.finapBillParams);
        return unchangeParams;
    }

    public void setFinapBillParams(List<Object[]> finapBillParams) {
        this.finapBillParams.addAll(finapBillParams);
    }

    public List<Object[]> getRecordTotalParams() {
        ArrayList<Object[]> unchangeParams = new ArrayList<Object[]>();
        unchangeParams.addAll(this.recordTotalParams);
        return unchangeParams;
    }

    public List<Object[]> getCostRecordDetailList() {
        ArrayList<Object[]> unChangeList = new ArrayList<Object[]>();
        unChangeList.addAll(this.costRecordDetailList);
        return unChangeList;
    }

    public void setRecordTotalParams(List<Object[]> recordTotalParams) {
        this.recordTotalParams.addAll(recordTotalParams);
    }

    public List<Object[]> getRecordFeeParams() {
        ArrayList<Object[]> unChangeList = new ArrayList<Object[]>();
        unChangeList.addAll(this.recordFeeParams);
        return unChangeList;
    }

    public void setRecordFeeParams(List<Object[]> recordFeeParams) {
        this.recordFeeParams.addAll(recordFeeParams);
    }

    public List<DynamicObject> getShareRecordList() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.shareRecordList);
        return unChangeList;
    }

    public void setVerifyRecordList(List<DynamicObject> verifyRecordList) {
        this.shareRecordList.addAll(verifyRecordList);
    }

    public List<DynamicObject> getVerifyRecordDetailList() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.verifyRecordDetailList);
        return unChangeList;
    }

    public void setVerifyRecordDetailList(List<DynamicObject> verifyRecordDetailList) {
        this.verifyRecordDetailList.addAll(verifyRecordDetailList);
    }

    public List<DynamicObject> getCostAdjustList() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.costAdjustList);
        return unChangeList;
    }

    public List<DynamicObject> getStdCostDiffBillList() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.stdCostDiffBillList);
        return unChangeList;
    }

    public void setCostAdjustList(List<DynamicObject> costAdjustList) {
        this.costAdjustList.addAll(costAdjustList);
    }

    public Collection<DynamicObject> getCostAdjustCollection() {
        ArrayList<DynamicObject> unChangeCollection = new ArrayList<DynamicObject>();
        unChangeCollection.addAll(this.costAdjustCollection);
        return unChangeCollection;
    }

    public Collection<DynamicObject> getStdCostDiffBillCollection() {
        ArrayList<DynamicObject> unChangeCollection = new ArrayList<DynamicObject>();
        unChangeCollection.addAll(this.stdCostDiffBillCollection);
        return unChangeCollection;
    }

    public List<DynamicObject> getCostEstAdjustBillArray() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.costEstAdjustBillArray);
        return unChangeList;
    }

    public List<DynamicObject> getCostEstStdcostDiffBillArray() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.costEstStdCostDiffBillArray);
        return unChangeList;
    }

    public List<DynamicObject> getFeeShareAdjustBillArray() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.feeShareAdjustBillArray);
        return unChangeList;
    }

    public List<DynamicObject> getFeeShareStdCostDiffBillArray() {
        ArrayList<DynamicObject> unChangeList = new ArrayList<DynamicObject>();
        unChangeList.addAll(this.feeShareStdCostDiffBillArray);
        return unChangeList;
    }

    public void addFeeShareParams(Map<String, Object> adjustBillMap) {
        List costAdjustBillList = (List)adjustBillMap.get("costAdjustBillList");
        List feeShareCostAdjustBill = (List)adjustBillMap.get("feeShareCostAdjustBill");
        List paramsList = (List)adjustBillMap.get("paramsList");
        if (costAdjustBillList == null || costAdjustBillList.isEmpty()) {
            return;
        }
        this.costEstAdjustBillArray.addAll(costAdjustBillList);
        this.feeShareAdjustBillArray.addAll(feeShareCostAdjustBill);
        this.paramsList.addAll(paramsList);
    }

    public void addFeeShareStdCostDiffBillParams(Map<String, Object> adjustBillMap) {
        List costAdjustBillList = (List)adjustBillMap.get("stdCostDiffBillList");
        List feeShareCostAdjustBill = (List)adjustBillMap.get("feeShareStdCostDiffBill");
        List paramsList = (List)adjustBillMap.get("paramsStdCostDiffBillList");
        if (costAdjustBillList == null || costAdjustBillList.isEmpty()) {
            return;
        }
        this.costEstStdCostDiffBillArray.addAll(costAdjustBillList);
        this.feeShareStdCostDiffBillArray.addAll(feeShareCostAdjustBill);
        this.stdCostDiffBillParamsList.addAll(paramsList);
    }

    public List<CostAdjustDetailParams> getParamsList() {
        ArrayList<CostAdjustDetailParams> unChangeList = new ArrayList<CostAdjustDetailParams>();
        unChangeList.addAll(this.paramsList);
        return unChangeList;
    }

    public List<CostAdjustDetailParams> getParamsStdCostDiffBillList() {
        ArrayList<CostAdjustDetailParams> unChangeList = new ArrayList<CostAdjustDetailParams>();
        unChangeList.addAll(this.stdCostDiffBillParamsList);
        return unChangeList;
    }

    public void setCostAdjustCollection() {
        this.costAdjustCollection = this.mergeCostAjustList(this.costAdjustList);
    }

    public void setStdCostDiffBillCollection() {
        this.stdCostDiffBillCollection = this.mergeStdCostDiffBillList(this.stdCostDiffBillList);
    }

    private Collection<DynamicObject> mergeCostAjustList(List<DynamicObject> costAdjustList) {
        HashMap<String, DynamicObject> costAdjustmap = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : costAdjustList) {
            StringBuilder key = new StringBuilder();
            key.append(dynamicObject.getDynamicObject("custsupplier").getString("id"));
            key.append(dynamicObject.getDynamicObject("billtype").getPkValue());
            key.append(dynamicObject.getDynamicObject("costaccount").getPkValue());
            key.append(dynamicObject.getString("createtype"));
            key.append(dynamicObject.getString("difftype"));
            String keyStr = key.toString();
            DynamicObject valueAdjustBill = (DynamicObject)costAdjustmap.get(keyStr);
            if (valueAdjustBill == null) {
                String billNo = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)dynamicObject, (String)dynamicObject.getDynamicObject("calorg").getPkValue().toString());
                dynamicObject.set("billno", (Object)billNo);
                costAdjustmap.put(keyStr, dynamicObject);
                continue;
            }
            DynamicObjectCollection entrys = valueAdjustBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0);
            entrys.add((Object)entry);
        }
        return costAdjustmap.values();
    }

    private Collection<DynamicObject> mergeStdCostDiffBillList(List<DynamicObject> costAdjustList) {
        HashMap<String, DynamicObject> costAdjustmap = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : costAdjustList) {
            StringBuilder key = new StringBuilder();
            key.append(dynamicObject.getDynamicObject("custsupplier").getString("id"));
            key.append(dynamicObject.getDynamicObject("billtype").getPkValue());
            key.append(dynamicObject.getDynamicObject("costaccount").getPkValue());
            key.append(dynamicObject.getString("createtype"));
            String keyStr = key.toString();
            DynamicObject valueAdjustBill = (DynamicObject)costAdjustmap.get(keyStr);
            if (valueAdjustBill == null) {
                String billNo = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)dynamicObject, (String)dynamicObject.getDynamicObject("calorg").getPkValue().toString());
                dynamicObject.set("billno", (Object)billNo);
                costAdjustmap.put(keyStr, dynamicObject);
                continue;
            }
            DynamicObjectCollection entrys = valueAdjustBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0);
            entrys.add((Object)entry);
        }
        return costAdjustmap.values();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeeShareUpdateParams other = (FeeShareUpdateParams)obj;
        if (this.finapBillParams == null ? other.finapBillParams != null : !this.finapBillParams.equals(other.finapBillParams)) {
            return false;
        }
        return !(this.recordFeeEntryIdSet == null ? other.recordFeeEntryIdSet != null : !this.recordFeeEntryIdSet.equals(other.recordFeeEntryIdSet));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.finapBillParams == null ? 0 : this.finapBillParams.hashCode());
        result = 31 * result + (this.recordFeeEntryIdSet == null ? 0 : this.recordFeeEntryIdSet.hashCode());
        return result;
    }

    public void addRecordFeeParams(Long billId, BigDecimal fee) {
        Object[] recordFeeParam = new Object[]{fee, billId};
        this.recordFeeParams.add(recordFeeParam);
    }

    public BigDecimal addCostRecordDetailList(FeeSharePrepare feeSharePrepare, DynamicObject asstBill, BigDecimal asstshareCost, FeeShareRelation feeShareRelation, Long costTypeId, Long costAccountId) {
        DynamicObject mainBill = feeShareRelation.getMainBill();
        DynamicObject mainParentBill = feeShareRelation.getMainParentObj();
        Map<String, Long[]> exitemElementMap = feeSharePrepare.getExitemElementMap();
        Long defaultId = feeSharePrepare.getDefaultId();
        String costRecordEntryId = asstBill.getString("id");
        String supplierId = mainParentBill.getString("asstact.id");
        DynamicObject expenseitem = mainBill.getDynamicObject("expenseitem");
        long elementId = 0L;
        Boolean isCostRecordDetail = feeSharePrepare.getCalByCostElementMap().get(costAccountId);
        if (isCostRecordDetail.booleanValue()) {
            Long[] elementIds = exitemElementMap.get(costTypeId + "|" + expenseitem.getLong("id"));
            elementId = elementIds == null ? defaultId.longValue() : elementIds[0].longValue();
        } else {
            Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
            elementId = defaultElementIds[0];
        }
        if (feeSharePrepare.getFirstCostEstCostMap().containsKey(costRecordEntryId + supplierId)) {
            asstshareCost = asstshareCost.subtract(feeSharePrepare.getFirstCostEstCostMap().get(costRecordEntryId + supplierId));
        }
        this.costRecordDetailList.add(new Object[]{asstshareCost, asstBill.getLong("id"), elementId});
        return asstshareCost;
    }

    public void addVerifyRecordDetailList(FeeShareRelation feeShareRelation, BigDecimal substractAmt, BigDecimal asstshareCost, long costRecordID) {
        DynamicObject recordDetailObj = BusinessDataServiceHelper.newDynamicObject((String)"cal_fee_sharedetail");
        DynamicObject asstParent = feeShareRelation.getAsstParentObj();
        DynamicObject mainParent = feeShareRelation.getMainParentObj();
        DynamicObject asstBill = feeShareRelation.getAsstBill();
        DynamicObject mainBill = feeShareRelation.getMainBill();
        recordDetailObj.set("costaccount", (Object)asstParent.getLong("costaccount.id"));
        recordDetailObj.set("sharercdid", (Object)costRecordID);
        recordDetailObj.set("costrecordid", (Object)asstParent.getLong("id"));
        recordDetailObj.set("entryid", (Object)asstBill.getLong("id"));
        recordDetailObj.set("expenseitem", (Object)mainBill.getDynamicObject("expenseitem"));
        recordDetailObj.set("sharedetailcurrency", (Object)asstParent.getDynamicObject("localcurrency"));
        recordDetailObj.set("shareamount", (Object)substractAmt);
        recordDetailObj.set("realshareamount", (Object)asstshareCost);
        recordDetailObj.set("asstacttype", (Object)mainParent.getString("asstacttype"));
        recordDetailObj.set("asstact", (Object)mainParent.getDynamicObject("asstact"));
        this.verifyRecordDetailList.add(recordDetailObj);
    }

    public void createCostAdjustBill(FeeShareRelation feeShareRelation, BigDecimal shareCost, long shareRecordId, long mianSupplierId, FeeSharePrepare feeShareData, boolean isBorrowContain, String diffType) {
        BigDecimal adjustCost = shareCost;
        DynamicObject asstBill = feeShareRelation.getAsstBill();
        String asstBillId = asstBill.get("id").toString();
        DynamicObject mainBill = feeShareRelation.getMainBill();
        if (CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(diffType) && !isBorrowContain) {
            if (feeShareData.getFirstCostEstCostMap().containsKey(asstBillId + mianSupplierId)) {
                adjustCost = adjustCost.subtract(feeShareData.getFirstCostEstCostMap().get(asstBillId + mianSupplierId));
            }
            if (adjustCost.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
        }
        DynamicObject mainParentBill = feeShareRelation.getMainParentObj();
        DynamicObject asstParentBill = feeShareRelation.getAsstParentObj();
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjustbill");
        costAdjustBill.set("cstype", mainParentBill.get("asstacttype"));
        costAdjustBill.set("custsupplier", (Object)mainParentBill.getDynamicObject("asstact"));
        costAdjustBill.set("currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
        costAdjustBill.set("bizdate", (Object)this.getMaxDateFromMainAsstBill(mainParentBill, asstParentBill, "bizdate"));
        costAdjustBill.set("bookdate", (Object)this.getMaxDateFromMainAsstBill(mainParentBill, asstParentBill, "bookdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("billtype", (Object)asstParentBill.getDynamicObject("billtype"));
        costAdjustBill.set("difftype", (Object)diffType);
        costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue());
        costAdjustBill.set("costaccount", (Object)asstParentBill.getDynamicObject("costaccount"));
        costAdjustBill.set("calorg", (Object)asstParentBill.getDynamicObject("calorg"));
        costAdjustBill.set("adminorg", (Object)asstParentBill.getDynamicObject("adminorg"));
        costAdjustBill.set("feeshareflag", (Object)shareRecordId);
        costAdjustBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        costAdjustBill.set("createtime", (Object)new Date());
        DynamicObject entry = costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", (Object)asstParentBill.getDynamicObject("storageorgunit"));
        entry.set("material", (Object)asstBill.getDynamicObject("material"));
        entry.set("lot", asstBill.get("lot"));
        entry.set("adjustamt", (Object)adjustCost);
        entry.set("warehouse", (Object)asstBill.getDynamicObject("warehouse"));
        entry.set("location", (Object)asstBill.getDynamicObject("location"));
        entry.set("ownertype", (Object)asstBill.getString("ownertype"));
        entry.set("owner", (Object)asstBill.getDynamicObject("owner"));
        entry.set("ecostcenter", (Object)asstBill.getDynamicObject("ecostcenter"));
        entry.set("assist", (Object)asstBill.getDynamicObject("assist"));
        entry.set("invbilltype", (Object)asstParentBill.getDynamicObject("billtype"));
        entry.set("invbillid", (Object)asstParentBill.getLong("id"));
        entry.set("invtype", (Object)asstBill.getDynamicObject("invtype"));
        entry.set("invstatus", (Object)asstBill.getDynamicObject("invstatus"));
        entry.set("baseunit", (Object)asstBill.getDynamicObject("baseunit"));
        entry.set("invbillentryid", (Object)asstBillId);
        entry.set("invbillnum", (Object)asstParentBill.getString("billno"));
        entry.set("inventryseq", (Object)asstBill.getString("seq"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("srcbilltype", (Object)mainParentBill.getDynamicObject("billtypeid"));
        entry.set("srcbillnum", (Object)mainParentBill.getString("billno"));
        entry.set("srcentryseq", (Object)mainBill.getLong("seq"));
        entry.set("feeprojectid", (Object)mainBill.getDynamicObject("expenseitem"));
        entry.set("srcbizentityobject", (Object)"ap_finapbill");
        entry.set("srcbillId", (Object)mainParentBill.getLong("id"));
        entry.set("srcbillentryId", (Object)mainBill.getLong("id"));
        entry.set("mversion", (Object)asstBill.getDynamicObject("mversion"));
        entry.set("project", (Object)asstBill.getDynamicObject("project"));
        entry.set("tracknumber", asstBill.get("tracknumber"));
        entry.set("configuredcode", asstBill.get("configuredcode"));
        entry.set("noupdatecalfields", asstBill.get("noupdatecalfields"));
        entry.set("stocktype", asstBill.get("stocktype"));
        Set<String> exFieldSet = feeShareData.getExFieldSet();
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        CommonSettingHelper.setExFieldValue(exFieldSet, (MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)asstBill);
        this.costAdjustList.add(costAdjustBill);
    }

    public void createStdCostDiffBill(FeeShareRelation feeShareRelation, BigDecimal shareCost, long shareRecordId, long mianSupplierId, FeeSharePrepare feeShareData, boolean isBorrowContain, String diffType) {
        BigDecimal adjustCost = shareCost;
        DynamicObject asstBill = feeShareRelation.getAsstBill();
        String asstBillId = asstBill.get("id").toString();
        DynamicObject mainBill = feeShareRelation.getMainBill();
        DynamicObject mainParentBill = feeShareRelation.getMainParentObj();
        DynamicObject asstParentBill = feeShareRelation.getAsstParentObj();
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        costAdjustBill.set("cstype", mainParentBill.get("asstacttype"));
        costAdjustBill.set("custsupplier", (Object)mainParentBill.getDynamicObject("asstact"));
        costAdjustBill.set("currency", (Object)asstParentBill.getDynamicObject("localcurrency"));
        costAdjustBill.set("bizdate", (Object)this.getMaxDateFromMainAsstBill(mainParentBill, asstParentBill, "bizdate"));
        costAdjustBill.set("bookdate", (Object)this.getMaxDateFromMainAsstBill(mainParentBill, asstParentBill, "bookdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("billtype", (Object)asstParentBill.getDynamicObject("billtype"));
        costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue());
        costAdjustBill.set("costaccount", (Object)asstParentBill.getDynamicObject("costaccount"));
        costAdjustBill.set("calorg", (Object)asstParentBill.getDynamicObject("calorg"));
        costAdjustBill.set("adminorg", (Object)asstParentBill.getDynamicObject("adminorg"));
        costAdjustBill.set("feeshareflag", (Object)shareRecordId);
        costAdjustBill.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        costAdjustBill.set("createtime", (Object)new Date());
        DynamicObject entry = costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", (Object)asstParentBill.getDynamicObject("storageorgunit"));
        entry.set("material", (Object)asstBill.getDynamicObject("material"));
        entry.set("lot", asstBill.get("lot"));
        entry.set("adjustamt", (Object)adjustCost);
        entry.set("diff_" + diffType.toLowerCase(), (Object)adjustCost);
        entry.set("warehouse", (Object)asstBill.getDynamicObject("warehouse"));
        entry.set("location", (Object)asstBill.getDynamicObject("location"));
        entry.set("ownertype", (Object)asstBill.getString("ownertype"));
        entry.set("owner", (Object)asstBill.getDynamicObject("owner"));
        entry.set("ecostcenter", (Object)asstBill.getDynamicObject("ecostcenter"));
        entry.set("assist", (Object)asstBill.getDynamicObject("assist"));
        entry.set("invbilltype", (Object)asstParentBill.getDynamicObject("billtype"));
        entry.set("invbillid", (Object)asstParentBill.getLong("id"));
        entry.set("invtype", (Object)asstBill.getDynamicObject("invtype"));
        entry.set("invstatus", (Object)asstBill.getDynamicObject("invstatus"));
        entry.set("baseunit", (Object)asstBill.getDynamicObject("baseunit"));
        entry.set("invbillentryid", (Object)asstBillId);
        entry.set("invbillnum", (Object)asstParentBill.getString("billno"));
        entry.set("inventryseq", (Object)asstBill.getString("seq"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("srcbilltype", (Object)mainParentBill.getDynamicObject("billtypeid"));
        entry.set("srcbillnum", (Object)mainParentBill.getString("billno"));
        entry.set("srcentryseq", (Object)mainBill.getLong("seq"));
        entry.set("feeprojectid", (Object)mainBill.getDynamicObject("expenseitem"));
        entry.set("srcbizentityobject", (Object)"ap_finapbill");
        entry.set("srcbillId", (Object)mainParentBill.getLong("id"));
        entry.set("srcbillentryId", (Object)mainBill.getLong("id"));
        entry.set("mversion", (Object)asstBill.getDynamicObject("mversion"));
        entry.set("project", (Object)asstBill.getDynamicObject("project"));
        entry.set("tracknumber", asstBill.get("tracknumber"));
        entry.set("configuredcode", asstBill.get("configuredcode"));
        entry.set("noupdatecalfields", asstBill.get("noupdatecalfields"));
        entry.set("stocktype", asstBill.get("stocktype"));
        Set<String> exFieldSet = feeShareData.getExFieldSet();
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        CommonSettingHelper.setExFieldValue(exFieldSet, (MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)asstBill);
        this.stdCostDiffBillList.add(costAdjustBill);
    }

    public Date getMaxDateFromMainAsstBill(DynamicObject mainParentBill, DynamicObject asstParentBill, String asstDateField) {
        Date mainDate = mainParentBill.getDate("bookdate");
        Date asstDate = asstParentBill.getDate(asstDateField);
        long costAccountID = asstParentBill.getDynamicObject("costaccount").getLong("id");
        Date costAccountBeginDate = this.costAccountBeginDateMap.get(costAccountID);
        if (costAccountBeginDate == null) {
            DynamicObject value = PeriodHelper.getCurrentPeriod((Long)costAccountID);
            costAccountBeginDate = value.getDate("beginDate");
            this.costAccountBeginDateMap.put(costAccountID, costAccountBeginDate);
        }
        Date MaxDate = costAccountBeginDate;
        if (null != mainDate) {
            Date date = MaxDate = MaxDate.compareTo(mainDate) > 0 ? MaxDate : mainDate;
        }
        if (null != asstDate) {
            MaxDate = MaxDate.compareTo(asstDate) > 0 ? MaxDate : asstDate;
        }
        return MaxDate;
    }

    public void addRecordTotalParams(BigDecimal shareCost, Long id) {
        Object[] recordParam = new Object[]{shareCost, id};
        this.recordTotalParams.add(recordParam);
    }

    public List<Object[]> getIsallocate() {
        ArrayList<Object[]> unChangeList = new ArrayList<Object[]>();
        unChangeList.addAll(this.isallocate);
        return unChangeList;
    }

    public void addIsallocate(Object[] asstBillIdObj) {
        this.isallocate.add(asstBillIdObj);
    }

    public void addTotalShareFee(long shareId, long costRecordEntryId, BigDecimal asstshareCost) {
        DynamicObject totalFeeDynamic = BusinessDataServiceHelper.newDynamicObject((String)"cal_fee_totalsharefee");
        totalFeeDynamic.set("feeshareid", (Object)shareId);
        totalFeeDynamic.set("costrecordentryid", (Object)costRecordEntryId);
        totalFeeDynamic.set("totalfee", (Object)asstshareCost);
        this.totalSharefeeList.add(totalFeeDynamic);
    }
}

