/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.sharemodel.AmtShareModel;
import kd.fi.cal.business.sharemodel.AmtShareParams;
import kd.fi.cal.business.sharemodel.IStandardAmtExchange;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.formplugin.calculate.in.FeeShareParent;

public class FeeShareVerifyPlugin
extends FeeShareParent {
    private Map<Long, Date> orgMaxDate = new HashMap<Long, Date>();

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String key = event.getOperateKey();
        if ("sharesetting".equals(key)) {
            this.showEstimateSettingView();
        } else if ("thisverifylog".equals(key)) {
            this.showFirstVerifyLog();
        } else if ("historyverifylog".equals(key)) {
            this.showHisVerifyLog();
        } else if ("verifypreview".equals(key)) {
            this.previewFeeShare();
        } else if ("verify".equals(key)) {
            this.beforVerify();
            this.doVerify();
            this.getView().invokeOperation("query");
        }
    }

    private void doVerify() {
        String content;
        Object[] mainSetArray = this.getMainPageId();
        Object[] asstSetArray = this.getAsstPageId();
        Long[] assbizbillids = this.getAsstBizBillIds();
        long shareNum = new Date().getTime();
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        jobParams.put("mainSetArray", SerializationUtils.toJsonString((Object)mainSetArray));
        jobParams.put("asstSetArray", SerializationUtils.toJsonString((Object)asstSetArray));
        jobParams.put("asstbizbillids", SerializationUtils.toJsonString((Object)assbizbillids));
        jobParams.put("matchingcondition", this.getModel().getValue("matchingcondition"));
        jobParams.put("shareNum", SerializationUtils.toJsonString((Object)shareNum));
        jobParams.put("asstQfilter", this.getPageCache().get("asstQfilter"));
        jobParams.put("CALORG", SerializationUtils.toJsonString((Object)this.getCalOrg()));
        jobParams.put("exratetable", SerializationUtils.toJsonString((Object)((DynamicObject)this.getModel().getValue("exratetable")).getLong("id")));
        jobParams.put("sharestandard", this.getModel().getValue("sharestandard"));
        Date shareDate = (Date)this.getModel().getValue("sharedate");
        String shareDateStr = new SimpleDateFormat("yyyy-MM-dd").format(shareDate);
        jobParams.put("sharedate", shareDateStr);
        jobParams.put("sharecurrency", SerializationUtils.toJsonString((Object)((DynamicObject)this.getModel().getValue("sharecurrency")).getPkValue()));
        JobInfo job = new JobInfo();
        String OpName = content = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a,\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\uff1a%1$s", (String)"FeeShareVerifyPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue("calorg")).getString("number"));
        job.setName(OpName);
        job.setTaskDefineId("2TEE+G+UFBFB");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.FeeShareVerifyTask");
        JobClient.dispatch((JobInfo)job);
        this.getPageCache().put("shareNum", String.valueOf(shareNum));
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7559\u610f\u7cfb\u7edf\u63d0\u793a\u3002", (String)"FeeShareVerifyPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private Long[] getAsstBizBillIds() {
        int[] indexs = this.getSelectIndexs("sentry");
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("sentry");
        List<Long> costrecordheadids = this.getIdByPage(indexs, entityColl, "costrecordheadid_id");
        DynamicObjectCollection infos = QueryServiceHelper.query((String)"cal_costrecord", (String)"bizbillid", (QFilter[])new QFilter("id", "in", costrecordheadids).toArray());
        HashSet<Long> bizbillids = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            bizbillids.add(info.getLong("bizbillid"));
        }
        return bizbillids.toArray(new Long[0]);
    }

    private Object[] getAsstPageId() {
        List<Long> calEntryId;
        Object[] setArray = new Object[1];
        int[] indexs = this.getSelectIndexs("sentry");
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("sentry");
        setArray[0] = calEntryId = this.getIdByPage(indexs, entityColl, "se_calentryid");
        return setArray;
    }

    private Object[] getMainPageId() {
        Object[] setArray = new Object[2];
        int[] indexs = this.getSelectIndexs("mentry");
        DynamicObjectCollection entityColl = this.getModel().getEntryEntity("mentry");
        List<Long> ids = this.getIdByPage(indexs, entityColl, "me_billid");
        List<Long> entryIds = this.getIdByPage(indexs, entityColl, "me_billentryid");
        setArray[0] = ids;
        setArray[1] = entryIds;
        return setArray;
    }

    private void beforVerify() {
        Object shareType = this.getModel().getValue("sharetype");
        Object matchCondition = this.getModel().getValue("matchingcondition");
        Object shaerDate = this.getModel().getValue("sharedate");
        if (StringUtils.isBlank((Object)shareType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u644a\u7c7b\u578b\u3002", (String)"FeeShareVerifyPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)matchCondition)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5339\u914d\u6761\u4ef6\u3002", (String)"FeeShareVerifyPlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)shaerDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u644a\u65e5\u671f\u3002", (String)"FeeShareVerifyPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.checkShareDate();
        this.isShareSettingOk();
        this.checkBillSelect();
    }

    private void showHisVerifyLog() {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cal_feeshare_newrecord");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)para);
    }

    private void showFirstVerifyLog() {
        String shareNum = this.getPageCache().get("shareNum");
        if (StringUtils.isBlank((CharSequence)shareNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u9875\u9762\u8fd8\u672a\u8fdb\u884c\u5206\u644a\u3002", (String)"FeeShareInitPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_fee_sharerecord", (String)"id", (QFilter[])new QFilter("createtime", "=", (Object)new Date(Long.parseLong(shareNum))).toArray(), null);){
            for (Row row : dataSet) {
                if (row.getLong("id") == 0L) continue;
                idSet.add(row.getLong("id"));
            }
        }
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_feeshare_newrecord");
        showParameter.setFormId("bos_list");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", idSet));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            showParameter.addLinkQueryPkId((Object)id);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showEstimateSettingView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("cal_feeshare_setting");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sharesetting"));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        if ("sharesetting".equals(sourceFldKey)) {
            this.bindShareStandard();
            this.bindMainEntryCost();
        }
    }

    private void bindShareStandard() {
        MainEntityType entitytype = MetadataServiceHelper.getDataEntityType((String)"cal_costdetail");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        List<String> standards = Arrays.asList(CommonSettingHelper.getEstimatestandards());
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (!standards.contains(pro.getName())) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), pro.getName());
            items.add(item);
        }
        if (items.isEmpty()) {
            return;
        }
        ComboEdit com = (ComboEdit)this.getControl("sharestandard");
        com.setComboItems(items);
        this.getModel().beginInit();
        this.getModel().setValue("sharestandard", (Object)((ComboItem)items.get(0)).getValue());
        this.getModel().endInit();
        this.getView().updateView("sharestandard");
    }

    private void previewFeeShare() {
        this.checkShareDate();
        this.checkBillSelect();
        this.isShareSettingOk();
        this.bindMainEntryCost();
        Map<DynamicObject, List<DynamicObject>> map = this.getMatchResultMap();
        StringBuilder resultMsg = new StringBuilder(20);
        Map<Long, BigDecimal[]> resultMap = this.getVerifyAmt(map, resultMsg);
        this.bindVerifyAmt(resultMap);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u644a\u9884\u89c8\u5df2\u5b8c\u6210\u3002", (String)"FeeShareInitPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), resultMsg.toString(), MessageTypes.Default);
    }

    private void bindVerifyAmt(Map<Long, BigDecimal[]> resultMap) {
        DynamicObjectCollection asstEntry = this.getModel().getEntryEntity("sentry");
        for (int i = 0; i < asstEntry.size(); ++i) {
            Long id = ((DynamicObject)asstEntry.get(i)).getLong("se_billentryid");
            this.getModel().beginInit();
            BigDecimal[] amt = resultMap.get(id);
            if (amt == null || amt.length != 2) {
                this.getModel().setValue("se_verifyamt", (Object)0, i);
                this.getModel().setValue("se_verifytaxamt", (Object)0, i);
            } else {
                this.getModel().setValue("se_verifyamt", (Object)amt[0], i);
                this.getModel().setValue("se_verifytaxamt", (Object)amt[1], i);
            }
            this.getModel().endInit();
            this.getView().updateView("se_verifyamt", i);
            this.getView().updateView("se_verifytaxamt", i);
        }
    }

    private Map<Long, BigDecimal[]> getVerifyAmt(Map<DynamicObject, List<DynamicObject>> map, StringBuilder resultMsg) {
        String dividestandard = (String)this.getModel().getValue("sharestandard");
        DynamicObject shareCurrency = (DynamicObject)this.getModel().getValue("sharecurrency");
        Date bizdate = (Date)this.getModel().getValue("sharedate");
        StandardAmtExchange ichange = this.getIExchange();
        HashMap<Long, BigDecimal[]> shareCostMap = new HashMap<Long, BigDecimal[]>();
        block0: for (Map.Entry<DynamicObject, List<DynamicObject>> entry : map.entrySet()) {
            String content;
            DynamicObject mainBill = entry.getKey();
            DynamicObject material = mainBill.getDynamicObject("material");
            long expenseitemId = mainBill.getLong("expenseitem_id");
            boolean materialFeeShare = expenseitemId == 0L;
            List<DynamicObject> asstBills = this.checkAsstBills(entry.getValue(), materialFeeShare, material);
            String name = ",";
            DynamicObject expenseitem = mainBill.getDynamicObject("expenseitem");
            if (materialFeeShare) {
                content = String.format(ResManager.loadKDString((String)"\u7269\u6599:%1$s", (String)"FeeShareInitPlugin_17", (String)"fi-cal-formplugin", (Object[])new Object[0]), material.get("name"));
                name = name + content;
            } else {
                content = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee:%1$s", (String)"FeeShareInitPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]), expenseitem.get("name"));
                name = name + content;
            }
            if (asstBills.isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u201c%1$s\u201d\u5206\u644a\u5931\u8d25\uff0c\u672a\u627e\u5230\u5339\u914d\u5173\u8054\u6570\u636e\u3002", (String)"FeeShareInitPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), ((DynamicObject)mainBill.getParent()).getString("billno") + name);
                resultMsg.append(msg);
                continue;
            }
            AmtShareParams param = new AmtShareParams();
            DynamicObject mainParentBill = (DynamicObject)mainBill.getParent();
            BigDecimal interCostAmt = mainBill.getBigDecimal("intercostamt");
            if (interCostAmt != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0) {
                param.setIsInterCostAmt(Boolean.TRUE);
                param.setBizdate(mainParentBill.getDate("exratedate"));
                param.setSourcecurrency(mainParentBill.getDynamicObject("basecurrency"));
                param.setTotalsourceamt(interCostAmt);
                param.setTotalsourcetaxamt(interCostAmt);
            } else {
                param.setIsInterCostAmt(Boolean.FALSE);
                param.setBizdate(bizdate);
                param.setSourcecurrency(mainParentBill.getDynamicObject("currency"));
                param.setTotalsourceamt(mainBill.getBigDecimal("e_amount"));
                param.setTotalsourcetaxamt(mainBill.getBigDecimal("e_pricetaxtotal"));
            }
            param.setDividestandard(dividestandard);
            param.setExchange((IStandardAmtExchange)ichange);
            param.setSharebills(asstBills);
            AmtShareModel sharemodel = new AmtShareModel(param);
            BigDecimal[] tempFee = null;
            for (DynamicObject asstBill : asstBills) {
                long asstBillId = (Long)asstBill.get("id");
                BigDecimal shareCost = sharemodel.getSharedBillAmt((Object)asstBillId, shareCurrency);
                BigDecimal shareTaxCost = sharemodel.getSharedBillTaxAmt((Object)asstBillId, shareCurrency);
                tempFee = (BigDecimal[])shareCostMap.get(asstBillId);
                tempFee = tempFee == null ? new BigDecimal[]{shareCost, shareTaxCost} : new BigDecimal[]{shareCost.add(tempFee[0]), shareTaxCost.add(tempFee[1])};
                if (!materialFeeShare && this.isUpdateCostAjust(asstBill) && this.judgeFailShare(asstBill, mainBill, resultMsg, tempFee).booleanValue()) continue block0;
                shareCostMap.put(asstBillId, tempFee);
            }
        }
        return shareCostMap;
    }

    private boolean isUpdateCostAjust(DynamicObject asstBill) {
        DynamicObject asstParentBill = (DynamicObject)asstBill.getParent();
        Date bizDate = asstParentBill.getDate("bizdate");
        boolean isCher = asstParentBill.getBoolean("isfeevoucher") || asstParentBill.getBoolean("isfivoucher") || asstParentBill.getBoolean("iscostcarryover") || asstParentBill.getBoolean("istempvoucher") || asstParentBill.getBoolean("isdischargevoucher");
        boolean realTime = AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(asstBill.getString("accounttype")) || AccountTypeEnum.FIN_FOUT.getValue().equals(asstBill.getString("accounttype"));
        boolean bizDateFlag = bizDate.compareTo(this.getMaxPeriodDateByOrgid(this.getCalOrg())) < 0;
        return bizDateFlag || realTime || isCher;
    }

    private Date getMaxPeriodDateByOrgid(long calorgId) {
        Date orgDate = this.orgMaxDate.get(calorgId);
        if (orgDate == null && (orgDate = AccountingSysHelper.getCurrentPeriodMaxDateByOrg((long)calorgId)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u4e2d\u7684\u6210\u672c\u8d26\u7c3f\uff0c\u6216\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\u3002", (String)"FeeSharePrepare_16", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return orgDate;
    }

    private List<DynamicObject> checkAsstBills(List<DynamicObject> value, boolean materialFeeShare, DynamicObject material) {
        if (materialFeeShare) {
            long apBillMaterialId = material.getLong("id");
            DynamicObject costRecord = null;
            Iterator<DynamicObject> iterator = value.iterator();
            while (iterator.hasNext()) {
                costRecord = iterator.next();
                if (costRecord.getLong("material_id") == apBillMaterialId) continue;
                iterator.remove();
            }
        }
        return value;
    }

    private Boolean judgeFailShare(DynamicObject asstBill, DynamicObject mainBill, StringBuilder resultMsg, BigDecimal[] totalShareCost) {
        boolean isSuccess;
        BigDecimal materialCost = this.getFieldCost(asstBill, "materialcost");
        BigDecimal processcost = this.getFieldCost(asstBill, "processcost");
        BigDecimal manufacturecost = this.getFieldCost(asstBill, "manufacturecost");
        BigDecimal resource = this.getFieldCost(asstBill, "resource");
        BigDecimal standardcost = this.getFieldCost(asstBill, "standardcost");
        BigDecimal totalsharefee = this.getFieldCost(asstBill, "totalsharefee");
        BigDecimal baseqty = this.getFieldCost(asstBill, "baseqty");
        BigDecimal addAll = null;
        addAll = this.isSupppotTaxAmt() ? materialCost.add(processcost).add(manufacturecost).add(resource).add(standardcost).add(totalsharefee).add(totalShareCost[1]).multiply(baseqty) : materialCost.add(processcost).add(manufacturecost).add(resource).add(standardcost).add(totalsharefee).add(totalShareCost[0]).multiply(baseqty);
        boolean bl = isSuccess = addAll.compareTo(BigDecimal.ZERO) < 0;
        if (isSuccess) {
            DynamicObject asstParentBill = (DynamicObject)asstBill.getParent();
            String msg = ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u7f16\u53f7\u201c%1$s\u201d,\u8d39\u7528\u9879\u76ee\u201c%2$s\u201d\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u7f16\u53f7%3$s\uff0c\u7b2c%4$s\u5206\u5f55\u884c\uff0c\u5206\u644a\u540e\u5b9e\u9645\u6210\u672c\u4e0e\u57fa\u672c\u6570\u91cf\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u5206\u644a\u5931\u8d25\u3002", (String)"FeeShareInitPlugin_51", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            msg = String.format(msg, ((DynamicObject)mainBill.getParent()).getString("billno"), mainBill.getDynamicObject("expenseitem"), asstParentBill.getString("billno"), asstBill.get("seq"));
            resultMsg.append(msg);
        }
        return isSuccess;
    }

    private boolean isSupppotTaxAmt() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        Object calOrgId = calOrg.getPkValue();
        QFilter qFilter = new QFilter("calorg", "=", calOrgId);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("ismainaccount", "=", (Object)"1");
        DynamicObject mainCostAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.supporttaxamt", (QFilter[])qFilter.toArray());
        return mainCostAccount.getBoolean("calpolicy.supporttaxamt");
    }

    public BigDecimal getFieldCost(DynamicObject asstBill, String field) {
        BigDecimal fieldCost = asstBill.getBigDecimal(field);
        return fieldCost == null ? BigDecimal.ZERO : fieldCost;
    }
}

