/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.matchrule.MatchResult;
import kd.fi.cal.business.matchrule.MatchRuleAlgorithm;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;
import kd.fi.cal.common.util.DBUtil;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.formplugin.calculate.in.FeeShareAlgoFactory;
import kd.fi.cal.formplugin.calculate.in.FeeShareAlgorithm;
import kd.fi.cal.formplugin.calculate.in.FeeSharePrepare;
import kd.fi.cal.formplugin.calculate.in.FeeShareRelation;
import kd.fi.cal.formplugin.calculate.in.FeeShareResultMsg;

public class FeeShareVerifyTask
extends AbstractTask {
    private static final String DLOCK_KEY_PRE = "fi-cal-FeeShareVerifyPlugin";
    private String asstQfilter;

    public void execute(RequestContext paramRequestContext, Map<String, Object> paramMap) throws KDException {
        String content;
        long calOrgId = Long.parseLong((String)paramMap.get("CALORG"));
        this.asstQfilter = (String)paramMap.get("asstQfilter");
        Long[] bizbillids = (Long[])SerializationUtils.fromJsonString((String)((String)paramMap.get("asstbizbillids")), Long[].class);
        DynamicObject calOrg = BusinessDataServiceHelper.loadSingle((Object)calOrgId, (String)"bos_org");
        String calOrgName = content = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011", (String)"FeeShareVerifyTask_17", (String)"fi-cal-formplugin", (Object[])new Object[0]), calOrg.getString("name"));
        MessageInfo msgInfo = this.getMessageInfo();
        String key = DLOCK_KEY_PRE + calOrgId;
        try (DLock lock = DLock.create((String)key, (String)"fi-cal-FeeShareVerifyPlugin-dlock");
             ShardingHintContext context = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbizbillid", FilterType.in_range, (Object)bizbillids)});){
            boolean isLockSuccess = lock.tryLock();
            if (!isLockSuccess) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u8d39\u7528\u5206\u644a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FeeShareVerifyTask_18", (String)"fi-cal-formplugin", (Object[])new Object[0]), calOrgName);
                throw new KDBizException(msg);
            }
            context.set();
            FeeShareResultMsg resultMsg = new FeeShareResultMsg();
            this.doShare(paramMap, resultMsg);
            msgInfo.setMessageContent((ILocaleString)new LocaleString(resultMsg.getResultMsg()));
        }
        catch (KDBizException e) {
            msgInfo.setMessageContent((ILocaleString)new LocaleString(e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            msgInfo.setMessageContent((ILocaleString)new LocaleString(ExceptionUtils.getExceptionStackTraceMessage((Exception)e).substring(0, 255)));
            throw e;
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
            String opName = ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a", (String)"FeeShareVerifyTask_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            CalLogInfo calLogInfo = CalLogUtils.buildCalAppLog((String)"cal_fee_share", (String)opName, (String)msgInfo.getMessageContent().getLocaleValue(), (long)calOrgId);
            CalLogUtils.addLog((CalLogInfo)calLogInfo);
        }
    }

    private void doShare(Map<String, Object> paramMap, FeeShareResultMsg resultMsg) {
        Map<String, Object> matchAndAsstAccountMap = this.getMatchResultMap(paramMap);
        Map matchResultMap = (Map)matchAndAsstAccountMap.get("matchResultMap");
        FeeSharePrepare feeSharePrepare = new FeeSharePrepare(paramMap, matchResultMap, (List)matchAndAsstAccountMap.get("asstUnMainAccount"), (Map)matchAndAsstAccountMap.get("bizdatefilter"));
        FeeShareAlgorithm feeShareAlgorithm = null;
        for (Map.Entry entry : matchResultMap.entrySet()) {
            DynamicObject mainBill = (DynamicObject)entry.getKey();
            long apBillMaterialId = mainBill.getLong("material_id");
            long apBillExpenseitemId = mainBill.getLong("expenseitem_id");
            boolean materialFeeShare = apBillExpenseitemId == 0L;
            List<DynamicObject> asstBills = this.checkAsstBills((List)entry.getValue(), materialFeeShare, apBillMaterialId);
            if (asstBills.isEmpty()) {
                String content = "\r\n" + String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u201c%1$s\u201d\u5206\u644a\u5931\u8d25\uff0c\u672a\u627e\u5230\u5339\u914d\u6570\u636e\u3002", (String)"FeeShareVerifyTask_19", (String)"fi-cal-formplugin", (Object[])new Object[0]), ((DynamicObject)mainBill.getParent()).getString("billno"));
                resultMsg.addFault(content);
                continue;
            }
            feeShareAlgorithm = materialFeeShare ? FeeShareAlgoFactory.MaterialFeeShare.create() : FeeShareAlgoFactory.ExpenseItemFeeShare.create();
            FeeShareRelation feeShareRelation = new FeeShareRelation(mainBill);
            TXHandle h1 = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    feeShareAlgorithm.excuteFeeShare(feeSharePrepare, matchAndAsstAccountMap, feeShareRelation, asstBills);
                    String content = "\r\n" + String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u201c%1$s\u201d\u5206\u644a\u6210\u529f\u3002", (String)"FeeShareVerifyTask_20", (String)"fi-cal-formplugin", (Object[])new Object[0]), ((DynamicObject)mainBill.getParent()).getString("billno"));
                    resultMsg.addSuccess(content);
                }
                catch (KDBizException e) {
                    String content = "\r\n" + String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u7f16\u53f7\uff1a%1$s\u5206\u644a\u5931\u8d25%2$s", (String)"FeeShareVerifyTask_21", (String)"fi-cal-formplugin", (Object[])new Object[0]), ((DynamicObject)mainBill.getParent()).getString("billno"), e.getMessage());
                    resultMsg.addFault(content);
                    h1.markRollback();
                }
                catch (Throwable e) {
                    h1.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h1 == null) continue;
                if (throwable != null) {
                    try {
                        h1.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h1.close();
            }
        }
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance && !feeSharePrepare.getSuccAssBillIds().isEmpty()) {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(feeSharePrepare.getSuccAssBillIds(), BalanceSourceEnum.FEE_DIVIDE);
        }
        if (!feeSharePrepare.getSuccMainBillEntryIds().isEmpty()) {
            try (TXHandle h2 = TX.requiresNew();){
                String entryIds = DBUtil.getInStringFromSet2(feeSharePrepare.getSuccMainBillEntryIds());
                String updateSql = "update t_ap_finapbilldetailentry set fisallocate  = 1 where fentryid in " + entryIds;
                DB.execute((DBRoute)new DBRoute("fi"), (String)updateSql);
                String updateSql1 = "update t_ap_finapbilldetailentry_e set fallocatedamt  = funallocatedamt,funallocatedamt = 0 where fentryid in " + entryIds;
                DB.execute((DBRoute)new DBRoute("fi"), (String)updateSql1);
            }
        }
    }

    private MessageInfo getMessageInfo() {
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>(16);
        userList.add(Long.valueOf(RequestContext.get().getUserId()));
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setMessageTitle((ILocaleString)ResManager.getLocaleString((String)"\u8d39\u7528\u5206\u644a", (String)"FeeShareVerifyTask_2", (String)"fi-cal-formplugin"));
        msgInfo.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u8d39\u7528\u5206\u644a", (String)"FeeShareVerifyTask_2", (String)"fi-cal-formplugin"));
        return msgInfo;
    }

    private Set<Long> getCalEntryId(Collection<List<DynamicObject>> mapValues) {
        HashSet<Long> calEntryIdSet = new HashSet<Long>();
        for (List<DynamicObject> list : mapValues) {
            for (DynamicObject dynamicObject : list) {
                calEntryIdSet.add(dynamicObject.getLong("calentryid"));
            }
        }
        return calEntryIdSet;
    }

    private Map<String, Object> getMatchResultMap(Map<String, Object> paramMap) {
        Collection<DynamicObject> mainBillList = this.getPageMainBill(paramMap);
        Object[] asstSetArray = (Object[])SerializationUtils.fromJsonString((String)((String)paramMap.get("asstSetArray")), Object[].class);
        List calEntryIdList = (List)asstSetArray[0];
        Map<String, Object> asstBillListMap = this.getPageAsstBill(calEntryIdList, mainBillList);
        Object mainCostRecordObj = asstBillListMap.get("MAIN");
        List mainCostRecords = new ArrayList();
        if (mainCostRecordObj != null) {
            mainCostRecords = (List)mainCostRecordObj;
        }
        Object asstCostRecordObj = asstBillListMap.get("ASST");
        ArrayList<DynamicObject> asstCostRecords = new ArrayList();
        if (asstCostRecordObj != null) {
            asstCostRecords = (List)asstCostRecordObj;
        }
        Object mainCount = asstBillListMap.get("MAINENTRYCOUNT");
        int mainCounts = 0;
        if (mainCount != null) {
            mainCounts = (Integer)mainCount;
        }
        if (mainCostRecords.isEmpty() || mainCounts != calEntryIdList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u4e2d\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6570\u636e\u5b58\u5728\u5df2\u88ab\u5220\u9664\u6216\u8005\u5df2\u88ab\u51b2\u9500\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u5206\u644a\u3002", (String)"FeeShareVerifyTask_16", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Object matchruleid = paramMap.get("matchingcondition");
        MatchRuleAlgorithm matchRule = new MatchRuleAlgorithm(matchruleid, "detailentry", "entry");
        MatchResult resultRule = matchRule.matchRules(mainBillList, mainCostRecords);
        Map matchResultMap = resultRule.getResultmap();
        Collection<List<DynamicObject>> mainCostRecordCollection = matchResultMap.values();
        Map<String, Object> asstUnMainAccount = this.getAsstUnMainAccount(mainCostRecordCollection, asstCostRecords);
        asstUnMainAccount.put("matchResultMap", matchResultMap);
        asstUnMainAccount.put("bizdatefilter", asstBillListMap.get("BIZDATEFILTER"));
        return asstUnMainAccount;
    }

    private Map<String, Object> getAsstUnMainAccount(Collection<List<DynamicObject>> mapValues, List<DynamicObject> asstCostRecords) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set<Long> calEntryIdSet = this.getCalEntryId(mapValues);
        long calEntryId = 0L;
        long entryId = 0L;
        HashSet<Long> entryIdSet = null;
        HashMap asstCostRecordEntryIdMap = new HashMap();
        for (DynamicObject dynamicObject : asstCostRecords) {
            DynamicObjectCollection entryObj = dynamicObject.getDynamicObjectCollection("entry");
            for (int i = entryObj.size() - 1; i >= 0; --i) {
                calEntryId = ((DynamicObject)entryObj.get(i)).getLong("calentryid");
                if (calEntryIdSet.contains(calEntryId)) {
                    entryId = ((DynamicObject)entryObj.get(i)).getLong("id");
                    entryIdSet = (HashSet<Long>)asstCostRecordEntryIdMap.get(calEntryId);
                    if (entryIdSet == null) {
                        entryIdSet = new HashSet<Long>();
                        entryIdSet.add(entryId);
                        asstCostRecordEntryIdMap.put(calEntryId, entryIdSet);
                        continue;
                    }
                    ((Set)asstCostRecordEntryIdMap.get(calEntryId)).add(entryId);
                    continue;
                }
                entryObj.remove(i);
            }
        }
        resultMap.put("asstUnMainAccount", asstCostRecords);
        resultMap.put("asstCostRecordEntryIdMap", asstCostRecordEntryIdMap);
        return resultMap;
    }

    private Collection<DynamicObject> getPageMainBill(Map<String, Object> paramMap) {
        Object[] mainSetArray = (Object[])SerializationUtils.fromJsonString((String)((String)paramMap.get("mainSetArray")), Object[].class);
        List ids = (List)mainSetArray[0];
        List<Long> entryIds = (List<Long>)mainSetArray[1];
        entryIds = this.getMainBillEntry(entryIds);
        Object[] objArray = new Object[ids.size()];
        DynamicObject[] mainObj = BusinessDataServiceHelper.load((Object[])ids.toArray(objArray), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ap_finapbill"));
        if (mainObj.length == 0 || entryIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u5931\u8d25\uff0c\u4e3b\u65b9\u5355\u636e\u4e2d\u7684\u5e94\u4ed8\u5355\u5b58\u5728\u88ab\u5220\u9664\u3001\u53cd\u5ba1\u6838\u6216\u8005\u5df2\u88ab\u5206\u644a\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u5206\u644a\u3002", (String)"FeeShareVerifyTask_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject dynamicObject : mainObj) {
            DynamicObjectCollection entryObj = dynamicObject.getDynamicObjectCollection("detailentry");
            for (int i = entryObj.size() - 1; i >= 0; --i) {
                long eId = ((DynamicObject)entryObj.get(i)).getLong("id");
                if (entryIds.contains(eId)) continue;
                entryObj.remove(i);
            }
        }
        return Arrays.asList(mainObj);
    }

    private Map<String, Object> getPageAsstBill(List<Long> calEntryIdList, Collection<DynamicObject> mainBillList) {
        int mainEntryCount = 0;
        QFilter costREcordFilter = new QFilter("entry.calentryid", "in", calEntryIdList);
        QFilter costAcountFilter = QFilter.fromSerializedString((String)this.asstQfilter);
        costREcordFilter.and(costAcountFilter);
        costREcordFilter.and("costaccount.enable", "=", (Object)"1");
        costREcordFilter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        costREcordFilter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)FeeShareHelper.getCostRecordFields(), (QFilter[])costREcordFilter.toArray());
        long calEntryId = 0L;
        for (DynamicObject dynamicObject : costRecords) {
            DynamicObjectCollection entryObj = dynamicObject.getDynamicObjectCollection("entry");
            for (int i = entryObj.size() - 1; i >= 0; --i) {
                calEntryId = ((DynamicObject)entryObj.get(i)).getLong("calentryid");
                if (calEntryIdList.contains(calEntryId)) continue;
                entryObj.remove(i);
            }
        }
        boolean isMainAccount = false;
        ArrayList<DynamicObject> mainCostRecords = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> asstCostRecords = new ArrayList<DynamicObject>();
        for (DynamicObject costRecord : costRecords) {
            isMainAccount = costRecord.getBoolean("costaccount.ismainaccount");
            if (isMainAccount) {
                mainCostRecords.add(costRecord);
                int costCount = costRecord.getDynamicObjectCollection("entry").size();
                mainEntryCount += costCount;
                continue;
            }
            asstCostRecords.add(costRecord);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ASST", asstCostRecords);
        hashMap.put("MAIN", mainCostRecords);
        hashMap.put("MAINENTRYCOUNT", mainEntryCount);
        hashMap.put("BIZDATEFILTER", this.getBizDateFilter(mainBillList, costRecords));
        return hashMap;
    }

    private Map<Long, QFilter> getBizDateFilter(Collection<DynamicObject> mainBillList, DynamicObject[] costRecords) {
        HashMap<Long, QFilter> bizDateFilterMap = new HashMap<Long, QFilter>(16);
        for (DynamicObject mainBill : mainBillList) {
            Long mainBillId = mainBill.getLong("id");
            Date mainBizDate = mainBill.getDate("bookdate");
            HashMap bizdateEntryIdsMap = new HashMap(16);
            for (DynamicObject costRecord : costRecords) {
                Date asstBizDate = costRecord.getDate("bookdate");
                Date bizDate = mainBizDate.after(asstBizDate) ? mainBizDate : asstBizDate;
                HashSet<Long> entryIds = (HashSet<Long>)bizdateEntryIdsMap.get(bizDate);
                if (entryIds == null) {
                    entryIds = new HashSet<Long>(16);
                    bizdateEntryIdsMap.put(bizDate, entryIds);
                }
                DynamicObjectCollection costRecordEntry = costRecord.getDynamicObjectCollection("entry");
                for (DynamicObject dynamicObject : costRecordEntry) {
                    entryIds.add(dynamicObject.getLong("id"));
                }
            }
            QFilter qFilter = null;
            for (Map.Entry mapEntry : bizdateEntryIdsMap.entrySet()) {
                QFilter bizDateFilter = new QFilter("bookdate", "<=", (Object)DateUtils.getDayEndTime((Date)((Date)mapEntry.getKey())));
                bizDateFilter.and("entryentity.invbillentryid", "in", mapEntry.getValue());
                if (qFilter == null) {
                    qFilter = bizDateFilter;
                    continue;
                }
                qFilter.or(bizDateFilter);
            }
            bizDateFilterMap.put(mainBillId, qFilter);
        }
        return bizDateFilterMap;
    }

    private List<Long> getMainBillEntry(List<Long> entryIds) {
        DynamicObjectCollection dbMainBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"billno,detailentry.id", (QFilter[])new QFilter("detailentry.id", "in", entryIds).and(new QFilter("detailentry.isallocate", "=", (Object)"1").or("billstatus", "!=", (Object)"C")).toArray());
        if (dbMainBills.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u5931\u8d25\uff0c\u4e3b\u65b9\u5355\u636e\u4e2d\u7684\u5e94\u4ed8\u5355\u5b58\u5728\u88ab\u5220\u9664\u3001\u53cd\u5ba1\u6838\u6216\u8005\u5df2\u88ab\u5206\u644a\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u5206\u644a\u3002", (String)"FeeShareVerifyTask_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return entryIds;
    }

    private List<DynamicObject> checkAsstBills(List<DynamicObject> value, boolean materialFeeShare, long apBillMaterialId) {
        if (materialFeeShare) {
            DynamicObject costRecord = null;
            Iterator<DynamicObject> iterator = value.iterator();
            while (iterator.hasNext()) {
                costRecord = iterator.next();
                if (costRecord.getLong("material_id") == apBillMaterialId) continue;
                iterator.remove();
            }
        }
        return value;
    }
}

