/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.in;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.fi.cal.common.helper.CommonSettingHelper;

public class SubEntityUtil {
    private static final String UNITACTUALCOST = "unitactualcost";
    private static final String ACTUALCOST = "actualcost";
    private static final String BASEQTY = "baseqty";

    public static Set<String> getSubEleFieldNumSet(DynamicObjectCollection costSubElements) {
        HashSet<String> resultSet = new HashSet<String>(costSubElements.size());
        for (DynamicObject subElement : costSubElements) {
            DynamicObject info = subElement.getDynamicObject("fbasedataid");
            String subEleNum = info.getString("number").toLowerCase();
            resultSet.add(subEleNum + "_unitcost");
            resultSet.add(subEleNum + "_cost");
        }
        return resultSet;
    }

    public static void subEleCostChange(String propertyName, ChangeData changeData, IDataModel model, int precision, IFormView view) {
        BigDecimal diffAmt;
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        BigDecimal baseQty = (BigDecimal)model.getValue(BASEQTY, rowIndex);
        BigDecimal actualCost = (BigDecimal)model.getValue(ACTUALCOST, rowIndex);
        if (propertyName.endsWith("_unitcost")) {
            String costName = propertyName.substring(0, propertyName.length() - 9) + "_cost";
            BigDecimal oldCost = (BigDecimal)model.getValue(costName, rowIndex);
            BigDecimal newCost = newValue.multiply(baseQty).setScale(precision, RoundingMode.HALF_UP);
            diffAmt = newCost.subtract(oldCost);
            model.setValue(costName, (Object)newCost, rowIndex);
            view.updateView(costName, rowIndex);
        } else {
            diffAmt = newValue.subtract(oldValue);
            String unitCostName = propertyName.substring(0, propertyName.length() - 5) + "_unitcost";
            model.setValue(unitCostName, (Object)SubEntityUtil.calUnitCostByAct(baseQty, newValue), rowIndex);
            view.updateView(unitCostName, rowIndex);
        }
        BigDecimal newActualCost = actualCost.add(diffAmt);
        model.setValue(ACTUALCOST, (Object)newActualCost, rowIndex);
        model.setValue(UNITACTUALCOST, (Object)SubEntityUtil.calUnitCostByAct(baseQty, newActualCost), rowIndex);
        view.updateView(ACTUALCOST, rowIndex);
        view.updateView(UNITACTUALCOST, rowIndex);
    }

    public static BigDecimal calUnitCostByAct(BigDecimal qty, BigDecimal cost) {
        BigDecimal unitCost = BigDecimal.ZERO;
        if (qty.compareTo(BigDecimal.ZERO) != 0) {
            unitCost = cost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        return unitCost;
    }

    public static Set<String> getOminBizObjectSet() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection ominBizObjects = setting.getDynamicObjectCollection("ominbiztype");
        if (ominBizObjects == null || ominBizObjects.isEmpty()) {
            return null;
        }
        HashSet<String> ominBizObjectSet = new HashSet<String>(ominBizObjects.size());
        for (DynamicObject ominBizObject : ominBizObjects) {
            ominBizObjectSet.add((String)ominBizObject.getDynamicObject("fbasedataid").getPkValue());
        }
        return ominBizObjectSet;
    }
}

