/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class BizGroupRecordBuilderPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String opKey = event.getOperateKey();
        if ("query".equals(opKey)) {
            this.queryBizGroupRecord();
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"itemsbar"});
    }

    private void queryBizGroupRecord() {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue("mulcostaccount");
        DynamicObjectCollection materials = (DynamicObjectCollection)this.getModel().getValue("mulmaterial");
        String mulbillno = (String)this.getModel().getValue("mulbillno");
        if (StringUtils.isEmpty((String)mulbillno)) {
            mulbillno = (String)this.getModel().getValue("mulbillno_tag");
        }
        DynamicObjectCollection billnoentry = this.getModel().getEntryEntity("billnoentry");
        DataSet groupDS = null;
        if (costAccounts != null && !costAccounts.isEmpty()) {
            groupDS = this.getGroupDSByCostAccountMaterials(costAccounts, materials);
        } else if (StringUtils.isNotEmpty((String)mulbillno)) {
            groupDS = this.getGroupDSByCostRecordBillnos(mulbillno);
        } else if (billnoentry != null && !billnoentry.isEmpty()) {
            groupDS = this.getGroupDSByBizBillnos(billnoentry);
        }
        if (groupDS == null) {
            return;
        }
        groupDS = this.replaceSrcBill(groupDS);
        this.buildEntry(groupDS);
    }

    private void buildEntry(DataSet groupDS) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String[] allFields = groupDS.getRowMeta().getFieldNames();
        for (String field : allFields) {
            vs.addField(field, new Object[0]);
        }
        for (Row row : groupDS) {
            Object[] objects = new Object[allFields.length];
            for (int i = 0; i < allFields.length; ++i) {
                objects[i] = row.get(allFields[i]);
            }
            vs.addRow(objects);
        }
        this.getModel().beginInit();
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            DynamicObjectCollection recordentry = this.getModel().getEntryEntity("recordentry");
            recordentry.clear();
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("recordentry", vs);
        }
        this.getModel().endInit();
        this.getView().updateView("recordentry");
    }

    private DataSet getGroupDSByBizBillnos(DynamicObjectCollection billnoentry) {
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("bizentityobject", (DataType)DataType.StringType), new Field("id", (DataType)DataType.LongType)});
        for (DynamicObject entryRow : billnoentry) {
            String formid = entryRow.getString("entityobject.id");
            String billnos = entryRow.getString("billnos");
            if (StringUtils.isEmpty((String)billnos)) {
                billnos = entryRow.getString("billnos_tag");
            }
            if (!StringUtils.isNotEmpty((String)formid) || !StringUtils.isNotEmpty((String)billnos)) continue;
            billnos = billnos.replaceAll("[\\s\\n\\r\\;]", ",");
            String[] billNos = billnos.split(",");
            QFilter filter = new QFilter("billno", "in", (Object)billNos);
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), formid, "'" + formid + "' as bizentityobject,id", filter.toArray(), rowMeta);
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            return null;
        }
        HashMap<String, Set> entity2BizbillidsMap = new HashMap<String, Set>(4);
        try (DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0]));){
            for (Row row : dataSet) {
                String entityobject = row.getString("bizentityobject");
                Long bizbillid = row.getLong("id");
                Set bizbillids = entity2BizbillidsMap.computeIfAbsent(entityobject, k -> new HashSet(4));
                bizbillids.add(bizbillid);
            }
        }
        if (entity2BizbillidsMap.isEmpty()) {
            return null;
        }
        DataSet allGroupRecordDataSet = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(entity2BizbillidsMap);
        return allGroupRecordDataSet;
    }

    private DataSet getGroupDSByCostRecordBillnos(String mulbillno) {
        mulbillno = mulbillno.trim();
        mulbillno = mulbillno.replaceAll("[\\s\\n\\r\\;]", ",");
        String[] billNos = mulbillno.split(",");
        QFilter filter = new QFilter("billno", "in", (Object)billNos);
        HashMap<String, Set> entity2BizbillidsMap = new HashMap<String, Set>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"bizbillid,bizentityobject", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                String entityobject = row.getString("bizentityobject");
                Long bizbillid = row.getLong("bizbillid");
                Set bizbillids = entity2BizbillidsMap.computeIfAbsent(entityobject, k -> new HashSet(4));
                bizbillids.add(bizbillid);
            }
        }
        if (entity2BizbillidsMap.isEmpty()) {
            return null;
        }
        DataSet allGroupRecordDataSet = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(entity2BizbillidsMap);
        return allGroupRecordDataSet;
    }

    private DataSet getGroupDSByCostAccountMaterials(DynamicObjectCollection costAccounts, DynamicObjectCollection materials) {
        HashMap costaccount2MaterialMap = new HashMap(4);
        HashSet<Long> materialids = new HashSet<Long>(16);
        if (materials != null) {
            for (DynamicObject material : materials) {
                materialids.add(material.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        for (DynamicObject costAccount : costAccounts) {
            costaccount2MaterialMap.put(costAccount.getDynamicObject("fbasedataid").getLong("id"), materialids);
        }
        DataSet allGroupRecordDataSet = new BizGroupRecordBuilder().getAllGroupRecordDataSetByCostAccount(costaccount2MaterialMap);
        return allGroupRecordDataSet;
    }

    private DataSet replaceSrcBill(DataSet groupDS) {
        Boolean replaceSrcBill = (Boolean)this.getModel().getValue("replacesrcbill");
        if (!replaceSrcBill.booleanValue()) {
            return groupDS;
        }
        String[] fieldNames = groupDS.getRowMeta().getFieldNames();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.BIZGROUP_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = groupDS.cache(cacheHint);
        String cacheId = cache.getCacheId();
        cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"RefreshGroupRecordService", (String)"replaceSrcBill", (Object[])new Object[]{cacheId});
        groupDS = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)BizGroupRecordBuilderPlugin.class.getName()), true).select(fieldNames);
        return groupDS;
    }
}

