/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListColumnCompareType;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.formplugin.base.CalOrgAcctLinkListPlugin;

public class CalculateOutCostListPlugin
extends CalOrgAcctLinkListPlugin {
    private Map<Object, DynamicObject> valueMap = new HashMap<Object, DynamicObject>();
    private Map<Long, Boolean> rangeEmptyEntrysMap = new HashMap<Long, Boolean>();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        DynamicObject[] calRangeDys;
        args.setListDataProvider((IListDataProvider)new CalculateOutCostListDataProvider());
        QFilter q = new QFilter("enable", "=", (Object)true);
        for (DynamicObject calRangeDy : calRangeDys = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"masterid,entry", (QFilter[])q.toArray())) {
            long masterId = calRangeDy.getLong("masterid");
            DynamicObjectCollection entrys = calRangeDy.getDynamicObjectCollection("entry");
            boolean emptyEntryFlag = false;
            if (entrys == null || entrys.isEmpty()) {
                emptyEntryFlag = true;
            }
            this.rangeEmptyEntrysMap.putIfAbsent(masterId, emptyEntryFlag);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject row = e.getRowData();
        String divideBasisStr = row.getString("dividebasis.dividebasis");
        String divideBasisValue = row.getString("dividebasisvalue");
        String caldimensionStr = row.getString("caldimension.caldimension");
        String caldimensionValue = row.getString("caldimensionvalue");
        AbstractColumnDesc col = (AbstractColumnDesc)e.getSource();
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_balance");
        if ("dividebasisvalue".equals(col.getFieldKey())) {
            DynamicObject calRangeObject = row.getDynamicObject("calrange");
            if (calRangeObject != null) {
                long masterId = row.getLong("calrange.masterid");
                Boolean emptyEntryFlag = this.rangeEmptyEntrysMap.getOrDefault(masterId, true);
                if (emptyEntryFlag.booleanValue()) {
                    e.setFormatValue((Object)this.getFieldsDisplayValue(divideBasisStr, divideBasisValue, balEntityType, this.valueMap));
                } else {
                    e.setFormatValue((Object)" ");
                }
            } else {
                e.setFormatValue((Object)this.getFieldsDisplayValue(divideBasisStr, divideBasisValue, balEntityType, this.valueMap));
            }
        }
        if ("caldimensionvalue".equals(col.getFieldKey())) {
            e.setFormatValue((Object)this.getFieldsDisplayValue(caldimensionStr, caldimensionValue, balEntityType, this.valueMap));
        }
        super.packageData(e);
    }

    private void buildBaseDataIdMap(String fieldStr, String valueStr, MainEntityType balEntityType, Map<String, Set<Object>> baseDataIdMap) {
        if (StringUtils.isEmpty((String)fieldStr)) {
            return;
        }
        String[] fields = fieldStr.split(",");
        String[] singleValues = valueStr.split("&");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            IDataEntityProperty property = balEntityType.findProperty(field);
            if (field.equals("assist") || !(property instanceof BasedataProp)) continue;
            for (String singleValue : singleValues) {
                String value;
                String[] values = singleValue.split("_");
                if (i >= values.length || StringUtils.isEmpty((String)(value = values[i])) || "#".equals(value)) continue;
                if (baseDataIdMap.get(field) != null) {
                    baseDataIdMap.get(field).add(Long.valueOf(value));
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(Long.valueOf(value));
                baseDataIdMap.put(field, set);
            }
        }
    }

    private void cacheBaseDataMap(Map<String, Set<Object>> baseDataIdMap, MainEntityType balEntityType, Map<Object, DynamicObject> valueMap) {
        for (Map.Entry<String, Set<Object>> entry : baseDataIdMap.entrySet()) {
            String field = entry.getKey();
            IDataEntityProperty property = balEntityType.findProperty(field);
            if (field.equals("assist") || !(property instanceof BasedataProp)) continue;
            String entity = ((BasedataProp)property).getBaseEntityId();
            if (field.equals("owner")) {
                entity = "bos_org";
            }
            valueMap.putAll(BusinessDataServiceHelper.loadFromCache((Object[])entry.getValue().toArray(), (String)entity));
        }
    }

    private String getFieldsDisplayValue(String fieldStr, String fieldValue, MainEntityType balEntityType, Map<Object, DynamicObject> valueMap) {
        if (StringUtils.isEmpty((String)fieldStr)) {
            return ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutCostListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        String[] fields = fieldStr.split(",");
        String[] singleValues = fieldValue.split("&");
        StringBuilder sb = new StringBuilder();
        for (String singleValue : singleValues) {
            String[] values = singleValue.split("_");
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (i >= values.length) {
                    sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutCostListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                } else {
                    String value = values[i];
                    IDataEntityProperty property = balEntityType.findProperty(field);
                    if (property instanceof BasedataProp) {
                        Long id;
                        if (value.trim().isEmpty() || "#".equals(value)) {
                            sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutCostListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                        } else if ("assist".equals(field)) {
                            id = Long.valueOf(value);
                            if (id.equals(0L)) {
                                sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutCostListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                            } else {
                                sb.append(id);
                            }
                        } else {
                            id = Long.valueOf(value);
                            if (id.equals(0L)) {
                                sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutCostListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                            } else {
                                DynamicObject obj;
                                String baseEntity = ((BasedataProp)property).getBaseEntityId();
                                String nameFiled = ((BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseEntity)).getNameProperty();
                                if (StringUtils.isEmpty((String)nameFiled)) {
                                    nameFiled = "name";
                                }
                                if ((obj = valueMap.get(id)) == null) {
                                    sb.append(id);
                                } else if ("tracknumber".equals(field)) {
                                    sb.append(obj.get("number"));
                                } else if ("configuredcode".equals(field)) {
                                    sb.append(obj.get("number"));
                                } else {
                                    sb.append(obj.get(nameFiled));
                                }
                            }
                        }
                    } else if (value.trim().isEmpty() || "#".equals(value)) {
                        sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutCostListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    } else {
                        sb.append(value);
                    }
                }
                sb.append('+');
            }
            if (sb.length() > 0) {
                sb = sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(';');
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String filter = (String)this.getView().getFormShowParameter().getCustomParam("filter");
        if (filter != null && StringUtils.isNotEmpty((String)filter)) {
            e.getQFilters().add(QFilter.of((String)filter, (Object[])new Object[0]));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object costAccount = params.get("cus_costaccount");
        Object orgId = params.get("cus_orgId");
        if (costAccount != null && orgId != null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                String fieldName;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                switch (fieldName = commonFilterColumn.getFieldName()) {
                    case "calorg.number": {
                        commonFilterColumn.setDefaultValue(orgId.toString());
                        break;
                    }
                    case "costaccount.number": {
                        commonFilterColumn.setDefaultValue(costAccount.toString());
                    }
                }
            }
        }
    }

    @Override
    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        if ("caldimensionvalue".equals(args.getListFieldKey())) {
            List srcs = args.getListColumnCompareTypes();
            ArrayList<ListColumnCompareType> decs = new ArrayList<ListColumnCompareType>(16);
            if (srcs != null && srcs.size() > 0) {
                for (ListColumnCompareType src : srcs) {
                    String typeId = src.getId();
                    if (!"59".equals(typeId)) continue;
                    decs.add(src);
                }
            }
            args.setListColumnCompareTypes(decs);
        }
    }

    private class CalculateOutCostListDataProvider
    extends ListDataProvider {
        private CalculateOutCostListDataProvider() {
        }

        public void setListFields(List<ListField> listFields) {
            ListField f = new ListField("caldimensionvalue");
            f.setFieldName("caldimensionvalue");
            listFields.add(f);
            ListField f1 = new ListField("dividebasisvalue");
            f1.setFieldName("dividebasisvalue");
            listFields.add(f1);
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            HashMap baseDataIdMap = new HashMap();
            MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_balance");
            for (DynamicObject row : rows) {
                String divideBasisStr = row.getString("dividebasis.dividebasis");
                String divideBasisValue = row.getString("dividebasisvalue");
                String caldimensionStr = row.getString("caldimension.caldimension");
                String caldimensionValue = row.getString("caldimensionvalue");
                CalculateOutCostListPlugin.this.buildBaseDataIdMap(divideBasisStr, divideBasisValue, balEntityType, baseDataIdMap);
                CalculateOutCostListPlugin.this.buildBaseDataIdMap(caldimensionStr, caldimensionValue, balEntityType, baseDataIdMap);
            }
            CalculateOutCostListPlugin.this.cacheBaseDataMap(baseDataIdMap, balEntityType, CalculateOutCostListPlugin.this.valueMap);
            return rows;
        }
    }
}

