/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.out;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class CalculateOutRptFilterListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CalculateOutRptFilterListPlugin.class);
    private String[] divFields = new String[]{"storageorgunit", "warehouse"};
    private String[] caldimensionFields = new String[]{"configuredcode", "project", "tracknumber"};

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.setDivFields(qFilters);
        block0: for (QFilter qFilter : qFilters) {
            QFilter divValueFilter;
            if ("dividebasisvalue".equals(qFilter.getProperty())) {
                divValueFilter = qFilter;
                this.replaceDivCalDimIdFilter(divValueFilter, "dividebasisvalue", this.divFields);
                if (divValueFilter.getCP().equalsIgnoreCase("is not null")) break;
            }
            if ("caldimensionvalue".equals(qFilter.getProperty())) {
                divValueFilter = qFilter;
                this.replaceDivCalDimIdFilter(divValueFilter, "caldimensionvalue", this.caldimensionFields);
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter curFilter = nest.getFilter();
                if ("dividebasisvalue".equals(curFilter.getProperty())) {
                    this.replaceDivCalDimIdFilter(curFilter, "dividebasisvalue", this.divFields);
                    continue block0;
                }
                if (!"caldimensionvalue".equals(curFilter.getProperty())) continue;
                this.replaceDivCalDimIdFilter(curFilter, "caldimensionvalue", this.caldimensionFields);
                continue block0;
            }
        }
    }

    private void replaceDivCalDimIdFilter(QFilter divValueFilter, String filterFiledName, String[] divFields) {
        if (divValueFilter == null) {
            return;
        }
        Object value = divValueFilter.getValue();
        List<String> divValues = new ArrayList(16);
        Object firstValue = value;
        if (value instanceof List) {
            divValues = (List)value;
            if (divValues.size() > 0) {
                firstValue = divValues.get(0);
            }
        } else if (value instanceof String) {
            divValues.add((String)value);
        }
        if (firstValue == null || !(firstValue instanceof String)) {
            if (divValueFilter.getCP().equalsIgnoreCase("is not null")) {
                divValueFilter.and(filterFiledName, "!=", (Object)"#");
                divValueFilter.and(filterFiledName, "!=", (Object)" ");
            } else if (firstValue instanceof QEmptyValue) {
                divValueFilter.or(filterFiledName, "=", (Object)"#");
            }
            return;
        }
        Map<String, Set<String>> divFieldValuesMap = this.getDivFieldValuesMap(divFields, divValues);
        Map<String, Map<String, String>> divFieldNameOrNumberIdMap = this.getDivNameOrNumberIdMap(divValueFilter, divFieldValuesMap);
        ArrayList<String> dbDivValues = new ArrayList<String>(16);
        boolean isLike = divValueFilter.getCP().toLowerCase().contains("like");
        for (String divValue : divValues) {
            boolean isFirstLike;
            if (kd.bos.util.StringUtils.isEmpty((String)divValue)) continue;
            int index = divValue.lastIndexOf("%");
            int firstIndex = divValue.indexOf("%");
            boolean isLastLike = index == divValue.length() - 1;
            boolean bl = isFirstLike = firstIndex == 0;
            if (isLike && isLastLike) {
                divValue = divValue.substring(0, index);
            }
            if (isLike && isFirstLike) {
                divValue = divValue.substring(1, divValue.length());
            }
            if (kd.bos.util.StringUtils.isEmpty((String)divValue)) continue;
            CharSequence[] splitValues = divValue.split("\\+");
            boolean equalSize = divFields.length == splitValues.length;
            for (int i = 0; i < divFields.length; ++i) {
                String divField = divFields[i];
                Map<String, String> nameOrNumberIdMap = divFieldNameOrNumberIdMap.get(divField);
                if (nameOrNumberIdMap == null || nameOrNumberIdMap.isEmpty()) continue;
                if (equalSize) {
                    splitValues[i] = nameOrNumberIdMap.get(splitValues[i]);
                    continue;
                }
                String fieldId = nameOrNumberIdMap.get(divValue);
                if (fieldId == null) continue;
                divValue = fieldId;
            }
            if (equalSize) {
                divValue = String.join((CharSequence)"_", splitValues);
            }
            dbDivValues.add(divValue);
            if (isLike) continue;
            String divValue1 = divValue + "_";
            dbDivValues.add(divValue1);
        }
        ArrayList<String> filterValue = dbDivValues;
        if (dbDivValues.size() == 1) {
            filterValue = dbDivValues.get(0);
        } else if (dbDivValues.size() > 1) {
            if (divValueFilter.getCP().equals("=")) {
                divValueFilter.__setCP("in");
            } else if (divValueFilter.getCP().equals("!=") || divValueFilter.getCP().equals("<>")) {
                divValueFilter.__setCP("not in");
            }
        }
        divValueFilter.__setValue(filterValue);
        String filterValue0 = divValues.get(0);
        if (isLike && filterValue0.startsWith("%") && !filterValue0.endsWith("%")) {
            divValueFilter.or(filterFiledName, "like", (Object)("%" + filterValue + "_"));
        }
    }

    private Map<String, Map<String, String>> getDivNameOrNumberIdMap(QFilter divValueFilter, Map<String, Set<String>> divFieldValuesMap) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        HashMap<String, Map<String, String>> divFieldNameOrNumberIdMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("name", (DataType)DataType.StringType), new Field("id", (DataType)DataType.LongType), new Field("number", (DataType)DataType.StringType), new Field("fieldKey", (DataType)DataType.StringType)});
        for (Map.Entry<String, Set<String>> divFieldValuesEntry : divFieldValuesMap.entrySet()) {
            String fieldKey = divFieldValuesEntry.getKey();
            IDataEntityProperty property = entityType.findProperty(fieldKey);
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp baseProp = (BasedataProp)property;
            String baseEntityId = baseProp.getBaseEntityId();
            String numberProp = baseProp.getNumberProp();
            String nameProp = "name";
            Object filterValueObj = divFieldValuesEntry.getValue();
            if (divFieldValuesEntry.getValue().size() == 1) {
                filterValueObj = divFieldValuesEntry.getValue().iterator().next();
            }
            QFilter numberFilter = new QFilter(numberProp, divValueFilter.getCP(), filterValueObj);
            QFilter nameFilter = new QFilter(nameProp, divValueFilter.getCP(), filterValueObj);
            String selectFields = nameProp + ",id," + numberProp + ",'" + fieldKey + "' as fieldKey";
            OrmInput numberInput = new OrmInput(((Object)((Object)this)).getClass().getName(), baseEntityId, selectFields, new QFilter[]{numberFilter}, rowMeta);
            inputs.add(numberInput);
            OrmInput nameInput = new OrmInput(((Object)((Object)this)).getClass().getName(), baseEntityId, selectFields, new QFilter[]{nameFilter}, rowMeta);
            inputs.add(nameInput);
        }
        if (inputs.size() > 0) {
            try (DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0]));){
                for (Row row : dataSet) {
                    Map nameOrNumberIdMap = divFieldNameOrNumberIdMap.computeIfAbsent(row.getString("fieldKey"), k -> new HashMap(16));
                    nameOrNumberIdMap.put(row.getString("number"), row.getString("id"));
                    nameOrNumberIdMap.put(row.getString("name"), row.getString("id"));
                }
            }
        }
        return divFieldNameOrNumberIdMap;
    }

    private Map<String, Set<String>> getDivFieldValuesMap(String[] divFields, List<String> divValues) {
        HashMap<String, Set<String>> divFieldValuesMap = new HashMap<String, Set<String>>(16);
        for (String divValue : divValues) {
            Set fieldValues;
            String divField;
            int j;
            String[] splitValue;
            int length;
            if (StringUtils.isEmpty((CharSequence)divValue) || (length = Math.min(divFields.length, (splitValue = divValue.split("\\+")).length)) < 1) continue;
            if (length == 1) {
                for (j = 0; j < divFields.length; ++j) {
                    divField = divFields[j];
                    fieldValues = divFieldValuesMap.computeIfAbsent(divField, k -> new HashSet(16));
                    String fieldValue = splitValue.length == 1 ? splitValue[0] : splitValue[j];
                    fieldValues.add(fieldValue);
                }
                continue;
            }
            for (j = 0; j < length; ++j) {
                divField = divFields[j];
                fieldValues = divFieldValuesMap.computeIfAbsent(divField, k -> new HashSet(16));
                fieldValues.add(splitValue[j]);
            }
        }
        return divFieldValuesMap;
    }

    private void setDivFields(List<QFilter> qFilters) {
        try {
            QFilter divValueFilter = null;
            for (QFilter qFilter : qFilters) {
                String property = qFilter.getProperty();
                if (property == null || !property.contains("dividebasis.")) continue;
                divValueFilter = qFilter.copy();
                divValueFilter.__setProperty(property.replace("dividebasis.", ""));
                break;
            }
            if (divValueFilter == null) {
                return;
            }
            DynamicObject divDyc = QueryServiceHelper.queryOne((String)"cal_bd_dividebasis", (String)"dividebasis", (QFilter[])divValueFilter.toArray());
            if (divDyc == null) {
                return;
            }
            String divStr = divDyc.getString("dividebasis");
            this.divFields = divStr.split(",");
        }
        catch (Throwable e) {
            logger.info("\u89e3\u6790\u5f55\u5165\u7684\u5212\u5206\u4f9d\u636e\u57fa\u7840\u8d44\u6599\u9519\u8bef\uff0c\u4e0d\u5f71\u54cd\u529f\u80fd");
            WriteLogHelper.writeErrorLog((Log)logger, (String)"CalculateOutRptFilterListPlugin-setDivFields", (Throwable)e);
        }
    }
}

