/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.calculate.out;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.DateUtils;

public class CalculateOutRptPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(CalculateOutRptPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        if (model.getValue("costaccount") == null) {
            return;
        }
        String[] divideBasis = ((DynamicObject)model.getValue("dividebasis")).getString("dividebasis").split(",");
        DynamicObject caldimensionObj = (DynamicObject)model.getValue("caldimension");
        String[] caldimension = this.getCaldimensions(caldimensionObj);
        Map<String, IDataEntityProperty> map = this.getPropertyTypeMap(divideBasis, caldimension);
        String divideValues = (String)model.getValue("dividebasisvalue");
        String newDivideValues = this.translateValue(divideBasis, map, divideValues);
        model.setValue("dividebasisvalue", (Object)newDivideValues);
        String caldimensionValues = (String)model.getValue("caldimensionvalue");
        String newCaldimensionValues = this.translateValue(caldimension, map, caldimensionValues);
        model.setValue("caldimensionvalue", (Object)newCaldimensionValues);
        String accounttype = (String)model.getValue("accounttype");
        Long assist = null;
        Long configuredcode = null;
        Long project = null;
        Long tracknumber = null;
        if (caldimensionObj != null && StringUtils.isNotEmpty((String)caldimensionValues)) {
            String[] caldimensionStrs = caldimensionObj.getString("caldimension").split(",");
            String[] caldimensionValue = caldimensionValues.split("_");
            if (caldimensionValue.length >= caldimensionStrs.length) {
                for (int i = 0; i < caldimensionStrs.length; ++i) {
                    try {
                        if ("assist".equals(caldimensionStrs[i])) {
                            assist = Long.valueOf(caldimensionValue[i]);
                            continue;
                        }
                        if ("configuredcode".equals(caldimensionStrs[i])) {
                            configuredcode = Long.valueOf(caldimensionValue[i]);
                            continue;
                        }
                        if ("project".equals(caldimensionStrs[i])) {
                            project = Long.valueOf(caldimensionValue[i]);
                            continue;
                        }
                        if (!"tracknumber".equals(caldimensionStrs[i])) continue;
                        tracknumber = Long.valueOf(caldimensionValue[i]);
                        continue;
                    }
                    catch (Exception e2) {
                        WriteLogHelper.writeErrorLog((Log)logger, (String)"CalculateOutRptPlugin-afterBindData", (Throwable)e2);
                    }
                }
            }
        }
        if (assist != null && assist.compareTo(0L) != 0) {
            this.getModel().setValue("assist", (Object)assist);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"assist"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"assist"});
        }
        if (configuredcode != null && configuredcode.compareTo(0L) != 0) {
            this.getModel().setValue("configuredcode", (Object)configuredcode);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"configuredcode"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"configuredcode"});
        }
        if (project != null && project.compareTo(0L) != 0) {
            this.getModel().setValue("project", (Object)project);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"project"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"project"});
        }
        if (tracknumber != null && tracknumber.compareTo(0L) != 0) {
            this.getModel().setValue("tracknumber", (Object)tracknumber);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tracknumber"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tracknumber"});
        }
        if (StringUtils.isNotEmpty((String)accounttype) && !AccountTypeEnum.ADD_AVERAGE.getValue().equals(accounttype) && !AccountTypeEnum.SPECIAL_ACCT.getValue().equals(accounttype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"matrix"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"costatenddateenable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"costatenddate"});
        }
        this.setMatrixLinkVisible();
        model.setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkEvent) {
        String fieldName = hyperLinkEvent.getFieldName();
        if ("billnumber".equals(fieldName)) {
            int index = hyperLinkEvent.getRowIndex();
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", index);
            String formId = dynamicObject.getString("billtypenum");
            Long billId = dynamicObject.getLong("bizbillid");
            Long parententryid = dynamicObject.getLong("parententryid");
            if (StringUtils.isEmpty((String)formId)) {
                QFilter qFilter = new QFilter("entryentity.id", "=", (Object)parententryid);
                DynamicObject parentObject = QueryServiceHelper.queryOne((String)"cal_calculateoutrpt", (String)"entryentity.billtypenum,entryentity.bizbillid", (QFilter[])qFilter.toArray());
                formId = parentObject.getString("entryentity.billtypenum");
                billId = parentObject.getLong("entryentity.bizbillid");
            }
            if (StringUtils.isEmpty((String)formId)) {
                return;
            }
            if (!formId.startsWith("cal_costadjust") && !"cal_initbill".equals(formId)) {
                formId = "cal_costrecord_subentity";
            }
            if (formId.startsWith("cal_costadjust")) {
                formId = "cal_costadjust_subentity";
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setPkId((Object)billId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        this.linkMatrixDtlRpt(itemKey);
    }

    protected String translateValue(String[] divideBasis, Map<String, IDataEntityProperty> map, String divideValues) {
        logger.info("CalculateOutRptPlugin_translateValue divideBasis==>{},divideValues==>{}", (Object)divideBasis, (Object)divideValues);
        String[] singleValues = divideValues.split("&");
        StringBuilder sb = new StringBuilder();
        for (String singleValue : singleValues) {
            String[] values = singleValue.split("_");
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                if (divideBasis.length == 0 || divideBasis.length < values.length) continue;
                String field = divideBasis[i];
                IDataEntityProperty property = map.get(field);
                if (property instanceof BasedataProp) {
                    Long id;
                    String entityId = ((BasedataProp)property).getBaseEntityId();
                    if ("owner".equals(field)) {
                        entityId = "bos_org";
                    }
                    if (value.trim().isEmpty() || "#".equals(value)) {
                        sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutRptPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    } else if ("assist".equals(field)) {
                        id = Long.valueOf(value);
                        if (id.equals(0L)) {
                            sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutRptPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                        } else {
                            sb.append(value);
                        }
                    } else {
                        id = Long.valueOf(value);
                        if (id.equals(0L)) {
                            sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutRptPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                        } else {
                            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityId);
                            if (obj == null) {
                                sb.append(id);
                            } else {
                                String name = obj.getString("name");
                                if (!StringUtils.isEmpty((String)name)) {
                                    sb.append(name);
                                } else {
                                    sb.append(obj.getString("number"));
                                }
                            }
                        }
                    }
                } else if (value.trim().isEmpty() || "#".equals(value)) {
                    sb.append(ResManager.loadKDString((String)"\u7a7a", (String)"CalculateOutRptPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                } else {
                    sb.append(value);
                }
                sb.append('+');
            }
            if (sb.length() <= 0) continue;
            sb = sb.deleteCharAt(sb.length() - 1);
            sb.append(';');
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return "";
    }

    protected String[] getCaldimensions(DynamicObject caldimensionObj) {
        String[] caldimension = null;
        caldimension = caldimensionObj == null ? CommonSettingHelper.getCalDimensionStr().split(",") : caldimensionObj.getString("caldimension").split(",");
        return caldimension;
    }

    protected Map<String, IDataEntityProperty> getPropertyTypeMap(String[] divideBasis, String[] caldimension) {
        HashMap<String, IDataEntityProperty> map = new HashMap<String, IDataEntityProperty>(32);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        for (String field : divideBasis) {
            ((BasedataProp)entityType.findProperty("owner")).getBaseEntityId();
            map.put(field, entityType.findProperty(field));
        }
        for (String field : caldimension) {
            ((BasedataProp)entityType.findProperty("owner")).getBaseEntityId();
            map.put(field, entityType.findProperty(field));
        }
        return map;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillView view = (BillView)e.getSource();
        DynamicObject costAccount = (DynamicObject)view.getModel().getValue("costaccount");
        if (costAccount == null) {
            return;
        }
        boolean calbycostelement = ParamsHelper.getCostElementByCostAccount((long)costAccount.getLong("id"));
        DynamicObjectCollection entryCol = view.getModel().getEntryEntity("entryentity");
        Iterator it = entryCol.iterator();
        while (it.hasNext()) {
            DynamicObject entry = (DynamicObject)it.next();
            if (calbycostelement || entry.getLong("parententryid") == 0L) continue;
            it.remove();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private void linkMatrixDtlRpt(String itemKey) {
        String entityName;
        if (!"linkdtlbtn".equals(itemKey)) {
            return;
        }
        Object calOrgId = ((DynamicObject)this.getModel().getValue("calorg")).getPkValue();
        Long userId = UserServiceHelper.getCurrentUserId();
        boolean hasPer = PermissionHelper.orgPermVerify((Long)userId, (String)(entityName = "cal_calculateoutrpt"), (String)"47150e89000000ac", (Long)((Long)calOrgId));
        if (!hasPer) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalculateOutRptPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        FilterInfo filter = new FilterInfo();
        ReportQueryParam queryParam = new ReportQueryParam();
        Date calTime = (Date)this.getModel().getValue("caltime");
        FilterItemInfo startTimeItem = new FilterItemInfo();
        startTimeItem.setCompareType("=");
        startTimeItem.setPropName("starttimefilter");
        startTimeItem.setValue((Object)DateUtils.getDayStartTime((Date)calTime));
        filter.getFilterItems().add(startTimeItem);
        FilterItemInfo endTimeItem = new FilterItemInfo();
        endTimeItem.setCompareType("=");
        endTimeItem.setPropName("endtimefilter");
        endTimeItem.setValue((Object)DateUtils.getDayEndTime((Date)calTime));
        filter.getFilterItems().add(endTimeItem);
        FilterItemInfo periodIdItem = new FilterItemInfo();
        periodIdItem.setCompareType("=");
        periodIdItem.setPropName("startperiodfilter");
        Object periodId = ((DynamicObject)this.getModel().getValue("period")).getPkValue();
        periodIdItem.setValue(periodId);
        filter.getFilterItems().add(periodIdItem);
        FilterItemInfo endPeriodIdItem = new FilterItemInfo();
        endPeriodIdItem.setCompareType("=");
        endPeriodIdItem.setPropName("endperiodfilter");
        endPeriodIdItem.setValue(periodId);
        filter.getFilterItems().add(endPeriodIdItem);
        FilterItemInfo acctItem = new FilterItemInfo();
        acctItem.setCompareType("=");
        acctItem.setPropName("mulcostaccountfilter");
        Object acctId = ((DynamicObject)this.getModel().getValue("costaccount")).getPkValue();
        acctItem.setValue(acctId);
        filter.getFilterItems().add(acctItem);
        FilterItemInfo calOrgtItem = new FilterItemInfo();
        calOrgtItem.setCompareType("=");
        calOrgtItem.setPropName("mulcalorgfilter");
        calOrgtItem.setValue(calOrgId);
        filter.getFilterItems().add(calOrgtItem);
        FilterItemInfo matIdItem = new FilterItemInfo();
        matIdItem.setCompareType(CompareTypeEnum.EQUAL.getId());
        matIdItem.setPropName("materialfilter");
        Object materialId = ((DynamicObject)this.getModel().getValue("material")).getPkValue();
        matIdItem.setValue(materialId);
        filter.getFilterItems().add(matIdItem);
        FilterItemInfo rptIdItem = new FilterItemInfo();
        rptIdItem.setCompareType("=");
        rptIdItem.setPropName("rptidfilter");
        rptIdItem.setValue(this.getModel().getValue("id"));
        filter.getFilterItems().add(rptIdItem);
        queryParam.setFilter(filter);
        HashMap<String, String> custParamsMap = new HashMap<String, String>(16);
        custParamsMap.put("isLink", "TRUE");
        queryParam.setCustomParam(custParamsMap);
        FilterItemInfo showSubSumItem = new FilterItemInfo();
        showSubSumItem.setCompareType(CompareTypeEnum.EQUAL.getId());
        showSubSumItem.setPropName("showsubsum");
        Boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)((Long)acctId));
        showSubSumItem.setValue((Object)calByCostElement);
        filter.getFilterItems().add(showSubSumItem);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_caloutrpt_dtl_rpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setMatrixLinkVisible() {
        boolean isMatrix = (Boolean)this.getModel().getValue("matrix");
        Boolean writeDtlRpt = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.MATRIX_WRITE_DTLRPT);
        boolean showDtlBtn = false;
        if (isMatrix && writeDtlRpt.booleanValue()) {
            showDtlBtn = true;
        }
        this.getView().setVisible(Boolean.valueOf(showDtlBtn), new String[]{"linkdtlbtn"});
    }
}

