/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.compare;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.AbstractFilterContantParser;
import kd.bos.entity.filter.FilterContantParserArgs;
import kd.bos.entity.filter.FilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class CalPeriodCustomComparePlugin
extends AbstractFilterContantParser {
    private static final Log log = LogFactory.getLog(CalPeriodCustomComparePlugin.class);
    private String entity;

    protected QFilter getQFilter(FilterContantParserArgs args) {
        Long oneAcctId;
        this.entity = args.getMainEntityType().getName();
        HashSet<Long> acctIdSet = new HashSet<Long>(16);
        HashSet<Long> curPeriodIdSet = new HashSet<Long>(16);
        this.collectAcctIdsAndPeriodIds(args, acctIdSet, curPeriodIdSet);
        if (curPeriodIdSet.isEmpty()) {
            log.info("CalPeriodCustomComparePlugin-\u671f\u95f4ids\u4e3a\u7a7a");
            return this.getBookDateFilter(null);
        }
        Long onePeriodId = (Long)curPeriodIdSet.iterator().next();
        DynamicObject periodDyc = this.getPeriodDyc(args, onePeriodId, oneAcctId = (Long)acctIdSet.iterator().next());
        log.info("CalPeriodCustomComparePlugin-\u671f\u95f4==\u300b{}", periodDyc == null ? Long.valueOf(0L) : periodDyc.getPkValue());
        QFilter bookDateFilter = this.getBookDateFilter(periodDyc);
        return bookDateFilter;
    }

    private void collectAcctIdsAndPeriodIds(FilterContantParserArgs args, Set<Long> acctIdSet, Set<Long> curPeriodIdSet) {
        List filterRows = args.getFilterRows();
        QFilter sysCtrlF = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (Object filterRow : filterRows) {
            boolean isOrg = filterRow.getFilterField().getFieldName().startsWith(this.getCalOrgField());
            boolean isAcct = filterRow.getFilterField().getFieldName().startsWith(this.getCostAcctField());
            if (!isOrg && !isAcct) continue;
            QFilter filter = filterRow.getFilterResult().getQFilter();
            if (filter == null) {
                Class propertyType = filterRow.getFilterField().getFieldProp().getPropertyType();
                List valueToFilter = filterRow.getValue();
                if ("long".equals(propertyType.getTypeName())) {
                    valueToFilter = filterRow.getValue().stream().map(Long::parseLong).collect(Collectors.toList());
                }
                filter = new QFilter(filterRow.getFilterField().getFieldName(), "in", valueToFilter);
            }
            if (isOrg) {
                this.replaceFieldKey(filter, this.getCalOrgField(), "org.");
            } else if (isAcct) {
                this.replaceFieldKey(filter, this.getCostAcctField(), "entry.costaccount.");
            }
            sysCtrlF.and(filter);
        }
        DataSet sysCtrlDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount acctid,entry.currentperiod,entry.currentperiod.begindate,entry.currentperiod.enddate", (QFilter[])sysCtrlF.toArray(), null);
        for (Row row : sysCtrlDs) {
            Long curPeriodId = row.getLong("entry.currentperiod");
            if (curPeriodId == null) continue;
            acctIdSet.add(row.getLong("acctid"));
            curPeriodIdSet.add(curPeriodId);
        }
        if (curPeriodIdSet.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u6309\u671f\u95f4\u67e5\u8be2\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u8fdb\u884c\u67e5\u8be2\u6216\u8005\u53ea\u67e5\u8be2\u5f53\u524d\u671f\u95f4\u4e00\u81f4\u7684\u8d26\u7c3f\u3002", (String)"CalPeriodCustomComparePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private void replaceFieldKey(QFilter filter, String srcField, String tgtField) {
        String replaceField = filter.getProperty().replace(srcField, tgtField);
        filter.__setProperty(replaceField);
        List nests = filter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter curFilter = nest.getFilter();
            int index = curFilter.getProperty().indexOf(".");
            String curReplaceField = curFilter.getProperty().replace(srcField, tgtField);
            if (index < 0) {
                curReplaceField = tgtField.substring(0, tgtField.length() - 1);
            }
            curFilter.__setProperty(curReplaceField);
        }
    }

    private DynamicObject getPeriodDyc(FilterContantParserArgs args, Long onePeriodId, Long oneAcctId) {
        DynamicObject periodDyc = null;
        if (onePeriodId.equals(0L)) {
            return periodDyc;
        }
        FilterRow curFilterRow = args.getFilterRow();
        boolean isPrePeriod = "1889913855992588288".equals(curFilterRow.getCompareType().getId());
        boolean isCurPeriod = "1889914094103231488".equals(curFilterRow.getCompareType().getId());
        boolean isNextPeriod = "1889913486189198336".equals(curFilterRow.getCompareType().getId());
        if (isPrePeriod) {
            periodDyc = PeriodHelper.getPreviousPeriod((Object)onePeriodId);
        } else if (isCurPeriod) {
            periodDyc = PeriodHelper.getCurrentPeriod((Long)oneAcctId);
        } else if (isNextPeriod) {
            periodDyc = PeriodHelper.getNextPeriod((Object)onePeriodId);
        }
        return periodDyc;
    }

    private QFilter getBookDateFilter(DynamicObject periodDyc) {
        String bookDateField = "bookdate";
        QFilter bookDateFilter = null;
        if (periodDyc == null) {
            Date now = TimeServiceHelper.now();
            bookDateFilter = new QFilter(bookDateField, ">", (Object)now);
            bookDateFilter.and(new QFilter(bookDateField, "<", (Object)now));
        } else {
            Date beginDate = periodDyc.getDate("begindate");
            Date endDate = periodDyc.getDate("enddate");
            bookDateFilter = new QFilter(bookDateField, ">=", (Object)beginDate);
            bookDateFilter.and(new QFilter(bookDateField, "<=", (Object)endDate));
        }
        return bookDateFilter;
    }

    protected String getScriptFilter(FilterContantParserArgs filterContantParserArgs) {
        return null;
    }

    private String getCostAcctField() {
        String costAcctField = "costaccount.";
        return costAcctField;
    }

    private String getCalOrgField() {
        boolean isFieldNameOrg;
        String calOrgField = "calorg.";
        boolean bl = isFieldNameOrg = "cal_price_provbill".equals(this.entity) || "cal_price_revbill".equals(this.entity);
        if (isFieldNameOrg) {
            calOrgField = "org.";
        }
        return calOrgField;
    }
}

