/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.data;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.account.SettleAccountFacade;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalCollectInfoHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ParamsHelper;

public class CalServiceDataCollectTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.collectLogInfo();
    }

    private void collectLogInfo() {
        HashMap<String, String> var = new HashMap<String, String>(16);
        Boolean isNewBal = CalBalanceModelHelper.isNewBalance();
        var.put("isNewBal", isNewBal.toString());
        Boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        var.put("isBalCompress", balCompress.toString());
        QFilter calrangeFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        calrangeFilter.and("status", "=", (Object)"C");
        DataSet accountTypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_calrange", (String)"accounttype", (QFilter[])calrangeFilter.toArray(), null).distinct();
        DataSet accountTypeDataSet2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_accounttype", (String)"entry.accounttype as accounttype", (QFilter[])calrangeFilter.toArray(), null).distinct();
        accountTypeDataSet = accountTypeDataSet.union(accountTypeDataSet2).distinct();
        StringBuilder accountTypes = new StringBuilder();
        for (Row row : accountTypeDataSet) {
            accountTypes.append(row.getString("accounttype")).append("#");
        }
        var.put("accountTypes", accountTypes.toString());
        Boolean accountGroup_newmodel = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ACCOUNTGROUP_NEWMODEL);
        Boolean bizGroup_model = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.BIZGROUP_MODEL);
        if (bizGroup_model.booleanValue()) {
            var.put("groupmodel", "bizGroup");
        } else if (accountGroup_newmodel.booleanValue()) {
            var.put("groupmodel", "newAccountGroup");
        } else {
            var.put("groupmodel", "oldAccountGroup");
        }
        QFilter orgPeriodQFilter = new QFilter("entry.isenabled", "=", (Object)Boolean.TRUE);
        DataSet orgPeriodDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sysctrlentity", (String)"org", (QFilter[])orgPeriodQFilter.toArray(), (String)"entry.currentperiod desc");
        Long orgid = 0L;
        for (Row row : orgPeriodDataSet) {
            if (orgid != 0L) continue;
            orgid = row.getLong("org");
        }
        String dischargeType = (String)ParamsHelper.getAppParam((long)orgid, (String)"dischargetype");
        if ("A".equals(dischargeType)) {
            var.put("dischargeType", DischargeTypeEnum.BILLCOMECLEAR.getDesc());
        } else if ("B".equals(dischargeType)) {
            var.put("dischargeType", DischargeTypeEnum.BEGINPERIODCLEAR.getDesc());
        } else if ("C".equals(dischargeType)) {
            var.put("dischargeType", DischargeTypeEnum.UNCLEAR.getDesc());
        } else {
            var.put("dischargeType", "###");
        }
        QFilter costAccountQFilter = new QFilter("calpolicy.calbycostelement", "=", (Object)Boolean.TRUE);
        costAccountQFilter.and("enable", "=", (Object)Boolean.TRUE);
        costAccountQFilter.and("calorg.id", "=", (Object)orgid);
        DataSet calpolicyDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])costAccountQFilter.toArray(), null).distinct();
        if (calpolicyDataSet.isEmpty()) {
            var.put("isCalbycostelement", Boolean.FALSE.toString());
        } else {
            var.put("isCalbycostelement", Boolean.TRUE.toString());
        }
        var.put("writeoffmodel", "oldwriteoff");
        try (DataSet batchSizeDataSet = DB.queryDataSet((String)SettleAccountFacade.class.getName(), (DBRoute)new DBRoute("scm"), (String)"SELECT FVALUE FROM T_IM_INVDBPARAM WHERE FKEY = 'fiswriteoffplan'");){
            for (Row batchSize : batchSizeDataSet) {
                if (batchSize.getInteger("FVALUE") != 1) continue;
                var.put("writeoffmodel", "newwriteoff");
            }
        }
        QFilter msmodSchemesetQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        msmodSchemesetQFilter.and("writeofftype.id", "in", (Object)Sets.newHashSet((Object[])new Long[]{1560135649820937216L, 1543570053495091200L}));
        DataSet msmodSchemesetDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msmod_schemeset", (String)"id", (QFilter[])msmodSchemesetQFilter.toArray(), null).distinct();
        if (msmodSchemesetDataSet.isEmpty()) {
            var.put("isNewFeeShare", "false");
        } else {
            var.put("isNewFeeShare", "true");
        }
        CalCollectInfoHelper.writeCollectInfo(null, (String)"SettleAccountFacade_doSettleAccount", (int)0, (Long)0L, (String)"cal_settleaccount", var);
    }
}

