/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.datacheck;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.EntityParseHelper;

public class DataCheckItemPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CHECKMODE = "checkmode";
    private static final String BIZOBJECT = "bizobject";
    private static final String CUSTOMFILTERTEXT = "customfiltertext";
    private static final String CUSTOMFILTER_TAG = "customfilter_tag";
    private static final String PLUGIN = "plugin";
    private static final String EXPMSGFIELDS = "expmsgfields";
    private static final String CUSTOMPLUGIN = "kd.fi.cal.business.datacheck.item.CustomDataCheck";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CUSTOMFILTERTEXT});
        this.addF7Listener(this, BIZOBJECT);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterBindData(EventObject e) {
        String conditionJson;
        this.initExpMsgFields();
        if (this.getModel().getValue(CHECKMODE) != null) {
            this.setFieldsView((String)this.getModel().getValue(CHECKMODE));
        }
        if (StringUtils.isNotBlank((CharSequence)(conditionJson = (String)this.getModel().getValue(CUSTOMFILTER_TAG)))) {
            CRCondition filterCondition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = this.tranFormula((CRFormula)filterCondition, this.getModel().getDataEntity().getDynamicObject(BIZOBJECT).getString("id"));
            exprTran = exprTran.length() > 500 ? exprTran.substring(0, 500) + "..." : exprTran;
            this.getModel().setValue(CUSTOMFILTERTEXT, (Object)exprTran);
            this.getModel().setDataChanged(false);
        }
    }

    protected String tranFormula(CRFormula formulaObj, String ENTITYNUMBER) {
        MainEntityType mainType = null;
        mainType = MetadataServiceHelper.getDataEntityType((String)ENTITYNUMBER);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            String tranExpr = String.join((CharSequence)ResManager.loadKDString((String)" \u4e14 ", (String)"BizGroupSettingPlugin_8", (String)"scmc-im-cal", (Object[])new Object[0]), descs);
            return tranExpr;
        }
        return "";
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CUSTOMFILTERTEXT.equals(key)) {
            this.doFilterClick(evt);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (CHECKMODE.equals(key)) {
            this.getModel().setValue(PLUGIN, null);
            this.getModel().setValue(BIZOBJECT, null);
            this.getModel().setValue(CUSTOMFILTERTEXT, null);
            this.getModel().setValue(CUSTOMFILTER_TAG, null);
            if ("A".equals(CHECKMODE)) {
                this.getModel().setValue(PLUGIN, (Object)CUSTOMPLUGIN);
            }
            this.setFieldsView(this.getModel().getDataEntity().getString(CHECKMODE));
        } else if (BIZOBJECT.equals(key)) {
            this.getModel().setValue(CUSTOMFILTERTEXT, null);
            this.getModel().setValue(CUSTOMFILTER_TAG, null);
            this.getModel().setValue(EXPMSGFIELDS, null);
            this.initExpMsgFields();
        } else if (CUSTOMFILTERTEXT.equals(key)) {
            this.getModel().beginInit();
            Object object = this.getModel().getValue(CUSTOMFILTERTEXT);
            if (null == object || object.equals("")) {
                this.getModel().setValue(CUSTOMFILTER_TAG, null);
            }
            this.getModel().endInit();
        }
    }

    private void setFieldsView(String checkMode) {
        switch (checkMode) {
            case "A": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BIZOBJECT});
                this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMFILTERTEXT});
                this.getView().setVisible(Boolean.TRUE, new String[]{EXPMSGFIELDS});
                this.getView().setVisible(Boolean.FALSE, new String[]{PLUGIN});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BIZOBJECT});
                this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOMFILTERTEXT});
                this.getView().setVisible(Boolean.FALSE, new String[]{EXPMSGFIELDS});
                this.getView().setVisible(Boolean.TRUE, new String[]{PLUGIN});
                break;
            }
        }
    }

    private void doFilterClick(EventObject evt) {
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue(BIZOBJECT);
        if (entityObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"DataCheckItemPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String entityObjectId = String.valueOf(entityObject.getPkValue());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityObjectId);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode nodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
        String nodesJson = SerializationUtils.toJsonString((Object)nodes);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_condition");
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entityNumber", entityObjectId);
        String conditionJson = (String)this.getModel().getValue(CUSTOMFILTER_TAG);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOMFILTERTEXT));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (returnData != null && CUSTOMFILTERTEXT.equals(key)) {
            if (StringUtils.isBlank((CharSequence)returnData)) {
                this.getModel().setValue(CUSTOMFILTER_TAG, (Object)"");
                this.getModel().setValue(CUSTOMFILTERTEXT, (Object)"");
            } else {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
                this.getModel().setValue(CUSTOMFILTER_TAG, (Object)returnData);
                this.getModel().setValue(CUSTOMFILTERTEXT, (Object)condition.getExprTran());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (BIZOBJECT.equals(key)) {
            Set checkObjectSet = CommonSettingHelper.getCheckObject();
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", (Object)checkObjectSet));
        }
    }

    private void initExpMsgFields() {
        ArrayList<String> list = new ArrayList<String>();
        ComboEdit co = (ComboEdit)this.getView().getControl(EXPMSGFIELDS);
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue(BIZOBJECT);
        if (bizObject == null) {
            co.setComboItems(null);
            return;
        }
        List<ComboItem> items = this.getObjectComBo(list, bizObject);
        co.setComboItems(items);
    }

    private List<ComboItem> getObjectComBo(List<String> list, DynamicObject bizObject) {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)bizObject.getString("number"));
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (Map.Entry entry : entitytype.getFields().entrySet()) {
            IDataEntityProperty field = (IDataEntityProperty)entry.getValue();
            ComboItem item = new ComboItem(field.getDisplayName(), field.getName());
            items.add(item);
        }
        return items;
    }
}

