/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.datacheck;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class DataCheckPlanPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(DataCheckPlanPlugin.class);
    private static final String CHECKTASK = "checktask";
    private static final String COSTACCOUNT = "costaccount";
    private static final String CALORG = "calorg";
    private static final String STORAGEORGUNIT = "storageorgunit";
    private static final String WAREHOUSE = "warehouse";
    private static final String LOCATION = "location";
    private static CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_viewresult".equals(key)) {
            this.showResultView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_datacheck_plan");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue(CALORG, (Object)new Object[]{calOrgId});
            this.setCostAccountByCalOrg(calOrgId);
        }
        FieldEdit txtCycleNum = (FieldEdit)this.getView().getControl("cyclenum");
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        if ("n".equals(repeatMode)) {
            txtCycleNum.setEnable("", false, -1);
        }
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            this.getModel().setValue(COSTACCOUNT, (Object)new Object[]{costAccount.getLong("id")});
        } else {
            this.getModel().setValue(COSTACCOUNT, null);
        }
    }

    private void showResultView() {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("cal_datacheck_result");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("planids", (Object)new Object[]{this.getModel().getValue("id")});
        this.getView().showForm((FormShowParameter)param);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabselectevent -> {
            String key = tabselectevent.getTabKey();
            if ("tabdatepage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"d");
            } else if ("tabweekpage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"w");
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(this, CHECKTASK, COSTACCOUNT, CALORG, STORAGEORGUNIT, WAREHOUSE, LOCATION);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (CHECKTASK.equals(key)) {
            QFilter q = new QFilter("purpose", "=", (Object)"A");
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else if (COSTACCOUNT.equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if (CALORG.equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if (STORAGEORGUNIT.equals(key)) {
            this.beforeF7Select4Storageorg(e);
        } else if (WAREHOUSE.equals(key)) {
            DataCheckPlanPlugin.beforeF7Select4Warehouse(e, this.getModel());
        } else if (LOCATION.equals(key)) {
            this.beforeF7Select4Location(e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            Object repeatmode;
            this.adjustByRepeatMode();
            String fromBiz = (String)this.getView().getFormShowParameter().getCustomParam("frombiz");
            if (fromBiz != null && fromBiz.equals("true")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"job"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnconfirm"});
            }
            String comno = ((String)this.getModel().getValue("comno")).trim();
            String comweek = ((String)this.getModel().getValue("comweek")).trim();
            this.getPageCache().put("loadData", "true");
            Tab tab = (Tab)this.getControl("tabap");
            Object combdorw = this.getModel().getValue("combdorw");
            if (combdorw != null && "w".equals(combdorw.toString())) {
                tab.activeTab("tabweekpage");
            }
            if ("m".equals((repeatmode = this.getModel().getValue("repeatmode")).toString().trim())) {
                this.getModel().setValue("comnobyweek", (Object)comno);
                this.getModel().setValue("comweekbyweek", (Object)comweek);
            } else if ("y".equals(repeatmode.toString().trim())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comnobymonth", "comweekbymonth"});
                this.getModel().setValue("comnobymonth", (Object)comno);
                this.getModel().setValue("comweekbymonth", (Object)comweek);
            }
            this.getPageCache().remove("loadData");
            this.getModel().setValue("txtdesc", (Object)this.genDesc());
            this.getModel().setValue("repeatmode", (Object)repeatmode.toString().trim());
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel dataModel = this.getView().getModel();
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if ((name.startsWith("comnoby") || name.startsWith("comweekby")) && this.getPageCache().get("loadData") == null) {
            this.getModel().setValue("comno", this.getModel().getValue(name.replace("comweek", "comno")));
            this.getModel().setValue("comweek", this.getModel().getValue(name.replace("comno", "comweek")));
            Object commo = this.getModel().getValue("comno");
            Object comweek = this.getModel().getValue("comweek");
            if (name.endsWith("bymonth")) {
                if (commo != null && comweek != null && StringUtils.isNotBlank((CharSequence)commo.toString()) && StringUtils.isNotBlank((CharSequence)comweek.toString())) {
                    this.getModel().setValue("ckbyweek", (Object)Boolean.TRUE);
                } else {
                    this.getModel().setValue("ckbyweek", (Object)Boolean.FALSE);
                }
            }
        }
        if (name.equals("plan") || property.getName().equals("txtdesc")) {
            return;
        }
        if (name.equals("repeatmode")) {
            this.adjustByRepeatMode();
        } else if (name.equals("combdorw")) {
            this.adjustByDayOrWeek();
        }
        boolean isMonth = false;
        for (String propMonth : CKMONTH) {
            if (!name.equals(propMonth)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : CKMONTH) {
                boolean b = Boolean.parseBoolean(this.getModel().getValue(month).toString());
                if (!b) continue;
                changeMonth = b;
                break;
            }
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comnobymonth"});
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comweekbymonth"});
        }
        dataModel.setValue("txtdesc", (Object)this.genDesc());
        if (CALORG.equals(name)) {
            this.getModel().setValue(STORAGEORGUNIT, null);
        } else if (STORAGEORGUNIT.equals(name)) {
            this.getModel().setValue(WAREHOUSE, null);
        } else if (WAREHOUSE.equals(name)) {
            this.getModel().setValue(LOCATION, null);
        }
    }

    private void adjustByDayOrWeek() {
        IFormView formView = this.getView();
        String byDayOrWeek = (String)this.getModel().getValue("combdorw");
        if (byDayOrWeek.equals("w")) {
            formView.setVisible(Boolean.FALSE, new String[]{"flexpdays"});
            formView.setVisible(Boolean.TRUE, new String[]{"flexpbyweek"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"flexpdays"});
            formView.setVisible(Boolean.FALSE, new String[]{"flexpbyweek"});
        }
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", "flexpdays", "flexpbyweek"});
        FieldEdit txtCycleNum = (FieldEdit)formView.getControl("cyclenum");
        txtCycleNum.setEnable("", true, -1);
        switch (repeatMode = repeatMode.trim()) {
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek"});
                this.getModel().setValue("cyclenum", (Object)1);
                txtCycleNum.setEnable("", false, -1);
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexpdays"});
                this.adjustByDayOrWeek();
                break;
            }
            case "y": {
                this.getModel().setValue("cyclenum", (Object)1);
                txtCycleNum.setEnable("", true, -1);
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths"});
                this.adjustByWeek();
                break;
            }
            case "n": {
                txtCycleNum.setEnable("", false, -1);
            }
        }
    }

    private void adjustByWeek() {
        boolean byWeek = (Boolean)this.getModel().getValue("ckbyweek");
        this.getView().setVisible(Boolean.valueOf(byWeek), new String[]{"flexpbyweek"});
    }

    private String genDesc() {
        Object cyclenumObj = this.getView().getModel().getValue("cyclenum");
        if (StringUtils.isBlank((Object)cyclenumObj) || Long.parseLong(cyclenumObj.toString()) == 0L) {
            return "";
        }
        CronStruct cron = new CronStruct();
        Calendar crStartTime = this.getStartTime();
        cron.setSeconds("0");
        cron.setMinutes(String.valueOf(crStartTime.get(12)));
        cron.setHours(String.valueOf(crStartTime.get(11)));
        cron.setDayOfMonth(String.valueOf(crStartTime.get(5)));
        cron.setMonth(String.valueOf(crStartTime.get(2) + 1));
        cron.setDayOfWeek("?");
        cron.setYear(String.valueOf(crStartTime.get(1)));
        String repeatMode = (String)this.getView().getModel().getValue("repeatmode");
        int cyclenum = (Integer)this.getView().getModel().getValue("cyclenum");
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"DataCheckPlanPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        switch (repeatMode = repeatMode.trim()) {
            case "n": {
                cron.getDescBuf().setLength(0);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d", (String)"DataCheckPlanPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mi": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DataCheckPlanPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d", (String)"DataCheckPlanPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    cron.setMinutes("0/" + cyclenum);
                } else {
                    cron.setMinutes("*");
                }
                cron.setHours("*");
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "h": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DataCheckPlanPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d", (String)"DataCheckPlanPlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    if (cyclenum > 23) {
                        cyclenum = 23;
                        this.getModel().setValue("cyclenum", (Object)23);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u91cd\u590d", (String)"DataCheckPlanPlugin_16", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    }
                    cron.setHours("0/" + cyclenum);
                } else {
                    cron.setHours("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "d": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DataCheckPlanPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5929\u91cd\u590d", (String)"DataCheckPlanPlugin_17", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    cron.setDayOfMonth("1/" + cyclenum);
                } else {
                    cron.setDayOfMonth("*");
                }
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "w": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DataCheckPlanPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5468", (String)"DataCheckPlanPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                cron = this.repeatByWeek(cron);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d", (String)"DataCheckPlanPlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "m": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DataCheckPlanPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u6708", (String)"DataCheckPlanPlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                if (cyclenum > 1) {
                    String month = String.valueOf(crStartTime.get(2) + 1);
                    cron.setMonth(month + "/" + cyclenum);
                } else {
                    cron.setMonth("*");
                }
                cron.setYear(null);
                cron = this.repeatByMonthDay(cron);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d", (String)"DataCheckPlanPlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "y": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)"DataCheckPlanPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5e74", (String)"DataCheckPlanPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                cron.setYear(null);
                cron = this.repeatByMonthly(cron);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d", (String)"DataCheckPlanPlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        this.getModel().setValue("plan", (Object)cron.toString());
        try {
            parser.parse(cron.toString());
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"DataCheckPlanPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            WriteLogHelper.writeErrorLog((Log)logger, (String)"DataCheckPlanPlugin-genDesc", (Throwable)e);
        }
        return cron.getDescBuf().toString();
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getView().getModel().getValue("starttime");
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getView().getModel().setValue("starttime", (Object)crStartTime.getTime());
        }
        return crStartTime;
    }

    private CronStruct repeatByMonthDay(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String byDayOrWeek = (String)dataModel.getValue("combdorw");
        if (byDayOrWeek.equals("d")) {
            String conStr = ResManager.loadKDString((String)"\u7684", (String)"DataCheckPlanPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            String days = "";
            if (((Boolean)dataModel.getValue("ckone")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"1\u65e5", (String)"DataCheckPlanPlugin_30", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "1,";
            }
            if (((Boolean)dataModel.getValue("cktwo")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"2\u65e5", (String)"DataCheckPlanPlugin_31", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "2,";
            }
            if (((Boolean)dataModel.getValue("ckthree")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"3\u65e5", (String)"DataCheckPlanPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "3,";
            }
            if (((Boolean)dataModel.getValue("ckfour")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"4\u65e5", (String)"DataCheckPlanPlugin_33", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "4,";
            }
            if (((Boolean)dataModel.getValue("ckfive")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"5\u65e5", (String)"DataCheckPlanPlugin_34", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "5,";
            }
            if (((Boolean)dataModel.getValue("cksix")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"6\u65e5", (String)"DataCheckPlanPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "6,";
            }
            if (((Boolean)dataModel.getValue("ckseven")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"7\u65e5", (String)"DataCheckPlanPlugin_36", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "7,";
            }
            if (((Boolean)dataModel.getValue("ckeight")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"8\u65e5", (String)"DataCheckPlanPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "8,";
            }
            if (((Boolean)dataModel.getValue("cknine")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"9\u65e5", (String)"DataCheckPlanPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "9,";
            }
            if (((Boolean)dataModel.getValue("ckten")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"10\u65e5", (String)"DataCheckPlanPlugin_39", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "10,";
            }
            if (((Boolean)dataModel.getValue("ckeleven")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"11\u65e5", (String)"DataCheckPlanPlugin_40", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "11,";
            }
            if (((Boolean)dataModel.getValue("cktwelve")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"12\u65e5", (String)"DataCheckPlanPlugin_41", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "12,";
            }
            if (((Boolean)dataModel.getValue("ckthirteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"13\u65e5", (String)"DataCheckPlanPlugin_42", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "13,";
            }
            if (((Boolean)dataModel.getValue("ckfourteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"14\u65e5", (String)"DataCheckPlanPlugin_43", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "14,";
            }
            if (((Boolean)dataModel.getValue("ckfifteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"15\u65e5", (String)"DataCheckPlanPlugin_44", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "15,";
            }
            if (((Boolean)dataModel.getValue("cksixteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"16\u65e5", (String)"DataCheckPlanPlugin_45", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "16,";
            }
            if (((Boolean)dataModel.getValue("ckseventeen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"17\u65e5", (String)"DataCheckPlanPlugin_46", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "17,";
            }
            if (((Boolean)dataModel.getValue("ckeighteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"18\u65e5", (String)"DataCheckPlanPlugin_47", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "18,";
            }
            if (((Boolean)dataModel.getValue("cknineteen")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"19\u65e5", (String)"DataCheckPlanPlugin_48", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "19,";
            }
            if (((Boolean)dataModel.getValue("cktwenty")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"20\u65e5", (String)"DataCheckPlanPlugin_49", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "20,";
            }
            if (((Boolean)dataModel.getValue("cktwentyone")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"21\u65e5", (String)"DataCheckPlanPlugin_50", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "21,";
            }
            if (((Boolean)dataModel.getValue("cktwentytwo")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"22\u65e5", (String)"DataCheckPlanPlugin_51", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "22,";
            }
            if (((Boolean)dataModel.getValue("cktwentythree")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"23\u65e5", (String)"DataCheckPlanPlugin_52", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "23,";
            }
            if (((Boolean)dataModel.getValue("cktwentyfour")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"24\u65e5", (String)"DataCheckPlanPlugin_53", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "24,";
            }
            if (((Boolean)dataModel.getValue("cktwentyfive")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"25\u65e5", (String)"DataCheckPlanPlugin_54", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "25,";
            }
            if (((Boolean)dataModel.getValue("cktwentysix")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"26\u65e5", (String)"DataCheckPlanPlugin_55", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "26,";
            }
            if (((Boolean)dataModel.getValue("cktwentyseven")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"27\u65e5", (String)"DataCheckPlanPlugin_56", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "27,";
            }
            if (((Boolean)dataModel.getValue("cktwentyeight")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"28\u65e5", (String)"DataCheckPlanPlugin_57", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "28,";
            }
            if (((Boolean)dataModel.getValue("cktwentynine")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"29\u65e5", (String)"DataCheckPlanPlugin_58", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "29,";
            }
            if (((Boolean)dataModel.getValue("ckthirty")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"30\u65e5", (String)"DataCheckPlanPlugin_59", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "30,";
            }
            if (((Boolean)dataModel.getValue("ckthirtyone")).booleanValue()) {
                cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"31\u65e5", (String)"DataCheckPlanPlugin_60", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                conStr = ",";
                days = days + "31,";
            }
            days = days.length() == 0 ? String.valueOf(this.getStartTime().get(5)) : days.substring(0, days.length() - 1);
            cron.setDayOfMonth(days);
        } else if (byDayOrWeek.equals("w")) {
            cron = this.repeatByNoWeek(cron);
        }
        return cron;
    }

    private CronStruct repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"DataCheckPlanPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        String weekDays = "";
        if (((Boolean)dataModel.getValue("cksun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"DataCheckPlanPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = "1,";
        }
        if (((Boolean)dataModel.getValue("ckmon")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"DataCheckPlanPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "2,";
        }
        if (((Boolean)dataModel.getValue("cktues")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"DataCheckPlanPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "3,";
        }
        if (((Boolean)dataModel.getValue("ckwed")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"DataCheckPlanPlugin_26", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "4,";
        }
        if (((Boolean)dataModel.getValue("ckthur")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"DataCheckPlanPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "5,";
        }
        if (((Boolean)dataModel.getValue("ckfri")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"DataCheckPlanPlugin_28", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "6,";
        }
        if (((Boolean)dataModel.getValue("cksat")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"DataCheckPlanPlugin_29", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            weekDays = weekDays + "7,";
        }
        weekDays = weekDays.length() == 0 ? String.valueOf(this.getStartTime().get(7)) : weekDays.substring(0, weekDays.length() - 1);
        cron.setDayOfMonth("?");
        cron.setDayOfWeek(weekDays);
        return cron;
    }

    private CronStruct repeatByMonthly(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"DataCheckPlanPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        String months = "";
        if (((Boolean)dataModel.getValue("ckjan")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e00\u6708", (String)"DataCheckPlanPlugin_69", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "1,";
        }
        if (((Boolean)dataModel.getValue("ckfeb")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e8c\u6708", (String)"DataCheckPlanPlugin_70", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "2,";
        }
        if (((Boolean)dataModel.getValue("ckmar")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e09\u6708", (String)"DataCheckPlanPlugin_71", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "3,";
        }
        if (((Boolean)dataModel.getValue("ckapr")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u56db\u6708", (String)"DataCheckPlanPlugin_72", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "4,";
        }
        if (((Boolean)dataModel.getValue("ckmay")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e94\u6708", (String)"DataCheckPlanPlugin_73", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "5,";
        }
        if (((Boolean)dataModel.getValue("ckjun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516d\u6708", (String)"DataCheckPlanPlugin_74", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "6,";
        }
        if (((Boolean)dataModel.getValue("ckjul")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e03\u6708", (String)"DataCheckPlanPlugin_75", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "7,";
        }
        if (((Boolean)dataModel.getValue("ckaug")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516b\u6708", (String)"DataCheckPlanPlugin_76", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "8,";
        }
        if (((Boolean)dataModel.getValue("cksep")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e5d\u6708", (String)"DataCheckPlanPlugin_77", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "9,";
        }
        if (((Boolean)dataModel.getValue("ckoct")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u6708", (String)"DataCheckPlanPlugin_78", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "10,";
        }
        if (((Boolean)dataModel.getValue("cknov")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e00\u6708", (String)"DataCheckPlanPlugin_79", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "11,";
        }
        if (((Boolean)dataModel.getValue("ckdec")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e8c\u6708", (String)"DataCheckPlanPlugin_80", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            conStr = ",";
            months = months + "12,";
        }
        months = months.length() == 0 ? String.valueOf(this.getStartTime().get(2) + 1) : months.substring(0, months.length() - 1);
        cron.setMonth(months);
        if (((Boolean)dataModel.getValue("ckbyweek")).booleanValue()) {
            cron = this.repeatByNoWeek(cron);
        }
        return cron;
    }

    private CronStruct repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String no = ((String)dataModel.getValue("comno")).trim();
        String noWeek = ((String)dataModel.getValue("comweek")).trim();
        switch (no == null ? "" : no) {
            case "1": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"DataCheckPlanPlugin_61", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"DataCheckPlanPlugin_62", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"DataCheckPlanPlugin_63", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"DataCheckPlanPlugin_64", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"DataCheckPlanPlugin_65", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "L": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"DataCheckPlanPlugin_66", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        switch (noWeek == null ? "" : noWeek) {
            case "1": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"DataCheckPlanPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"DataCheckPlanPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"DataCheckPlanPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"DataCheckPlanPlugin_26", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"DataCheckPlanPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "6": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"DataCheckPlanPlugin_28", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "7": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"DataCheckPlanPlugin_29", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "8": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"DataCheckPlanPlugin_67", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                break;
            }
            case "9": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"DataCheckPlanPlugin_68", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        if (no != null && noWeek != null) {
            if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfWeek(noWeek + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek(noWeek + "L");
                }
                cron.setDayOfMonth("?");
            } else if (noWeek.equals("8")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfMonth(no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfMonth("1L");
                }
                cron.setDayOfWeek("?");
            } else if (noWeek.equals("9")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    String workday = String.valueOf(Integer.parseInt(no) + 1);
                    cron.setDayOfWeek(workday + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek("6L");
                }
                cron.setDayOfMonth("?");
            }
        }
        return cron;
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgs = (DynamicObjectCollection)this.getModel().getValue(CALORG);
        if (calOrgs != null && !calOrgs.isEmpty()) {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (DynamicObject calOrg : calOrgs) {
                orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
            }
            QFilter q = new QFilter(CALORG, "in", orgIds);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection costAccounts = (DynamicObjectCollection)this.getModel().getValue(COSTACCOUNT);
        if (costAccounts != null && !costAccounts.isEmpty()) {
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                costAccountIds.add(costAccount.getDynamicObject("fbasedataid").getLong("id"));
            }
            DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)"", (String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])new QFilter("id", "in", costAccountIds).toArray(), null);
            HashSet<Long> orgIds = new HashSet<Long>(16);
            for (Row account : accountDataSet) {
                orgIds.add(account.getLong(CALORG));
            }
            QFilter q = new QFilter("id", "in", orgIds);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4Storageorg(BeforeF7SelectEvent e) {
        DynamicObjectCollection calOrgs = (DynamicObjectCollection)this.getModel().getValue(CALORG);
        if (calOrgs != null && !calOrgs.isEmpty()) {
            ArrayList orgIds = new ArrayList();
            for (DynamicObject calOrg : calOrgs) {
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getDynamicObject("fbasedataid").getLong("id"));
                orgIds.addAll(list);
            }
            QFilter q = new QFilter("id", "in", orgIds);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private static void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue(STORAGEORGUNIT);
        DynamicObjectCollection calOrgs = (DynamicObjectCollection)model.getValue(CALORG);
        QFilter q = new QFilter("id", "=", (Object)-1L);
        Set<Object> set = DataCheckPlanPlugin.beforeF7Warehouse(storageOrgs, calOrgs);
        if (set.size() > 0) {
            q = new QFilter("id", "in", set);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private static Set<Object> beforeF7Warehouse(DynamicObjectCollection storageOrgs, DynamicObjectCollection calOrgs) {
        HashSet<Object> set = new HashSet<Object>();
        if (storageOrgs != null && storageOrgs.size() > 0) {
            for (DynamicObject info : storageOrgs) {
                Long[] warehouseIds = SCMHelper.getAllWarehouseIDs((String)info.getDynamicObject("fbasedataid").getString("number"));
                if (warehouseIds == null) continue;
                Long[] longArray = warehouseIds;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long id = longArray[i];
                    set.add(id);
                }
            }
        } else if (calOrgs != null && !calOrgs.isEmpty()) {
            Long[] warehouseIds;
            ArrayList orgIds = new ArrayList();
            for (DynamicObject calOrg : calOrgs) {
                List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getDynamicObject("fbasedataid").getLong("id"));
                orgIds.addAll(list);
            }
            Long[] longArray = warehouseIds = SCMHelper.getAllWarehouseIDs((Object[])orgIds.toArray());
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                set.add(id);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ReportF7Helper_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        return set;
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObjectCollection warehouses = (DynamicObjectCollection)this.getModel().getValue(WAREHOUSE);
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouses != null && warehouses.size() > 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject info : warehouses) {
                set.add(info.getDynamicObject("fbasedataid").getLong("id"));
            }
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])set.toArray()));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }
}

