/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.datacheck;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.datacheck.DataRepairExecutor;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.ResultStatus;

public class DataCheckResultPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opName = ((FormOperate)args.getSource()).getOperateKey();
        if ("repair_entry".equals(opName)) {
            this.repairEntryOp();
            args.setCancel(true);
        } else if ("repair_detail".equals(opName)) {
            this.repairDetailOp();
            args.setCancel(true);
        }
    }

    private void repairEntryOp() {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject result = model.getDataEntity(true);
        DynamicObject resultEntry = (DynamicObject)result.getDynamicObjectCollection("entryentity").get(index);
        if (ResultStatus.ERROR.getValue().equals(resultEntry.getString("entrystatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u9519\u8bef\u72b6\u6001\u7684\u68c0\u67e5\u9879\u5141\u8bb8\u4fee\u590d\u3002", (String)"DataCheckResultPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String plugin = resultEntry.getDynamicObject("checkitem").getString("plugin");
        DynamicObjectCollection detailCol = resultEntry.getDynamicObjectCollection("subentryentity");
        ArrayList<ExceptionObj> objList = new ArrayList<ExceptionObj>();
        for (int i = 0; i < detailCol.size(); ++i) {
            DynamicObject detail = (DynamicObject)detailCol.get(i);
            if (detail.getBoolean("isrepaired")) continue;
            ExceptionObj obj = new ExceptionObj(Long.valueOf(detail.getLong("objid")), detail.getString("objtype"));
            obj.setDescription(detail.getString("objdesc"));
            obj.setExtralInfo(detail.getString("extralinfo"));
            objList.add(obj);
            model.setValue("isrepaired", (Object)Boolean.TRUE, index, i);
        }
        new DataRepairExecutor().repairErrorData(plugin, objList);
        model.setValue("entrystatus", (Object)ResultStatus.REPAIRED.getValue(), index);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
    }

    private void repairDetailOp() {
        IDataModel model = this.getModel();
        int subindex = model.getEntryCurrentRowIndex("subentryentity");
        int index = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject result = model.getDataEntity(true);
        DynamicObject resultEntry = (DynamicObject)result.getDynamicObjectCollection("entryentity").get(index);
        String plugin = resultEntry.getDynamicObject("checkitem").getString("plugin");
        DynamicObject detail = (DynamicObject)resultEntry.getDynamicObjectCollection("subentryentity").get(subindex);
        if (detail.getBoolean("isrepaired")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5f02\u5e38\u5bf9\u8c61\u5df2\u4fee\u590d\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fee\u590d\u3002", (String)"DataCheckResultPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        ExceptionObj obj = new ExceptionObj(Long.valueOf(detail.getLong("objid")), detail.getString("objtype"));
        obj.setDescription(detail.getString("objdesc"));
        obj.setExtralInfo(detail.getString("extralinfo"));
        ArrayList<ExceptionObj> objList = new ArrayList<ExceptionObj>();
        objList.add(obj);
        new DataRepairExecutor().repairErrorData(plugin, objList);
        model.setValue("isrepaired", (Object)Boolean.TRUE, index, subindex);
        if (this.isAllExObjRepaired(resultEntry)) {
            model.setValue("entrystatus", (Object)ResultStatus.REPAIRED.getValue(), index);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
    }

    private boolean isAllExObjRepaired(DynamicObject resultEntry) {
        for (DynamicObject detail : resultEntry.getDynamicObjectCollection("subentryentity")) {
            if (detail.getBoolean("isrepaired")) continue;
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

