/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.domain;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.formplugin.domain.MulTaskCache;
import org.apache.commons.lang3.StringUtils;

public class DomainReCalPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getProgressBar().start();
        this.setCols4FilterGrid();
        this.setDefaultDate();
        this.matchCalRangeDimAcctChange();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getProgressBar().addProgressListener((ProgresssListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "bill": {
                this.setCols4FilterGrid();
                break;
            }
            case "ismatchrangedimacct": {
                this.matchCalRangeDimAcctChange();
                break;
            }
        }
    }

    private void matchCalRangeDimAcctChange() {
        Boolean isMatchCalRangeDim = (Boolean)this.getModel().getValue("ismatchrangedimacct");
        if (isMatchCalRangeDim.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isupdatebaseunit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isupdatebaseunit"});
            this.getModel().setValue("isupdatebaseunit", (Object)Boolean.FALSE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String key = event.getOperateKey();
        if ("recaldomain".equals(key)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            this.getModel().setValue("resultinfo", null);
            this.setBillFs();
            this.dispatchBatchTask();
        }
    }

    public void onProgress(ProgressEvent e) {
        String curOptime = new MulTaskCache().getPageOpTime(this.getView().getPageId());
        if (StringUtils.isBlank((CharSequence)curOptime)) {
            return;
        }
        MulTaskCache reCalCache = new MulTaskCache(curOptime);
        String curMsg = reCalCache.getAndRemoveBatchMsg();
        int percent = reCalCache.getPercent();
        if (percent >= 100) {
            percent = 99;
            reCalCache.clearBatch();
        }
        e.setProgress(percent);
        e.setText("");
        String resultInfo = (String)this.getModel().getValue("resultinfo");
        resultInfo = resultInfo == null ? "" : resultInfo;
        resultInfo = resultInfo + curMsg;
        this.getModel().setValue("resultinfo", (Object)resultInfo);
    }

    private void dispatchBatchTask() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_billdomain_recal");
        Object[] dycObj = new Object[]{this.getModel().getDataEntity(true)};
        String domainReCalDycStr = DynamicObjectSerializeUtil.serialize((Object[])dycObj, (DynamicObjectType)entityType);
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        Date endDate = this.getModel().getDataEntity().getDate("enddate");
        endDate = DateUtils.getDayEndTime((Date)endDate);
        int splitday = this.getModel().getDataEntity().getInt("splitday");
        splitday = splitday <= 1 ? 1 : splitday;
        int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate);
        int pages = diffDays / splitday;
        if (diffDays % splitday != 0) {
            ++pages;
        }
        MulTaskCache mulTaskCache = new MulTaskCache(this.getView().getPageId());
        mulTaskCache.clearBatch();
        mulTaskCache.setPageOpTime(this.getView().getPageId());
        String pageOpTime = mulTaskCache.getPageOpTime(this.getView().getPageId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String batchInfo = String.format("%s-%s-[%s]-[%s-%s]-%s-start-%s\r\n", TimeServiceHelper.formatUserNow(), splitday, pages, sdf.format(startDate.getTime()), sdf.format(endDate.getTime()), pageOpTime, "0%");
        this.getModel().setValue("resultinfo", (Object)batchInfo);
        MulTaskCache recalCache = new MulTaskCache(pageOpTime);
        recalCache.setTakCount(pages);
        for (int pageIndex = 1; pageIndex <= pages; ++pageIndex) {
            Date curStartDate = DateUtils.addDateTime((Date)startDate, (int)5, (int)((pageIndex - 1) * splitday));
            Date curEnDate = DateUtils.addDateTime((Date)startDate, (int)5, (int)(pageIndex * splitday));
            if (pageIndex == pages) {
                curEnDate = endDate;
            }
            String batchStr = String.format("%s-[%s/%s]-[%s-%s]", splitday, pageIndex, pages, sdf.format(curStartDate.getTime()), sdf.format(curEnDate.getTime()));
            if (pageIndex == pages) {
                curEnDate = DateUtils.getDayStartTime((Date)DateUtils.addDateTime((Date)endDate, (int)5, (int)1));
            }
            recalCache.addBatch(batchStr);
            HashMap<String, Object> jobParams = new HashMap<String, Object>(16);
            jobParams.put("BATCHSTR", batchStr);
            jobParams.put("DOMAINRECALDYCSTR", domainReCalDycStr);
            jobParams.put("CURSTARTDATE", curStartDate.getTime());
            jobParams.put("CURENDATE", curEnDate.getTime());
            jobParams.put("CUROPTIME", pageOpTime);
            this.dispatchTask(batchStr, jobParams, null);
        }
    }

    private void setCols4FilterGrid() {
        String entityName = this.getBill();
        String grid = "bill_fs";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(grid);
        filterGrid.SetValue(new FilterCondition());
        if (StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(new ArrayList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(grid);
    }

    private String dispatchTask(String batchStr, Map<String, Object> jobParams, String curOpPageIdTimeKey) {
        String content;
        JobInfo job = new JobInfo();
        String opName = content = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u636e\u6210\u672c\u57df\u91cd\u7b97", (String)"DomainReCalPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), new Object[0]);
        job.setName(opName + "-" + batchStr);
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setTaskClassname("kd.fi.cal.formplugin.domain.DomainReCalTask");
        job.setRunByLang(Lang.get());
        String taskid = JobClient.dispatch((JobInfo)job);
        return taskid;
    }

    private String getBill() {
        DynamicObject bill = this.getModel().getDataEntity().getDynamicObject("bill");
        if (bill != null) {
            return bill.getString("id");
        }
        return null;
    }

    private void setBillFs() {
        String bill = this.getBill();
        if (bill == null) {
            return;
        }
        FilterGrid grid = (FilterGrid)this.getControl("bill_fs");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String filterString = SerializationUtils.toJsonString((Object)condition);
        this.getModel().getDataEntity().set("filter_tag", (Object)filterString);
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getView().getControl("progressap");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getProgressBar().stop();
        new MulTaskCache(this.getView().getPageId()).clearBatch();
    }

    private void setDefaultDate() {
        this.getModel().setValue("startdate", (Object)DateUtils.getThisMonthFirstDay());
        this.getModel().setValue("enddate", (Object)DateUtils.getThisMonthEndDay());
    }
}

