/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.cal.business.calculate.domain.DomainReCalHandle;
import kd.fi.cal.formplugin.domain.MulTaskCache;
import org.apache.commons.lang3.StringUtils;

public class DomainReCalTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        String batchStr = (String)paramMap.get("BATCHSTR");
        String pageOpTime = (String)paramMap.get("CUROPTIME");
        MulTaskCache recalCache = new MulTaskCache(pageOpTime);
        try {
            int entryCount = this.doTask(paramMap);
            recalCache.setBatchMsg(batchStr, batchStr + String.format("-sucess-entryCount[%s]", entryCount));
        }
        catch (Throwable e) {
            recalCache.setBatchMsg(batchStr, batchStr + "-error\uff1a\r\n" + ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
            throw e;
        }
    }

    private int doTask(Map<String, Object> paramMap) {
        Date curStartBookDate = new Date((Long)paramMap.get("CURSTARTDATE"));
        Date curEndBookDate = new Date((Long)paramMap.get("CURENDATE"));
        String DOMAINRECALDYCSTR = (String)paramMap.get("DOMAINRECALDYCSTR");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_billdomain_recal");
        Object[] domainReCalDycs = DynamicObjectSerializeUtil.deserialize((String)DOMAINRECALDYCSTR, (DynamicObjectType)entityType);
        DynamicObject domainReCalDyc = (DynamicObject)domainReCalDycs[0];
        String entityName = this.getBill(domainReCalDyc);
        List<Long> costActIds = this.getCostActs(domainReCalDyc);
        List<Long> matIds = this.getMatIds(domainReCalDyc);
        Set<String> lotNums = this.getLotNums(domainReCalDyc);
        Date startDate = curStartBookDate;
        Date endDate = curEndBookDate;
        int updateBatch = domainReCalDyc.getInt("updatebatch");
        QFilter billFs = this.getBillFs(domainReCalDyc);
        DomainReCalHandle reCalHandle = new DomainReCalHandle();
        reCalHandle.setCostActIds(costActIds);
        reCalHandle.setMatIds(matIds);
        reCalHandle.setLotNums(lotNums);
        reCalHandle.setBillFs(billFs);
        reCalHandle.setStartDate(startDate);
        reCalHandle.setEndDate(endDate);
        reCalHandle.setUpdateBatch(updateBatch);
        boolean isMatchRangeDimAcct = domainReCalDyc.getBoolean("ismatchrangedimacct");
        reCalHandle.setIsMatchRangeDimAcct(isMatchRangeDimAcct);
        boolean isUpdateBaseUnit = domainReCalDyc.getBoolean("isupdatebaseunit");
        reCalHandle.setIsUpdateBaseUnit(isUpdateBaseUnit);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            reCalHandle.handle("cal_initbill");
            reCalHandle.handle("cal_costrecord_subentity");
            reCalHandle.handle("cal_costadjust_subentity");
        } else {
            reCalHandle.handle(this.getBill(domainReCalDyc));
        }
        return reCalHandle.getEntryCount();
    }

    private String getBill(DynamicObject domainReCalDyc) {
        DynamicObject bill = domainReCalDyc.getDynamicObject("bill");
        if (bill != null) {
            return bill.getString("id");
        }
        return null;
    }

    private List<Long> getMatIds(DynamicObject domainReCalDyc) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DynamicObjectCollection datas = domainReCalDyc.getDynamicObjectCollection("material");
        for (DynamicObject data : datas) {
            ids.add(data.getLong("fbasedataid_id"));
        }
        ids = ids.isEmpty() ? null : ids;
        return ids;
    }

    private List<Long> getCostActs(DynamicObject domainReCalDyc) {
        ArrayList<Long> ids = new ArrayList<Long>(20);
        DynamicObjectCollection datas = domainReCalDyc.getDynamicObjectCollection("costaccounts");
        for (DynamicObject data : datas) {
            ids.add(data.getLong("fbasedataid_id"));
        }
        return ids;
    }

    private Set<String> getLotNums(DynamicObject domainReCalDyc) {
        String lotNumStr = domainReCalDyc.getString("lot");
        if (kd.bos.util.StringUtils.isEmpty((String)lotNumStr)) {
            lotNumStr = domainReCalDyc.getString("lot_tag");
        }
        HashSet<String> lotNums = new HashSet<String>(16);
        if (kd.bos.util.StringUtils.isNotEmpty((String)lotNumStr)) {
            lotNums.addAll(Arrays.asList(lotNumStr.split("\\s+|[\\r\\n]+")));
        }
        return lotNums;
    }

    private QFilter getBillFs(DynamicObject domainReCalDyc) {
        String bill = this.getBill(domainReCalDyc);
        if (bill == null) {
            return null;
        }
        String filterTag = domainReCalDyc.getString("filter_tag");
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)bill), condition);
        fb.buildFilter();
        QFilter fs = fb.getQFilter();
        return fs;
    }
}

