/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.domain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MulTaskCache {
    private IAppCache CACHE = AppCache.get((String)"cal");
    private static final String BATCH_KEY = "BATCH";
    private String pageOpTime;
    private static final String TAKCOUNT = "TAKCOUNT";
    private static final String CUROPTIME = "CUROPTIME";

    public MulTaskCache() {
    }

    public MulTaskCache(String pageOpTime) {
        this.pageOpTime = pageOpTime;
    }

    public void setTakCount(int taskCount) {
        String batchListStr = this.getTaskCountKey();
        this.CACHE.put(batchListStr, (Object)taskCount);
    }

    public int getPercent() {
        Integer takCount = this.getTakCount();
        if (takCount == null || takCount == 0) {
            return 100;
        }
        String batchListStr = this.getBatchListKey();
        List batchList = (List)this.CACHE.get(batchListStr, List.class);
        batchList = batchList == null ? new ArrayList(16) : batchList;
        return (takCount - batchList.size()) * 100 / takCount;
    }

    public Integer getTakCount() {
        String batchListStr = this.getTaskCountKey();
        Integer taskCount = (Integer)this.CACHE.get(batchListStr, Integer.class);
        return taskCount;
    }

    public void addBatch(String batchStr) {
        String batchListStr = this.getBatchListKey();
        List batchList = (List)this.CACHE.get(batchListStr, List.class);
        batchList = batchList == null ? new ArrayList(16) : batchList;
        batchList.add(batchStr);
        this.CACHE.put(batchListStr, (Object)batchList);
    }

    public void addBatch(List<String> batchStrs) {
        String batchListStr = this.getBatchListKey();
        List batchList = (List)this.CACHE.get(batchListStr, List.class);
        batchList = batchList == null ? new ArrayList(16) : batchList;
        batchList.addAll(batchStrs);
        this.CACHE.put(batchListStr, (Object)batchList);
        String taskCountKey = this.getTaskCountKey();
        this.CACHE.put(taskCountKey, (Object)batchStrs.size());
    }

    public List<String> getBatchListStr() {
        String batchListStr = this.getBatchListKey();
        List batchList = (List)this.CACHE.get(batchListStr, List.class);
        batchList = batchList == null ? new ArrayList(16) : batchList;
        return batchList;
    }

    public void clearBatch() {
        String batchListStr = this.getBatchListKey();
        String taskCountKey = this.getTaskCountKey();
        List<String> batchList = this.getBatchListStr();
        for (String batch : batchList) {
            String batchMsgKey = this.getBatchMsgKey(batch);
            this.CACHE.remove(batchMsgKey);
        }
        this.CACHE.remove(batchListStr);
        this.CACHE.remove(taskCountKey);
    }

    public void setBatchMsg(String batch, String msg) {
        String batchMsgKey = this.getBatchMsgKey(batch);
        this.CACHE.put(batchMsgKey, (Object)msg);
    }

    public String getBatchMsg(String batch) {
        String batchMsKey = this.getBatchMsgKey(batch);
        String msg = (String)this.CACHE.get(batchMsKey, String.class);
        return msg;
    }

    public void removeBatchMsg(String batch) {
        String batchMsgKey = this.getBatchMsgKey(batch);
        this.CACHE.remove(batchMsgKey);
        ArrayList batchList = this.getBatchListStr();
        batchList = batchList == null ? new ArrayList(16) : batchList;
        batchList.remove(batch);
        String batchListKey = this.getBatchListKey();
        this.CACHE.put(batchListKey, batchList);
    }

    public String getAndRemoveBatchMsg() {
        List<String> batchListStrs = this.getBatchListStr();
        Iterator<String> iterator = batchListStrs.iterator();
        StringBuilder msgSB = new StringBuilder();
        int percent = 0;
        while (iterator.hasNext()) {
            String batchStr = iterator.next();
            String msg = this.getBatchMsg(batchStr);
            if (StringUtils.isBlank((CharSequence)msg)) continue;
            this.removeBatchMsg(batchStr);
            iterator.remove();
            percent = this.getPercent();
            msgSB.append(TimeServiceHelper.formatUserNow()).append("-").append(msg).append("-").append(percent).append("%\r\n");
        }
        return msgSB.toString();
    }

    private String getBatchListKey() {
        return this.pageOpTime + BATCH_KEY;
    }

    private String getBatchMsgKey(String batch) {
        return this.pageOpTime + batch;
    }

    private String getTaskCountKey() {
        return this.pageOpTime + TAKCOUNT;
    }

    private String getPageOpTimeKey(String pageId) {
        return pageId + CUROPTIME;
    }

    public void setPageOpTime(String pageId) {
        String pageOpTimeKey = this.getPageOpTimeKey(pageId);
        String pageOpTime = pageId + TimeServiceHelper.getTimeStamp();
        this.CACHE.put(pageOpTimeKey, (Object)pageOpTime);
    }

    public String getPageOpTime(String pageId) {
        String pageOpTimeKey = this.getPageOpTimeKey(pageId);
        return (String)this.CACHE.get(pageOpTimeKey, String.class);
    }
}

