/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.fallprice;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceExtractParam;
import kd.fi.cal.business.fallprice.FallPriceExtractor;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.business.fallprice.FallPriceSettingParam;
import kd.fi.cal.common.enums.ProvisionWayEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.CommonUtils;

public class ExtractFallPricePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnextract"});
        BasedataEdit calOrg = (BasedataEdit)this.getControl("calorg");
        calOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fallPriceSetting = (BasedataEdit)this.getControl("fallpricesetting");
        fallPriceSetting.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialfrom = (BasedataEdit)this.getControl("materialfrom");
        materialfrom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialto = (BasedataEdit)this.getControl("materialto");
        materialto.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String key = beforeF7SelectEvent.getProperty().getName();
        QFilter filter = null;
        if ("calorg".equals(key)) {
            filter = this.getCalorgF7Qf();
        } else if ("costaccount".equals(key)) {
            filter = this.getCostAccountF7Qf();
        } else if ("fallpricesetting".equals(key)) {
            filter = this.getFallPriceSettingF7Qf(beforeF7SelectEvent);
        } else if ("materialfrom".equals(key) || "materialto".equals(key)) {
            filter = null;
            showParameter.setShowApproved(false);
            showParameter.setShowUsed(false);
            showParameter.setF7ClickByFilter(true);
            showParameter.getListFilterParameter();
        }
        if (filter != null) {
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("calorg".equals(propertyName)) {
            this.orgChange();
            this.costAccountChange();
        } else if ("costaccount".equals(propertyName)) {
            this.costAccountChange();
        } else if ("materialfrom".equals(propertyName)) {
            this.materialFromChange();
        } else if ("materialgroup".equals(propertyName)) {
            this.matGroupChange();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey = event.getOperateKey();
        if ("btnextract".equals(opKey) && event.getOperationResult().isSuccess()) {
            this.extract(event);
        }
    }

    private void extract(AfterDoOperationEventArgs event) {
        DynamicObject costAccountDyc = (DynamicObject)this.getView().getModel().getValue("costaccount");
        DynamicObject currentPeriodDyc = PeriodHelper.getCurrentPeriod((Long)((Long)costAccountDyc.getPkValue()));
        Object period = this.getModel().getValue("period");
        if (period != null) {
            currentPeriodDyc = (DynamicObject)period;
            currentPeriodDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)currentPeriodDyc.getPkValue(), (String)"bd_period");
        }
        if (currentPeriodDyc == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u3002", (String)"ExtractFallPricePlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean exitUnAuditBill = this.checkExitUnAuditBill(costAccountDyc, currentPeriodDyc);
        if (exitUnAuditBill) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8ba1\u63d0\u5355\u6216\u51b2\u56de\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u53d6\u8dcc\u4ef7\u51c6\u5907\u3002", (String)"ExtractFallPricePlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        FallPriceExtractor fallPriceExtractor = new FallPriceExtractor();
        this.initExtractParam(fallPriceExtractor);
        boolean asyncExec = (Boolean)this.getModel().getValue("asyncexec");
        if (asyncExec) {
            fallPriceExtractor.extractAsync();
            OperationResult result = event.getOperationResult();
            result.setMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u81f3\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u5230\u201c\u7cfb\u7edf\u7ba1\u7406>\u8c03\u5ea6\u7ba1\u7406>\u8c03\u5ea6\u4efb\u52a1\u201c\u67e5\u770b\u6267\u884c\u662f\u5426\u6210\u529f\uff0c\u6216\u201c\u6d88\u606f\u4e2d\u5fc3>\u901a\u77e5\u201d\u67e5\u770b\u5177\u4f53\u6267\u884c\u60c5\u51b5\u3002", (String)"ExtractFallPricePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            this.getView().showOperationResult(result);
        } else {
            String execMsg = fallPriceExtractor.extract();
            if (execMsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u53d6\u8dcc\u4ef7\u51c6\u5907\u5b8c\u6210\u3002", (String)"ExtractFallPricePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), execMsg, MessageTypes.Default);
            }
        }
    }

    private boolean checkExitUnAuditBill(DynamicObject costAccountDyc, DynamicObject currentPeriodDyc) {
        DynamicObject calOrgDyc = (DynamicObject)this.getView().getModel().getValue("calorg");
        int currentPeriodNum = currentPeriodDyc.getInt("periodyear") * 100 + currentPeriodDyc.getInt("periodnumber");
        QFilter billStatusf = new QFilter("billstatus", "<>", (Object)BillStatus.C);
        QFilter calOrgf = new QFilter("org", "=", calOrgDyc.getPkValue());
        QFilter acctAcountf = new QFilter("costaccount", "=", costAccountDyc.getPkValue());
        QFilter periodf = new QFilter("period", "<", (Object)currentPeriodNum);
        QFilter[] filters = new QFilter[]{billStatusf, calOrgf, acctAcountf, periodf};
        boolean existProvBill = QueryServiceHelper.exists((String)"cal_price_provbill", (QFilter[])filters);
        boolean existRevBill = QueryServiceHelper.exists((String)"cal_price_provbill", (QFilter[])filters);
        return existProvBill || existRevBill;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgId = RequestContext.get().getOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        orgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_fallprice_setting");
        this.getModel().setValue("calorg", (Object)orgId);
        this.orgChange();
        this.costAccountChange();
        Boolean isSplitInvOrg = CalDbParamServiceHelper.getBoolean((String)"fallprice_split_invorg");
        if (isSplitInvOrg.booleanValue()) {
            this.getModel().setValue("asyncexec", (Object)true);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"asyncexec"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulstorageorgunit"});
        }
    }

    private void initExtractParam(FallPriceExtractor fallPriceExtractor) {
        DynamicObjectCollection settingDycs = (DynamicObjectCollection)this.getView().getModel().getValue("fallpricesetting");
        DynamicObjectCollection matGroupDycs = (DynamicObjectCollection)this.getView().getModel().getValue("materialgroup");
        DynamicObjectCollection matFromDycs = (DynamicObjectCollection)this.getView().getModel().getValue("materialfrom");
        DynamicObject matToDycs = (DynamicObject)this.getView().getModel().getValue("materialto");
        DynamicObject costAccountDyc = (DynamicObject)this.getView().getModel().getValue("costaccount");
        DynamicObject calOrgDyc = (DynamicObject)this.getView().getModel().getValue("calorg");
        DynamicObject currentPeriodDyc = PeriodHelper.getCurrentPeriod((Long)((Long)costAccountDyc.getPkValue()));
        DynamicObject startPeriodDyc = PeriodHelper.getStartPeriod((Long)((Long)costAccountDyc.getPkValue()));
        Object period = this.getModel().getValue("period");
        if (period != null) {
            currentPeriodDyc = (DynamicObject)period;
            currentPeriodDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)currentPeriodDyc.getPkValue(), (String)"bd_period");
        }
        Long currencyId = FallPriceHelper.getCurrencyByCalPolicy((Long)costAccountDyc.getLong("calpolicy.id"));
        FallPriceExtractParam fallPriceExtractParam = fallPriceExtractor.getFallPriceExtractParam();
        fallPriceExtractParam.setCurrencyId(currencyId);
        fallPriceExtractParam.setCostAccountId((Long)costAccountDyc.getPkValue());
        fallPriceExtractParam.setCalOrgId((Long)calOrgDyc.getPkValue());
        fallPriceExtractParam.setCostAccountName(costAccountDyc.getString("name"));
        fallPriceExtractParam.setCostAccountNum(costAccountDyc.getString("number"));
        DynamicObjectCollection invOrgDycs = (DynamicObjectCollection)this.getView().getModel().getValue("mulstorageorgunit");
        HashSet<Long> invOrgIds = new HashSet<Long>(16);
        if (invOrgDycs != null && invOrgDycs.size() > 0) {
            for (DynamicObject matGroupDyc : invOrgDycs) {
                DynamicObject baseDyc = matGroupDyc.getDynamicObject("fbasedataid");
                invOrgIds.add((Long)baseDyc.getPkValue());
            }
        }
        fallPriceExtractParam.setSelInvOrgIds(invOrgIds);
        fallPriceExtractParam.setCurrentPeriodId((Long)currentPeriodDyc.getPkValue());
        int currentPeriodNum = currentPeriodDyc.getInt("periodyear") * 100 + currentPeriodDyc.getInt("periodnumber");
        fallPriceExtractParam.setCurrentPeriodNum(currentPeriodNum);
        Date startPeriodFirstDate = startPeriodDyc.getDate("begindate");
        fallPriceExtractParam.setStartPeriodFirstDate(startPeriodFirstDate);
        fallPriceExtractParam.setCurPeriodLastDay(currentPeriodDyc.getDate("enddate"));
        if (matGroupDycs != null && matGroupDycs.size() > 0) {
            ArrayList<String> matGroupNums = new ArrayList<String>(matGroupDycs.size());
            ArrayList matGroupIds = new ArrayList(matGroupDycs.size());
            for (DynamicObject matGroupDyc : matGroupDycs) {
                DynamicObject baseDyc = matGroupDyc.getDynamicObject("fbasedataid");
                matGroupNums.add(baseDyc.getString("longnumber"));
                matGroupIds.add((Long)baseDyc.getPkValue());
            }
            fallPriceExtractParam.setMatGroupLNums(matGroupNums);
            fallPriceExtractParam.setMatGroupIds((List)matGroupIds);
        }
        if (matFromDycs != null && matFromDycs.size() > 0) {
            ArrayList<Long> matFromIds = new ArrayList<Long>(matFromDycs.size());
            for (DynamicObject matFromDyc : matFromDycs) {
                DynamicObject baseDyc = matFromDyc.getDynamicObject("fbasedataid");
                matFromIds.add((Long)baseDyc.getPkValue());
            }
            fallPriceExtractParam.setMaterialFromNum(((DynamicObject)matFromDycs.get(0)).getDynamicObject("fbasedataid").getString("number"));
            fallPriceExtractParam.setMaterialFromIds(matFromIds);
        }
        if (matToDycs != null) {
            fallPriceExtractParam.setMaterialToNum(matToDycs.getString("number"));
        }
        Map entityAgeFieldMap = FallPriceHelper.getEntityAgeFieldMap();
        fallPriceExtractParam.setEntityAgeFieldMap(entityAgeFieldMap);
        this.setMatCategoryIds(fallPriceExtractParam);
        List matFallPriceParams = fallPriceExtractParam.getMatFallPriceParam();
        List matGroupFallPriceParams = fallPriceExtractParam.getMatGroupFallPriceParam();
        List wareGroupFallPriceParams = fallPriceExtractParam.getWareGroupFallPriceParam();
        Map<Long, String> settingIdNoCalAgeBillMap = this.queryNotCalAgeBill(settingDycs);
        for (DynamicObject settingDyc : settingDycs) {
            DynamicObject baseDyc = settingDyc.getDynamicObject("fbasedataid");
            if (baseDyc == null) continue;
            String provisionWay = baseDyc.getString("provisionway");
            if (ProvisionWayEnum.MATERIAL.getValue().equals(provisionWay)) {
                matFallPriceParams.add(this.buildFallPriceSettingParam(baseDyc, "material", settingIdNoCalAgeBillMap));
                continue;
            }
            if (ProvisionWayEnum.MATERIALGROUP.getValue().equals(provisionWay)) {
                matGroupFallPriceParams.add(this.buildFallPriceSettingParam(baseDyc, "materialgroup", settingIdNoCalAgeBillMap));
                continue;
            }
            if (!ProvisionWayEnum.WAREHOUSEGROUP.getValue().equals(provisionWay)) continue;
            wareGroupFallPriceParams.add(this.buildFallPriceSettingParam(baseDyc, "warehousegroup", settingIdNoCalAgeBillMap));
        }
    }

    private void setMatCategoryIds(FallPriceExtractParam fallPriceExtractParam) {
        DynamicObjectCollection matCategoryDycs = (DynamicObjectCollection)this.getView().getModel().getValue("mulmatcategory");
        ArrayList<Long> matCategoryIds = new ArrayList<Long>(16);
        for (DynamicObject matCatDyc : matCategoryDycs) {
            DynamicObject baseDyc = matCatDyc.getDynamicObject("fbasedataid");
            matCategoryIds.add((Long)baseDyc.getPkValue());
        }
        fallPriceExtractParam.setMatCategoryIds(matCategoryIds);
    }

    private Map<Long, String> queryNotCalAgeBill(DynamicObjectCollection settingDycs) {
        HashMap<Long, String> settingIdNoCalAgeBillMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> noCalAgeIdSettingIdMap = new HashMap<Long, Long>(16);
        String msg = ResManager.loadKDString((String)"\u63d0\u53d6\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ExtractFallPricePlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        for (DynamicObject settingDyc : settingDycs) {
            DynamicObject baseDyc = settingDyc.getDynamicObject("fbasedataid");
            if (baseDyc == null) {
                throw new KDBizException(msg);
            }
            long notCalageBillId = baseDyc.getLong("notcalagebill_id");
            if (notCalageBillId == 0L) continue;
            noCalAgeIdSettingIdMap.put(notCalageBillId, (Long)baseDyc.getPkValue());
        }
        QFilter idFilter = new QFilter("id", "in", noCalAgeIdSettingIdMap.keySet());
        String selFields = "id,entry.billtype billtype,entry.biztype biztype,entry.invscheme invscheme";
        HashMap<Long, List> ageIdNotCalAgeBillMap = new HashMap<Long, List>(16);
        try (DataSet noCalAgeDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_notcalage", (String)selFields, (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : noCalAgeDs) {
                List notCalAgeBills = ageIdNotCalAgeBillMap.computeIfAbsent(row.getLong("id"), k -> new ArrayList(16));
                StringBuilder curNoCalAgeEntrySB = new StringBuilder();
                Long billType = row.getLong("billtype");
                Long bizType = row.getLong("biztype");
                Long invScheme = row.getLong("invscheme");
                if (billType != null && billType != 0L) {
                    curNoCalAgeEntrySB.append(billType);
                    if (bizType != null && bizType != 0L) {
                        curNoCalAgeEntrySB.append(":");
                        curNoCalAgeEntrySB.append(bizType);
                    }
                    if (invScheme != null && invScheme != 0L) {
                        curNoCalAgeEntrySB.append(":");
                        curNoCalAgeEntrySB.append(invScheme);
                    }
                }
                notCalAgeBills.add(curNoCalAgeEntrySB.toString());
            }
        }
        for (Map.Entry ageIdNotCalAgeBillEntry : ageIdNotCalAgeBillMap.entrySet()) {
            Long ageId = (Long)ageIdNotCalAgeBillEntry.getKey();
            Long settingId = (Long)noCalAgeIdSettingIdMap.get(ageId);
            settingIdNoCalAgeBillMap.put(settingId, String.join((CharSequence)",", (Iterable)ageIdNotCalAgeBillEntry.getValue()));
        }
        return settingIdNoCalAgeBillMap;
    }

    private FallPriceSettingParam buildFallPriceSettingParam(DynamicObject settingDyc, String extractWay, Map<Long, String> settingIdNoCalAgeBillMap) {
        FallPriceSettingParam settingParam = new FallPriceSettingParam();
        settingParam.setExtractWay(extractWay);
        settingParam.setProvisionToMat(settingDyc.getBoolean("provisiontomat"));
        Long settingId = (Long)settingDyc.getPkValue();
        settingParam.setSettingId(settingId);
        settingParam.setCurDims(this.getDealNullArrDims(settingDyc.getString("setdimension")));
        settingParam.setProvDims(this.getDealNullArrDims(settingDyc.getString("provdimension")));
        settingParam.setCurrencyAmtPrecision(settingDyc.getInt("currency.amtprecision"));
        settingParam.setMaxAge(settingDyc.getInt("maximumage"));
        settingParam.setSeetingName(settingDyc.getString("name"));
        Long mgsId = settingDyc.getLong("materialgroupstandard_id");
        settingParam.setMGS(mgsId);
        Boolean enableShelfLife = settingDyc.getBoolean("enableshelflife");
        settingParam.setEnableShelfLife(enableShelfLife);
        settingParam.setNoCalAgeBills(settingIdNoCalAgeBillMap.get(settingId));
        settingParam.setProvStrategy(settingDyc.getString("provstrategy"));
        return settingParam;
    }

    private String[] getDealNullArrDims(String dimVal) {
        String dimensions = FallPriceHelper.getDropdownListStr((String)dimVal);
        if ((dimensions = CommonUtils.trimComma((String)dimensions)).isEmpty()) {
            return new String[0];
        }
        String[] dims = dimensions.split(",");
        HashSet<String> dimSet = new HashSet<String>(dims.length);
        for (String dim : dims) {
            if ("x".equals(dim)) continue;
            dimSet.add(dim);
        }
        return dimSet.toArray(new String[0]);
    }

    private QFilter getCalorgF7Qf() {
        QFilter qFilter = null;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_extract_fallprice", (String)"47150e89000000ac");
        if (calorgList != null) {
            qFilter = new QFilter("id", "in", (Object)calorgList);
        }
        return qFilter;
    }

    private QFilter getCostAccountF7Qf() {
        QFilter qFilter = null;
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            qFilter = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        return qFilter;
    }

    private void orgChange() {
        DynamicObject calOrgDyc = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrgDyc == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("fallpricesetting", null);
            return;
        }
        long orgId = calOrgDyc.getLong("id");
        DynamicObject costAccountDyc = OrgHelper.getCostAccountByCalOrg((Long)orgId);
        if (costAccountDyc != null) {
            this.getModel().setValue("costaccount", costAccountDyc.get("id"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }

    private void costAccountChange() {
        DynamicObject calOrgDyc = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject acctDyc = (DynamicObject)this.getModel().getValue("costaccount");
        if (calOrgDyc == null || acctDyc == null) {
            this.getModel().setValue("fallpricesetting", null);
            this.getModel().setValue("period", null);
            return;
        }
        DynamicObject currentPeriodDyc = PeriodHelper.getCurrentPeriod((Long)((Long)acctDyc.getPkValue()));
        if (currentPeriodDyc != null) {
            this.getModel().setValue("period", currentPeriodDyc.getPkValue());
        } else {
            this.getModel().setValue("period", null);
        }
        QFilter settingFilter = new QFilter("calorg", "=", calOrgDyc.getPkValue());
        QFilter acctf = new QFilter("costaccount", "=", acctDyc.getPkValue());
        acctf.or(new QFilter("costaccount", "=", (Object)0L));
        settingFilter.and(acctf);
        settingFilter.and("status", "=", (Object)BillStatus.C);
        settingFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection settingDycs = QueryServiceHelper.query((String)"cal_fallprice_setting", (String)"id", (QFilter[])new QFilter[]{settingFilter});
        if (settingDycs.size() == 1) {
            this.getModel().setValue("fallpricesetting", (Object)new Object[]{((DynamicObject)settingDycs.get(0)).get("id")});
        } else {
            this.getModel().setValue("fallpricesetting", null);
        }
    }

    private QFilter getFallPriceSettingF7Qf(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject calOrgDyc = (DynamicObject)this.getModel().getValue("calorg");
        DynamicObject accountDyc = (DynamicObject)this.getModel().getValue("costaccount");
        if (calOrgDyc == null || accountDyc == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f\u3002", (String)"ExtractFallPricePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return null;
        }
        QFilter qFilter = new QFilter("calorg", "=", calOrgDyc.getPkValue());
        QFilter acctf = new QFilter("costaccount", "=", (Object)0L);
        acctf.or(new QFilter("costaccount", "=", accountDyc.getPkValue()));
        qFilter.and(acctf);
        return qFilter;
    }

    private void materialFromChange() {
        DynamicObjectCollection materialFromDycs = (DynamicObjectCollection)this.getModel().getValue("materialfrom");
        if (materialFromDycs == null || materialFromDycs.isEmpty()) {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        } else if (materialFromDycs.size() == 1) {
            this.getModel().setValue("materialto", ((DynamicObject)materialFromDycs.get(0)).getDynamicObject("fbasedataid").getPkValue());
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        } else if (materialFromDycs.size() > 1) {
            this.getModel().setValue("materialto", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialto"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"materialto"});
        }
    }

    private void matGroupChange() {
        this.getModel().setValue("materialfrom", null);
        this.getModel().setValue("materialto", null);
    }
}

