/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.fallprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.business.formula.StandGroupBaseDataConverter;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.ArrayUtils;

public class FallPriceProvBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String unit_realizable_amount = "unitrealizableamount";
    private static final String realizable_amount = "realizableamount";
    private static final String require_amount = "requireamount";
    private static final String fall_price_scale = "fallpricescale";
    private static final String replenish_amount = "replenishamount";
    private static final String entry = "entry";
    private static final String material = "material";
    private static final String baseunit = "baseunit";
    private static final String[] initBillHideFields = new String[]{"baseqty", "baseprice", "amount", "fallpricescale", "unitrealizableamount", "realizableamount", "requireamount", "replenishamount", "rushbaseqty", "rushamount"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (((IBillModel)this.getView().getModel()).isFromImport()) {
            return;
        }
        this.calorgChanged();
        this.costaccountChanged();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBillResolve();
        this.setDimVisible(this.getAllDims(null));
        this.setRealizableAmountEnable();
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject accsettingInfo = (DynamicObject)this.getModel().getValue("accsetting");
        if (accsettingInfo == null) {
            return;
        }
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && ((Boolean)isinitbill).booleanValue()) {
            this.costaccountChanged();
            this.settingAndImportDataIntersection(accsettingInfo);
        }
    }

    private void setRealizableAmountEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
        for (int i = 0; i < entryEntity.size(); ++i) {
            boolean endAmountLessEqualZero;
            DynamicObject entryRow = (DynamicObject)entryEntity.get(i);
            BigDecimal baseQty = entryRow.getBigDecimal("baseqty");
            BigDecimal amount = entryRow.getBigDecimal("amount");
            boolean qtyLessEqualZero = baseQty.compareTo(BigDecimal.ZERO) <= 0;
            boolean bl = endAmountLessEqualZero = amount.compareTo(BigDecimal.ZERO) <= 0;
            if (!qtyLessEqualZero && !endAmountLessEqualZero) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{realizable_amount});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{unit_realizable_amount});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("org".equals(key)) {
            this.calorgChanged();
        } else if ("costaccount".equals(key)) {
            this.costaccountChanged();
            this.accsettingChanged();
        } else if ("accsetting".equals(key)) {
            this.accsettingChanged();
        } else if (fall_price_scale.equals(key)) {
            this.fallpricescaleChanged();
        } else if (unit_realizable_amount.equals(key)) {
            this.unitrealizableamountChanged();
        } else if (realizable_amount.equals(key)) {
            this.realizableamountChanged();
        } else if (material.equals(key)) {
            this.materialChanged(e);
        }
        super.propertyChanged(e);
    }

    private void materialChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(material, rowIndex);
        this.getModel().setValue("stocktype", null, rowIndex);
        if (materialInfo == null) {
            return;
        }
        DynamicObject bastunitObj = materialInfo.getDynamicObject(baseunit);
        this.getModel().setValue(baseunit, bastunitObj.get("id"), rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate source = (AbstractOperate)e.getSource();
        String key = source.getOperateKey();
        if ("submit".equals(key)) {
            source.getOption().setVariableValue("fromedit", "true");
            this.deleteRepZeroEntry();
        } else if ("linkagerpt".equals(key)) {
            this.linkToStockAgeRpt();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("audit") && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void linkToStockAgeRpt() {
        FilterInfo filter = new FilterInfo();
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Date bookdate = (Date)this.getModel().getValue("bookdate");
        List<String> rptDims = this.getAgeRptDims();
        filter.addFilterItem("mulcostaccount", (Object)calOrg);
        filter.addFilterItem("mulcalorg", (Object)costAccount);
        if (costAccount != null) {
            DynamicObject newCostAcctDyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_bd_costaccount"));
            newCostAcctDyc.set("id", costAccount.get("id"));
            DynamicObjectCollection costAcctDycs = new DynamicObjectCollection();
            costAcctDycs.add((Object)newCostAcctDyc);
            filter.getFilterItem("mulcostaccount").setValue((Object)costAcctDycs);
        }
        if (calOrg != null) {
            DynamicObject newCalOrgDycs = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
            newCalOrgDycs.set("id", calOrg.get("id"));
            DynamicObjectCollection calOrgDycs = new DynamicObjectCollection();
            calOrgDycs.add((Object)newCalOrgDycs);
            filter.getFilterItem("mulcalorg").setValue((Object)calOrgDycs);
        }
        filter.addFilterItem("enddate", (Object)bookdate);
        String dimStr = ",calorg,costaccount,material,";
        if (!rptDims.isEmpty()) {
            dimStr = dimStr + String.join((CharSequence)",", rptDims);
        }
        filter.addFilterItem("showkeycols", (Object)dimStr);
        filter.addFilterItem("enddate", (Object)bookdate);
        filter.addFilterItem("localcurrency", (Object)currency);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entry);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 0) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(entry);
            DynamicObjectCollection storageDys = new DynamicObjectCollection();
            DynamicObjectCollection wareGroupDys = new DynamicObjectCollection();
            DynamicObjectCollection matDys = new DynamicObjectCollection();
            DynamicObjectCollection ownerDys = new DynamicObjectCollection();
            DynamicObjectCollection wareDys = new DynamicObjectCollection();
            DynamicObjectCollection locDys = new DynamicObjectCollection();
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRow = (DynamicObject)entrys.get(selectRows[i]);
                DynamicObject storageorgunit = entryRow.getDynamicObject("storageorgunit");
                DynamicObject warehousegroup = entryRow.getDynamicObject("warehousegroup");
                DynamicObject material = entryRow.getDynamicObject(material);
                DynamicObject owner = entryRow.getDynamicObject("owner");
                DynamicObject warehouse = entryRow.getDynamicObject("warehouse");
                DynamicObject location = entryRow.getDynamicObject("location");
                if (storageorgunit != null) {
                    storageDys.add((Object)storageorgunit);
                }
                if (warehousegroup != null) {
                    wareGroupDys.add((Object)warehousegroup);
                }
                if (material != null) {
                    matDys.add((Object)material);
                }
                if (owner != null) {
                    ownerDys.add((Object)owner);
                }
                if (warehouse != null) {
                    wareDys.add((Object)warehouse);
                }
                if (location == null) continue;
                locDys.add((Object)location);
            }
            if (!storageDys.isEmpty()) {
                filter.addFilterItem("mulstorageorg", (Object)storageDys);
            }
            if (!wareGroupDys.isEmpty()) {
                filter.addFilterItem("mulwarehsgroup", (Object)wareGroupDys);
            }
            if (!matDys.isEmpty()) {
                filter.addFilterItem("mulmaterial", (Object)matDys);
                if (matDys.size() == 1) {
                    filter.addFilterItem("materialto", matDys.get(0));
                }
            }
            if (!ownerDys.isEmpty()) {
                filter.addFilterItem("mulowner", (Object)ownerDys);
            }
            if (!wareDys.isEmpty()) {
                filter.addFilterItem("mulwarehouse", (Object)wareDys);
            }
            if (!locDys.isEmpty()) {
                filter.addFilterItem("mullocation", (Object)locDys);
            }
        }
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_stock_age_newrpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<String> getAgeRptDims() {
        ArrayList<String> rptDims = new ArrayList<String>(16);
        DynamicObject accSetting = (DynamicObject)this.getModel().getValue("accsetting");
        if (accSetting == null) {
            return rptDims;
        }
        String setDimension = accSetting.getString("setdimension");
        Object[] setDims = setDimension.split(",");
        String provDimension = accSetting.getString("provdimension");
        String[] provDims = provDimension.split(",");
        String[] dims = (String[])ArrayUtils.concatAll((Object[])setDims, (Object[][])new String[][]{provDims});
        HashSet<String> dimDists = new HashSet<String>(Arrays.asList(dims));
        for (String dim : dimDists) {
            if (dim.equals("x")) continue;
            if (dim.equals("warehouse")) {
                rptDims.add("warehouse");
            }
            if (dim.equals("location")) {
                rptDims.add("location");
            }
            if (dim.equals("storageorgunit")) {
                rptDims.add("storageorg");
            }
            if (!dim.equals("owner")) continue;
            rptDims.add("owner");
        }
        if (accSetting != null && "C".equals(accSetting.getString("provisionway"))) {
            rptDims.add("group");
        }
        return rptDims;
    }

    public void initImportData(InitImportDataEventArgs e) {
    }

    private void deleteRepZeroEntry() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Boolean provAll = (Boolean)ParamsHelper.getAppParam((long)((Long)((DynamicObject)org).getPkValue()), (String)"provall");
        if (provAll.booleanValue()) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(16);
        DynamicObjectCollection entryDycs = this.getModel().getEntryEntity(entry);
        boolean notInitBill = (Boolean)this.getModel().getValue("isinitbill") == false;
        for (int i = 0; i < entryDycs.size(); ++i) {
            boolean delete;
            BigDecimal repAmount = ((DynamicObject)entryDycs.get(i)).getBigDecimal(replenish_amount);
            boolean bl = delete = notInitBill && repAmount != null && repAmount.compareTo(BigDecimal.ZERO) == 0;
            if (!delete) continue;
            rowIndexs.add(i);
        }
        if (rowIndexs.size() > 0) {
            int[] rows = new int[rowIndexs.size()];
            for (int i = 0; i < rowIndexs.size(); ++i) {
                rows[i] = (Integer)rowIndexs.get(i);
            }
            this.getModel().deleteEntryRows(entry, rows);
        }
    }

    private void realizableamountChanged() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        BigDecimal baseqty = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("baseqty");
        BigDecimal amount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("amount");
        BigDecimal realizableamount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal(realizable_amount);
        BigDecimal unitrealizableamount = realizableamount.divide(baseqty, 10, RoundingMode.HALF_UP);
        BigDecimal fallpricescale = amount.subtract(realizableamount).multiply(new BigDecimal(100)).divide(amount, 2, RoundingMode.HALF_UP);
        BigDecimal hasamount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("hasamount");
        BigDecimal requireamount = amount.subtract(realizableamount);
        BigDecimal replenishamount = requireamount.subtract(hasamount);
        this.getModel().beginInit();
        this.getModel().setValue(fall_price_scale, (Object)fallpricescale, rowIndex);
        this.getModel().setValue(unit_realizable_amount, (Object)unitrealizableamount, rowIndex);
        this.getModel().setValue(replenish_amount, (Object)replenishamount, rowIndex);
        this.getModel().setValue(require_amount, (Object)requireamount, rowIndex);
        this.getView().updateView(fall_price_scale, rowIndex);
        this.getView().updateView(unit_realizable_amount, rowIndex);
        this.getView().updateView(replenish_amount, rowIndex);
        this.getView().updateView(require_amount, rowIndex);
        this.getModel().endInit();
    }

    private void unitrealizableamountChanged() {
        int amtPrecision = 10;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        BigDecimal baseqty = (BigDecimal)this.getModel().getValue("baseqty", rowIndex);
        baseqty = baseqty == null ? BigDecimal.ZERO : baseqty;
        BigDecimal baseprice = (BigDecimal)this.getModel().getValue("baseprice", rowIndex);
        baseprice = baseprice == null ? BigDecimal.ZERO : baseprice;
        BigDecimal unitrealizableamount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal(unit_realizable_amount);
        BigDecimal realizableamount = unitrealizableamount.multiply(baseqty).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal fallpricescale = baseprice.subtract(unitrealizableamount).multiply(new BigDecimal(100)).divide(baseprice, 2, RoundingMode.HALF_UP);
        BigDecimal amount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("amount");
        BigDecimal requireamount = amount.subtract(realizableamount);
        BigDecimal hasamount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("hasamount");
        BigDecimal replenishamount = requireamount.subtract(hasamount);
        this.getModel().beginInit();
        this.getModel().setValue(fall_price_scale, (Object)fallpricescale, rowIndex);
        this.getModel().setValue(realizable_amount, (Object)realizableamount, rowIndex);
        this.getModel().setValue(require_amount, (Object)requireamount, rowIndex);
        this.getModel().setValue(replenish_amount, (Object)replenishamount, rowIndex);
        this.getView().updateView(fall_price_scale, rowIndex);
        this.getView().updateView(realizable_amount, rowIndex);
        this.getView().updateView(require_amount, rowIndex);
        this.getView().updateView(replenish_amount, rowIndex);
        this.getModel().endInit();
    }

    private void fallpricescaleChanged() {
        int amtPrecision = 10;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        BigDecimal baseqty = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("baseqty");
        BigDecimal amount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("amount");
        BigDecimal fallpricescale = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal(fall_price_scale);
        BigDecimal realizableamount = amount.multiply(new BigDecimal(100).subtract(fallpricescale)).divide(new BigDecimal(100), amtPrecision, RoundingMode.HALF_UP);
        BigDecimal unitrealizableamount = BigDecimal.ZERO;
        if (baseqty.compareTo(BigDecimal.ZERO) != 0) {
            unitrealizableamount = realizableamount.divide(baseqty, 10, RoundingMode.HALF_UP);
        }
        BigDecimal requireamount = amount.subtract(realizableamount);
        BigDecimal hasamount = ((DynamicObject)this.getModel().getEntryEntity(entry).get(rowIndex)).getBigDecimal("hasamount");
        BigDecimal replenishamount = requireamount.subtract(hasamount);
        this.getModel().beginInit();
        this.getModel().setValue(unit_realizable_amount, (Object)unitrealizableamount, rowIndex);
        this.getModel().setValue(realizable_amount, (Object)realizableamount, rowIndex);
        this.getModel().setValue(require_amount, (Object)requireamount, rowIndex);
        this.getModel().setValue(replenish_amount, (Object)replenishamount, rowIndex);
        this.getView().updateView(unit_realizable_amount, rowIndex);
        this.getView().updateView(realizable_amount, rowIndex);
        this.getView().updateView(require_amount, rowIndex);
        this.getView().updateView(replenish_amount, rowIndex);
        this.getModel().endInit();
    }

    private void initBillResolve() {
        boolean initbill = (Boolean)this.getModel().getValue("isinitbill");
        this.getModel().beginInit();
        if (initbill) {
            this.getView().setVisible(Boolean.valueOf(false), initBillHideFields);
        }
        this.getModel().endInit();
    }

    private void accsettingChanged() {
        DynamicObject accsettingInfo = (DynamicObject)this.getModel().getValue("accsetting");
        this.getModel().deleteEntryData(entry);
        if (accsettingInfo == null) {
            return;
        }
        String provisionWay = accsettingInfo.getString("provisionway");
        this.getModel().deleteEntryData(entry);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getTableSetterBySetting(accsettingInfo);
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            model.batchCreateNewEntryRow(entry, vs);
        }
        model.endInit();
        this.getView().updateView(entry);
        if (!"C".equals(provisionWay)) {
            for (int i = 0; i < rowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{material});
                this.getView().updateView(material, i);
            }
        }
    }

    private TableValueSetter getTableSetterBySetting(DynamicObject accsettingInfo) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> entryDims = this.getEntryRealDims(accsettingInfo);
        List<String> allRealDims = this.getRealDims(accsettingInfo);
        allRealDims = new ArrayList<String>(new HashSet<String>(allRealDims));
        entryDims = new ArrayList<String>(new HashSet<String>(entryDims));
        List<String> allDims = this.getAllDims(null);
        this.setDimVisible(allDims);
        String provisionWay = accsettingInfo.getString("provisionway");
        allRealDims.add("materialgroup");
        allRealDims.add(material);
        allRealDims.add("ownertype");
        allRealDims.add(unit_realizable_amount);
        allRealDims.add(fall_price_scale);
        allRealDims.add("invagefrom");
        allRealDims.add("invageto");
        allRealDims.add("expirydatefrom");
        allRealDims.add("expirydateto");
        entryDims.add("entry.ownertype as ownertype");
        entryDims.add("entry.unitrealizableamount as unitrealizableamount");
        entryDims.add("entry.fallpricescale as fallpricescale");
        entryDims.add("entry.invagefrom as invagefrom");
        entryDims.add("entry.invageto as invageto");
        entryDims.add("entry.expirydatefrom as expirydatefrom");
        entryDims.add("entry.expirydateto as expirydateto");
        for (String string : allRealDims) {
            vs.addField(string, new Object[0]);
        }
        vs.addField(baseunit, new Object[0]);
        Object accsettingId = accsettingInfo.get("id");
        QFilter accSettingFilter = new QFilter("id", "=", accsettingId);
        List setDims = FallPriceHelper.getSetDimStrsWithoutGroup((DynamicObject)accsettingInfo);
        Set provDims = FallPriceHelper.getDropdownList((String)accsettingInfo.getString("provdimension"));
        DataSet initBalDs = this.getInitBalDs(accsettingInfo);
        if ("A".equals(provisionWay)) {
            allRealDims.add(baseunit);
            entryDims.add("entry.material.group as materialgroup");
            entryDims.add("entry.material as material");
            entryDims.add("entry.material.baseunit as baseunit");
            DataSet matSettingDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_fallprice_setting", (String)String.join((CharSequence)",", new HashSet<String>(entryDims)), (QFilter[])accSettingFilter.toArray(), null);
            matSettingDs = this.settingDsJoinBalDs(setDims, provDims, initBalDs, matSettingDs);
            this.addTableSetterRow(vs, allRealDims, matSettingDs, provisionWay);
        } else if ("B".equals(provisionWay)) {
            entryDims.add("entry.materialgroup as materialgroup");
            entryDims.add("entry.materialgroup.longnumber as grouplnum");
            allRealDims.add(baseunit);
            String mgsSel = String.format("case when (materialgroupstandard is null or materialgroupstandard = 0) then %s else materialgroupstandard end as materialgroupstandard", 730148448254487552L);
            DataSet matGroupSettingDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_fallprice_setting", (String)(String.join((CharSequence)",", new HashSet<String>(entryDims)) + ",entry.materialgroup.longnumber," + mgsSel), (QFilter[])accSettingFilter.toArray(), null);
            HashSet<Long> matGroupIds = new HashSet<Long>(16);
            for (Row row : matGroupSettingDs.copy()) {
                matGroupIds.add(row.getLong("materialgroup"));
            }
            String matGroupDLM = FallPriceHelper.getMatGroupDLM();
            if (matGroupIds.size() > 0) {
                DataSet materialDataSet = this.getMatDsByMatGroup(matGroupIds, accsettingInfo);
                ArrayList<String> settingFields = new ArrayList<String>(Arrays.asList(matGroupSettingDs.getRowMeta().getFieldNames()));
                settingFields.remove(material);
                settingFields.remove(baseunit);
                String format = "matgrouplnum = grouplnum or StartsWith(matgrouplnum,grouplnum + '%s')";
                format = String.format(format, matGroupDLM);
                matGroupSettingDs = matGroupSettingDs.join(materialDataSet).on("materialgroupstandard", "standard").select(settingFields.toArray(new String[0]), new String[]{material, baseunit, "matgrouplnum", "detailmatgroup"}).finish().filter(format);
                matGroupSettingDs = this.settingDsJoinBalDs(setDims, provDims, initBalDs, matGroupSettingDs);
                this.addTableSetterRow(vs, allRealDims, matGroupSettingDs, provisionWay);
            }
        } else if ("C".equals(provisionWay)) {
            vs.addField("warehousegroup", new Object[0]);
            allRealDims.add(baseunit);
            allRealDims.add("warehousegroup");
            entryDims.add("entry.warehousegroup as warehousegroup");
            DataSet warehouseGroupDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_fallprice_setting", (String)String.join((CharSequence)",", entryDims), (QFilter[])accSettingFilter.toArray(), null);
            setDims.add("warehousegroup");
            provDims.add(material);
            provDims.add(baseunit);
            provDims.add("materialgroup");
            warehouseGroupDs = this.settingDsJoinBalDs(setDims, provDims, initBalDs, warehouseGroupDs);
            this.addTableSetterRow(vs, allRealDims, warehouseGroupDs, provisionWay);
        }
        return vs;
    }

    private List<String> getEntryRealDims(DynamicObject accsettingInfo) {
        ArrayList<String> entryDims = new ArrayList<String>(16);
        String[] setDimArr = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("setdimension")).split(",");
        HashSet<String> setDims = new HashSet<String>(Arrays.asList(setDimArr));
        setDims.remove("");
        for (String realDim : setDims) {
            entryDims.add("entry." + realDim + " as " + realDim);
        }
        return entryDims;
    }

    private List<String> getRealDims(DynamicObject accsettingInfo) {
        String[] setDimArr = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("setdimension")).split(",");
        ArrayList<String> setDims = new ArrayList<String>(Arrays.asList(setDimArr));
        Set realDims = FallPriceHelper.getDropdownList((String)accsettingInfo.getString("provdimension"));
        setDims.addAll(realDims);
        HashSet<String> allRealDimSet = new HashSet<String>(setDims);
        allRealDimSet.remove("");
        setDims = new ArrayList<String>(allRealDimSet);
        return setDims;
    }

    private DataSet getMatDsByMatGroup(Set<Long> matGroupIds, DynamicObject accsettingInfo) {
        Long mgsId = accsettingInfo.getLong("materialgroupstandard_id");
        mgsId = mgsId == null || mgsId.equals(0L) ? Long.valueOf(730148448254487552L) : mgsId;
        StandGroupBaseDataConverter baseDataParser = new StandGroupBaseDataConverter("bd_materialgroupdetail", material);
        String matSelField = "standard,material,group.longnumber as matgrouplnum,material.baseunit baseunit,group detailmatgroup";
        DataSet materialDataSet = baseDataParser.getBaseDataDs(mgsId, matGroupIds, matSelField);
        return materialDataSet;
    }

    private List<String> getAllDims(List<String> entryDims) {
        ArrayList<String> allDims = new ArrayList<String>(16);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_fallprice_setting");
        List setDimensions = ((MulComboProp)dataEntityType.getAllFields().get("setdimension")).getComboItems();
        for (ValueMapItem dim : setDimensions) {
            if (dim.getValue().equals("x")) continue;
            allDims.add(dim.getValue());
            if (entryDims == null) continue;
            entryDims.add("entry." + dim.getValue() + " as " + dim.getValue());
        }
        return allDims;
    }

    private void setDimVisible(List<String> allDims) {
        DynamicObject accsettingInfo = (DynamicObject)this.getModel().getValue("accsetting");
        if (accsettingInfo == null) {
            this.getView().setVisible(Boolean.FALSE, allDims.toArray(new String[0]));
        } else {
            String[] setDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("setdimension")).split(",");
            String[] provDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("provdimension")).split(",");
            this.getView().setVisible(Boolean.FALSE, allDims.toArray(new String[0]));
            this.getView().setVisible(Boolean.TRUE, setDims);
            this.getView().setVisible(Boolean.TRUE, provDims);
            String provisionWay = accsettingInfo.getString("provisionway");
            this.getView().setVisible(Boolean.FALSE, new String[]{"warehousegroup", "warehousegroupname"});
            if ("C".equals(provisionWay)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"warehousegroup", "warehousegroupname"});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "org", "costaccount", "accsetting");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void costaccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("bizdate", null);
            this.getModel().setValue("bookdate", null);
            this.getModel().setValue("periodid", null);
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", costAccount.getDynamicObject("calpolicy").getPkValue()).toArray());
        this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (currentPeriod != null) {
            this.getModel().setValue("periodid", currentPeriod.getPkValue());
            this.getModel().setValue("bizdate", (Object)currentPeriod.getDate("enddate"));
            this.getModel().setValue("bookdate", (Object)currentPeriod.getDate("enddate"));
            this.getModel().setValue("period", (Object)0);
        }
    }

    private void calorgChanged() {
        DynamicObject costaccout;
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("org");
        if (calOrg != null && (costaccout = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"))) != null) {
            this.getModel().setValue("costaccount", costaccout.get("id"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4Costaccount(e);
        } else if ("accsetting".equals(key)) {
            this.beforeF7Select4AccSetting(e);
        }
    }

    private void beforeF7Select4AccSetting(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (costaccount != null) {
            q = new QFilter("costaccount", "=", costaccount.getPkValue());
        } else if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        q.and("status", "=", (Object)Character.valueOf('C'));
        q.and("enable", "=", (Object)true);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Costaccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("org");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FallPriceProvBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        q = new QFilter("calorg", "=", calOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_price_provbill", (String)"47156aff000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void settingAndImportDataIntersection(DynamicObject accsettingInfo) {
        String[] setDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("setdimension")).split(",");
        String[] provDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("provdimension")).split(",");
        Map<String, List<Map<String, Object>>> importDimValuesMap = this.getSetDimImportValueMap(accsettingInfo, setDims, provDims);
        TableValueSetter vs = this.getTableSetterBySetting(accsettingInfo);
        TableValueSetter newVs = new TableValueSetter(new String[0]);
        List fields = vs.getFields();
        for (String field : fields) {
            newVs.addField(field, new Object[0]);
        }
        newVs.addField("hasamount", new Object[0]);
        newVs.addField("id", new Object[0]);
        List newVsFields = newVs.getFields();
        String provisionWay = accsettingInfo.getString("provisionway");
        for (int i = 0; i < vs.getCount(); ++i) {
            StringBuilder sb = new StringBuilder();
            Object matGroup = vs.get("materialgroup", i);
            Object warehouseGroup = vs.get("warehousegroup", i);
            Object material = vs.get(material, i);
            this.appendProvWayDim(sb, provisionWay, material, matGroup, warehouseGroup);
            for (String item : setDims) {
                if (item.isEmpty()) continue;
                sb.append(this.getDimValue(item, vs.get(item, i)));
                sb.append(",");
            }
            sb.append(vs.get("invagefrom", i));
            sb.append(",");
            sb.append(vs.get("invageto", i));
            sb.append(",");
            sb.append(vs.get("expirydatefrom", i));
            sb.append(",");
            sb.append(vs.get("expirydateto", i));
            sb.append(",");
            for (String item : provDims) {
                if (item.isEmpty()) continue;
                sb.append(this.getDimValue(item, vs.get(item, i)));
                sb.append(",");
            }
            String key = sb.substring(0, sb.length() - 1);
            List<Map<String, Object>> importValues = importDimValuesMap.get(key);
            if (importValues == null || importValues.isEmpty()) continue;
            Map<String, Object> firstImportValue = importValues.get(0);
            importValues.remove(0);
            Object[] newRow = new Object[newVsFields.size()];
            for (int index = 0; index < fields.size(); ++index) {
                newRow[index] = vs.get((String)fields.get(index), i);
            }
            newRow[newVsFields.size() - 2] = firstImportValue.get("hasamount");
            newRow[newVsFields.size() - 1] = firstImportValue.get("entry.id");
            newVs.addRow(newRow);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int rowCount = newVs.getCount();
        model.deleteEntryData(entry);
        if (rowCount != 0) {
            model.batchCreateNewEntryRow(entry, newVs);
        }
        model.endInit();
        this.getView().updateView(entry);
    }

    private void appendProvWayDim(StringBuilder sb, String provisionWay, Object material, Object materialgroup, Object warehousegroup) {
        if (provisionWay.equals("A")) {
            sb.append(material);
            sb.append(",");
        }
        if (provisionWay.equals("B")) {
            sb.append(material);
            sb.append(",");
            sb.append(materialgroup);
            sb.append(",");
        }
        if (provisionWay.equals("C")) {
            sb.append(material);
            sb.append(",");
            sb.append(warehousegroup);
            sb.append(",");
        }
    }

    private Map<String, List<Map<String, Object>>> getSetDimImportValueMap(DynamicObject accsettingInfo, String[] setDims, String[] provDims) {
        HashMap<String, List<Map<String, Object>>> importDimValuesMap = new HashMap<String, List<Map<String, Object>>>(16);
        String provisionWay = accsettingInfo.getString("provisionway");
        int rowCount = this.getModel().getEntryEntity(entry).size();
        for (int i = 0; i < rowCount; ++i) {
            Object dimValue;
            HashMap<String, Object> importRowDimValue = new HashMap<String, Object>(16);
            StringBuilder sb = new StringBuilder();
            Object matGroup = this.getModel().getValue("materialgroup", i);
            matGroup = this.getDimValue("materialgroup", matGroup);
            Object warehouseGroup = this.getModel().getValue("warehousegroup", i);
            warehouseGroup = this.getDimValue("warehousegroup", warehouseGroup);
            Object material = this.getModel().getValue(material, i);
            material = this.getDimValue(material, material);
            this.appendProvWayDim(sb, provisionWay, material, matGroup, warehouseGroup);
            for (String item : setDims) {
                if (item.isEmpty()) continue;
                dimValue = this.getModel().getValue(item, i);
                dimValue = this.getDimValue(item, dimValue);
                sb.append(dimValue);
                sb.append(",");
                importRowDimValue.put(item, dimValue);
            }
            sb.append(this.getModel().getValue("invagefrom", i));
            sb.append(",");
            sb.append(this.getModel().getValue("invageto", i));
            sb.append(",");
            sb.append(this.getModel().getValue("expirydatefrom", i));
            sb.append(",");
            sb.append(this.getModel().getValue("expirydateto", i));
            sb.append(",");
            for (String item : provDims) {
                if (item.isEmpty()) continue;
                dimValue = this.getModel().getValue(item, i);
                dimValue = this.getDimValue(item, dimValue);
                sb.append(dimValue);
                sb.append(",");
                importRowDimValue.put(item, dimValue);
            }
            String key = sb.substring(0, sb.length() - 1);
            List importRowValue = importDimValuesMap.computeIfAbsent(key, k -> new ArrayList());
            importRowDimValue.put(material, material);
            importRowDimValue.put("hasamount", this.getModel().getValue("hasamount", i));
            importRowDimValue.put("entry.id", this.getModel().getValue("entry.id", i));
            importRowValue.add(importRowDimValue);
        }
        return importDimValuesMap;
    }

    private Object getDimValue(String dimField, Object dimValue) {
        if (dimValue instanceof DynamicObject) {
            dimValue = ((DynamicObject)dimValue).getPkValue();
        }
        if (dimValue == null && this.getModel().getDataEntityType().findProperty(dimField) instanceof BasedataProp) {
            dimValue = 0L;
        }
        if (dimValue == null && this.getModel().getDataEntityType().findProperty(dimField) instanceof TextProp) {
            dimValue = "";
        }
        return dimValue;
    }

    private DataSet getInitBalDs(DynamicObject accsettingInfo) {
        List setDims = FallPriceHelper.getSetDimStrsWithoutGroup((DynamicObject)accsettingInfo);
        String[] provDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("provdimension")).split(",");
        HashSet<String> balDims = new HashSet<String>(setDims);
        balDims.addAll(Arrays.asList(provDims));
        balDims.add("material.group as materialgroup");
        balDims.add("warehouse.group as warehousegroup");
        balDims.add(material);
        balDims.add(baseunit);
        balDims.remove("");
        String balDimSelects = String.join((CharSequence)",", balDims);
        ArrayList<QFilter> balFilter = new ArrayList<QFilter>(16);
        QFilter orgf = new QFilter("calorg", "=", this.getModel().getValue("org_id"));
        balFilter.add(orgf);
        Object costaccountId = this.getModel().getValue("costaccount_id");
        QFilter acctf = new QFilter("costaccount", "=", costaccountId);
        balFilter.add(acctf);
        QFilter periodf = new QFilter("period", "=", (Object)0L);
        balFilter.add(periodf);
        QFilter ownerTypef = new QFilter("ownertype", "=", (Object)"bos_org");
        balFilter.add(ownerTypef);
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        DataSet balDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)balName, (String)balDimSelects, (QFilter[])balFilter.toArray(new QFilter[0]), null);
        return balDs;
    }

    private DataSet settingDsJoinBalDs(List<String> setDims, Set<String> provDims, DataSet initBalDs, DataSet settingDs) {
        ArrayList<String> groupDims = new ArrayList<String>(setDims);
        groupDims.addAll(provDims);
        initBalDs = initBalDs.groupBy(groupDims.toArray(new String[0])).finish();
        JoinDataSet matSettingJoinBalDs = settingDs.leftJoin(initBalDs);
        for (String item : setDims) {
            matSettingJoinBalDs.on(item, item);
        }
        HashSet<String> settingAllFields = new HashSet<String>(Arrays.asList(settingDs.getRowMeta().getFieldNames()));
        provDims.removeAll(settingAllFields);
        settingDs = matSettingJoinBalDs.select(settingDs.getRowMeta().getFieldNames(), provDims.toArray(new String[0])).finish();
        return settingDs;
    }

    private void addTableSetterRow(TableValueSetter vs, List<String> allDims, DataSet settingDsJoinBalDs, String provisionWay) {
        boolean isProvMatGroup = "B".equals(provisionWay);
        try (DataSet settingDataset = settingDsJoinBalDs;){
            int size = allDims.size();
            Object[] values = new Object[size];
            for (Row row : settingDataset) {
                for (int i = 0; i < size; ++i) {
                    String field = allDims.get(i);
                    if ("materialgroup".equals(field) && isProvMatGroup) {
                        field = "detailmatgroup";
                    }
                    values[i] = row.get(field);
                }
                vs.addRow(values);
            }
        }
    }
}

