/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.fallprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.ArrayUtils;

public class FallPriceRevBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String org = "org";
    private static final String cost_account = "costaccount";
    private static final String period_id = "periodid";
    private static final String biz_date = "bizdate";
    private static final String book_date = "bookdate";
    private static final String entry = "entry";
    private static final String accsetting = "accsetting";
    private static final String cur_period_rush_amount = "curperiodrushamount";

    public void afterCreateNewData(EventObject e) {
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue(org);
        if (null != orgDyc) {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)((Long)orgDyc.getPkValue()));
            this.changeCostAccount(costAccount);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDimVisible(this.getAllDims());
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if ("ADDNEW".equals(billStatus.name())) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(cost_account);
            this.changeCostAccount(costAccount);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            DynamicObjectCollection entryInfos = this.getModel().getEntryEntity(entry);
            BigDecimal rushAmount = BigDecimal.ZERO;
            ArrayList<Integer> rowList = new ArrayList<Integer>();
            for (int i = 0; i < entryInfos.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entryInfos.get(i);
                rushAmount = entryInfo.getBigDecimal(cur_period_rush_amount);
                if (rushAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                rowList.add(i);
            }
            if (!rowList.isEmpty()) {
                int[] rowArray = new int[rowList.size()];
                for (int i = 0; i < rowArray.length; ++i) {
                    rowArray[i] = (Integer)rowList.get(i);
                }
                this.getModel().deleteEntryRows(entry, rowArray);
            }
        } else if (StringUtils.equals((CharSequence)"linkagerpt", (CharSequence)operateKey)) {
            this.linkToStockAgeRpt();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("audit") && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void linkToStockAgeRpt() {
        FilterInfo filter = new FilterInfo();
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue(org);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(cost_account);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Date bookdate = (Date)this.getModel().getValue(book_date);
        List<String> rptDims = this.getAgeRptDims();
        filter.addFilterItem("mulcostaccount", (Object)calOrg);
        filter.addFilterItem("mulcalorg", (Object)costAccount);
        if (costAccount != null) {
            DynamicObject newCostAcctDyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_bd_costaccount"));
            newCostAcctDyc.set("id", costAccount.get("id"));
            DynamicObjectCollection costAcctDycs = new DynamicObjectCollection();
            costAcctDycs.add((Object)newCostAcctDyc);
            filter.getFilterItem("mulcostaccount").setValue((Object)costAcctDycs);
        }
        if (calOrg != null) {
            DynamicObject newCalOrgDycs = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
            newCalOrgDycs.set("id", calOrg.get("id"));
            DynamicObjectCollection calOrgDycs = new DynamicObjectCollection();
            calOrgDycs.add((Object)newCalOrgDycs);
            filter.getFilterItem("mulcalorg").setValue((Object)calOrgDycs);
        }
        filter.addFilterItem("enddate", (Object)bookdate);
        String dimStr = ",calorg,costaccount,material,";
        if (!rptDims.isEmpty()) {
            dimStr = dimStr + String.join((CharSequence)",", rptDims);
        }
        filter.addFilterItem("showkeycols", (Object)dimStr);
        filter.addFilterItem("enddate", (Object)bookdate);
        filter.addFilterItem("localcurrency", (Object)currency);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entry);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 0) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(entry);
            DynamicObjectCollection storageDys = new DynamicObjectCollection();
            DynamicObjectCollection wareGroupDys = new DynamicObjectCollection();
            DynamicObjectCollection matDys = new DynamicObjectCollection();
            DynamicObjectCollection ownerDys = new DynamicObjectCollection();
            DynamicObjectCollection wareDys = new DynamicObjectCollection();
            DynamicObjectCollection locDys = new DynamicObjectCollection();
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRow = (DynamicObject)entrys.get(selectRows[i]);
                DynamicObject storageorgunit = entryRow.getDynamicObject("storageorgunit");
                DynamicObject warehousegroup = entryRow.getDynamicObject("warehousegroup");
                DynamicObject material = entryRow.getDynamicObject("material");
                DynamicObject owner = entryRow.getDynamicObject("owner");
                DynamicObject warehouse = entryRow.getDynamicObject("warehouse");
                DynamicObject location = entryRow.getDynamicObject("location");
                if (storageorgunit != null) {
                    storageDys.add((Object)storageorgunit);
                }
                if (warehousegroup != null) {
                    wareGroupDys.add((Object)warehousegroup);
                }
                if (material != null) {
                    matDys.add((Object)material);
                }
                if (owner != null) {
                    ownerDys.add((Object)owner);
                }
                if (warehouse != null) {
                    wareDys.add((Object)warehouse);
                }
                if (location == null) continue;
                locDys.add((Object)location);
            }
            if (!storageDys.isEmpty()) {
                filter.addFilterItem("mulstorageorg", (Object)storageDys);
            }
            if (!wareGroupDys.isEmpty()) {
                filter.addFilterItem("mulwarehsgroup", (Object)wareGroupDys);
            }
            if (!matDys.isEmpty()) {
                filter.addFilterItem("mulmaterial", (Object)matDys);
                if (matDys.size() == 1) {
                    filter.addFilterItem("materialto", matDys.get(0));
                }
            }
            if (!ownerDys.isEmpty()) {
                filter.addFilterItem("mulowner", (Object)ownerDys);
            }
            if (!wareDys.isEmpty()) {
                filter.addFilterItem("mulwarehouse", (Object)wareDys);
            }
            if (!locDys.isEmpty()) {
                filter.addFilterItem("mullocation", (Object)locDys);
            }
        }
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_stock_age_newrpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<String> getAgeRptDims() {
        ArrayList<String> rptDims = new ArrayList<String>(16);
        DynamicObject accSetting = (DynamicObject)this.getModel().getValue(accsetting);
        if (accSetting == null) {
            return rptDims;
        }
        String setDimension = accSetting.getString("setdimension");
        Object[] setDims = setDimension.split(",");
        String provDimension = accSetting.getString("provdimension");
        String[] provDims = provDimension.split(",");
        String[] dims = (String[])ArrayUtils.concatAll((Object[])setDims, (Object[][])new String[][]{provDims});
        HashSet<String> dimDists = new HashSet<String>(Arrays.asList(dims));
        for (String dim : dimDists) {
            if (dim.equals("x")) continue;
            if (dim.equals("warehouse")) {
                rptDims.add("warehouse");
            }
            if (dim.equals("location")) {
                rptDims.add("location");
            }
            if (dim.equals("storageorgunit")) {
                rptDims.add("storageorg");
            }
            if (!dim.equals("owner")) continue;
            rptDims.add("owner");
        }
        if (accSetting != null && "C".equals(accSetting.getString("provisionway"))) {
            rptDims.add("group");
        }
        return rptDims;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, org, cost_account, accsetting);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        QFilter qFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        if (org.equals(key)) {
            this.getCalorgF7Qf(qFilter);
        } else if (cost_account.equals(key)) {
            this.getCostAccountF7Qf(qFilter);
        } else if (accsetting.equals(key)) {
            this.getAccsettingFilter(qFilter);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void getAccsettingFilter(QFilter qFilter) {
        DynamicObject orgInfo = (DynamicObject)this.getModel().getValue(org);
        DynamicObject costAccountInfo = (DynamicObject)this.getModel().getValue(cost_account);
        if (costAccountInfo != null) {
            qFilter.and(cost_account, "=", costAccountInfo.getPkValue());
            return;
        }
        long costAccountInfoId = 0L;
        if (orgInfo != null) {
            costAccountInfoId = orgInfo.getLong("id");
        }
        qFilter.and("calorg", "=", (Object)costAccountInfoId);
    }

    private void getCostAccountF7Qf(QFilter qFilter) {
        DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(org);
        if (calOrg == null) {
            qFilter.and("calorg", "=", null);
        } else {
            qFilter.and("calorg", "=", calOrg.getPkValue());
        }
    }

    private void changeCostAccount(DynamicObject costAccount) {
        Long costAccountId = null;
        Long periodId = null;
        Date bizDate = null;
        this.getModel().beginInit();
        if (costAccount != null) {
            Object calPolicy;
            costAccountId = costAccount.getLong("id");
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (period != null) {
                periodId = period.getLong("id");
                bizDate = PeriodHelper.getCurrentPeriodenddate((Long)costAccountId);
            }
            if ((calPolicy = costAccount.get("calpolicy")) instanceof DynamicObject) {
                calPolicy = ((DynamicObject)calPolicy).getPkValue();
            }
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", calPolicy).toArray());
            this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
            this.getView().updateView("currency");
        }
        this.getModel().setValue(cost_account, (Object)costAccountId);
        this.getModel().setValue(period_id, periodId);
        this.getModel().setValue(biz_date, bizDate);
        this.getModel().setValue(book_date, (Object)bizDate);
        this.getView().updateView(cost_account);
        this.getView().updateView(period_id);
        this.getView().updateView(biz_date);
        this.getView().updateView(book_date);
        this.getModel().endInit();
    }

    private void getCalorgF7Qf(QFilter qFilter) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_price_revbill", (String)"47150e89000000ac");
        if (calorgList != null) {
            qFilter.and("id", "in", (Object)calorgList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (org.equals(propertyName)) {
            this.orgChange();
        } else if (cost_account.equals(propertyName)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(cost_account);
            this.changeCostAccount(costAccount);
        } else if (accsetting.equals(propertyName)) {
            this.setDimVisible(this.getAllDims());
        } else if ("material".equals(propertyName)) {
            this.getModel().setValue("stocktype", null, rowIndex);
        }
    }

    private void orgChange() {
        DynamicObject calorgObj = (DynamicObject)this.getModel().getValue(org);
        if (calorgObj == null) {
            return;
        }
        long orgId = calorgObj.getLong("id");
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)orgId);
        this.changeCostAccount(costAccount);
    }

    private void setDimVisible(List<String> allDims) {
        DynamicObject accsettingInfo = (DynamicObject)this.getModel().getValue(accsetting);
        if (accsettingInfo == null) {
            this.getView().setVisible(Boolean.FALSE, allDims.toArray(new String[0]));
            this.getModel().deleteEntryData(entry);
        } else {
            String[] setDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("setdimension")).split(",");
            String[] provDims = FallPriceHelper.getDropdownListStr((String)accsettingInfo.getString("provdimension")).split(",");
            this.getView().setVisible(Boolean.FALSE, allDims.toArray(new String[0]));
            this.getView().setVisible(Boolean.TRUE, setDims);
            this.getView().setVisible(Boolean.TRUE, provDims);
            String provisionWay = accsettingInfo.getString("provisionway");
            this.getView().setVisible(Boolean.FALSE, new String[]{"warehousegroup", "warehousegroupname"});
            if ("C".equals(provisionWay)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"warehousegroup", "warehousegroupname"});
            }
        }
    }

    private List<String> getAllDims() {
        ArrayList<String> allDims = new ArrayList<String>(16);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_fallprice_setting");
        List setDimensions = ((MulComboProp)dataEntityType.getAllFields().get("setdimension")).getComboItems();
        List provDimensions = ((MulComboProp)dataEntityType.getAllFields().get("provdimension")).getComboItems();
        for (ValueMapItem dim : setDimensions) {
            if (dim.getValue().equals("x")) continue;
            allDims.add(dim.getValue());
        }
        for (ValueMapItem dim : provDimensions) {
            allDims.add(dim.getValue());
        }
        return allDims;
    }
}

