/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.fallprice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.enums.ProvisionWayEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.BatchFillEntryHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class FallPriceSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String calorg = "calorg";
    private static final String cost_account = "costaccount";
    private static final String cal_policy = "calpolicy";
    private static final String accsys = "accsys";
    private static final String currency = "currency";
    private static final String warehouse_group = "warehousegroup";
    private static final String material_group = "materialgroup";
    private static final String material = "material";
    private static final String material_name = "materialname";
    private static final String owner = "owner";
    private static final String warehouse = "warehouse";
    private static final String location = "location";
    private static final String storage_orgunit = "storageorgunit";
    private static final String provision_way = "provisionway";
    private static final String set_dimension = "setdimension";
    private static final String entry = "entry";
    private static final String invage_from = "invagefrom";
    private static final String invage_to = "invageto";
    private static final String unit_realizable_amount = "unitrealizableamount";
    private static final String inv_type = "invtype";
    private static final String provision_to_mat = "provisiontomat";
    private static final String FALLPRICESCALE = "fallpricescale";
    private static final String LOT = "lot";
    private static final String ENABLE_SHELFLIFE = "enableshelflife";
    private static final String EXPIRYDATE_FROM = "expirydatefrom";
    private static final String EXPIRYDATE_TO = "expirydateto";
    private static final int DEFALUT_MAX_DAY = 999999;
    private static final String MATERIAL_GROUP_STANDARD = "materialgroupstandard";

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (calorg.equals(key)) {
            this.calorgChange();
        } else if (cost_account.equals(key)) {
            DynamicObject costAccountPage = (DynamicObject)this.getModel().getValue(cost_account);
            if (costAccountPage == null) {
                return;
            }
            DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])new QFilter("id", "=", (Object)costAccountPage.getLong("id")).toArray());
            this.reviewCostAccount(costAccount);
        } else if (provision_way.equals(key)) {
            this.changeProvisionWay();
            this.setDefaultMGS();
        } else if (set_dimension.equals(key)) {
            this.changeSetDimension();
        } else if (warehouse.equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(location, null, rowIndex);
            this.setLocationEnable(rowIndex);
        } else if (invage_from.equals(key)) {
            int invageToInfo;
            int newValue;
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object oldValueObj = e.getChangeSet()[0].getOldValue();
            int oldValue = 0;
            if (oldValueObj != null) {
                oldValue = Integer.parseInt(oldValueObj.toString());
            }
            if ((newValue = ((Integer)e.getChangeSet()[0].getNewValue()).intValue()) > (invageToInfo = Integer.parseInt(this.getModel().getValue(invage_to, rowIndex).toString()))) {
                this.getModel().beginInit();
                this.getModel().setValue(invage_from, (Object)oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(invage_from, rowIndex);
            }
        } else if (invage_to.equals(key)) {
            int invageFromInfo;
            int newValue;
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object oldValueObj = e.getChangeSet()[0].getOldValue();
            int oldValue = 0;
            if (oldValueObj != null) {
                oldValue = Integer.parseInt(oldValueObj.toString());
            }
            if ((newValue = ((Integer)e.getChangeSet()[0].getNewValue()).intValue()) < (invageFromInfo = Integer.parseInt(this.getModel().getValue(invage_from, rowIndex).toString()))) {
                this.getModel().beginInit();
                this.getModel().setValue(invage_to, (Object)oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(invage_to, rowIndex);
            }
        } else if (storage_orgunit.equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(warehouse, null, rowIndex);
            this.getModel().setValue(location, null, rowIndex);
        } else if (!provision_to_mat.equals(key)) {
            if (material_group.equals(key)) {
                this.setRealizableAmountEnable();
            } else if (warehouse_group.equals(key)) {
                this.setRealizableAmountEnable();
            } else if (material.equals(key)) {
                this.getModel().setValue("configuredcode", null, e.getChangeSet()[0].getRowIndex());
            } else if (ENABLE_SHELFLIFE.equals(key)) {
                Boolean enableShelfLife = (Boolean)e.getChangeSet()[0].getNewValue();
                this.changeEnableShelfLife(enableShelfLife);
            } else if (MATERIAL_GROUP_STANDARD.equals(key)) {
                this.changeMGS(e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String value = e.getResultValue();
        if (e.getCallBackId().equals("change_mgs")) {
            String customVaule = e.getCustomVaule();
            Map paramsMap = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            String newMgsIdStr = (String)paramsMap.get("newmgsid");
            String oldMgsIdStr = (String)paramsMap.get("oldmgsid");
            if (MessageBoxResult.Yes.name().equals(value)) {
                this.getView().getModel().deleteEntryData(entry);
            } else {
                Long oldMgsId = null;
                if (!StringUtils.isEmpty((CharSequence)oldMgsIdStr)) {
                    oldMgsId = Long.valueOf(oldMgsIdStr);
                }
                this.getModel().beginInit();
                this.getModel().setValue(MATERIAL_GROUP_STANDARD, (Object)oldMgsId);
                this.getModel().endInit();
                this.getView().updateView(MATERIAL_GROUP_STANDARD);
            }
        }
    }

    private void changeEnableShelfLife(Boolean enableShelfLife) {
        this.setAgeOrShelfLifeEnable();
        if (enableShelfLife.booleanValue()) {
            return;
        }
        boolean hasSetExpirydate = false;
        int rowCount = this.getModel().getEntryEntity(entry).size();
        for (int i = 0; i < rowCount; ++i) {
            int expiryDateFrom = (Integer)this.getModel().getValue(EXPIRYDATE_FROM, i);
            int expiryDateTo = (Integer)this.getModel().getValue(EXPIRYDATE_TO, i);
            if (expiryDateFrom == -999999 && expiryDateTo == 999999) continue;
            hasSetExpirydate = true;
            break;
        }
        if (hasSetExpirydate) {
            this.getModel().beginInit();
            this.getModel().setValue(ENABLE_SHELFLIFE, (Object)true);
            this.getModel().endInit();
            this.getView().updateView(ENABLE_SHELFLIFE);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EXPIRYDATE_FROM, EXPIRYDATE_TO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{invage_from, invage_to});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u7ef4\u62a4\u6709\u6548\u671f\u5929\u6570\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u3002", (String)"FallPriceSettingPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeMGS(PropertyChangedArgs e) {
        Object newMgsObj = e.getChangeSet()[0].getNewValue();
        Object oldMgsObj = e.getChangeSet()[0].getOldValue();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("change_mgs", (IFormPlugin)this);
        JSONObject json = new JSONObject();
        json.put("newmgsid", (Object)(newMgsObj == null ? "" : ((DynamicObject)newMgsObj).getPkValue().toString()));
        json.put("oldmgsid", (Object)(oldMgsObj == null ? "" : ((DynamicObject)oldMgsObj).getPkValue().toString()));
        String paramStr = SerializationUtils.toJsonString((Object)json);
        String msg = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u6807\u51c6\u5207\u6362\uff0c\u6e05\u7a7a\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"FallPriceSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, MessageBoxOptions.YesNo, null, confirmCallBacks, null, paramStr);
    }

    private void setDefaultMGS() {
        this.getModel().beginInit();
        String way = (String)this.getModel().getValue(provision_way);
        if (ProvisionWayEnum.MATERIALGROUP.getValue().equals(way)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MATERIAL_GROUP_STANDARD});
            this.getModel().setValue(MATERIAL_GROUP_STANDARD, (Object)730148448254487552L);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MATERIAL_GROUP_STANDARD});
            this.getModel().setValue(MATERIAL_GROUP_STANDARD, null);
        }
        this.getModel().endInit();
        this.getView().updateView(MATERIAL_GROUP_STANDARD);
    }

    private void setLocationEnable(int rowIndex) {
        DynamicObject warehouseObj = (DynamicObject)this.getModel().getValue(warehouse, rowIndex);
        if (warehouseObj == null) {
            return;
        }
        boolean isopenlocation = warehouseObj.getBoolean("isopenlocation");
        this.getModel().beginInit();
        this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{location});
        this.getView().updateView(location, rowIndex);
        this.getModel().endInit();
    }

    private void setRealizableAmountEnable() {
        String way = (String)this.getModel().getValue(provision_way);
        boolean isMaterial = "A".equals(way) ? Boolean.TRUE : Boolean.FALSE;
        int count = this.getModel().getEntryRowCount(entry);
        for (int i = 0; i < count; ++i) {
            if (isMaterial) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{unit_realizable_amount});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{unit_realizable_amount});
        }
    }

    private void reviewCostAccount(DynamicObject costAccount) {
        this.getModel().beginInit();
        this.changeCostAccount(costAccount);
        this.getView().updateView(cost_account);
        this.getView().updateView(accsys);
        this.getView().updateView(cal_policy);
        this.getView().updateView(currency);
        this.getModel().endInit();
    }

    private void calorgChange() {
        DynamicObject calorgObj = (DynamicObject)this.getModel().getValue(calorg);
        if (calorgObj == null) {
            return;
        }
        long orgId = calorgObj.getLong("id");
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)orgId);
        this.reviewCostAccount(costAccount);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId;
        super.afterCreateNewData(e);
        if (((IBillModel)this.getView().getModel()).isFromImport()) {
            return;
        }
        DynamicObject calorgInfo = (DynamicObject)this.getModel().getValue(calorg);
        if (calorgInfo == null) {
            orgId = RequestContext.get().getOrgId();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            orgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)orgId, (String)"cal_fallprice_setting");
            this.getModel().setValue(calorg, (Object)orgId);
        } else {
            orgId = calorgInfo.getLong("id");
        }
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)orgId);
        this.changeCostAccount(costAccount);
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue(cost_account);
        if (costAccount == null) {
            return;
        }
        QFilter q = new QFilter("id", "=", (Object)costAccount.getLong("id"));
        costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])q.toArray());
        this.changeCostAccount(costAccount);
        this.clearNoUseFieldImport();
    }

    private void clearNoUseFieldImport() {
        this.getModel().beginInit();
        int rowCount = this.getModel().getEntryEntity(entry).size();
        String way = (String)this.getModel().getValue(provision_way);
        ComboProp prop = (ComboProp)this.getModel().getProperty(set_dimension);
        List propComboItems = prop.getComboItems();
        String setDimension = (String)this.getModel().getValue(set_dimension);
        String[] setDims = setDimension.split(",");
        ArrayList<String> setDimList = new ArrayList<String>(Arrays.asList(setDims));
        ArrayList<String> noUseDimList = new ArrayList<String>();
        for (ValueMapItem propComboItem : propComboItems) {
            if (setDimList.contains(propComboItem.getValue())) continue;
            noUseDimList.add(propComboItem.getValue());
        }
        for (int i = 0; i < rowCount; ++i) {
            if (ProvisionWayEnum.MATERIAL.getValue().equals(way)) {
                this.getModel().setValue(material_group, null, i);
                this.getModel().setValue(warehouse_group, null, i);
            } else if (ProvisionWayEnum.MATERIALGROUP.getValue().equals(way)) {
                this.getModel().setValue(material, null, i);
                this.getModel().setValue(warehouse_group, null, i);
                this.getModel().setValue(unit_realizable_amount, null, i);
            } else if (ProvisionWayEnum.WAREHOUSEGROUP.getValue().equals(way)) {
                this.getModel().setValue(material, null, i);
                this.getModel().setValue(material_group, null, i);
                this.getModel().setValue(unit_realizable_amount, null, i);
            }
            for (String curDim : noUseDimList) {
                if ("x".equals(curDim)) continue;
                this.getModel().setValue(curDim, null, i);
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        super.afterAddRow(e);
        String way = (String)this.getModel().getValue(provision_way);
        boolean isMaterial = "A".equals(way) ? Boolean.TRUE : Boolean.FALSE;
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            int rowIndex = row.getRowIndex();
            if (isMaterial) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{unit_realizable_amount});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{unit_realizable_amount});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("batchfillentry".equals(key)) {
            e.setCancel(true);
            this.batchFillEntry();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("unaudit".equals(key)) {
            this.setIsRef();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsRef();
        this.changeProvisionWay();
        this.getModel().setDataChanged(false);
        int rowCount = this.getModel().getEntryEntity(entry).size();
        for (int i = 0; i < rowCount; ++i) {
            this.setLocationEnable(i);
        }
        this.changeSetDimension();
        this.setAgeOrShelfLifeEnable();
    }

    private void setAgeOrShelfLifeEnable() {
        Boolean enableShelfLife = (Boolean)this.getModel().getValue(ENABLE_SHELFLIFE);
        if (enableShelfLife.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EXPIRYDATE_FROM, EXPIRYDATE_TO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{invage_from, invage_to});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPIRYDATE_FROM, EXPIRYDATE_TO});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{invage_from, invage_to});
        }
    }

    private void setIsRef() {
        QFilter settingf;
        boolean ref;
        Long settingId = (Long)this.getModel().getValue("id");
        if (settingId != null && settingId != 0L && (ref = QueryServiceHelper.exists((String)"cal_price_provbill", (QFilter[])new QFilter[]{settingf = new QFilter("accsetting", "=", (Object)settingId)}))) {
            this.getModel().setValue("isref", (Object)true);
            String setDimension = (String)this.getModel().getValue(set_dimension);
            this.getModel().setDataChanged(false);
            if (setDimension != null) {
                boolean dimEmpty;
                String[] dims = FallPriceHelper.getDropdownListStr((String)setDimension).split(",");
                boolean bl = dimEmpty = dims.length == 1 && dims[0].equals("");
                if (!dimEmpty) {
                    int rowCount = this.getModel().getEntryEntity(entry).size();
                    for (int i = 0; i < rowCount; ++i) {
                        this.getView().setEnable(Boolean.valueOf(false), i, dims);
                    }
                }
            }
        }
    }

    private void changeSetDimension() {
        DynamicObjectCollection entryInfo = this.getModel().getEntryEntity(entry);
        if (entryInfo.isEmpty()) {
            return;
        }
        ComboProp prop = (ComboProp)this.getModel().getProperty(set_dimension);
        List propComboItems = prop.getComboItems();
        String way = (String)this.getModel().getValue(set_dimension);
        way = FallPriceHelper.getDropdownListStr((String)way);
        String fieldValue = "";
        if (StringUtils.isBlank((CharSequence)way)) {
            for (ValueMapItem valueMapItem : propComboItems) {
                fieldValue = valueMapItem.getValue();
                if ("x".equals(fieldValue)) continue;
                int rowCount = this.getModel().getEntryEntity(entry).size();
                for (int i = 0; i < rowCount; ++i) {
                    this.getModel().setValue(fieldValue, null, i);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{fieldValue});
            }
        } else {
            String[] wayArray = way.split(",");
            this.getView().setVisible(Boolean.TRUE, wayArray);
            ArrayList<String> wayList = new ArrayList<String>(Arrays.asList(wayArray));
            for (ValueMapItem valueMapItem : propComboItems) {
                fieldValue = valueMapItem.getValue();
                if (wayList.contains(fieldValue) || "x".equals(fieldValue)) continue;
                int rowCount = this.getModel().getEntryEntity(entry).size();
                for (int i = 0; i < rowCount; ++i) {
                    this.getModel().setValue(fieldValue, null, i);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{fieldValue});
            }
        }
    }

    private void changeProvisionWay() {
        String way = (String)this.getModel().getValue(provision_way);
        if (ProvisionWayEnum.MATERIAL.getValue().equals(way)) {
            this.materialChange();
        } else if (ProvisionWayEnum.MATERIALGROUP.getValue().equals(way)) {
            this.materialGroupChange();
        } else if (ProvisionWayEnum.WAREHOUSEGROUP.getValue().equals(way)) {
            this.warehouseGroupChange();
        }
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_fallprice_setting");
        ComboProp property = (ComboProp)entitytype.getProperty(set_dimension);
        ArrayList<ComboItem> newItems = new ArrayList<ComboItem>(16);
        for (ValueMapItem item : property.getComboItems()) {
            if (!ProvisionWayEnum.MATERIAL.getValue().equals(way) && "configuredcode".equals(item.getValue())) continue;
            newItems.add(new ComboItem(item.getName(), item.getValue()));
        }
        if (newItems.isEmpty()) {
            return;
        }
        String setDimStr = (String)this.getModel().getValue(set_dimension);
        if (!ProvisionWayEnum.MATERIAL.getValue().equals(way) && setDimStr != null && setDimStr.contains("configuredcode")) {
            setDimStr = setDimStr.replace("configuredcode", "").replace(",,", ",");
            this.getModel().setValue(set_dimension, (Object)setDimStr);
        }
        ComboEdit co = (ComboEdit)this.getView().getControl(set_dimension);
        co.setComboItems(newItems);
        if (ProvisionWayEnum.MATERIALGROUP.getValue().equals(way)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MATERIAL_GROUP_STANDARD});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MATERIAL_GROUP_STANDARD});
        }
    }

    private void warehouseGroupChange() {
        this.getModel().setValue(provision_to_mat, (Object)Boolean.TRUE);
        int rowCount = this.getModel().getEntryEntity(entry).size();
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(material_group, null, i);
            this.getModel().setValue(unit_realizable_amount, null, i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{unit_realizable_amount});
        }
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entry);
        entryGrid.setMustInput(material_group, Boolean.FALSE.booleanValue());
        entryGrid.setMustInput(warehouse_group, Boolean.TRUE.booleanValue());
        this.getView().setVisible(Boolean.FALSE, new String[]{material_group});
        this.getView().setVisible(Boolean.TRUE, new String[]{warehouse_group});
        entryGrid.setMustInput(material, Boolean.FALSE.booleanValue());
        this.getView().setVisible(Boolean.FALSE, new String[]{material});
        this.getView().setVisible(Boolean.FALSE, new String[]{material_name});
    }

    private void materialGroupChange() {
        this.getModel().setValue(provision_to_mat, (Object)Boolean.FALSE);
        this.getView().setEnable(Boolean.FALSE, new String[]{provision_to_mat});
        int rowCount = this.getModel().getEntryEntity(entry).size();
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(material, null, i);
            this.getModel().setValue(warehouse_group, null, i);
            this.getModel().setValue(unit_realizable_amount, null, i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{unit_realizable_amount});
        }
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entry);
        entryGrid.setMustInput(material, Boolean.FALSE.booleanValue());
        entryGrid.setMustInput(material_group, Boolean.TRUE.booleanValue());
        this.getView().setVisible(Boolean.FALSE, new String[]{material});
        this.getView().setVisible(Boolean.FALSE, new String[]{material_name});
        this.getView().setVisible(Boolean.TRUE, new String[]{material_group});
        this.getView().setVisible(Boolean.FALSE, new String[]{warehouse_group});
    }

    private void materialChange() {
        this.getModel().setValue(provision_to_mat, (Object)Boolean.FALSE);
        this.getView().setEnable(Boolean.FALSE, new String[]{provision_to_mat});
        int rowCount = this.getModel().getEntryEntity(entry).size();
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(material_group, null, i);
            this.getModel().setValue(warehouse_group, null, i);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{unit_realizable_amount});
        }
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entry);
        entryGrid.setMustInput(material_group, Boolean.FALSE.booleanValue());
        entryGrid.setMustInput(material, Boolean.TRUE.booleanValue());
        this.getView().setVisible(Boolean.FALSE, new String[]{material_group});
        this.getView().setVisible(Boolean.TRUE, new String[]{material});
        this.getView().setVisible(Boolean.TRUE, new String[]{material_name});
        this.getView().setVisible(Boolean.FALSE, new String[]{warehouse_group});
    }

    private void changeCostAccount(DynamicObject costAccount) {
        Long costAccountId = null;
        Long accsysId = null;
        Long calPolicy = null;
        Long currencyId = null;
        if (costAccount != null) {
            costAccountId = costAccount.getLong("id");
            accsysId = costAccount.getLong("calsystem");
            calPolicy = costAccount.getLong(cal_policy);
            currencyId = costAccount.getLong("calpolicy.currency");
        } else {
            currencyId = this.getCurrencyByOrg();
        }
        this.getModel().setValue(cost_account, (Object)costAccountId);
        this.getModel().setValue(accsys, (Object)accsysId);
        this.getModel().setValue(cal_policy, (Object)calPolicy);
        this.getModel().setValue(currency, (Object)currencyId);
    }

    private Long getCurrencyByOrg() {
        DynamicObjectCollection currencyObj;
        DynamicObject calorgObj = (DynamicObject)this.getModel().getValue(calorg);
        Long currencyId = null;
        if (calorgObj != null && !(currencyObj = QueryServiceHelper.query((String)"bd_accountingsys_base", (String)"basecurrrency.id", (QFilter[])new QFilter("baseacctorg", "=", calorgObj.getPkValue()).toArray())).isEmpty()) {
            currencyId = ((DynamicObject)currencyObj.get(0)).getLong("basecurrrency.id");
        }
        return currencyId;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, calorg, cost_account, accsys, cal_policy, currency, storage_orgunit, material_group, owner, warehouse, location, inv_type, "configuredcode", material);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        QFilter qFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        if (calorg.equals(key)) {
            this.getCalorgF7Qf(qFilter);
        } else if (cost_account.equals(key)) {
            this.getCostAccountF7Qf(qFilter);
        } else if (material_group.equals(key)) {
            Object mgs = this.getModel().getValue(MATERIAL_GROUP_STANDARD);
            mgs = mgs == null ? Long.valueOf(730148448254487552L) : ((DynamicObject)mgs).getPkValue();
            qFilter = new QFilter("standard", "=", mgs);
            showParameter.setCustomParam("groupStandard", mgs);
        } else if (owner.equals(key)) {
            this.getOwnerF7Qf(qFilter);
        } else if (storage_orgunit.equals(key)) {
            this.getStorageOrgunitF7Qf(qFilter);
        } else if (warehouse.equals(key)) {
            int rowIndex = event.getRow();
            this.getWarehouseF7Qf(rowIndex, qFilter);
        } else if (location.equals(key)) {
            int rowIndex = event.getRow();
            this.getLocationF7Qf(rowIndex, qFilter);
        } else if (inv_type.equals(key)) {
            qFilter.and("isforwardamount", "=", (Object)Boolean.TRUE);
        } else if ("configuredcode".equals(key)) {
            DynamicObject material = (DynamicObject)this.getModel().getValue(material, event.getRow());
            if (material == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CostAdjustBillPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long materialId = material.getLong("id");
            QFilter matFilter = new QFilter(material, "=", (Object)materialId);
            showParameter.getListFilterParameter().setFilter(matFilter);
        } else if (material.equals(key)) {
            showParameter.setShowApproved(false);
            showParameter.setShowUsed(false);
            showParameter.setF7ClickByFilter(true);
            showParameter.getListFilterParameter();
        }
        if (!material.equals(key)) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void getLocationF7Qf(int rowIndex, QFilter qFilter) {
        DynamicObject warehouseObj = (DynamicObject)this.getModel().getValue(warehouse, rowIndex);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (warehouseObj != null) {
            DynamicObjectCollection locationCol = warehouseObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject locDym : locationCol) {
                ids.add(locDym.getLong("location.id"));
            }
        }
        qFilter.and("id", "in", ids);
    }

    private void getStorageOrgunitF7Qf(QFilter qFilter) {
        DynamicObject orgInfo = (DynamicObject)this.getModel().getValue(calorg);
        List storageOrgIdList = new ArrayList();
        if (orgInfo != null) {
            storageOrgIdList = OrgHelper.getStorageOrgUnitByCalOrg((Long)orgInfo.getLong("id"));
        }
        qFilter.and("id", "in", storageOrgIdList);
    }

    private void getWarehouseF7Qf(int rowIndex, QFilter qFilter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(storage_orgunit, rowIndex);
        Long[] allWhs = null;
        if (org != null) {
            allWhs = SCMHelper.getAllInUseWarehouseIDs((String)org.getString("number"));
        } else {
            DynamicObject calOrg = (DynamicObject)this.getModel().getValue(calorg);
            List list = OrgHelper.getStorageOrgUnitByCalOrg((Long)calOrg.getLong("id"));
            allWhs = SCMHelper.getAllInUseWarehouseIDs(Arrays.asList(list.toArray(new Object[0]))).toArray(new Long[0]);
        }
        qFilter.and("id", "in", (Object)allWhs);
    }

    private void getOwnerF7Qf(QFilter qFilter) {
        DynamicObject costaccountObj = (DynamicObject)this.getModel().getValue(cost_account);
        if (costaccountObj != null) {
            Long[] ownerIsArray = AccountingSysHelper.getOwners((Long)costaccountObj.getLong("id"));
            qFilter.and("id", "in", (Object)ownerIsArray);
        } else {
            qFilter.and("id", "=", null);
        }
    }

    private void getCostAccountF7Qf(QFilter qFilter) {
        DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(calorg);
        if (calOrg == null) {
            qFilter.and(calorg, "=", null);
        } else {
            qFilter.and(calorg, "=", calOrg.getPkValue());
        }
    }

    private void getCalorgF7Qf(QFilter qFilter) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_fallprice_setting", (String)"47150e89000000ac");
        if (calorgList != null) {
            qFilter.and("id", "in", (Object)calorgList);
        }
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    private void batchFillEntry() {
        BatchFillEntryHelper batchFillEntryHelper = new BatchFillEntryHelper();
        Set neeFiellNoCheckFields = FallPriceHelper.getDropdownList((String)((String)this.getModel().getValue(set_dimension)));
        neeFiellNoCheckFields.add(material);
        neeFiellNoCheckFields.add(material_group);
        neeFiellNoCheckFields.add(warehouse_group);
        neeFiellNoCheckFields.add(invage_from);
        neeFiellNoCheckFields.add(invage_to);
        neeFiellNoCheckFields.add(FALLPRICESCALE);
        neeFiellNoCheckFields.add(unit_realizable_amount);
        String way = (String)this.getModel().getValue(provision_way);
        boolean isMaterial = "A".equals(way) ? Boolean.TRUE : Boolean.FALSE;
        if (isMaterial) {
            neeFiellNoCheckFields.remove(LOT);
        }
        neeFiellNoCheckFields.remove(location);
        batchFillEntryHelper.setNeedFillFields((Collection)neeFiellNoCheckFields);
        batchFillEntryHelper.batchFill(this.getView(), entry);
    }
}

