/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.formula;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.formula.CalBcmFormualParser;
import kd.fi.cal.business.formula.StandGroupBaseDataConverter;

public class AbstractCalFormulaFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showFormula();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            this.callBackFormual();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    protected void filterBaseDataByStandGroupId(ListShowParameter showParameter, String baseKey, String detailEntity) {
        Object standard = this.getModel().getValue(baseKey + "standard");
        DynamicObjectCollection groupDycs = (DynamicObjectCollection)this.getModel().getValue(baseKey + "group");
        ArrayList<Long> groupIds = new ArrayList<Long>(16);
        if (standard != null || groupDycs.size() > 0) {
            if (standard != null) {
                standard = ((DynamicObject)standard).getPkValue();
            }
            for (DynamicObject groupdyc : groupDycs) {
                groupIds.add(groupdyc.getLong("fbasedataid_id"));
            }
            StandGroupBaseDataConverter baseDataParser = new StandGroupBaseDataConverter(detailEntity, baseKey);
            Set baseDataIds = baseDataParser.getBaseDataIdsByStandGroupId((Long)standard, groupIds);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)baseDataIds));
        }
    }

    protected IDataEntityProperty getPropByConfigField(DataEntityPropertyCollection properties, String field) {
        return (IDataEntityProperty)properties.get((Object)field);
    }

    protected void filterGroupIdsByStandId(ListShowParameter showParameter, String baseKey, String groupDetailEntity) {
        String standardKey = baseKey + "standard";
        Object standard = this.getModel().getValue(standardKey);
        if (standard != null) {
            standard = ((DynamicObject)standard).getPkValue();
            StandGroupBaseDataConverter baseDataConverter = new StandGroupBaseDataConverter(groupDetailEntity, baseKey);
            Set groupIds = baseDataConverter.getGroupIdsByStandId((Long)standard);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)groupIds));
        }
    }

    private String getFieldValueByType(IDataEntityProperty property) {
        String value = null;
        Object fieldValue = this.getModel().getValue(property.getName());
        if (fieldValue == null) {
            value = "";
        } else if (property instanceof DateTimeProp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            value = sdf.format(fieldValue);
        } else if (property instanceof BasedataProp) {
            DynamicObject baseDyc = (DynamicObject)fieldValue;
            if (baseDyc != null) {
                value = baseDyc.getString("number");
            }
        } else if (property instanceof MulBasedataProp) {
            DynamicObjectCollection dycs = (DynamicObjectCollection)fieldValue;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject item : dycs) {
                sb.append(item.getDynamicObject("fbasedataid").getString("number"));
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            value = sb.toString();
        } else {
            value = (String)fieldValue;
        }
        value = "\"" + value + "\"";
        return value;
    }

    private List<Object> getBaseDataIds(String paramValue, String baseEntityId) {
        return QueryServiceHelper.queryPrimaryKeys((String)baseEntityId, (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)paramValue.split(","))}, null, (int)-1);
    }

    private void callBackFormual() {
        String formulaNumber = (String)this.getView().getFormShowParameter().getCustomParam("accttype");
        CalBcmFormualParser calBcmFormualParser = new CalBcmFormualParser(formulaNumber);
        List paramNameWithoutEntryList = calBcmFormualParser.getParamNameWithoutEntryList();
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        ArrayList<String> valueList = new ArrayList<String>(16);
        for (String field : paramNameWithoutEntryList) {
            IDataEntityProperty property = this.getPropByConfigField(properties, field);
            String value = this.getFieldValueByType(property);
            valueList.add(value);
        }
        String format = "=%s(%s)";
        String result = String.format(format, formulaNumber, String.join((CharSequence)",", valueList));
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    private void showFormula() {
        String formulaNumber = (String)this.getView().getFormShowParameter().getCustomParam("accttype");
        if (formulaNumber == null) {
            return;
        }
        String formulaStr = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CalBcmFormualParser calBcmFormualHelper = new CalBcmFormualParser(formulaNumber);
        List paramNameWithoutEntryList = calBcmFormualHelper.getParamNameWithoutEntryList();
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        Map fieldValueMap = calBcmFormualHelper.explainWithoutEntryFormulaValue(formulaStr);
        if (formulaStr != null) {
            String[] paramValues = formulaStr.split("\",\"");
            int minLength = Math.min(paramValues.length, paramNameWithoutEntryList.size());
            for (int i = 0; i < minLength; ++i) {
                List<Object> ids;
                String baseEntityId;
                String fieldKey = (String)paramNameWithoutEntryList.get(i);
                IDataEntityProperty property = this.getPropByConfigField(properties, fieldKey);
                String formFieldKey = property.getName();
                String paramValue = (String)fieldValueMap.get(fieldKey);
                if (StringUtils.isEmpty((String)paramValue)) continue;
                if (property instanceof BasedataProp) {
                    baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    ids = this.getBaseDataIds(paramValue, baseEntityId);
                    if (ids.size() <= 0) continue;
                    this.getModel().setValue(formFieldKey, ids.get(0));
                    continue;
                }
                if (property instanceof MulBasedataProp) {
                    baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
                    ids = this.getBaseDataIds(paramValue, baseEntityId);
                    this.getModel().setValue(formFieldKey, (Object)ids.toArray());
                    continue;
                }
                this.getModel().setValue(formFieldKey, (Object)paramValue);
            }
        }
    }
}

