/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CalAccountAgeGroup;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.formplugin.home.CardHomePlugin;

public class CalAccountAgePlugin
extends CardHomePlugin {
    private static final String end_date = "enddate";
    private static final String account_materiel = "accountmateriel";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(end_date, (Object)new Date());
        this.drawChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (end_date.equals(key) || account_materiel.equals(key)) {
            this.drawChart();
        }
    }

    private void drawChart() {
        PointLineChart customchart = this.getPointLineChart();
        customchart.clearData();
        List<Object> analysisGroups = new ArrayList();
        if (this.judgeDrawChart()) {
            analysisGroups = this.getGroupData();
        }
        ArrayList<String> demensions = new ArrayList<String>(analysisGroups.size());
        ArrayList<Number> countList = new ArrayList<Number>(analysisGroups.size());
        ArrayList<Number> amountList = new ArrayList<Number>(analysisGroups.size());
        for (CalAccountAgeGroup calAccountAgeGroup : analysisGroups) {
            demensions.add(calAccountAgeGroup.getName());
            countList.add(calAccountAgeGroup.getCount());
            amountList.add(calAccountAgeGroup.getAmount());
        }
        Axis categoryAxis = this.createCategoryXaxis();
        categoryAxis.setCategorys(demensions);
        this.createValueYaxis();
        LineSeries lineSeries = this.createLineSeries(ResManager.loadKDString((String)"\u6570\u91cf(\u4e07)", (String)"CalAccountAgePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), countList, "#CC00CC");
        lineSeries.setYAxisIndex(0);
        this.createValueAxis();
        LineSeries amountSeries = this.createLineSeries(ResManager.loadKDString((String)"\u91d1\u989d\uff08\u4e07\uff09", (String)"CalAccountAgePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), amountList, "#39bdb9");
        amountSeries.setYAxisIndex(1);
        customchart.setMargin(Position.right, "40px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    protected LineSeries createLineSeries(String name, List<Number> values, String color) {
        LineSeries expireSeries = this.getPointLineChart().createSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
        return expireSeries;
    }

    protected Axis createValueAxis() {
        PointLineChart chart = this.getPointLineChart();
        Axis axis = null;
        axis = chart.createYAxis(ResManager.loadKDString((String)"\u4e07", (String)"CalAccountAgePlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> splitLine = new HashMap<String, HashMap<String, String>>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        chart.setShowTooltip(Boolean.TRUE.booleanValue());
        return axis;
    }

    protected Axis createValueYaxis() {
        PointLineChart chart = this.getPointLineChart();
        Axis axis = null;
        axis = chart.createYAxis(ResManager.loadKDString((String)"\u7b14", (String)"CalAccountAgePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> splitLine = new HashMap<String, HashMap<String, String>>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        chart.setShowTooltip(Boolean.TRUE.booleanValue());
        return axis;
    }

    protected Axis createCategoryXaxis() {
        PointLineChart chart = this.getPointLineChart();
        Axis axis = null;
        axis = chart.createXAxis(null, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    protected void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    protected PointLineChart getPointLineChart() {
        return (PointLineChart)this.getControl("pointlinechartap");
    }

    protected List<CalAccountAgeGroup> getGroupData() {
        Date enddate = this.getEndDate();
        List analysisGroups = CalAccountAgeGroup.getDefaultGroups((Date)enddate);
        DynamicObject cuccency = this.getCuccencyBycostAccount();
        int amtprecision = cuccency.getInt("amtprecision");
        DataSet costRecorddDs = this.getCostRecordDs();
        if (costRecorddDs == null) {
            return analysisGroups;
        }
        for (Object row : costRecorddDs) {
            CalAccountAgeGroup group = CalAccountAgeGroup.matchGroup((List)analysisGroups, (Date)row.getDate("bizdate"));
            BigDecimal unSettleAmount = row.getBigDecimal("entry.actualcost").abs();
            group.addAmount(unSettleAmount);
            BigDecimal baseqty = row.getBigDecimal("entry.baseqty");
            group.addCount(baseqty.abs());
        }
        DataSet adjustDs = this.getAdjustDs();
        for (Row row : adjustDs) {
            CalAccountAgeGroup group = CalAccountAgeGroup.matchGroup((List)analysisGroups, (Date)row.getDate("bizdate"));
            BigDecimal unSettleAmount = row.getBigDecimal("entryentity.adjustamt");
            group.addAmount(unSettleAmount);
        }
        BigDecimal accountQty = this.getAccountQty();
        BigDecimal accountAmount = this.getAccountAmount();
        this.dealAccountGroupQty(analysisGroups, accountQty, amtprecision);
        this.dealAccountGroupAmount(analysisGroups, accountAmount, amtprecision);
        return analysisGroups;
    }

    private void dealAccountGroupAmount(List<CalAccountAgeGroup> analysisGroups, BigDecimal accountAmount, int amtprecision) {
        BigDecimal preAmount = BigDecimal.ZERO;
        BigDecimal tenThousand = new BigDecimal(10000);
        BigDecimal tempAmout = BigDecimal.ZERO;
        for (CalAccountAgeGroup calAccountAgeGroup : analysisGroups) {
            tempAmout = preAmount;
            if (accountAmount.subtract(preAmount = preAmount.add(calAccountAgeGroup.getAmount())).compareTo(BigDecimal.ZERO) >= 0) {
                calAccountAgeGroup.setAmount(calAccountAgeGroup.getAmount().divide(tenThousand, amtprecision + 4, RoundingMode.HALF_UP));
                continue;
            }
            if (accountAmount.subtract(tempAmout).compareTo(BigDecimal.ZERO) <= 0) {
                calAccountAgeGroup.setAmount(new BigDecimal(0));
                continue;
            }
            calAccountAgeGroup.setAmount(accountAmount.subtract(tempAmout).divide(tenThousand, amtprecision + 4, RoundingMode.HALF_UP));
        }
    }

    private BigDecimal getAccountAmount() {
        Date periodEndDate = this.getPeriodEndDate();
        DynamicObject costAccount = this.getCostAccount();
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObject period = PeriodHelper.getPeriodByDate((Date)periodEndDate, (Long)costAccount.getLong("id"));
        amount = this.getAccountBalanceAmount(period, amount);
        amount = this.getAccountCostRecordAmount(period, amount);
        amount = this.getAccountAdjustAmount(period, amount);
        return amount;
    }

    private BigDecimal getAccountBalanceAmount(DynamicObject period, BigDecimal amount) {
        DynamicObject metriel = this.getMatriel();
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        int periodNumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
        QFilter periodQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue()).and("period", "<", (Object)periodNumber).and("endperiod", ">=", (Object)periodNumber);
        if (metriel != null) {
            periodQf.and("material", "=", metriel.getPkValue());
        }
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountBalanceAmount()"), (String)"cal_balance", (String)"calorg,periodendactualcost", (QFilter[])periodQf.toArray(), (String)"");
        periodDataSet = periodDataSet.groupBy(new String[]{"calorg"}).sum("periodendactualcost").finish();
        for (Row row : periodDataSet) {
            amount = amount.add(row.getBigDecimal("periodendactualcost"));
        }
        return amount;
    }

    private BigDecimal getAccountCostRecordAmount(DynamicObject period, BigDecimal amount) {
        Date endDate = this.getEndDate();
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        QFilter costRecordQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue());
        DynamicObject metriel = this.getMatriel();
        if (metriel != null) {
            costRecordQf.and("entry.material", "=", metriel.getPkValue());
        }
        costRecordQf.and("bizdate", ">=", (Object)period.getDate("beginDate")).and("bizdate", "<=", (Object)endDate).and("billstatus", "=", (Object)"C").and("issplitcreate", "=", (Object)Boolean.FALSE);
        QFilter inBillQf = new QFilter("calbilltype", "=", (Object)"IN").and(costRecordQf);
        QFilter billStatusf = new QFilter("entry.entrystatus", "=", (Object)"C");
        inBillQf.and(billStatusf);
        DataSet costRecordInDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountCostRecordAmount()"), (String)"cal_costrecord", (String)"calorg,entry.actualcost as actualcost", (QFilter[])inBillQf.toArray(), null);
        costRecordInDs = costRecordInDs.groupBy(new String[]{"calorg"}).sum("actualcost").finish();
        for (Row row : costRecordInDs) {
            amount = amount.add(row.getBigDecimal("actualcost"));
        }
        QFilter outBillQf = new QFilter("calbilltype", "=", (Object)"OUT").and(costRecordQf);
        outBillQf.and(billStatusf);
        DataSet costRecordOutDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountCostRecordAmount()"), (String)"cal_costrecord", (String)"calorg,entry.id,entry.actualcost as actualcost", (QFilter[])outBillQf.toArray(), null);
        costRecordOutDs = costRecordOutDs.groupBy(new String[]{"calorg"}).sum("actualcost").finish();
        for (Row row : costRecordOutDs) {
            amount = amount.subtract(row.getBigDecimal("actualcost"));
        }
        return amount;
    }

    private BigDecimal getAccountAdjustAmount(DynamicObject period, BigDecimal amount) {
        long calOrgId = this.getCalorg();
        Date enDate = this.getEndDate();
        DynamicObject costAccount = this.getCostAccount();
        QFilter adjustQf = new QFilter("calorg", "=", (Object)calOrgId);
        adjustQf.and("costaccount", "=", costAccount.getPkValue());
        adjustQf.and("bizdate", ">=", (Object)period.getDate("beginDate"));
        adjustQf.and("bizdate", "<=", (Object)enDate);
        adjustQf.and("difftype", "not in", (Object)new String[]{CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue(), CostAdjustBillDiffTypeEnum.INVOICE_DIFF.getValue(), CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue(), CostAdjustBillDiffTypeEnum.OTHER_DIFF.getValue()});
        adjustQf.and("billstatus", "=", (Object)"C");
        DynamicObject materiel = this.getMatriel();
        if (materiel != null) {
            adjustQf.and("entryentity.material", "=", materiel.getPkValue());
        }
        QFilter inAdjustQf = new QFilter("biztype", "=", (Object)"A").and(adjustQf);
        DataSet inAdjustDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountAdjustAmount()"), (String)"cal_costadjustbill", (String)"calorg,entryentity.adjustamt as adjustamt", (QFilter[])inAdjustQf.toArray(), null);
        inAdjustDs = inAdjustDs.groupBy(new String[]{"calorg"}).sum("adjustamt").finish();
        for (Row row : inAdjustDs) {
            amount = amount.add(row.getBigDecimal("adjustamt"));
        }
        QFilter outAdjustQf = new QFilter("biztype", "=", (Object)"B").and(adjustQf);
        DataSet outAdjustDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountAdjustAmount()"), (String)"cal_costadjustbill", (String)"calorg,entryentity.adjustamt as adjustamt", (QFilter[])outAdjustQf.toArray(), null);
        outAdjustDs = outAdjustDs.groupBy(new String[]{"calorg"}).sum("adjustamt").finish();
        for (Row row : outAdjustDs) {
            amount = amount.subtract(row.getBigDecimal("adjustamt"));
        }
        return amount;
    }

    private void dealAccountGroupQty(List<CalAccountAgeGroup> analysisGroups, BigDecimal accountQty, Integer amtprecision) {
        BigDecimal preAmount = BigDecimal.ZERO;
        BigDecimal tenThousand = new BigDecimal(10000);
        BigDecimal tempAmout = BigDecimal.ZERO;
        for (int i = 0; i < analysisGroups.size(); ++i) {
            CalAccountAgeGroup calAccountAgeGroup = analysisGroups.get(i);
            tempAmout = preAmount;
            if (accountQty.subtract(preAmount = preAmount.add(calAccountAgeGroup.getCount())).compareTo(BigDecimal.ZERO) >= 0) {
                calAccountAgeGroup.setCount(calAccountAgeGroup.getCount().divide(tenThousand, amtprecision + 4, RoundingMode.HALF_UP));
                continue;
            }
            if (accountQty.subtract(tempAmout).compareTo(BigDecimal.ZERO) <= 0) {
                calAccountAgeGroup.setCount(new BigDecimal(0));
                continue;
            }
            calAccountAgeGroup.setCount(accountQty.subtract(tempAmout).divide(tenThousand, amtprecision + 4, RoundingMode.HALF_UP));
        }
    }

    private BigDecimal getAccountQty() {
        Date endDate = this.getEndDate();
        Date periodEndDate = this.getPeriodEndDate();
        DynamicObject metriel = this.getMatriel();
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        BigDecimal qty = BigDecimal.ZERO;
        DynamicObject period = PeriodHelper.getPeriodByDate((Date)periodEndDate, (Long)costAccount.getLong("id"));
        int periodNumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
        QFilter periodQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue()).and("period", "<", (Object)periodNumber).and("endperiod", ">=", (Object)periodNumber);
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountQty()"), (String)"cal_balance", (String)"calorg,periodendqty", (QFilter[])periodQf.toArray(), (String)"");
        periodDataSet = periodDataSet.groupBy(new String[]{"calorg"}).sum("periodendqty").finish();
        for (Row row : periodDataSet) {
            qty = qty.add(row.getBigDecimal("periodendqty"));
        }
        QFilter costRecordQf = new QFilter("calorg", "=", (Object)calOrgId).and("billstatus", "=", (Object)"C");
        costRecordQf.and("costaccount", "=", costAccount.getPkValue()).and("issplitcreate", "=", (Object)Boolean.FALSE);
        costRecordQf.and("bizdate", ">=", (Object)period.getDate("beginDate")).and("bizdate", "<=", (Object)endDate);
        if (metriel != null) {
            costRecordQf.and("entry.material", "=", metriel.getPkValue());
        }
        QFilter inBillQf = new QFilter("calbilltype", "=", (Object)"IN").and(costRecordQf);
        DataSet costRecordInDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountQty()"), (String)"cal_costrecord", (String)"calorg,entry.baseqty as baseqty", (QFilter[])inBillQf.toArray(), null);
        for (Row row : costRecordInDs) {
            qty = qty.add(row.getBigDecimal("baseqty"));
        }
        QFilter outBillQf = new QFilter("calbilltype", "=", (Object)"OUT").and(costRecordQf);
        DataSet costRecordOutDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAccountQty()"), (String)"cal_costrecord", (String)"calorg,entry.id,entry.baseqty as baseqty", (QFilter[])outBillQf.toArray(), null);
        for (Row row : costRecordOutDs) {
            qty = qty.subtract(row.getBigDecimal("baseqty"));
        }
        return qty;
    }

    private DataSet getAdjustDs() {
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        Date enddate = this.getEndDate();
        QFilter adjustQf = new QFilter("calorg", "=", (Object)calOrgId);
        adjustQf.and("costaccount", "=", costAccount.getPkValue());
        adjustQf.and("bizdate", "<=", (Object)enddate);
        adjustQf.and("biztype", "=", (Object)"A");
        adjustQf.and("billstatus", "=", (Object)"C");
        DynamicObject materiel = this.getMatriel();
        if (materiel != null) {
            adjustQf.and("entryentity.material", "=", materiel.getPkValue());
        }
        DataSet adjustDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getAdjustDs()"), (String)"cal_costadjustbill", (String)"bizdate,entryentity.adjustamt", (QFilter[])adjustQf.toArray(), null);
        return adjustDs;
    }

    private DataSet getCostRecordDs() {
        long calOrgId = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        Date enddate = this.getEndDate();
        QFilter costRecordQf = new QFilter("calorg", "=", (Object)calOrgId).and("costaccount", "=", costAccount.getPkValue()).and("billstatus", "=", (Object)"C");
        costRecordQf.and("bizdate", "<=", (Object)enddate).and("issplitcreate", "=", (Object)Boolean.FALSE);
        QFilter inBillQf = new QFilter("calbilltype", "=", (Object)"IN").and("entry.baseqty", ">", (Object)BigDecimal.ZERO);
        QFilter outBillQf = new QFilter("calbilltype", "=", (Object)"OUT").and("entry.baseqty", "<", (Object)BigDecimal.ZERO);
        costRecordQf.and(inBillQf.or(outBillQf));
        DynamicObject materiel = this.getMatriel();
        if (materiel == null) {
            return null;
        }
        costRecordQf.and("entry.material", "=", materiel.getPkValue());
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getDataSet()"), (String)"cal_costrecord", (String)"bizdate,entry.baseqty,entry.actualcost", (QFilter[])costRecordQf.toArray(), null);
        return costRecordDs;
    }

    private DynamicObject getMatriel() {
        long costAccountId;
        DynamicObject materiel = this.getModel().getDataEntity().getDynamicObject(account_materiel);
        DynamicObject costAccount = this.getCostAccount();
        long l = costAccountId = costAccount == null ? 0L : costAccount.getLong("id");
        if (materiel == null) {
            Date periodEndDate = this.getPeriodEndDate();
            DynamicObject period = PeriodHelper.getPeriodByDate((Date)periodEndDate, (Long)costAccountId);
            int periodNumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
            QFilter calBalanceFilter = new QFilter("calorg", "=", (Object)this.getCalorg());
            calBalanceFilter.and("costaccount", "=", (Object)costAccountId).and("period", "<=", (Object)periodNumber);
            calBalanceFilter.and("periodendqty", ">", (Object)0);
            DynamicObjectCollection calBalances = QueryServiceHelper.query((String)"cal_balance", (String)"id,material.id", (QFilter[])calBalanceFilter.toArray(), (String)"periodendqty desc", (int)1);
            if (calBalances != null && !calBalances.isEmpty()) {
                materiel = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)calBalances.get(0)).get("material.id"), (String)"bd_material");
            }
            this.getModel().setValue(account_materiel, (Object)materiel);
        }
        return this.getModel().getDataEntity().getDynamicObject(account_materiel);
    }

    private Date getEndDate() {
        Date endDate = (Date)this.getModel().getValue(end_date);
        if (endDate == null) {
            endDate = new Date();
        }
        return DateUtils.getDayEndTime((Date)endDate);
    }

    private Date getPeriodEndDate() {
        Date endDate = (Date)this.getModel().getValue(end_date);
        if (endDate == null) {
            endDate = new Date();
        }
        return endDate;
    }

    private boolean judgeDrawChart() {
        long calOrg = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        if (calOrg == 0L || costAccount == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

