/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CalCostOrder;
import kd.fi.cal.formplugin.home.CardHomePlugin;

public class CalCostOrderPlugin
extends CardHomePlugin
implements BeforeF7SelectListener {
    private static final String compare_period = "compareperiod";
    private static final String target_period = "targetperiod";
    private static final String histogram_chartap = "histogramchartap";
    private static final String period_end_actualcost = "periodendactualcost";
    private static final String period_end_qty = "periodendqty";
    private static final String period_in_actualcost = "periodinactualcost";
    private static final String period_in_qty = "periodinqty";

    public void afterCreateNewData(EventObject e) {
        this.initPeriod();
        this.drawChart();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, compare_period, target_period);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        if (compare_period.equals(sourceID) || target_period.equals(sourceID)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            long calOrg = this.getCalorg();
            DynamicObject costAccount = this.getCostAccount();
            if (costAccount != null) {
                QFilter qFilter = new QFilter("org", "=", (Object)calOrg).and("entry.costaccount", "=", costAccount.getPkValue()).and("entry.isenabled", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection periodDynamic = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.startperiod,entry.currentperiod", (QFilter[])qFilter.toArray());
                long startPeriodId = 0L;
                for (DynamicObject entity : periodDynamic) {
                    startPeriodId = entity.getLong("entry.startperiod");
                }
                if (startPeriodId == 0L) {
                    String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u81f3\u201c\u521d\u59cb\u5316>\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u201d\u754c\u9762\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalCostOrderPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccount.getString("number"));
                    throw new KDBizException(content);
                }
                QFilter nextPeriodQf = PeriodHelper.getNextPeriodQf((Object)startPeriodId);
                showParameter.getListFilterParameter().setFilter(nextPeriodQf);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("1", "!=", (Object)"1"));
            }
        }
    }

    private void initPeriod() {
        long calOrg = this.getCalorg();
        DynamicObject costAccount = this.getCostAccount();
        if (calOrg == 0L || costAccount == null) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)calOrg).and("entry.costaccount", "=", costAccount.getPkValue()).and("entry.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection periodDynamic = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.startperiod,entry.currentperiod", (QFilter[])qFilter.toArray());
        for (DynamicObject entity : periodDynamic) {
            long startPeriod = entity.getLong("entry.startperiod");
            long currentPeriod = entity.getLong("entry.currentperiod");
            if (currentPeriod != startPeriod) {
                DynamicObject preViousPeriod = PeriodHelper.getPreviousPeriod((Object)currentPeriod);
                startPeriod = preViousPeriod.getLong("id");
            }
            this.getModel().setValue(compare_period, (Object)startPeriod);
            this.getModel().setValue(target_period, (Object)currentPeriod);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        DynamicObject compareDynamic = (DynamicObject)this.getModel().getValue(compare_period);
        DynamicObject targetDynamic = (DynamicObject)this.getModel().getValue(target_period);
        if (compare_period.equals(key)) {
            if (this.judgePeriod(compareDynamic, targetDynamic).booleanValue()) {
                this.getModel().setValue(compare_period, (Object)targetDynamic);
            }
            this.drawChart();
        }
        if (target_period.equals(key)) {
            if (this.judgePeriod(compareDynamic, targetDynamic).booleanValue()) {
                this.getModel().setValue(target_period, (Object)compareDynamic);
            }
            this.drawChart();
        }
    }

    private Boolean judgePeriod(DynamicObject compareDynamic, DynamicObject targetDynamic) {
        return compareDynamic != null && targetDynamic != null && PeriodHelper.compare2period((DynamicObject)compareDynamic, (DynamicObject)targetDynamic) == 1;
    }

    private Boolean judgeReview() {
        DynamicObject currentPeriod;
        DynamicObject comparePeriod = (DynamicObject)this.getModel().getValue(compare_period);
        DynamicObject targetPeriod = (DynamicObject)this.getModel().getValue(target_period);
        if (comparePeriod == null || targetPeriod == null) {
            return Boolean.FALSE;
        }
        long targetPeriodId = targetPeriod.getLong("id");
        if (comparePeriod.getLong("id") == targetPeriodId && (currentPeriod = PeriodHelper.getCurrentPeriod((Long)this.getCostAccount().getLong("id"))).getLong("id") != targetPeriodId) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void drawChart() {
        HistogramChart customchart = (HistogramChart)this.getControl(histogram_chartap);
        customchart.clearData();
        List<Object> calCostOrderList = new ArrayList();
        if (this.judgeReview().booleanValue()) {
            calCostOrderList = this.getPeriodData();
        }
        ArrayList<String> xAxisData = new ArrayList<String>();
        ArrayList<Number> yAxisData = new ArrayList<Number>();
        int size = calCostOrderList.size();
        for (int i = 0; i < size && i < 10; ++i) {
            CalCostOrder entity = (CalCostOrder)calCostOrderList.get(i);
            xAxisData.add(entity.getMetrialName());
            yAxisData.add(entity.getCostPercent());
        }
        Axis categoryAxis = this.createXAxis();
        categoryAxis.setCategorys(xAxisData);
        this.createYAxis();
        this.createBarSeries(yAxisData, "#FF0000");
        customchart.setMargin(Position.right, "50px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private List<CalCostOrder> getPeriodData() {
        IDataModel model = this.getModel();
        DynamicObject comparePeriod = (DynamicObject)model.getValue(compare_period);
        DynamicObject targetPeriod = (DynamicObject)model.getValue(target_period);
        DynamicObject currency = this.getCuccencyBycostAccount();
        int priceprecision = currency.getInt("priceprecision");
        int amtprecision = currency.getInt("amtprecision");
        Map<Long, BigDecimal> targetPeriodMap = this.getTargetPeriodMap(targetPeriod, amtprecision);
        DataSet comparePeriodDataSet = this.queryCpPeriodDataSet(comparePeriod, targetPeriod);
        ArrayList<CalCostOrder> calCostOrderList = new ArrayList<CalCostOrder>();
        CalCostOrder calCostOrder = null;
        BigDecimal compareActualAmt = BigDecimal.ZERO;
        BigDecimal targetActualAmt = BigDecimal.ZERO;
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumAty = BigDecimal.ZERO;
        for (Row row : comparePeriodDataSet) {
            long materialId = row.getLong("materialid");
            targetActualAmt = targetPeriodMap.get(materialId);
            sumAmt = row.getBigDecimal("sumamt");
            sumAty = row.getBigDecimal("sumaty");
            if (targetActualAmt == null || sumAty == null || sumAty.compareTo(BigDecimal.ZERO) == 0) continue;
            String materialName = (String)row.get("materialname");
            String materialNumber = (String)row.get("materialnumber");
            compareActualAmt = sumAmt.divide(sumAty, priceprecision, 4);
            if (compareActualAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            calCostOrder = new CalCostOrder(materialId, materialName + "(" + materialNumber + ")", compareActualAmt, targetActualAmt, Integer.valueOf(amtprecision));
            calCostOrderList.add(calCostOrder);
        }
        if (calCostOrderList.size() != 0) {
            Collections.sort(calCostOrderList, new Comparator<CalCostOrder>(){

                @Override
                public int compare(CalCostOrder o1, CalCostOrder o2) {
                    return o2.getCostPercentAbs().compareTo(o1.getCostPercentAbs());
                }
            });
        }
        return calCostOrderList;
    }

    private DataSet queryCpPeriodDataSet(DynamicObject comparePeriod, DynamicObject targetPeriod) {
        long targetPeriodId;
        DynamicObject costAccount = this.getCostAccount();
        long calOrg = this.getCalorg();
        int periodNumber = comparePeriod.getInt("periodyear") * 100 + comparePeriod.getInt("periodnumber");
        QFilter periodQf = new QFilter("calorg", "=", (Object)calOrg).and("costaccount", "=", costAccount.getPkValue()).and("period", "<", (Object)periodNumber).and("endperiod", ">=", (Object)periodNumber);
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "queryPeriodDataSet"), (String)"cal_balance", (String)"periodendactualcost,periodendqty,0 as periodinactualcost,0 as periodinqty,material.id as materialid,material.number as materialnumber,material.name as materialname", (QFilter[])periodQf.toArray(), (String)"");
        periodDataSet = periodDataSet.groupBy(new String[]{"materialid", "materialnumber", "materialname"}).sum(period_in_actualcost).sum(period_in_qty).sum(period_end_actualcost).sum(period_end_qty).finish();
        long comparePeriodId = comparePeriod.getLong("id");
        if (comparePeriodId == (targetPeriodId = targetPeriod.getLong("id"))) {
            periodDataSet = periodDataSet.select(new String[]{"materialid", "materialnumber", "materialname", "periodendactualcost as sumamt", "periodendqty as sumaty"});
        } else {
            QFilter actuaQf = new QFilter("calorg", "=", (Object)calOrg).and("costaccount", "=", costAccount.getPkValue()).and("periodid", "=", comparePeriod.getPkValue());
            DataSet actuaQfSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "queryPeriodDataSet_actuaQf"), (String)"cal_balance", (String)"0 as periodendactualcost,0 as periodendqty,periodinactualcost,periodinqty,material.id as materialid,material.number as materialnumber,material.name as materialname", (QFilter[])actuaQf.toArray(), (String)"");
            actuaQfSet = actuaQfSet.groupBy(new String[]{"materialid", "materialnumber", "materialname"}).sum(period_in_actualcost).sum(period_in_qty).sum(period_end_actualcost).sum(period_end_qty).finish();
            periodDataSet = periodDataSet.union(actuaQfSet).groupBy(new String[]{"materialid", "materialnumber", "materialname"}).sum(period_in_actualcost).sum(period_in_qty).sum(period_end_actualcost).sum(period_end_qty).finish();
            periodDataSet = periodDataSet.select(new String[]{"materialid", "materialnumber", "materialname", "periodendactualcost + periodinactualcost as sumamt", "periodendqty + periodinqty as sumaty"});
        }
        return periodDataSet;
    }

    private Map<Long, BigDecimal> getTargetPeriodMap(DynamicObject targetPeriod, Integer amtprecision) {
        HashMap<Long, BigDecimal> tsrgetPeriodMap = new HashMap<Long, BigDecimal>();
        DataSet agoPeriodDataSet = this.queryAgoPeriodDataSet(targetPeriod);
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        for (Row row : agoPeriodDataSet) {
            amt = row.getBigDecimal("sumamt");
            qty = row.getBigDecimal("sumaty");
            if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) continue;
            tsrgetPeriodMap.put(row.getLong("materialid"), amt.divide(qty, (int)amtprecision, 4));
        }
        return tsrgetPeriodMap;
    }

    private DataSet queryAgoPeriodDataSet(DynamicObject period) {
        DynamicObject costAccount = this.getCostAccount();
        long calOrg = this.getCalorg();
        int periodNumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
        QFilter periodQf = new QFilter("calorg", "=", (Object)calOrg).and("costaccount", "=", costAccount.getPkValue()).and("period", "<", (Object)periodNumber).and("endperiod", ">=", (Object)periodNumber);
        DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "queryPeriodDataSet"), (String)"cal_balance", (String)"periodendactualcost,periodendqty,0 as periodinactualcost,0 as periodinqty,material.id as materialid,material.name as materialname", (QFilter[])periodQf.toArray(), (String)"");
        QFilter actuaQf = new QFilter("calorg", "=", (Object)calOrg).and("costaccount", "=", costAccount.getPkValue()).and("periodid", "=", period.getPkValue());
        DataSet actuaQfSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "queryPeriodDataSet_actuaQf"), (String)"cal_balance", (String)"0 as  periodendactualcost,0 as periodendqty,periodinactualcost,periodinqty,material.id as materialid,material.name as materialname", (QFilter[])actuaQf.toArray(), (String)"");
        periodDataSet = periodDataSet.union(actuaQfSet).groupBy(new String[]{"materialid", "materialname"}).sum(period_in_actualcost).sum(period_in_qty).sum(period_end_actualcost).sum(period_end_qty).finish();
        periodDataSet = periodDataSet.select(new String[]{"materialid", "materialname", "periodendactualcost + periodinactualcost as sumamt", "periodendqty + periodinqty as sumaty"});
        return periodDataSet;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl(histogram_chartap);
    }

    private Axis createXAxis() {
        Axis axis = null;
        axis = this.getMainChart().createXAxis(ResManager.loadKDString((String)"\u7269\u6599", (String)"CalCostOrderPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createYAxis() {
        Axis axis = null;
        axis = this.getMainChart().createYAxis(ResManager.loadKDString((String)"\u6ce2\u52a8\u7387", (String)"CalCostOrderPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(Boolean.TRUE.booleanValue());
        return axis;
    }

    private void createBarSeries(List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(ResManager.loadKDString((String)"\u6ce2\u52a8\u7387", (String)"CalCostOrderPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        barSeries.setBarWidth("8px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

