/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.formplugin.home.CardHomePlugin;

public class HandleExpBillPlugin
extends CardHomePlugin {
    private String TEMPORARYBILLCNT = "temporarybillcnt";
    private String TOBEPROCESSEDCNT = "tobeprocessedcnt";
    private String AUDITEDBILLSCNT = "auditedbillscnt";

    public void afterCreateNewData(EventObject e) {
        DynamicObject costAccount = this.getCostAccount();
        if (costAccount != null) {
            this.initValue(costAccount, this.TEMPORARYBILLCNT, "A");
            this.initValue(costAccount, this.TOBEPROCESSEDCNT, "B");
            this.initValue(costAccount, this.AUDITEDBILLSCNT, "C");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.TOBEPROCESSEDCNT, this.TEMPORARYBILLCNT, this.AUDITEDBILLSCNT});
    }

    private void initValue(DynamicObject costAccount, String anyCnt, String billStatus) {
        int count = 0;
        QFilter filters = new QFilter(this.COSTACCOUNT, "=", costAccount.getPkValue());
        filters.and(new QFilter(this.CALORG, "=", (Object)this.getCalorg()));
        filters.and(new QFilter("billstatus", "=", (Object)billStatus));
        filters.and("difftype", "=", (Object)CostAdjustBillDiffTypeEnum.ACT_COST.getValue());
        DynamicObjectCollection costAdjustBills = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)"id", (QFilter[])filters.toArray());
        count = costAdjustBills.size();
        Label label = (Label)this.getView().getControl(anyCnt);
        label.setText(String.valueOf(count));
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (this.getCostAccount() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"HandleExpBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (this.TEMPORARYBILLCNT.equals(key)) {
            this.showVoucherFormWithFilter("A");
        } else if (this.TOBEPROCESSEDCNT.equals(key)) {
            this.showVoucherFormWithFilter("B");
        } else if (this.AUDITEDBILLSCNT.equals(key)) {
            this.showVoucherFormWithFilter("C");
        }
    }

    private void showVoucherFormWithFilter(String billStatus) {
        DynamicObject costAccountObj = this.getCostAccount();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("cal_costadjust_subentity");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filters = new QFilter(this.COSTACCOUNT, "=", costAccountObj.getPkValue());
        filters.and(new QFilter(this.CALORG, "=", (Object)this.getCalorg()));
        filters.and(new QFilter("billstatus", "=", (Object)billStatus));
        para.setCustomParam("source", (Object)"CalHandleExpBillPlugin");
        para.setCustomParam("costaccount", costAccountObj.getPkValue());
        para.setCustomParam("billstatus", (Object)billStatus);
        para.setCustomParam("calorg", (Object)this.getCalorg());
        para.setCustomParam("filter", (Object)filters.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }
}

