/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.home;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.util.JsonUtils;

public class HomePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener,
ICloseCallBack {
    private String CALORG = "calorg";
    private String CALMAINORG = "calmainorg";
    private String COSTACCOUNT = "costaccount";
    private String[][] systemNodeInfos = new String[][]{{"bd_accountingsys", ResManager.loadKDString((String)"\u6838\u7b97\u4f53\u7cfb", (String)"HomePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"bd_accountbookstype", ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b", (String)"HomePlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"gl_accountbook", ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f", (String)"HomePlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"bd_accountingsys_base", ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e", (String)"HomePlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"bd_bdctrstratege_formcard", ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565", (String)"HomePlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0])}};
    private String[][] settingNodeInfos = new String[][]{{"cal_setting", ResManager.loadKDString((String)"\u516c\u5171\u914d\u7f6e", (String)"HomePlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_calbillrule", ResManager.loadKDString((String)"\u6838\u7b97\u5355\u6620\u5c04\u914d\u7f6e", (String)"HomePlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_billgroupsetting", ResManager.loadKDString((String)"\u5355\u636e\u6210\u7ec4\u5173\u7cfb\u914d\u7f6e", (String)"HomePlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_dividebasis", ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u5212\u5206\u4f9d\u636e", (String)"HomePlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_caldimension", ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"HomePlugin_9", (String)"fi-cal-formplugin", (Object[])new Object[0])}};
    private String[][] baseNodeInfos = new String[][]{{"cal_bd_calpolicy", ResManager.loadKDString((String)"\u6838\u7b97\u653f\u7b56", (String)"HomePlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_costaccount", ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"HomePlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_calrange", ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4", (String)"HomePlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_accounttype", ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u4ef7\u65b9\u6cd5\u8bbe\u7f6e", (String)"HomePlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_materialdimension", ResManager.loadKDString((String)"\u7269\u6599\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e", (String)"HomePlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_queuesetting", ResManager.loadKDString((String)"\u51fa\u5165\u5e93\u5e8f\u5217\u5b9a\u4e49", (String)"HomePlugin_15", (String)"fi-cal-formplugin", (Object[])new Object[0])}};
    private String[][] modelNodeInfos = new String[][]{{"ai_vchtemplate_configs", ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f", (String)"HomePlugin_16", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"bos_coderule", ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"HomePlugin_17", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"bos_importtemplate", ResManager.loadKDString((String)"\u5f15\u5165\u6a21\u677f", (String)"HomePlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0])}};
    private String[][] beginNodeInfos = new String[][]{{"cal_sysctrlentity", ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e", (String)"HomePlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_balance", ResManager.loadKDString((String)"\u4f59\u989d\u521d\u59cb\u5316", (String)"HomePlugin_19", (String)"fi-cal-formplugin", (Object[])new Object[0])}};
    private String[][] biLunodeInfos = new String[][]{{"cal_bd_calpolicy", ResManager.loadKDString((String)"\u6838\u7b97\u653f\u7b56", (String)"HomePlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_costaccount", ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"HomePlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_bd_calrange", ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4", (String)"HomePlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0])}, {"cal_sysctrlentity", ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e", (String)"HomePlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0])}};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long currentOrgId = RequestContext.get().getOrgId();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)currentOrgId, (String)"cal_apphome");
        if (calOrgId == null || calOrgId == 0L) {
            this.getModel().setValue(this.CALORG, null);
            this.getModel().setValue(this.CALMAINORG, null);
            this.setSelfVisible(false, "initguidepanel");
            return;
        }
        this.initCalorgAndCostAccount(calOrgId);
        this.initGuide(calOrgId);
    }

    private void initGuide(Long calOrgId) {
        boolean inited = this.isInited(calOrgId);
        if (!inited) {
            this.setSelfVisible(true, "initguidepanel");
        } else {
            this.setSelfVisible(false, "initguidepanel");
        }
        this.initGuidePanel();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "endtool"});
        this.addF7Listener(this, this.COSTACCOUNT, this.CALORG);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        String key = e.getTabKey();
        if (key.equals("appmiantab") || key.equals("tabpageap")) {
            this.refreshPage();
        }
    }

    public void initialize() {
        super.initialize();
        Tab apptabs = (Tab)this.getView().getControl("_submaintab_");
        apptabs.addTabSelectListener((TabSelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("begininit".equals(key)) {
            this.setSelfVisible(false, "step1");
            this.setSelfVisible(true, "step2");
            this.initStatusCache();
            int itemCount = this.systemNodeInfos.length + this.baseNodeInfos.length + this.settingNodeInfos.length + this.modelNodeInfos.length + this.beginNodeInfos.length;
            this.putItemCount(itemCount);
            this.setCustomCtrlProp("itemcount", itemCount);
            this.refreshStep2Page();
        } else if ("endinit".equals(key)) {
            String msg = Stream.of(this.biLunodeInfos).filter(v -> !this.getConfirmed(v[0])).map(v -> v[1]).collect(Collectors.joining("\u3001"));
            if (msg != null && msg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5fc5\u5f55\u9879\u76ee\u5c1a\u672a\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"HomePlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
            } else {
                this.endInit();
            }
        }
    }

    private void initStatusCache() {
        HashMap<String, Boolean> status = new HashMap<String, Boolean>(36);
        for (String[] node : this.systemNodeInfos) {
            status.put(node[0], Boolean.FALSE);
        }
        for (String[] node : this.baseNodeInfos) {
            status.put(node[0], Boolean.FALSE);
        }
        for (String[] node : this.settingNodeInfos) {
            status.put(node[0], Boolean.FALSE);
        }
        for (String[] node : this.modelNodeInfos) {
            status.put(node[0], Boolean.FALSE);
        }
        for (String[] node : this.beginNodeInfos) {
            status.put(node[0], Boolean.FALSE);
        }
        this.saveStatus(status);
    }

    private void saveStatus(Map<String, Boolean> status) {
        long orgId = this.getOrgId();
        IAppCache iAppCache = AppCache.get((String)"cal");
        iAppCache.put(orgId + ".initguide.status", status);
    }

    private void putStatus(String key, boolean value) {
        Map<String, Boolean> cache = this.getStatus();
        cache.put(key, value);
        long orgId = this.getOrgId();
        IAppCache iAppCache = AppCache.get((String)"cal");
        iAppCache.put(orgId + ".initguide.status", cache);
    }

    private void putItemCount(Integer value) {
        long orgId = this.getOrgId();
        IAppCache iAppCache = AppCache.get((String)"cal");
        iAppCache.put(orgId + ".initguide.ItemCount", (Object)value);
    }

    private Integer getItemCount() {
        long orgId = this.getOrgId();
        IAppCache iAppCache = AppCache.get((String)"cal");
        return (Integer)iAppCache.get(orgId + ".initguide.ItemCount", Integer.class);
    }

    private void changeCostAccount() {
        DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
        if (calOrg != null) {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue(this.COSTACCOUNT, (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue(this.COSTACCOUNT, null);
            }
        } else {
            this.getModel().setValue(this.COSTACCOUNT, null);
        }
    }

    private void initCalorgAndCostAccount(Long calOrgId) {
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue(this.CALORG, (Object)calOrgId);
            this.getModel().setValue(this.CALMAINORG, (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue(this.COSTACCOUNT, (Object)costAccount.getLong("id"));
            }
        }
    }

    private void initGuidePanel() {
        Map<String, Boolean> status = this.getStatus();
        if (status == null) {
            this.setSelfVisible(true, "step1");
            this.setSelfVisible(true, "begininit");
            ((Label)this.getControl("tips_11")).setText(ResManager.loadKDString((String)"\u5728\u4f7f\u7528\u5e94\u7528\u524d\uff0c\u9700\u8981\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u8ba9\u5c0fK\u5e2e\u4f60\u4e00\u8d77\u5b8c\u6210\u8fd9\u9879\u5de5\u4f5c\u5427\u3002", (String)"HomePlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            this.setSelfVisible(false, "step2");
        } else {
            this.setSelfVisible(false, "step1");
            this.setSelfVisible(true, "step2");
        }
        Integer itemCount = this.getItemCount();
        this.setCustomCtrlProp("itemcount", itemCount);
        this.refreshStep2Page();
    }

    private void refreshStep2Page() {
        ArrayList<Map> nodeInitDatas = new ArrayList<Map>();
        boolean isGreenBaseHead = false;
        boolean isGreenSystemHead = false;
        boolean isGreenSettingHead = false;
        boolean isGreenModelHead = false;
        boolean isGreenBeginHead = false;
        isGreenSystemHead = this.buildNodeDatas(this.systemNodeInfos, nodeInitDatas);
        isGreenSettingHead = this.buildNodeDatas(this.settingNodeInfos, nodeInitDatas);
        isGreenBaseHead = this.buildNodeDatas(this.baseNodeInfos, nodeInitDatas);
        isGreenModelHead = this.buildNodeDatas(this.modelNodeInfos, nodeInitDatas);
        isGreenBeginHead = this.buildNodeDatas(this.beginNodeInfos, nodeInitDatas);
        this.greendHead(isGreenBaseHead, isGreenSystemHead, isGreenSettingHead, isGreenModelHead, isGreenBeginHead);
        this.setCustomCtrlProp("refreshNodes", nodeInitDatas);
    }

    private void greendHead(boolean isGreenBaseHead, boolean isGreenSystemHead, boolean isGreenSettingHead, boolean isGreenModelHead, boolean isGreenBeginHead) {
        this.setCustomCtrlProp("isBaseGreenHead", isGreenBaseHead);
        this.setCustomCtrlProp("isSystemGreenHead", isGreenSystemHead);
        this.setCustomCtrlProp("isSettingGreenHead", isGreenSettingHead);
        this.setCustomCtrlProp("isModelGreenHead", isGreenModelHead);
        this.setCustomCtrlProp("isBeginGreenHead", isGreenBeginHead);
    }

    private Boolean buildNodeDatas(String[][] nodeInfos, List<Map> nodeInitDatas) {
        Boolean isGreenHead = true;
        for (String[] nodeInfo : nodeInfos) {
            String entityName = nodeInfo[0];
            boolean lock = false;
            lock = this.chekLock(entityName);
            boolean confirmed = this.getConfirmed(entityName);
            isGreenHead = isGreenHead & confirmed;
            nodeInitDatas.add(this.refreshNode(entityName, nodeInfo[1], lock, confirmed));
        }
        return isGreenHead;
    }

    private boolean chekLock(String entityName) {
        if (entityName.equals("cal_bd_costaccount")) {
            return !this.getStatus("cal_bd_calpolicy");
        }
        if (entityName.equals("cal_bd_calrange")) {
            return !this.getStatus("cal_bd_costaccount");
        }
        if (entityName.equals("cal_sysctrlentity")) {
            return !this.getStatus("cal_bd_calrange");
        }
        if (entityName.equals("cal_balance")) {
            return !this.getStatus("cal_sysctrlentity");
        }
        return false;
    }

    private boolean getEntityCount(String entityName) {
        if (Arrays.asList("bd_bdctrstratege_formcard", "ai_vchtemplate_configs", "cal_setting").indexOf(entityName) >= 0) {
            return true;
        }
        if ("cal_sysctrlentity".equals(entityName)) {
            long orgId = this.getOrgId();
            QFilter entityFilter = new QFilter("org", "=", (Object)orgId);
            DynamicObject sysctrlEntry = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)"org,entry.costaccount,entry.isenabled", (QFilter[])entityFilter.toArray());
            boolean sysctrlentity = false;
            if (sysctrlEntry != null) {
                DynamicObjectCollection sysctrlEntryEntry = sysctrlEntry.getDynamicObjectCollection("entry");
                for (DynamicObject dynamicObject : sysctrlEntryEntry) {
                    if (dynamicObject.getBoolean("isenabled")) {
                        sysctrlentity = true;
                        continue;
                    }
                    sysctrlentity = false;
                    break;
                }
            }
            return sysctrlentity;
        }
        return QueryServiceHelper.exists((String)entityName, (QFilter[])this.getNodeFilter(entityName).toArray());
    }

    private Map refreshNode(String key, String label, boolean lock, boolean confirmed) {
        HashMap<String, Object> mData = new HashMap<String, Object>();
        mData.put("nodeKey", key);
        mData.put("label", label);
        mData.put("lock", lock);
        mData.put("confirmed", confirmed);
        return mData;
    }

    private boolean getConfirmed(String entityName) {
        return this.getStatus(entityName);
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgsStr = e.getEventArgs();
        Map eventArgs = (Map)JsonUtils.jsonToObj((String)eventArgsStr, Map.class);
        Object initGuideEvent = eventArgs.get("initGuideEvent");
        if (initGuideEvent == null) {
            return;
        }
        Object type = eventArgs.get("type");
        String entityName = eventArgs.get("nodeKey").toString();
        if ("clicklink".equals(type)) {
            int width = (Integer)eventArgs.get("top.outerWidth");
            int height = (Integer)eventArgs.get("top.outerHeight");
            boolean hasOrgPermission = this.judgeOrgPermission(entityName);
            if (!hasOrgPermission) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u6b64\u529f\u80fd\u67e5\u770b\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"HomePlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            this.handleLinkClick(entityName, width, height);
        }
    }

    private boolean judgeOrgPermission(String entityName) {
        boolean notVchTpl;
        boolean hasPermission = true;
        long orgId = this.getOrgId();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean bl = notVchTpl = !"ai_vchtemplate_configs".equals(entityName);
        if (!notVchTpl) {
            Boolean isPermission = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)EntityMetadataCache.getAppInfo((String)"iep").getId());
            hasPermission = isPermission;
        }
        if (!Arrays.asList("bd_accountingsys_base", "cal_setting").contains(entityName) && notVchTpl) {
            hasPermission = this.hasPermission(userId, entityName, orgId);
        }
        return hasPermission;
    }

    private Boolean hasPermission(Long userId, String entityName, long orgId) {
        List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)entityName, (String)"47150e89000000ac");
        if (calorgList == null) {
            return true;
        }
        if (calorgList != null && calorgList.isEmpty()) {
            return false;
        }
        return calorgList.contains(orgId);
    }

    private void handleLinkClick(String entityName, int width, int height) {
        BaseShowParameter showParameter = null;
        if (Collections.singletonList("cal_setting").indexOf(entityName) >= 0) {
            showParameter = new BaseShowParameter();
            showParameter.setFormId(entityName);
        } else if (Arrays.asList("bd_bdctrstratege_formcard", "ai_vchtemplate_configs").indexOf(entityName) >= 0) {
            showParameter = new FormShowParameter();
            showParameter.setFormId(entityName);
        } else {
            showParameter = new ListShowParameter();
            if (entityName.equals("bd_accountingsys_base")) {
                showParameter.setFormId("bd_accountingsys_list");
            } else if ("bos_importtemplate".equals(entityName)) {
                showParameter.setFormId("bos_treelist");
            } else if ("bos_coderule".equals(entityName)) {
                showParameter.setFormId("bos_coderule_list");
            } else {
                showParameter.setFormId("bos_list");
            }
            ((ListShowParameter)showParameter).setShowFilter(false);
            ((ListShowParameter)showParameter).setShowQuickFilter(false);
            ((ListShowParameter)showParameter).setBillFormId(entityName);
            ((ListShowParameter)showParameter).setUseOrgId(this.getOrgId());
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        showParameter.setParentFormId("cal_homepage_grid");
        this.getPageCache().put("entityName", entityName);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityName = this.getPageCache().get("entityName");
        if (entityName != null) {
            this.getPageCache().remove("entityName");
            boolean confirmed = this.getEntityCount(entityName);
            boolean useConfiremd = this.getStatus(entityName);
            if (!useConfiremd && confirmed) {
                Integer itemCount;
                Integer n = itemCount = this.getItemCount();
                Integer n2 = itemCount = Integer.valueOf(itemCount - 1);
                this.putItemCount(itemCount);
                this.setCustomCtrlProp("itemcount", itemCount);
            }
            this.putStatus(entityName, confirmed);
            this.refreshStep2Page();
        }
    }

    private void endInit() {
        this.removeStatus();
        this.setSelfVisible(false, "initguidepanel");
        this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316", (String)"HomePlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]));
    }

    private void removeStatus() {
        long orgId = this.getOrgId();
        IAppCache iAppCache = AppCache.get((String)"cal");
        iAppCache.remove(orgId + ".initguide.status");
        iAppCache.remove(orgId + ".initguide.ItemCount");
    }

    private QFilter getNodeFilter(String entityName) {
        long orgId = this.getOrgId();
        if ("bd_accountingsys".equalsIgnoreCase(entityName)) {
            return new QFilter("bizorgentry.bizorg", "!=", (Object)orgId);
        }
        if ("gl_accountbook".equals(entityName)) {
            return new QFilter("org", "=", (Object)orgId);
        }
        if ("bd_accountingsys_base".equals(entityName)) {
            return new QFilter("baseacctorg", "=", (Object)orgId);
        }
        if ("cal_bd_accounttype".equals(entityName)) {
            return new QFilter("calorg", "=", (Object)orgId);
        }
        if ("cal_bd_costaccount".equals(entityName)) {
            return new QFilter("calorg", "=", (Object)orgId);
        }
        if ("cal_bd_calrange".equals(entityName)) {
            return new QFilter("headcalorg", "=", (Object)orgId);
        }
        if ("cal_bd_materialdimension".equals(entityName)) {
            return new QFilter("calorg", "=", (Object)orgId);
        }
        if ("cal_queuesetting".equals(entityName)) {
            return new QFilter("calorg", "=", (Object)orgId);
        }
        if ("cal_sysctrlentity".equals(entityName)) {
            return new QFilter("org", "=", (Object)orgId);
        }
        if ("cal_balance".equals(entityName)) {
            return new QFilter("calorg", "=", (Object)orgId);
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    private void setCustomCtrlProp(String prop, Object value) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(prop, value);
        this.setCustomCtrlProp(data);
    }

    private void setCustomCtrlProp(Map data) {
        CustomControl node = (CustomControl)this.getView().getControl("generalctrl");
        IClientViewProxy proxy = (IClientViewProxy)node.getView().getService(IClientViewProxy.class);
        HashMap noneData = (HashMap)proxy.getViewState(node.getKey());
        if (noneData == null) {
            noneData = new HashMap();
        }
        noneData.putAll(data);
        node.setData(noneData);
    }

    private Map<String, Boolean> getStatus() {
        long orgId = this.getOrgId();
        IAppCache iAppCache = AppCache.get((String)"cal");
        Map statusCache = (Map)iAppCache.get(orgId + ".initguide.status", Map.class);
        return statusCache;
    }

    private boolean getStatus(String key) {
        return this.getStatus() == null ? false : this.getStatus().get(key);
    }

    protected long getOrgId() {
        IDataModel model = this.getModel();
        Object org = model.getValue(this.CALORG);
        long orgId = 0L;
        if (!(org instanceof DynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"HomePlugin_26", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        orgId = ((DynamicObject)org).getLong("id");
        return orgId;
    }

    private boolean isInited(Long calOrgId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("calorg", "=", (Object)calOrgId), new QFilter("enable", "=", (Object)true), new QFilter("status", "=", (Object)"C")};
        boolean costAccount = QueryServiceHelper.exists((String)"cal_bd_costaccount", (QFilter[])qFilters);
        boolean existsCalPolicy = QueryServiceHelper.exists((String)"cal_bd_calpolicy", null);
        boolean existsCalRange = QueryServiceHelper.exists((String)"cal_bd_calrange", (QFilter[])new QFilter("headcalorg", "=", (Object)calOrgId).toArray());
        QFilter entityFilter = new QFilter("org", "=", (Object)calOrgId);
        DynamicObject sysctrlEntry = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)"org,entry.costaccount,entry.isenabled", (QFilter[])entityFilter.toArray());
        boolean sysctrlentity = false;
        if (sysctrlEntry != null) {
            DynamicObjectCollection sysctrlEntryEntry = sysctrlEntry.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : sysctrlEntryEntry) {
                if (dynamicObject.getBoolean("isenabled")) {
                    sysctrlentity = true;
                    continue;
                }
                sysctrlentity = false;
                break;
            }
        }
        return costAccount && existsCalPolicy && existsCalRange && sysctrlentity && this.getStatus() == null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (this.CALORG.equals(propertyName)) {
            this.getModel().beginInit();
            this.getModel().setValue(this.CALMAINORG, (Object)this.getModel().getDataEntity().getDynamicObject(this.CALORG));
            this.changeCostAccount();
            this.getModel().endInit();
            this.getView().updateView(this.CALMAINORG);
            this.getView().updateView(this.COSTACCOUNT);
            boolean inited = this.isInited(this.getOrgId());
            if (inited) {
                this.setSelfVisible(false, "initguidepanel");
            } else {
                this.setSelfVisible(true, "initguidepanel");
                this.initGuidePanel();
            }
            this.refreshPage();
        } else if (this.COSTACCOUNT.equals(propertyName)) {
            this.refreshPage();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.COSTACCOUNT.equals(sourceID)) {
            DynamicObject calOrg = this.getModel().getDataEntity().getDynamicObject(this.CALORG);
            QFilter qf = null;
            qf = calOrg == null ? new QFilter(this.CALORG, "=", null) : new QFilter(this.CALORG, "=", calOrg.getPkValue());
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.CALORG.equals(sourceID)) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            List calorgList = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_apphome", (String)"47150e89000000ac");
            QFilter calorgFilter = new QFilter("id", "in", (Object)calorgList);
            if (calorgList != null) {
                showParameter.getListFilterParameter().setFilter(calorgFilter);
            }
        }
    }

    private void refreshPage() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    private void setSelfVisible(boolean show, String key) {
        if (show) {
            HashMap<String, Serializable> fieldMap = new HashMap<String, Serializable>();
            HashMap<String, String> c1 = new HashMap<String, String>();
            c1.put("zh_CN", "inherit");
            fieldMap.put("w", c1);
            fieldMap.put("h", c1);
            fieldMap.put("gr", Integer.valueOf(1));
            this.getView().updateControlMetadata(key, fieldMap);
        } else {
            HashMap<String, Serializable> fieldMap = new HashMap<String, Serializable>();
            HashMap<String, String> c1 = new HashMap<String, String>();
            c1.put("zh_CN", "0px");
            fieldMap.put("w", c1);
            fieldMap.put("h", c1);
            fieldMap.put("gr", Integer.valueOf(0));
            this.getView().updateControlMetadata(key, fieldMap);
        }
    }
}

