/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.queryscheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class SchemeParamPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addF7Listener(this, "calscheme");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParent();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object defaultParam = this.getView().getFormShowParameter().getCustomParam("defaultparam");
        if (ObjectUtils.isNotEmpty((Object)defaultParam)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)((String)defaultParam), Map.class);
            this.getModel().setValue("calscheme", map.get("calscheme"));
            Boolean hideFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("hideflag");
            if (hideFlag != null && hideFlag.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object mulCostAccount = this.getView().getFormShowParameter().getCustomParam("mulcostaccount");
        if (ObjectUtils.isNotEmpty((Object)mulCostAccount) && ((Boolean)mulCostAccount).booleanValue()) {
            this.getModel().setValue("calscheme", null);
            this.getView().updateView("calscheme");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"calscheme"});
        }
    }

    private void returnDataToParent() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        DynamicObject calScheme = (DynamicObject)this.getModel().getValue("calscheme");
        if (calScheme != null) {
            paramMap.put("calscheme", calScheme.getLong("id"));
            paramMap.put("calcparainfo", calScheme.getString("name"));
        }
        String filterString = SerializationUtils.toJsonString(paramMap);
        if (paramMap.size() == 0) {
            this.getView().returnDataToParent(null);
        } else {
            this.getView().returnDataToParent((Object)filterString);
        }
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String settleItemNumber = (String)this.getView().getFormShowParameter().getCustomParam("settleitemnumber");
        String entityNumber = "";
        if (settleItemNumber.equals("CH_ITEM_001")) {
            entityNumber = "cal_closeaccount";
        }
        if (settleItemNumber.equals("CH_ITEM_007")) {
            entityNumber = "cal_out_calculate";
        }
        if (settleItemNumber.equals("CH_ITEM_016")) {
            entityNumber = "cal_settleaccount";
        }
        if (!entityNumber.equals("")) {
            QFilter filter = new QFilter("formid.number", "=", (Object)entityNumber);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_query_scheme", (String)"id", (QFilter[])new QFilter[]{filter});
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("id"));
            }
            if (!ids.isEmpty()) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", ids));
            }
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }
}

