/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.queryscheme;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.cal.formplugin.queryscheme.QuerySchemeHolder;

public class SchemeSettingPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String SAVE_SCHEME_OP_KEY = "savescheme";
    private static final String DELETE_SCHEME_OP_KEY = "deletescheme";
    private static final String ADD_SCHEME_OP_KEY = "addscheme";
    private static final String RESET_SCHEME_OP_KEY = "resetcheme";
    private String schemeEntryKey = "scheme_entry";
    private static final String BUTTONAP_KEY = "buttonap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        holder.initSchemesList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
        holder.setDefaultScheme();
        this.afterSelScheme();
        this.getView().getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Button defaultBtn = (Button)this.getView().getControl(BUTTONAP_KEY);
        defaultBtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (BUTTONAP_KEY.equals(source.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.schemeEntryKey);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                return;
            }
            entryGrid.selectRows(selectRows[0]);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (event.getOperationResult() == null || !event.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = event.getOperateKey();
        if (SAVE_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            String removeEntitiesStr = this.getView().getPageCache().get("removeEntities");
            if (StringUtils.isNotEmpty((String)removeEntitiesStr)) {
                List<String> entitys = Arrays.asList(removeEntitiesStr.split(","));
                holder.addRemoveEntities(entitys);
            }
            holder.saveScheme();
        } else if (DELETE_SCHEME_OP_KEY.equals(opKey)) {
            int[] selectRows = ((EntryGrid)this.getView().getControl(this.schemeEntryKey)).getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"QuerySchemeHolder_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                event.getOperationResult().setShowMessage(false);
                return;
            }
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.deleteScheme();
        } else if (ADD_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.addScheme();
            this.afterAddScheme();
        } else if (RESET_SCHEME_OP_KEY.equals(opKey)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.resetScheme();
            this.afterAddScheme();
        }
    }

    public void entryRowClick(RowClickEvent e) {
        String key = ((EntryGrid)e.getSource()).getKey();
        if (this.schemeEntryKey.equals(key)) {
            QuerySchemeHolder holder = new QuerySchemeHolder(this.getView());
            holder.setScheme(e.getRow());
            this.afterSelScheme();
            this.getView().getModel().setDataChanged(false);
        }
    }

    protected void afterSelScheme() {
    }

    protected void afterAddScheme() {
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("close")) {
            boolean isClose = true;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().getPageCache().put("isclose", String.valueOf(true));
                this.getView().close();
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                isClose = false;
            }
            this.getView().getPageCache().put("isclose", String.valueOf(isClose));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isDataChange = this.getModel().getDataChanged();
        boolean isClose = "true".equals(this.getView().getPageCache().get("isclose"));
        if (isDataChange && !isClose) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, callBackListener, btnNameMaps);
            e.setCancel(true);
        }
    }
}

