/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BillGroupRecordListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (!"billno".equals(fieldName)) {
            return;
        }
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        int selectRowIndex = args.getRowIndex();
        BillList list = (BillList)this.getControl("billlistap");
        int pageRows = list.getEntryState().getPageRows();
        int pageIndex = list.getEntryState().getCurrentPageIndex();
        if (pageIndex > 1) {
            selectRowIndex -= pageRows * (pageIndex - 1);
        }
        ListSelectedRow row = billList.getCurrentListAllRowCollection().get(selectRowIndex);
        QFilter recordFilter = new QFilter("entryentity.id", "=", row.getEntryPrimaryKeyValue());
        recordFilter.and("id", "=", row.getPrimaryKeyValue());
        DynamicObject record = QueryServiceHelper.queryOne((String)"cal_groupbillrecord", (String)"entryentity.billid,entryentity.bizbillid", (QFilter[])recordFilter.toArray());
        if (record == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bb0\u5f55\u3002", (String)"CostRecordEditPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("calbillid", "=", (Object)record.getLong("entryentity.billid"));
        filter.and("bizbillid", "=", (Object)record.getLong("entryentity.bizbillid"));
        DynamicObject billCostRecord = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"bizbillid,bizentityobject", (QFilter[])filter.toArray());
        BillShowParameter sbillShowParameter = new BillShowParameter();
        sbillShowParameter.setFormId(billCostRecord.getString("bizentityobject"));
        sbillShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        sbillShowParameter.setStatus(OperationStatus.VIEW);
        sbillShowParameter.setPkId(billCostRecord.get("bizbillid"));
        this.getView().showForm((FormShowParameter)sbillShowParameter);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if ("tbl_atgrouprecord".equals(key)) {
            this.showAccountGroupRecordList(ids);
        }
    }

    private void showAccountGroupRecordList(Object[] ids) {
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostRecordListPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("cal_account_grouprecord");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("bizgrouprecordid", "in", (Object)ids));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.setCancel(true);
    }
}

