/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.EntityParseHelper;
import kd.fi.cal.formplugin.setting.BuildGroupHelper;

public class BillGroupSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String BILL = "bill";
    private static final String RELATEION_BILL = "relationbill";
    private static final String COSTACCOUNT = "costaccount";
    private static final String BILLFILTE = "billfiltergrid";
    private static final String RELATIONFILTER = "relationbillfiltergrid";
    private static final String RELATIONTABLE = "entryentity";
    private static final String BILLFIELD_COLUMN = "billfield";
    private static final String BILLFIELD_NAME_COLUMN = "billfieldname";
    private static final String RELATIONBILLFIELD_COLUMN = "rbillfield";
    private static final String RELATIONBILLFIELD_NAME_COLUMN = "rbillfieldname";
    private static final String BILLFILTERSTR = "billfilterstr";
    private static final String RBILLFILTERSTR = "rbillfilterstr";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
        this.addF7Listener(this, BILL, RELATEION_BILL, "bizplugin");
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    private void addListener() {
        this.addClickListeners(new String[]{BILLFIELD_NAME_COLUMN, RELATIONBILLFIELD_NAME_COLUMN});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (RELATEION_BILL.equals(key)) {
            this.billChanged(key);
        } else if (BILL.equals(key)) {
            this.billChanged(key);
            this.reloadWeightField();
        } else if (COSTACCOUNT.equals(key)) {
            DynamicObject costAccountInfo = (DynamicObject)this.getModel().getValue(COSTACCOUNT);
            DynamicObject calOrg = costAccountInfo.getDynamicObject("calorg");
            this.getModel().setValue("calorg", (Object)calOrg);
        } else if (BILLFIELD_NAME_COLUMN.equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex(RELATIONTABLE);
            String billfieldname = (String)this.getModel().getValue(BILLFIELD_NAME_COLUMN, row);
            if (StringUtils.isEmpty((CharSequence)billfieldname)) {
                this.getModel().setValue(BILLFIELD_COLUMN, (Object)"", row);
            }
        } else if (RELATIONBILLFIELD_NAME_COLUMN.equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex(RELATIONTABLE);
            String rbillfieldname = (String)this.getModel().getValue(RELATIONBILLFIELD_NAME_COLUMN, row);
            if (StringUtils.isEmpty((CharSequence)rbillfieldname)) {
                this.getModel().setValue(RELATIONBILLFIELD_COLUMN, (Object)"", row);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (BILL.equals(key) || RELATEION_BILL.equals(key)) {
            QFilter q = new QFilter("number", "in", (Object)new String[]{"cal_incalbill", "cal_outcalbill"});
            showParameter.getListFilterParameter().setFilter(q);
            return;
        }
        if ("bizplugin".equals(key)) {
            showParameter.getListFilterParameter().getQFilters().clear();
            showParameter.setShowApproved(false);
            showParameter.setShowUsed(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        int row = this.getModel().getEntryCurrentRowIndex(RELATIONTABLE);
        if ("save".equals(key)) {
            this.beforeSave();
        }
        if ("clear".equals(key)) {
            this.getModel().setValue(BILLFIELD_COLUMN, (Object)"", row);
            this.getModel().setValue(BILLFIELD_NAME_COLUMN, (Object)"", row);
            this.getModel().setValue(RELATIONBILLFIELD_COLUMN, (Object)"", row);
            this.getModel().setValue(RELATIONBILLFIELD_NAME_COLUMN, (Object)"", row);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("manualcreate".equals(key)) {
            this.clickManualCreate();
        }
    }

    private void clickManualCreate() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_billgroupstartdate");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "manualcreate");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void beforeSave() {
        this.storeFilter(BILLFILTERSTR);
        this.storeFilter(RBILLFILTERSTR);
    }

    private void storeFilter(String fieldName) {
        String filerGridName = BILLFILTE;
        if (RBILLFILTERSTR.equals(fieldName)) {
            filerGridName = RELATIONFILTER;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filerGridName);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().getDataEntity().set(fieldName + "_tag", (Object)filterString);
        this.getModel().getDataEntity().set(fieldName, (Object)" ");
    }

    public void afterBindData(EventObject e) {
        this.initFilterGrid();
        this.doBillFilter();
        this.doRelateionBillFilter();
        this.setFilterEnanle();
        this.reloadWeightField();
        this.setNameAndFilter();
    }

    private void setNameAndFilter() {
        DynamicObject bill = (DynamicObject)this.getModel().getDataEntity().get(BILL);
        DynamicObject relationbill = (DynamicObject)this.getModel().getDataEntity().get(RELATEION_BILL);
        if (bill != null) {
            EntityParseHelper.bindColNames((IDataModel)this.getModel(), (String)RELATIONTABLE, (String)bill.getString("id"), (String)BILLFIELD_COLUMN, (String)BILLFIELD_NAME_COLUMN);
        }
        if (relationbill != null) {
            EntityParseHelper.bindColNames((IDataModel)this.getModel(), (String)RELATIONTABLE, (String)relationbill.getString("id"), (String)RELATIONBILLFIELD_COLUMN, (String)RELATIONBILLFIELD_NAME_COLUMN);
        }
    }

    private void setFilterEnanle() {
        Object bill = this.getModel().getValue(BILL);
        if (bill == null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(BILLFILTE);
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView(BILLFILTE);
            this.getView().setEnable(Boolean.FALSE, new String[]{BILLFILTE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BILLFILTE});
        }
        Object relationBill = this.getModel().getValue(RELATEION_BILL);
        if (relationBill == null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(RELATIONFILTER);
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView(RELATIONFILTER);
            this.getView().setEnable(Boolean.FALSE, new String[]{RELATIONFILTER});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{RELATIONFILTER});
        }
    }

    private void initFilterGrid() {
        this.chengeFilterByBillType(BILL);
        this.chengeFilterByBillType(RELATEION_BILL);
    }

    private void doBillFilter() {
        this.setFilter(this.getFilterStr(BILLFILTERSTR), BILLFILTE);
    }

    private void doRelateionBillFilter() {
        this.setFilter(this.getFilterStr(RBILLFILTERSTR), RELATIONFILTER);
    }

    private String getFilterStr(String filterName) {
        return (String)this.getModel().getDataEntity().get(filterName + "_tag");
    }

    private void setFilter(String filter, String controlName) {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(controlName);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        DynamicObject currentEntity = null;
        if (BILLFIELD_NAME_COLUMN.equals(key)) {
            currentEntity = this.getModel().getDataEntity().getDynamicObject(BILL);
        } else if (RELATIONBILLFIELD_NAME_COLUMN.equals(key)) {
            currentEntity = this.getModel().getDataEntity().getDynamicObject(RELATEION_BILL);
        }
        if (currentEntity == null) {
            if (RELATIONBILLFIELD_NAME_COLUMN.equals(key)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"BillGroupSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            } else if (BILLFIELD_NAME_COLUMN.equals(key)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5355\u636e\u3002", (String)"BillGroupSettingPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
            return;
        }
        String entityNumber = currentEntity.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
        this.showSelectFieldForm(srcBillNode, key);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnMap;
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (BILLFIELD_NAME_COLUMN.equals(sourceFldKey)) {
            DynamicObject currentEntity = this.getModel().getDataEntity().getDynamicObject(BILL);
            String entityNumber = currentEntity.getString("number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            this.receiveSelectField(mainEntityType, (String)returnData, BILLFIELD_COLUMN, BILLFIELD_NAME_COLUMN);
        } else if (RELATIONBILLFIELD_NAME_COLUMN.equals(sourceFldKey)) {
            DynamicObject currentEntity = this.getModel().getDataEntity().getDynamicObject(RELATEION_BILL);
            String entityNumber = currentEntity.getString("number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            this.receiveSelectField(mainEntityType, (String)returnData, RELATIONBILLFIELD_COLUMN, RELATIONBILLFIELD_NAME_COLUMN);
        } else if ("manualcreate".equals(sourceFldKey) && (returnMap = (Map)returnData) != null) {
            BuildGroupHelper.doManualCreate(returnMap);
            this.getView().showMessage(ResManager.loadKDString((String)"\u624b\u5de5\u751f\u6210\u6b63\u5728\u540e\u53f0\u5904\u7406\u4e2d\uff0c\u7ed3\u679c\u8bf7\u5230\u201c\u540e\u53f0\u76d1\u63a7>\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u3002", (String)"BillGroupSettingPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String field, String fieldName) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex(RELATIONTABLE);
        this.getModel().setValue(field, (Object)returnPropName, row);
        this.getModel().setValue(fieldName, (Object)fieldCaption, row);
    }

    private void billChanged(String billName) {
        DynamicObject currentBill = this.getModel().getDataEntity().getDynamicObject(billName);
        if (currentBill == null) {
            this.getModel().deleteEntryData(RELATIONTABLE);
            return;
        }
        if (RELATEION_BILL.equals(billName)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(RELATIONFILTER);
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView(RELATIONFILTER);
            this.getView().setEnable(Boolean.TRUE, new String[]{RELATIONFILTER});
        } else if (BILL.equals(billName)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(BILLFILTE);
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView(BILLFILTE);
            this.getView().setEnable(Boolean.TRUE, new String[]{BILLFILTE});
        }
        this.getModel().deleteEntryData(RELATIONTABLE);
        this.chengeFilterByBillType(billName);
        this.getModel().createNewEntryRow(RELATIONTABLE);
    }

    private void chengeFilterByBillType(String typeName) {
        DynamicObject currentEntity;
        if (typeName == null) {
            return;
        }
        String filterGridName = BILLFILTE;
        if (RELATEION_BILL.equals(typeName)) {
            filterGridName = RELATIONFILTER;
        }
        if ((currentEntity = this.getModel().getDataEntity().getDynamicObject(typeName)) == null) {
            return;
        }
        String entityNumber = currentEntity.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGridName);
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(cols);
        this.getView().updateView(filterGridName);
    }

    private void reloadWeightField() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (bill != null) {
            MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)bill.getPkValue().toString());
            for (IDataEntityProperty pro : entitytype.getAllFields().values()) {
                if (!(pro instanceof DecimalProp) && !(pro instanceof LongProp) || pro.getDisplayName() == null) continue;
                IDataEntityType parentType = pro.getParent();
                ComboItem item = null;
                item = parentType instanceof EntryType ? new ComboItem(pro.getDisplayName(), parentType.getName() + "." + pro.getName()) : new ComboItem(pro.getDisplayName(), pro.getName());
                items.add(item);
            }
        }
        ComboEdit co = (ComboEdit)this.getView().getControl("tarweightfield");
        co.setComboItems(items);
    }
}

