/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CalAutoCleanZeroCostElementTask
extends AbstractTask {
    private int periodRange = 5;
    private Boolean isCleanAll = Boolean.FALSE;
    private boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);

    public void execute(RequestContext requestContext, Map<String, Object> arg) throws KDException {
        Date beginDate;
        Long crtAccountId;
        if (!this.balCompress) {
            return;
        }
        this.init(arg);
        QFilter filter = new QFilter("entry.isenabled", "=", (Object)true);
        DataSet accountDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount as accountid,entry.costaccount.number as accountnum,entry.startperiod as startperiod,entry.startperiod.begindate as startpdbegindate,entry.startperiod.periodyear as startperiodyear,entry.startperiod.periodnumber as startperiodnumber,entry.currentperiod as currentperiod,entry.currentperiod.periodyear as crtperiodyear,entry.currentperiod.periodnumber as crtperiodnumber,entry.calpolicy.periodtype as periodtype", (QFilter[])filter.toArray(), null);
        HashSet<Long> periodTypeIds = new HashSet<Long>(16);
        HashMap<Long, Date> accountBeginDateMap = new HashMap<Long, Date>(16);
        HashMap<Long, String> accountNumMap = new HashMap<Long, String>(16);
        for (Row row : accountDs.copy()) {
            periodTypeIds.add(row.getLong("periodtype"));
            accountBeginDateMap.put(row.getLong("accountid"), row.getDate("startpdbegindate"));
            accountNumMap.put(row.getLong("accountid"), row.getString("accountnum"));
        }
        DataSet periodDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"periodtype,periodyear,periodnumber,id,begindate,enddate", (QFilter[])new QFilter("periodtype", "in", periodTypeIds).toArray(), null);
        accountDs = accountDs.leftJoin(periodDs).on("periodtype", "periodtype").select(new String[]{"accountid", "accountnum", "startperiodyear", "startperiodnumber", "crtperiodyear", "crtperiodnumber"}, new String[]{"periodyear", "periodnumber", "begindate", "enddate"}).finish();
        accountDs = accountDs.groupBy(accountDs.getRowMeta().getFieldNames()).finish();
        accountDs = accountDs.select("accountid,accountnum,begindate,enddate,(startperiodyear *100) + startperiodnumber as startperiodint,(crtperiodyear *100) + crtperiodnumber as endperiodint,(periodyear *100) + periodnumber as periodint");
        accountDs = accountDs.filter("startperiodint <= periodint and endperiodint >= periodint").select("accountid,accountnum,begindate,enddate,periodint");
        accountDs = accountDs.orderBy(new String[]{"accountid", "periodint desc"});
        Long accountId = 0L;
        int accurePeriodInt = 1;
        for (Row row : accountDs) {
            crtAccountId = row.getLong("accountid");
            if (Long.compare(accountId, crtAccountId) != 0) {
                accountId = crtAccountId;
                accurePeriodInt = 1;
            }
            if (accurePeriodInt <= this.periodRange) {
                ++accurePeriodInt;
                continue;
            }
            String accountNum = row.getString("accountnum");
            beginDate = row.getDate("begindate");
            Date endDate = row.getDate("enddate");
            if ("CHHS08".equals(accountNum)) {
                System.out.println(accountNum + row.getInteger("periodint"));
            }
            if (this.isCleanAll.booleanValue()) {
                this.doBatchlean(crtAccountId, accountNum, beginDate, endDate);
                continue;
            }
            if (accurePeriodInt == this.periodRange + 1) {
                this.doBatchlean(crtAccountId, accountNum, beginDate, endDate);
            }
            ++accurePeriodInt;
        }
        if (this.isCleanAll.booleanValue()) {
            for (Map.Entry entry : accountBeginDateMap.entrySet()) {
                crtAccountId = (Long)entry.getKey();
                String creAccountNum = (String)accountNumMap.get(crtAccountId);
                beginDate = (Date)entry.getValue();
                this.doBatchlean(crtAccountId, creAccountNum, null, beginDate);
            }
        }
    }

    private void init(Map<String, Object> arg) {
        String periodRangeStr;
        if (arg.get("iscleanall") != null) {
            this.isCleanAll = Boolean.valueOf((String)arg.get("iscleanall"));
        }
        int n = this.periodRange = StringUtils.isEmpty((String)(periodRangeStr = (String)arg.get("periodrange"))) ? 5 : Integer.parseInt(periodRangeStr);
        if (this.periodRange == 0) {
            this.periodRange = 5;
        }
    }

    private void doBatchlean(Long accountId, String accountNum, Date beginDate, Date endDate) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("accountid", SerializationUtils.toJsonString((Object)accountId));
        jobParams.put("begindate", SerializationUtils.toJsonString((Object)beginDate));
        jobParams.put("enddate", SerializationUtils.toJsonString((Object)endDate));
        JobInfo job = new JobInfo();
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        dateStr = beginDate == null ? String.format(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u3010%1$s\u3011(\u521d\u59cb\u5316\u6570\u636e\u6e05\u7406)", (String)"CalAutoCleanZeroCostElementTask_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), sdf.format(endDate)) : String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u3010%1$s\u3011,\u622a\u6b62\u65e5\u671f\u3010%2$s\u3011", (String)"CalAutoCleanZeroCostElementTask_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), sdf.format(beginDate), sdf.format(endDate));
        String OpName = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u5904\u7406\u96f6\u6210\u672c\u5b50\u8981\u7d20\u6e05\u7a7a\uff0c%2$s", (String)"CalAutoCleanZeroCostElementTask_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), accountNum, dateStr);
        job.setName(OpName);
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setTaskClassname("kd.fi.cal.formplugin.balance.CalCleaZeroCostElementTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        JobClient.dispatch((JobInfo)job);
    }
}

