/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.business.wf.WfHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.DateUtils;

public class CalAutoRepairWriteOffSubTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(CalAutoRepairWriteOffSubTask.class);
    private static final long SERVICE_ATTRIBUTE = 1194029484878120960L;
    private static final String BOOKDATE_PARAM = "bookdatedayrange";
    private static final String REPAIR_SALOUT = "repairSalOut";
    private static final String splitBookdateDayStr_param = "splitbookdatedaystr_param";
    private Date beginDate;
    private Date enddate;
    private Boolean isRepairSalout = Boolean.TRUE;

    public void execute(RequestContext requestContext, Map<String, Object> arg) throws KDException {
        this.init(arg);
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.REPAIRUNWRITEOFF).booleanValue()) {
            this.handleNoVerifyRecord();
        }
        this.handleNoWriteOff();
    }

    private void handleNoVerifyRecord() {
        QFilter q = new QFilter("bookdate", ">=", (Object)this.beginDate);
        q.and("bookdate", "<=", (Object)this.enddate);
        q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
        q.and("writeoffstatus", "=", (Object)Character.valueOf('A'));
        Set<Long> allCostAccount = this.getAllValidCostAccount();
        if (!allCostAccount.isEmpty()) {
            q.and("costaccount", "in", allCostAccount);
        }
        q.and("costaccount.accountcosttype", "!=", (Object)Character.valueOf('B'));
        QFilter purQ = q.copy().and("bizentityobject", "in", (Object)new String[]{"im_purinbill", "im_mdc_ominbill", "im_ospurinbill"});
        QFilter salQ = q.copy().and("bizentityobject", "=", (Object)"im_saloutbill");
        this.handleBillUnVerifyRecord(purQ, "ap_verifyrecord");
        this.handleBillUnVerifyRecord(salQ, "ar_verifyrecord");
    }

    /*
     * WARNING - void declaration
     */
    private void handleBillUnVerifyRecord(QFilter billAQ, String entityNumber) {
        DataSet recordADateSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)"bizbillid,entry.writeoffid as writeoffid", (QFilter[])billAQ.toArray(), null);
        recordADateSet = recordADateSet.groupBy(new String[]{"bizbillid", "writeoffid"}).finish();
        HashMap<Object, void> wtfAndbizBillIdMap = new HashMap<Object, void>(16);
        for (Row row : recordADateSet) {
            void var9_9;
            Long writeoffId = row.getLong("writeoffid");
            Long bizBillid = row.getLong("bizbillid");
            Set set = (Set)wtfAndbizBillIdMap.get(writeoffId);
            if (set == null) {
                HashSet hashSet = new HashSet(16);
            }
            var9_9.add(bizBillid);
            wtfAndbizBillIdMap.put(writeoffId, var9_9);
        }
        DataSet wtfDataSet = this.getBillAVerifyRecords(wtfAndbizBillIdMap.keySet(), entityNumber);
        HashSet<Long> wtfIdSet = new HashSet<Long>(16);
        if (wtfDataSet != null) {
            for (Object row : wtfDataSet) {
                wtfIdSet.add(row.getLong("id"));
            }
        }
        wtfAndbizBillIdMap.keySet().removeAll(wtfIdSet);
        HashMap<Long, Set> bizBill2VeryRecordIdsMap = new HashMap<Long, Set>(16);
        for (Map.Entry entry : wtfAndbizBillIdMap.entrySet()) {
            Long noFoundWTFId = (Long)entry.getKey();
            Set billIdSet = (Set)entry.getValue();
            for (Long l : billIdSet) {
                Set purVerifyRecordIds = bizBill2VeryRecordIdsMap.computeIfAbsent(l, k -> new HashSet(4));
                purVerifyRecordIds.add(noFoundWTFId);
            }
        }
        HashSet<DynamicObject> verifyRecords = new HashSet<DynamicObject>(16);
        boolean bl = false;
        StringBuilder apErrorLog = new StringBuilder();
        StringBuilder arErrorLog = new StringBuilder();
        for (Map.Entry entry : bizBill2VeryRecordIdsMap.entrySet()) {
            Map map;
            Object[] obj;
            boolean bl2;
            Long bizbillid = (Long)entry.getKey();
            Set veryRecordIds = (Set)entry.getValue();
            bl2 += 1;
            for (Long veryRecordId : veryRecordIds) {
                DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityNumber, Arrays.asList("id", "billid", "billno", "entry"));
                DynamicObject verifyRecord = new DynamicObject(subDataEntityType);
                verifyRecord.set("id", (Object)veryRecordId);
                verifyRecord.set("billid", (Object)bizbillid);
                verifyRecord.set("billno", (Object)bizbillid.toString());
                verifyRecords.add(verifyRecord);
            }
            if (bl2 < 100) continue;
            if (entityNumber.equals("ap_verifyrecord")) {
                obj = new Object[]{ActionEnum.PUR_UN_WRITEOFF.getValue(), null, verifyRecords.toArray(new DynamicObject[0])};
                map = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])obj);
                if (map != null && !map.isEmpty()) {
                    apErrorLog.append(map.toString());
                }
            } else if (entityNumber.equals("ar_verifyrecord") && (map = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])(obj = new Object[]{ActionEnum.SALE_UN_WRITEOFF.getValue(), null, verifyRecords.toArray(new DynamicObject[0])}))) != null && !map.isEmpty()) {
                arErrorLog.append(map.toString());
            }
            verifyRecords.clear();
            bl2 = false;
        }
        if (verifyRecords.size() > 0) {
            Map map;
            Object[] obj;
            if (entityNumber.equals("ap_verifyrecord")) {
                obj = new Object[]{ActionEnum.PUR_UN_WRITEOFF.getValue(), null, verifyRecords.toArray(new DynamicObject[0])};
                Map map2 = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])obj);
                if (map2 != null && !map2.isEmpty()) {
                    apErrorLog.append(map2.toString());
                }
            } else if (entityNumber.equals("ar_verifyrecord") && (map = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])(obj = new Object[]{ActionEnum.SALE_UN_WRITEOFF.getValue(), null, verifyRecords.toArray(new DynamicObject[0])}))) != null && !map.isEmpty()) {
                arErrorLog.append(map.toString());
            }
        }
        if (apErrorLog.length() > 0) {
            log.error(apErrorLog.toString());
        }
        if (arErrorLog.length() > 0) {
            log.error(arErrorLog.toString());
        }
    }

    private DataSet getBillAVerifyRecords(Set<Long> allRecordAWTFIdSet, String entityNumber) {
        ArrayList<OrmInput> verifyRecordIOs = new ArrayList<OrmInput>(16);
        HashSet<Long> batchWTFIdSet = new HashSet<Long>(16);
        for (Long writeoffId : allRecordAWTFIdSet) {
            batchWTFIdSet.add(writeoffId);
            if (batchWTFIdSet.size() != 5000) continue;
            QFilter verifyRecordQ = new QFilter("id", "in", batchWTFIdSet);
            OrmInput verifyRecordIO = new OrmInput(((Object)((Object)this)).getClass().getName(), entityNumber, "id", verifyRecordQ.toArray());
            verifyRecordIOs.add(verifyRecordIO);
            batchWTFIdSet = new HashSet(16);
        }
        if (batchWTFIdSet.size() > 0) {
            QFilter verifyRecordQ = new QFilter("id", "in", batchWTFIdSet);
            OrmInput verifyRecordIO = new OrmInput(((Object)((Object)this)).getClass().getName(), entityNumber, "id", verifyRecordQ.toArray());
            verifyRecordIOs.add(verifyRecordIO);
        }
        if (verifyRecordIOs.size() <= 0) {
            return null;
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet verifyRecordDataSet = algo.createDataSet((Input[])verifyRecordIOs.toArray(new OrmInput[verifyRecordIOs.size()]));
        return verifyRecordDataSet;
    }

    private Set<Long> getAllValidCostAccount() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)true);
        DynamicObject[] costAccountCol = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> costAccount = new HashSet<Long>(costAccountCol.length);
        for (DynamicObject costAccountObj : costAccountCol) {
            costAccount.add(costAccountObj.getLong("id"));
        }
        return costAccount;
    }

    private void init(Map<String, Object> arg) {
        if (arg.get(REPAIR_SALOUT) != null) {
            this.isRepairSalout = Boolean.valueOf((String)arg.get(REPAIR_SALOUT));
        }
        Date now = TimeServiceHelper.now();
        String bookDateDayRangeStr = (String)arg.get(BOOKDATE_PARAM);
        int bookDateDayRange = bookDateDayRangeStr == null ? 3 : Integer.parseInt(bookDateDayRangeStr);
        Calendar bookDateRangeCalendar = Calendar.getInstance();
        bookDateRangeCalendar.setTime(DateUtils.getDayStartTime((Date)now));
        bookDateRangeCalendar.add(5, 0 - bookDateDayRange);
        this.beginDate = new Date((Long)arg.get("curStartDate"));
        this.enddate = new Date((Long)arg.get("curEntDate"));
    }

    private void handleNoWriteOff() {
        DataSet auxDataSet = this.getAuxBills(this.beginDate, this.enddate);
        Map<String, Set<Long>> auxbillMap = this.getAuxBillMap(auxDataSet);
        DataSet writeOffInfosData = this.getWriteOffData(auxbillMap);
        if (writeOffInfosData == null) {
            return;
        }
        HashSet<Long> writeOffIds = new HashSet<Long>(16);
        HashSet<Long> bizbillIds = new HashSet<Long>(16);
        for (Row row : writeOffInfosData.copy()) {
            writeOffIds.add(row.getLong("id"));
            bizbillIds.add(row.getLong("billid"));
        }
        if (writeOffIds.isEmpty()) {
            return;
        }
        DataSet writeOffCostRecord = this.getWriteOffCostRecord(bizbillIds);
        HashMap<String, Set<Long>> mainBillEntityBillIdsMap = new HashMap<String, Set<Long>>(16);
        HashMap<Long, Set<Long>> apMainBillIdWfIdsMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Set<Long>> arMainBillIdWfIdsMap = new HashMap<Long, Set<Long>>(16);
        this.getNotWfInfo(writeOffInfosData, writeOffCostRecord, mainBillEntityBillIdsMap, apMainBillIdWfIdsMap, arMainBillIdWfIdsMap);
        new WfHelper().removeNotSyncCalWfIds(mainBillEntityBillIdsMap, new Map[]{apMainBillIdWfIdsMap, arMainBillIdWfIdsMap});
        if (apMainBillIdWfIdsMap.isEmpty() && arMainBillIdWfIdsMap.isEmpty()) {
            return;
        }
        new WfHelper().invokeWfByBatch(apMainBillIdWfIdsMap, ActionEnum.PUR_WRITEOFF.getValue(), "ap_verifyrecord");
        new WfHelper().invokeWfByBatch(arMainBillIdWfIdsMap, ActionEnum.SALE_WRITEOFF.getValue(), "ar_verifyrecord");
    }

    private DataSet getAuxBills(Date beginDate, Date enddate) {
        QFilter q = new QFilter("bookdate", ">=", (Object)beginDate);
        q.and("bookdate", "<=", (Object)enddate);
        QFilter qbiz = new QFilter("bizdate", ">=", (Object)beginDate);
        qbiz.and("bizdate", "<=", (Object)enddate);
        QFilter purInQ = q.copy().and("billentry.linetype.serviceattribute", "=", (Object)1194029484878120960L);
        QFilter apQ = qbiz.copy().and("detailentry.linetype.serviceattribute", "=", (Object)1194029484878120960L);
        QFilter salOutQ = q.copy().and("billentry.linetype.serviceattribute", "=", (Object)1194029484878120960L);
        QFilter cfmQ = qbiz.and("entry.linetype.serviceattribute", "=", (Object)1194029484878120960L);
        purInQ.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        salOutQ.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        ArrayList<OrmInput> auxBillIOs = new ArrayList<OrmInput>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("bizobject", (DataType)DataType.StringType)});
        OrmInput purInBillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "im_purinbill", "id,'im_purinbill' as bizobject", purInQ.toArray(), rowMeta);
        OrmInput omInBillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "im_mdc_ominbill", "id,'im_mdc_ominbill' as bizobject", purInQ.toArray(), rowMeta);
        OrmInput osPurInBillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "im_ospurinbill", "id,'im_ospurinbill' as bizobject", purInQ.toArray(), rowMeta);
        OrmInput apBillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "ap_finapbill", "id,'ap_finapbill' as bizobject", apQ.toArray(), rowMeta);
        OrmInput salOutBillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "im_saloutbill", "id,'im_saloutbill' as bizobject", salOutQ.toArray(), rowMeta);
        OrmInput cfmBillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "ar_revcfmbill", "id,'ar_revcfmbill' as bizobject", cfmQ.toArray(), rowMeta);
        auxBillIOs.add(purInBillIO);
        auxBillIOs.add(omInBillIO);
        auxBillIOs.add(apBillIO);
        auxBillIOs.add(osPurInBillIO);
        if (this.isRepairSalout.booleanValue()) {
            auxBillIOs.add(salOutBillIO);
            auxBillIOs.add(cfmBillIO);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        return algo.createDataSet((Input[])auxBillIOs.toArray(new OrmInput[auxBillIOs.size()]));
    }

    private Map<String, Set<Long>> getAuxBillMap(DataSet auxDataSet) {
        HashMap<String, Set<Long>> auxBillIdMap = new HashMap<String, Set<Long>>(16);
        for (Row row : auxDataSet) {
            Long billId = row.getLong("id");
            String bizObject = row.getString("bizobject");
            HashSet<Long> billIdSet = (HashSet<Long>)auxBillIdMap.get(bizObject);
            if (billIdSet == null) {
                billIdSet = new HashSet<Long>(16);
            }
            billIdSet.add(billId);
            auxBillIdMap.put(bizObject, billIdSet);
        }
        return auxBillIdMap;
    }

    private DataSet getWriteOffData(Map<String, Set<Long>> auxBillIdMap) {
        QFilter purWriteoffQ = new QFilter("billtype", "in", (Object)new String[]{"im_purinbill", "im_mdc_ominbill", "im_ospurinbill"});
        purWriteoffQ.and("verifyrelation", "in", (Object)new String[]{"appurin", "appurreturn", "purself", "apomin", "apominreturn", "ominself", "purwrittenoff", "purreturnwrittenoff"});
        purWriteoffQ.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        QFilter salWriteoffQ = new QFilter("billtype", "=", (Object)"im_saloutbill");
        salWriteoffQ.and("verifyrelation", "in", (Object)new String[]{"arsalout", "arsalreturn", "salself", "arfinself", "saloutwrittenoff", "salreturnwrittenoff"});
        salWriteoffQ.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        ArrayList<OrmInput> verifyRecordIOs = new ArrayList<OrmInput>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("billid", (DataType)DataType.LongType), new Field("bizobject", (DataType)DataType.StringType), new Field("billtype", (DataType)DataType.StringType)});
        for (Map.Entry<String, Set<Long>> entry : auxBillIdMap.entrySet()) {
            OrmInput verifyRecordEntryIO;
            OrmInput verifyRecordIO;
            String entityName = entry.getKey();
            Set<Long> idSet = entry.getValue();
            QFilter mainBillQ = new QFilter("billid", "in", idSet);
            QFilter assistBillQ = new QFilter("entry.e_billtype", "=", (Object)entityName);
            assistBillQ.and("entry.e_billid", "in", idSet);
            if ("im_purinbill".equals(entityName) || "ap_finapbill".equals(entityName) || "im_mdc_ominbill".equals(entityName) || "im_ospurinbill".equals(entityName)) {
                verifyRecordIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "ap_verifyrecord", "id,billid,'ap_verifyrecord' as bizobject,billtype", purWriteoffQ.copy().and(mainBillQ).toArray(), rowMeta);
                verifyRecordEntryIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "ap_verifyrecord", "id,billid,'ap_verifyrecord' as bizobject,billtype", purWriteoffQ.copy().and(assistBillQ).toArray(), rowMeta);
            } else {
                verifyRecordIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "ar_verifyrecord", "id,billid,'ar_verifyrecord' as bizobject,billtype", salWriteoffQ.copy().and(mainBillQ).toArray(), rowMeta);
                verifyRecordEntryIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "ar_verifyrecord", "id,billid,'ar_verifyrecord' as bizobject,billtype", salWriteoffQ.copy().and(assistBillQ).toArray(), rowMeta);
            }
            verifyRecordIOs.add(verifyRecordIO);
            verifyRecordIOs.add(verifyRecordEntryIO);
        }
        if (verifyRecordIOs.size() <= 0) {
            return null;
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        return algo.createDataSet((Input[])verifyRecordIOs.toArray(new OrmInput[verifyRecordIOs.size()]));
    }

    private DataSet getWriteOffCostRecord(Set<Long> bizbillIds) {
        if (bizbillIds.isEmpty()) {
            return null;
        }
        ArrayList inputs = new ArrayList(16);
        Lists.partition(new ArrayList<Long>(bizbillIds), (int)50000).forEach(list -> {
            QFilter costRecordQ = new QFilter("bizbillid", "in", list);
            costRecordQ.and("writeoffstatus", "=", (Object)"A");
            costRecordQ.and("costaccount.accountcosttype", "!=", (Object)Character.valueOf('B'));
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", "entry.writeoffid", costRecordQ.toArray());
            inputs.add(input);
        });
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet totalDataSet = algo.createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        return totalDataSet;
    }

    private void getNotWfInfo(DataSet writeOffInfosData, DataSet writeOffCostRecord, Map<String, Set<Long>> mainBillEntityBillIdsMap, Map<Long, Set<Long>> apMainBillIdWfIdsMap, Map<Long, Set<Long>> arMainBillIdWfIdsMap) {
        if (writeOffCostRecord != null) {
            JoinDataSet joinNoWriteOffData = writeOffInfosData.leftJoin(writeOffCostRecord);
            joinNoWriteOffData.on("id", "entry.writeoffid");
            DataSet noWriteOffData = joinNoWriteOffData.select(new String[]{"id", "bizobject", "billtype", "billid"}, new String[]{"entry.writeoffid"}).finish().filter("entry.writeoffid is null");
            for (Row row : noWriteOffData) {
                Set wfIds;
                Long wfId = row.getLong("id");
                if ("ap_verifyrecord".equals(row.getString("bizobject"))) {
                    wfIds = apMainBillIdWfIdsMap.computeIfAbsent(row.getLong("billid"), k -> new HashSet(16));
                    wfIds.add(wfId);
                } else if ("ar_verifyrecord".equals(row.getString("bizobject"))) {
                    wfIds = arMainBillIdWfIdsMap.computeIfAbsent(row.getLong("billid"), k -> new HashSet(16));
                    wfIds.add(wfId);
                }
                String mainBillEntity = row.getString("billtype");
                Set billIds = mainBillEntityBillIdsMap.computeIfAbsent(mainBillEntity, k -> new HashSet(16));
                billIds.add(row.getLong("billid"));
            }
        }
    }
}

