/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.SyncSimpleDycHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.util.DateUtils;

public class CalAutoSyncTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalAutoSyncTask.class);
    private static final String modifyTimeFromHours_param = "modifytimefromhour";
    private static final String modifyTimeToHours_param = "modifytimetohour";
    private static final String bizDate_param = "bizdatedayrange";
    private String batch_param = "batch";
    private String splitBookdateDayStr_param = "splitbookdate";
    private Date modifyTimeMaxDate;
    private Date modifyTimeMinDate;
    private Date bizDateMaxDate;
    private Date bizDateMinDate;
    private int batch;
    private String entity;
    private int splitBookdateDay;

    public void execute(RequestContext requestContext, Map<String, Object> arg) throws KDException {
        this.init(arg);
        DataSet allBillDs = this.getDiffBillDs();
        if (allBillDs == null) {
            return;
        }
        this.autoSync(allBillDs);
    }

    private void autoSync(DataSet allBillDs) {
        HashSet<Long> unSubmitBillIds = new HashSet<Long>(16);
        HashSet<Long> unAuditBillIds = new HashSet<Long>(16);
        HashSet<Long> submitBillIds = new HashSet<Long>(16);
        HashSet<Long> auditBillIds = new HashSet<Long>(16);
        int count = 0;
        for (Row row : allBillDs) {
            Integer calBillStatus = row.getInteger("calbillstatus");
            Integer invBillStatus = row.getInteger("invbillstatus");
            Long invBillId = row.getLong("invbillid");
            if (calBillStatus.equals(0) && invBillStatus.equals(2)) {
                auditBillIds.add(invBillId);
            }
            if (calBillStatus.equals(1)) {
                if (invBillStatus.equals(0)) {
                    unAuditBillIds.add(invBillId);
                } else if (invBillStatus.equals(1)) {
                    unAuditBillIds.add(invBillId);
                } else if (invBillStatus.equals(2)) {
                    auditBillIds.add(invBillId);
                }
            }
            if (calBillStatus.equals(2)) {
                if (invBillStatus.equals(0)) {
                    unAuditBillIds.add(invBillId);
                } else if (invBillStatus.equals(1)) {
                    unAuditBillIds.add(invBillId);
                }
            }
            if (count >= this.batch) {
                this.invokeAutoSync(ActionEnum.UN_AUDIT.getValue(), unAuditBillIds);
                this.invokeAutoSync(ActionEnum.UN_SUBMIT.getValue(), unSubmitBillIds);
                this.invokeAutoSync(ActionEnum.SUBMIT.getValue(), submitBillIds);
                this.invokeAutoSync(ActionEnum.AUDIT.getValue(), auditBillIds);
                count = 0;
                unAuditBillIds.clear();
                unSubmitBillIds.clear();
                submitBillIds.clear();
                auditBillIds.clear();
            }
            ++count;
        }
        if (count > 0) {
            this.invokeAutoSync(ActionEnum.UN_AUDIT.getValue(), unAuditBillIds);
            this.invokeAutoSync(ActionEnum.AUDIT.getValue(), auditBillIds);
        }
    }

    private DataSet getDiffBillDs() {
        ArrayList<QFilter> splitFilters;
        List<QFilter> dateSpitFilters;
        QFilter entityFilter;
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadRulesByBills(new HashSet<String>(Collections.singletonList(this.entity)));
        Map inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        List inCalBillRules = (List)inCalBillRuleMap.get(this.entity);
        inCalBillRules = inCalBillRules == null ? new ArrayList(0) : inCalBillRules;
        Map outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
        List outCalBillRules = (List)outCalBillRuleMap.get(this.entity);
        outCalBillRules = outCalBillRules == null ? new ArrayList(0) : outCalBillRules;
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("invbillid", (DataType)DataType.LongType), new Field("invbillstatus", (DataType)DataType.IntegerType), new Field("calbillstatus", (DataType)DataType.IntegerType), new Field("calstatus", (DataType)DataType.IntegerType)});
        String selectFields = "id as invbillid,case when billstatus = 'A' then 0 when billstatus = 'B' then 1 else 2 end as invbillstatus,0 as calbillstatus,0 as calstatus";
        for (CalBillRule inCalBillRule : inCalBillRules) {
            List inBizFilters = inCalBillRule.getBillFilters();
            Map inBillFielsMap = inCalBillRule.getCalBizFieldMap();
            if (inBillFielsMap == null) continue;
            String bizDateField = (String)inBillFielsMap.get("bookdate");
            String modifyField = (String)inBillFielsMap.get("modifytime");
            this.addDateFilter(modifyField, inBizFilters);
            if (this.entity.contains("im_mdc_")) {
                entityFilter = new QFilter("billtype.billformid.number", "=", (Object)this.entity);
                inBizFilters.add(entityFilter);
            }
            dateSpitFilters = this.getDateSpitFilters(bizDateField);
            for (QFilter dateSpitFilter : dateSpitFilters) {
                splitFilters = new ArrayList<QFilter>(inBizFilters);
                splitFilters.add(0, dateSpitFilter);
                OrmInput inOI = new OrmInput(((Object)((Object)this)).getClass().getName(), this.entity, selectFields, splitFilters.toArray(new QFilter[0]), rowMeta);
                billOIs.add(inOI);
            }
        }
        for (CalBillRule outCalBillRule : outCalBillRules) {
            List outBillFilter = outCalBillRule.getBillFilters();
            Map outBillFieldsMap = outCalBillRule.getCalBizFieldMap();
            if (outBillFieldsMap == null) continue;
            String outBizDateField = (String)outBillFieldsMap.get("bookdate");
            String outModifyField = (String)outBillFieldsMap.get("modifytime");
            this.addDateFilter(outModifyField, outBillFilter);
            if (this.entity.contains("im_mdc_")) {
                entityFilter = new QFilter("billtype.billformid.number", "=", (Object)this.entity);
                outBillFilter.add(entityFilter);
            }
            dateSpitFilters = this.getDateSpitFilters(outBizDateField);
            for (QFilter dateSpitFilter : dateSpitFilters) {
                splitFilters = new ArrayList(outBillFilter);
                splitFilters.add(0, dateSpitFilter);
                OrmInput outOI = new OrmInput(((Object)((Object)this)).getClass().getName(), this.entity, selectFields, splitFilters.toArray(new QFilter[0]), rowMeta);
                billOIs.add(outOI);
            }
        }
        if (billOIs.isEmpty()) {
            return null;
        }
        ArrayList<QFilter> calFilters = new ArrayList<QFilter>(16);
        QFilter entityFilter2 = new QFilter("bizentityobject.number", "=", (Object)this.entity);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(entityFilter2);
        calFilters.add(entityFilter2);
        this.addDateFilter("modifytime", calFilters);
        if (this.entity.contains("im_mdc_")) {
            calFilters.add(new QFilter("billtype.billformid", "=", (Object)this.entity));
        }
        String calSelectFields = "bizbillid as invbillid,0 as invbillstatus,case when billstatus = 'A' then 0 when billstatus = 'B' then 1 else 2 end as calbillstatus,case when calstatus = 'B' then 1 when calstatus = 'C' then 1 else 0 end as calstatus";
        List<QFilter> dateSpitFilters2 = this.getDateSpitFilters("bookdate");
        for (QFilter dateSpitFilter : dateSpitFilters2) {
            ArrayList<QFilter> splitFilters2 = new ArrayList<QFilter>(calFilters);
            splitFilters2.add(0, dateSpitFilter);
            OrmInput costRecordOI = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", calSelectFields, splitFilters2.toArray(new QFilter[0]), rowMeta);
            billOIs.add(costRecordOI);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet allBillDs = algo.createDataSet((Input[])billOIs.toArray(new OrmInput[billOIs.size()]));
        allBillDs = allBillDs.groupBy(new String[]{"invbillid"}).max("invbillstatus").max("calbillstatus").max("calstatus").finish();
        allBillDs = allBillDs.filter("invbillstatus <> calbillstatus and calstatus <> 1");
        return allBillDs;
    }

    private void invokeAutoSync(String actionName, Set<Long> autoSyncBillIds) {
        DynamicObject[] bizBillDycs;
        if (autoSyncBillIds.isEmpty()) {
            return;
        }
        HashMap<String, String> paras = new HashMap<String, String>(16);
        paras.put("nocheckacct", "TRUE");
        Map checkBillIdMsgMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"ReSyncService", (String)"check", (Object[])new Object[]{this.entity, autoSyncBillIds, paras});
        autoSyncBillIds.removeAll(checkBillIdMsgMap.keySet());
        if (autoSyncBillIds.isEmpty()) {
            return;
        }
        logger.info("\u6838\u7b97\u81ea\u52a8\u540c\u6b65-" + actionName + "-" + autoSyncBillIds);
        for (DynamicObject bizBillDyc : bizBillDycs = this.getSimpleBillDycs(this.entity, autoSyncBillIds)) {
            autoSyncBillIds.remove(bizBillDyc.getPkValue());
        }
        List allBizBillDycs = new SyncSimpleDycHelper().buildDelBizBillDycsByCostRecord(this.entity, autoSyncBillIds);
        allBizBillDycs.addAll(Arrays.asList(bizBillDycs));
        DynamicObject[] newBizBillDycs = allBizBillDycs.toArray(new DynamicObject[0]);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{actionName, null, newBizBillDycs});
    }

    private void addDateFilter(String modifyField, List<QFilter> bizFilters) {
        QFilter minModifyTimeF = new QFilter(modifyField, ">=", (Object)this.modifyTimeMinDate);
        QFilter maxModifyTimeF = new QFilter(modifyField, "<=", (Object)this.modifyTimeMaxDate);
        bizFilters.add(0, minModifyTimeF);
        bizFilters.add(0, maxModifyTimeF);
    }

    private void init(Map<String, Object> arg) {
        Date now = TimeServiceHelper.now();
        String modifyTimeFromHoursStr = (String)arg.get(modifyTimeFromHours_param);
        String modifyTimeToHoursStr = (String)arg.get(modifyTimeToHours_param);
        String bizDateDayRangeStr = (String)arg.get(bizDate_param);
        int modifyTimeFromHours = modifyTimeFromHoursStr == null ? 24 : Integer.parseInt(modifyTimeFromHoursStr);
        int modifyTimeToHours = modifyTimeToHoursStr == null ? 168 : Integer.parseInt(modifyTimeToHoursStr);
        int bizDateDayRange = bizDateDayRangeStr == null ? 30 : Integer.parseInt(bizDateDayRangeStr);
        Calendar maxCalendar = Calendar.getInstance();
        maxCalendar.setTime(now);
        maxCalendar.add(10, 0 - modifyTimeFromHours);
        this.modifyTimeMaxDate = maxCalendar.getTime();
        Calendar minCalendar = Calendar.getInstance();
        minCalendar.setTime(now);
        minCalendar.add(10, 0 - modifyTimeToHours);
        this.modifyTimeMinDate = minCalendar.getTime();
        Calendar bizDateRangeCalendar = Calendar.getInstance();
        bizDateRangeCalendar.setTime(now);
        bizDateRangeCalendar.add(5, 0 - bizDateDayRange);
        this.bizDateMinDate = bizDateRangeCalendar.getTime();
        this.bizDateMaxDate = now;
        this.upgradeChangeDateRange();
        String batchStr = (String)arg.get(this.batch_param);
        this.batch = batchStr == null ? 100 : Integer.parseInt(batchStr);
        String splitBookdateDayStr = (String)arg.get(this.splitBookdateDayStr_param);
        this.splitBookdateDay = splitBookdateDayStr == null ? 50 : Integer.parseInt(splitBookdateDayStr);
        this.entity = (String)arg.get("entity");
    }

    private void upgradeChangeDateRange() {
        Integer upgradeTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.SYNC_AUTO_UPGRADEDELETESUBMITBILL_TIMES);
        if (upgradeTimes > 3) {
            return;
        }
        Date now = TimeServiceHelper.now();
        Double aDouble = Math.pow(2.0, upgradeTimes - 1);
        int month = 12 / aDouble.intValue();
        int days = month * 31;
        Calendar bizDateRangeCalendar = Calendar.getInstance();
        bizDateRangeCalendar.setTime(now);
        bizDateRangeCalendar.add(5, 0 - days);
        this.bizDateMinDate = bizDateRangeCalendar.getTime();
        bizDateRangeCalendar.setTime(now);
        bizDateRangeCalendar.add(5, days);
        this.bizDateMaxDate = bizDateRangeCalendar.getTime();
    }

    private DynamicObject[] getSimpleBillDycs(String formId, Collection<Long> bizBillIds) {
        QFilter qFilter = new QFilter("id", "in", bizBillIds);
        StringBuilder selector = new StringBuilder();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        String mainOrgName = dataEntityType.getMainOrg();
        selector.append("id").append(",").append("billno").append(",").append("billstatus").append(",").append(mainOrgName).append(",").append("auditor").append(",").append("modifytime").append(",").append("auditdate");
        DynamicObject[] billDycs = BusinessDataServiceHelper.load((String)formId, (String)selector.toString(), (QFilter[])new QFilter[]{qFilter});
        return billDycs;
    }

    private List<QFilter> getDateSpitFilters(String dateField) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = this.bizDateMinDate;
        Date nowDate = this.bizDateMaxDate;
        int diffDay = DateUtils.getDiffDays((Date)startDate, (Date)nowDate);
        int batch = diffDay / this.splitBookdateDay;
        if (batch == 0) {
            batch = 1;
        }
        for (int i = 0; i < batch; ++i) {
            Date curEndDate = DateUtils.addDateTime((Date)startDate, (int)5, (int)this.splitBookdateDay);
            if (i == batch - 1) {
                curEndDate = nowDate;
            }
            QFilter curFilter = new QFilter(dateField, ">=", (Object)startDate);
            curFilter.and(new QFilter(dateField, "<=", (Object)curEndDate));
            filters.add(curFilter);
            startDate = curEndDate;
        }
        return filters;
    }
}

