/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.inner.OverWfAutoUnWfHelper;
import kd.fi.cal.business.service.CalProcessReExcuteHandle;
import kd.fi.cal.business.wf.WfHelper;
import kd.fi.cal.chargeoff.CalChargeOffHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SyncSimpleDycHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;

public class CalBatchSyncFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CalBatchSyncFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnwriteoff", "btnwritedate"});
        this.addF7Listener(this, "bizentityobjects");
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            if ("btncancel".equals(((Button)evt.getSource()).getKey())) {
                this.getView().close();
            } else if ("btnok".equals(((Button)evt.getSource()).getKey())) {
                this.excute();
                String opName = ResManager.loadKDString((String)"\u6279\u91cf\u540c\u6b65", (String)"CalBatchSyncFormPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.recordOpLog(opName);
            } else if ("btnwriteoff".equals(((Button)evt.getSource()).getKey())) {
                this.excute4WriteOff(false);
                String opName = ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u540c\u6b65", (String)"CalBatchSyncFormPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.recordOpLog(opName);
            } else if ("btnwritedate".equals(((Button)evt.getSource()).getKey())) {
                this.excute4WriteDate();
            }
        }
    }

    private void excute() {
        DynamicObjectCollection entityObjects = (DynamicObjectCollection)this.getModel().getValue("bizentityobjects");
        HashSet<String> selEntitys = new HashSet<String>(entityObjects.size());
        if (entityObjects.size() > 0) {
            for (DynamicObject entityObject : entityObjects) {
                selEntitys.add(entityObject.getDynamicObject("fbasedataid").getString("number"));
            }
        }
        DynamicObject org = (DynamicObject)this.getModel().getDataEntity().get("org");
        Object dateStart = this.getModel().getDataEntity().get("daterange_startdate");
        Object dateEnd = this.getModel().getDataEntity().get("daterange_enddate");
        if (dateEnd == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"CalBatchSyncFormPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Set<String>> billEntityMatFieldsMap = this.getEntityMatFieldsMap(selEntitys);
        if (billEntityMatFieldsMap.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u5355\u636e\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"CalBatchSyncFormPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        String billNoStr = (String)this.getModel().getValue("billnos");
        if (StringUtils.isEmpty((String)billNoStr)) {
            billNoStr = (String)this.getModel().getValue("billnos_tag");
        }
        HashSet<String> billNos = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)billNoStr)) {
            billNos.addAll(Arrays.asList(billNoStr.split("\\s+|[\\r\\n]+")));
        }
        DynamicObjectCollection materialDycs = (DynamicObjectCollection)this.getModel().getValue("mulmaterials");
        HashSet<Long> matIds = new HashSet<Long>(materialDycs.size());
        if (materialDycs.size() > 0) {
            for (DynamicObject matDyc : materialDycs) {
                matIds.add(matDyc.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        int pageInt = 100;
        Integer batchQty = (Integer)this.getModel().getValue("batchqty");
        if (batchQty != null && batchQty > 0) {
            pageInt = batchQty;
        }
        QFilter neeUnAuditCostRecF = this.getCostRecF(org, dateStart, dateEnd, billNos, matIds);
        neeUnAuditCostRecF.and(new QFilter("billstatus", "=", (Object)"C"));
        try (AlgoContext context = Algo.newContext();){
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u53cd\u5ba1\u6838\u5f00\u59cb");
            this.autoUnAudit(neeUnAuditCostRecF);
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u53cd\u5ba1\u6838\u7ed3\u675f");
        }
        catch (Throwable e) {
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u53cd\u5ba1\u6838\u5931\u8d25", e);
        }
        for (Map.Entry<String, Set<String>> billEntityMatFields : billEntityMatFieldsMap.entrySet()) {
            String entity = billEntityMatFields.getKey();
            QFilter fs = new QFilter("billstatus", "in", (Object)new String[]{"C"});
            if (entity.contains("im_mdc_")) {
                fs.and(new QFilter("billtype.billformid.number", "=", (Object)entity));
            }
            if (org != null) {
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entity);
                String mainOrgName = type.getMainOrg();
                if (StringUtils.isEmpty((String)mainOrgName)) {
                    mainOrgName = "org";
                }
                fs.and(new QFilter(mainOrgName, "=", org.getPkValue()));
            }
            String bizDate = "biztime";
            boolean containBookDate = EntityMetadataCache.getDataEntityType((String)entity).getProperties().containsKey((Object)"bookdate");
            if (containBookDate) {
                bizDate = "bookdate";
            }
            if (dateStart != null) {
                fs.and(new QFilter(bizDate, ">=", dateStart));
            }
            if (dateEnd != null) {
                fs.and(new QFilter(bizDate, "<=", dateEnd));
            }
            if (billNos.size() > 0) {
                fs.and(new QFilter("billno", "in", billNos));
            }
            DataSet allBizBillDs = null;
            if (matIds.size() > 0) {
                Set<String> matFields = billEntityMatFields.getValue();
                for (String matField : matFields) {
                    QFilter tmpf = new QFilter(matField, "in", matIds);
                    DataSet bizBillDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id", (QFilter[])new QFilter[]{tmpf.and(fs)}, null);
                    allBizBillDs = allBizBillDs == null ? bizBillDs : allBizBillDs.union(bizBillDs);
                }
            } else {
                DataSet billDs;
                allBizBillDs = billDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id", (QFilter[])new QFilter[]{fs}, null);
            }
            QFilter costRecF = new QFilter("bizentityobject", "=", (Object)entity);
            QFilter comCostRecF = this.getCostRecF(org, dateStart, dateEnd, billNos, matIds);
            costRecF.and(comCostRecF);
            costRecF.and(new QFilter("billstatus", "=", (Object)"C"));
            DataSet costRecDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"bizbillid", (QFilter[])costRecF.toArray(), null);
            if (allBizBillDs == null) continue;
            allBizBillDs = allBizBillDs.leftJoin(costRecDs).on("id", "bizbillid").select(new String[]{"id"}, new String[]{"bizbillid"}).finish().filter("bizbillid is null");
            HashSet<Long> needAuditBillIds = new HashSet<Long>(16);
            for (Row row : allBizBillDs) {
                Long billId = row.getLong("id");
                needAuditBillIds.add(billId);
                if (needAuditBillIds.size() < pageInt) continue;
                this.audit(entity, needAuditBillIds);
                needAuditBillIds = new HashSet(16);
            }
            this.audit(entity, needAuditBillIds);
        }
        QFilter costRecF = this.getCostRecF(org, dateStart, dateEnd, billNos, matIds);
        costRecF.and(new QFilter("billstatus", "=", (Object)"C"));
        try (AlgoContext context = Algo.newContext();){
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u6750\u6599\u6838\u9500\u5f00\u59cb");
            new CalProcessReExcuteHandle().autoMatWriteOffBatchSyc(costRecF.copy());
        }
        catch (Throwable e) {
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u6750\u6599\u6838\u9500\u5931\u8d25", e);
        }
        new OverWfAutoUnWfHelper().autoUnWf(costRecF.copy());
        try {
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u6838\u9500\u5f00\u59cb");
            this.excute4WriteOff(true);
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u6838\u9500\u7ed3\u675f");
        }
        catch (Throwable e) {
            logger.error("\u6279\u91cf\u540c\u6b65-\u6279\u91cf\u6838\u9500\u5931\u8d25", e);
        }
        this.getView().returnDataToParent((Object)"btnok");
        this.getView().close();
    }

    private void autoUnAudit(QFilter neeUnAuditCostRecF) {
        Set bizBillIds;
        DataSet srcCostRecDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,bizentityobject", (QFilter[])neeUnAuditCostRecF.toArray(), null);
        HashMap<String, Set> entityBizBillIdsMap = new HashMap<String, Set>(16);
        for (Object row : srcCostRecDs.copy()) {
            String string = row.getString("bizentityobject");
            Long bizBillId = row.getLong("bizbillid");
            bizBillIds = entityBizBillIdsMap.computeIfAbsent(string, k -> new HashSet(16));
            bizBillIds.add(bizBillId);
        }
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        for (Map.Entry entry : entityBizBillIdsMap.entrySet()) {
            String entity = (String)entry.getKey();
            bizBillIds = (Set)entry.getValue();
            RowMeta rowMeta = ORM.create().createRowMeta(entity, "id");
            QFilter billIdF = new QFilter("id", "in", (Object)bizBillIds);
            billIdF.and("billstatus", "=", (Object)"C");
            OrmInput billOI = new OrmInput(((Object)((Object)this)).getClass().getName(), entity, "id", billIdF.toArray(), rowMeta);
            billOIs.add(billOI);
        }
        if (billOIs.isEmpty()) {
            logger.info("CalBatchSyncFormPlugin-autoUnAudit\uff0c\u81ea\u52a8\u53cd\u5ba1\u6838\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        DataSet bizBillDs = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet((Input[])billOIs.toArray(new OrmInput[0]));
        srcCostRecDs = srcCostRecDs.leftJoin(bizBillDs).on("bizbillid", "id").select(new String[]{"bizbillid", "bizentityobject"}, new String[]{"id"}).finish().filter("id is null");
        HashMap<String, Set> hashMap = new HashMap<String, Set>(16);
        for (Row row : srcCostRecDs) {
            String bizEntity = row.getString("bizentityobject");
            Long bizBillId = row.getLong("bizbillid");
            Set bizBillIds2 = hashMap.computeIfAbsent(bizEntity, k -> new HashSet(16));
            bizBillIds2.add(bizBillId);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String entity = (String)entry.getKey();
            Set bizBillIds3 = (Set)entry.getValue();
            Lists.partition(new ArrayList(bizBillIds3), (int)100).forEach(list -> {
                List allBizBillDycs = new SyncSimpleDycHelper().buildDelBizBillDycsByCostRecord(entity, new HashSet(list));
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{ActionEnum.UN_AUDIT.getValue(), null, allBizBillDycs.toArray(new DynamicObject[0])});
            });
        }
    }

    private QFilter getCostRecF(DynamicObject org, Object dateStart, Object dateEnd, Set<String> billNos, Set<Long> matIds) {
        QFilter costRecF = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (org != null) {
            costRecF.and(new QFilter("storageorgunit", "=", org.getPkValue()));
        }
        if (dateStart != null) {
            costRecF.and(new QFilter("bookdate", ">=", dateStart));
        }
        if (dateEnd != null) {
            costRecF.and(new QFilter("bookdate", "<=", dateEnd));
        }
        if (billNos.size() > 0) {
            costRecF.and(new QFilter("billnumber", "in", billNos));
        }
        if (matIds.size() > 0) {
            costRecF.and(new QFilter("entry.material", "in", matIds));
        }
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecF);
        return costRecF;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("bizentityobjects".equals(key)) {
            this.beforeF7Select4BizEntity(e);
        }
    }

    private void beforeF7Select4BizEntity(BeforeF7SelectEvent e) {
        Set<String> entityNumberSet = this.getAllEntityNumberSet();
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("number", "in", entityNumberSet));
    }

    private Set<String> getAllEntityNumberSet() {
        QFilter fs = new QFilter("enable", "=", (Object)"1");
        HashSet<String> entityNumberSet = new HashSet<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_calbillrule", (String)"id,sourcebill.number", (QFilter[])new QFilter[]{fs}, null);){
            for (Row row : dataSet) {
                entityNumberSet.add(row.getString("sourcebill.number"));
            }
        }
        return entityNumberSet;
    }

    private Map<String, Set<String>> getEntityMatFieldsMap(Set<String> selEntitys) {
        HashMap<String, Set<String>> billEntityMatFieldsMap = new HashMap<String, Set<String>>(16);
        QFilter fs = new QFilter("enable", "=", (Object)Boolean.TRUE);
        fs.and(new QFilter("fieldmap.calfield", "=", (Object)"material"));
        if (selEntitys.size() > 0) {
            fs.and(new QFilter("sourcebill.number", "in", selEntitys));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_calbillrule", (String)"id,sourcebill.number,fieldmap.sourcefield as sourcefield", (QFilter[])new QFilter[]{fs}, null);){
            for (Row row : dataSet) {
                String bizBillNumber = row.getString("sourcebill.number");
                String sourceField = row.getString("sourcefield");
                Set matFields = billEntityMatFieldsMap.computeIfAbsent(bizBillNumber, k -> new HashSet(2));
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizBillNumber);
                Map billAllFields = dataEntityType.getAllFields();
                boolean contaninMasterId = sourceField.contains(".masterid");
                sourceField = sourceField.replace(".masterid", "");
                IDataEntityProperty prop = (IDataEntityProperty)billAllFields.get(sourceField);
                IDataEntityType parentProp = prop.getParent();
                sourceField = this.getFieldPath(sourceField, parentProp);
                if (contaninMasterId) {
                    sourceField = sourceField + ".masterid";
                }
                matFields.add(sourceField);
            }
        }
        return billEntityMatFieldsMap;
    }

    private String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return this.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    private void excute4WriteOff(boolean isAutoSyn) {
        Object dateEnd = this.getModel().getDataEntity().get("daterange_enddate");
        if (dateEnd == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"CalBatchSyncFormPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        this.excute4WriteOff("ap_verifyrecord", ActionEnum.PUR_WRITEOFF.getValue());
        this.excute4WriteOff("ar_verifyrecord", ActionEnum.SALE_WRITEOFF.getValue());
        if (!isAutoSyn) {
            this.getView().returnDataToParent((Object)"btnok");
            this.getView().close();
        }
    }

    private void excute4WriteOff(String entityNumber, String ActionName) {
        DynamicObject org = (DynamicObject)this.getModel().getDataEntity().get("org");
        Object dateStart = this.getModel().getDataEntity().get("daterange_startdate");
        Object dateEnd = this.getModel().getDataEntity().get("daterange_enddate");
        String billNoStr = (String)this.getModel().getValue("billnos");
        if (StringUtils.isEmpty((String)billNoStr)) {
            billNoStr = (String)this.getModel().getValue("billnos_tag");
        }
        HashSet<String> billNos = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)billNoStr)) {
            billNos.addAll(Arrays.asList(billNoStr.split("\\s+|[\\r\\n]+")));
        }
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (billNos.size() > 0) {
            q.and(new QFilter("billno", "in", billNos));
        }
        if (org != null) {
            q.and(new QFilter("org", "=", org.getPkValue()));
        }
        if (dateStart != null) {
            q.and(new QFilter("billdate", ">=", dateStart));
        }
        if (dateEnd != null) {
            q.and(new QFilter("billdate", "<=", dateEnd));
        }
        q.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        DataSet writeOffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNumber, (String)"id,entry.e_hadwrittenoff e_hadwrittenoff,billid,billtype", (QFilter[])q.toArray(), null);
        QFilter q1 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        q1.and("issplitcreate", "=", (Object)Boolean.TRUE);
        if (org != null) {
            q1.and(new QFilter("calorg", "=", org.getPkValue()));
        }
        if (dateStart != null) {
            q1.and(new QFilter("bizdate", ">=", dateStart));
        }
        if (dateEnd != null) {
            q1.and(new QFilter("bizdate", "<=", dateEnd));
        }
        if (billNos.size() > 0) {
            q1.and(new QFilter("billnumber", "in", billNos));
        }
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(q1);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id as billid,entry.id as entryid,entry.writeoffid as writeoffid,ischargeoffed", (QFilter[])q1.toArray(), null);
        DataSet finalDataSet = writeOffDataSet.leftJoin(costRecordDataSet).on("id", "writeoffid").select(new String[]{"id", "e_hadwrittenoff", "billid", "billtype"}, new String[]{"entryid", "ischargeoffed"}).finish();
        HashSet<Long> chargeWfRecIdSet = new HashSet<Long>(32);
        HashMap<Long, Set> mainBillIdWfIdsMap = new HashMap<Long, Set>(16);
        HashMap<String, Set> mainBillEntityBillIdsMap = new HashMap<String, Set>(16);
        HashSet<Long> allHasHcWfId = new HashSet<Long>(16);
        for (Row row : finalDataSet) {
            Boolean isCostRecChargeoff;
            Boolean hadWriteOff = row.getBoolean("e_hadwrittenoff");
            Long wfRecId = row.getLong("id");
            if (row.getLong("entryid") == null) {
                Set wfIds = mainBillIdWfIdsMap.computeIfAbsent(row.getLong("billid"), k -> new HashSet(16));
                wfIds.add(wfRecId);
                String mainBillEntity = row.getString("billtype");
                Set billIds = mainBillEntityBillIdsMap.computeIfAbsent(mainBillEntity, k -> new HashSet(16));
                billIds.add(row.getLong("billid"));
                continue;
            }
            if (hadWriteOff.booleanValue()) {
                chargeWfRecIdSet.add(wfRecId);
            }
            if ((isCostRecChargeoff = row.getBoolean("ischargeoffed")) == null || !isCostRecChargeoff.booleanValue()) continue;
            allHasHcWfId.add(wfRecId);
        }
        chargeWfRecIdSet.removeAll(allHasHcWfId);
        if (chargeWfRecIdSet.size() > 0) {
            try {
                DynamicObject[] chargeWfDycs = BusinessDataServiceHelper.load((Object[])chargeWfRecIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
                new CalChargeOffHelper().autoInvokeCharge(Arrays.asList(chargeWfDycs), entityNumber);
            }
            catch (Throwable e) {
                logger.info("\u51b2\u9500\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e)));
            }
        }
        if (mainBillEntityBillIdsMap.isEmpty()) {
            return;
        }
        new WfHelper().removeNotSyncCalWfIds(mainBillEntityBillIdsMap, new Map[]{mainBillIdWfIdsMap});
        new WfHelper().invokeWfByBatch(mainBillIdWfIdsMap, ActionName, entityNumber);
    }

    private void excute4WriteDate() {
        Object dateStart = this.getModel().getDataEntity().get("daterange_startdate");
        Object dateEnd = this.getModel().getDataEntity().get("daterange_enddate");
        QFilter q1 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (dateStart != null) {
            q1.and(new QFilter("bizdate", ">=", dateStart));
        }
        if (dateEnd != null) {
            q1.and(new QFilter("bizdate", "<=", dateEnd));
        }
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,writeoffdate,costaccount,writeoffperiod.enddate,writeoffperiod.begindate", (QFilter[])q1.toArray(), null);
        costRecordDataSet = costRecordDataSet.filter("writeoffdate < writeoffperiod.begindate or writeoffdate > writeoffperiod.enddate");
        ArrayList<Object[]> list = new ArrayList<Object[]>(32);
        for (Row row : costRecordDataSet) {
            Long id = row.getLong("id");
            Date date = row.getDate("writeoffdate");
            Long costAccount = row.getLong("costaccount");
            DynamicObject period = PeriodHelper.getPeriodByDate((Date)date, (Long)costAccount);
            list.add(new Object[]{period.getLong("id"), id});
        }
        if (list.isEmpty()) {
            return;
        }
        String sql = "update t_cal_calcostrecord set fwriteoffperiodid = ? where fid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, list);
    }

    private void audit(String entity, Set<Long> needAuditBillIds) {
        if (needAuditBillIds.isEmpty()) {
            return;
        }
        DynamicObject[] simpleBillDycs = new SyncSimpleDycHelper().getSimpleBillDycs(entity, needAuditBillIds);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doServiceSync", (Object[])new Object[]{"AUDIT", null, simpleBillDycs});
    }

    private void recordOpLog(String opName) {
        String billNoStr;
        Object dateStart = this.getModel().getDataEntity().get("daterange_startdate");
        Object dateEnd = this.getModel().getDataEntity().get("daterange_enddate");
        Object batchQty = this.getModel().getValue("batchqty");
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org");
        long orgId = 0L;
        String orgName = "";
        if (orgDyc != null) {
            orgId = (Long)orgDyc.getPkValue();
            orgName = orgDyc.getString("name");
        }
        if (StringUtils.isEmpty((String)(billNoStr = (String)this.getModel().getValue("billnos")))) {
            billNoStr = (String)this.getModel().getValue("billnos_tag");
        }
        DynamicObjectCollection entityObjects = (DynamicObjectCollection)this.getModel().getValue("bizentityobjects");
        HashSet<String> selEntitys = new HashSet<String>(entityObjects.size());
        if (entityObjects.size() > 0) {
            for (DynamicObject entityObject : entityObjects) {
                selEntitys.add(entityObject.getDynamicObject("fbasedataid").getString("name"));
            }
        }
        DynamicObjectCollection materialDycs = (DynamicObjectCollection)this.getModel().getValue("mulmaterials");
        HashSet<String> matNos = new HashSet<String>(materialDycs.size());
        if (materialDycs.size() > 0) {
            for (DynamicObject matDyc : materialDycs) {
                matNos.add(matDyc.getDynamicObject("fbasedataid").getString("number"));
            }
        }
        StringBuilder descriptionSb = new StringBuilder();
        descriptionSb.append(dateStart);
        descriptionSb.append("-");
        descriptionSb.append(dateEnd);
        descriptionSb.append("-");
        if (StringUtils.isNotEmpty((String)orgName)) {
            descriptionSb.append(orgName);
            descriptionSb.append("-");
        }
        if (selEntitys.size() > 0) {
            descriptionSb.append(selEntitys);
            descriptionSb.append("-");
        }
        if (StringUtils.isNotEmpty((String)billNoStr)) {
            descriptionSb.append(billNoStr);
            descriptionSb.append("-");
        }
        if (matNos.size() > 0) {
            descriptionSb.append(matNos);
            descriptionSb.append("-");
        }
        descriptionSb.append(batchQty);
        CalLogInfo logInfo = CalLogUtils.buildCalAppLog((String)EntityMetadataCache.getDataEntityType((String)"cal_businesslog").getName(), (String)opName, (String)descriptionSb.toString(), (long)orgId);
        CalLogUtils.addLog((CalLogInfo)logInfo);
    }
}

