/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.BillTreeBuildParameter;
import kd.fi.cal.common.helper.EntityParseHelper;

public class CalBillRulePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String F7_CALBILL = "calbill";
    private static final String F7_SOURCEBILL = "sourcebill";
    private static final String COLNAME_SOURCEFIELD = "sourcefield";
    private static final String COLNAME_SOURCEFIELDNAME = "sourcefieldname";
    private static final String COLNAME_CALFIELD = "calfield";
    private static final String COLNAME_CALFIELDNAME = "calfieldname";
    private static final String ENTRYNAME_FIELDMAP = "fieldmap";
    private static final String FILTERNAME_FILTERGRID = "filtergrid";
    private static final String[] unShowCalFields = new String[]{"bizbillid", "bizbillentryid", "bizentityobject", "bizdirection"};

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (F7_CALBILL.equals(key)) {
            this.calBillChanged();
        }
        if (F7_SOURCEBILL.equals(key)) {
            this.srcBillChanged();
        }
        if (COLNAME_SOURCEFIELDNAME.equals(key) && "".equals(this.getModel().getValue(COLNAME_SOURCEFIELDNAME))) {
            this.sourceFieldNameChanged();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, F7_CALBILL);
        this.addClickListeners(new String[]{COLNAME_SOURCEFIELDNAME});
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (F7_CALBILL.equals(key)) {
            QFilter qf = new QFilter("number", "in", (Object)new String[]{"cal_incalbill", "cal_outcalbill", "cal_initbill"});
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qf);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setOrderBy("dentityid");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        if (COLNAME_SOURCEFIELDNAME.equals(key)) {
            Object sourcebill = this.getModel().getValue(F7_SOURCEBILL);
            if (sourcebill == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5355", (String)"CalBillRulePlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            int row = this.getModel().getEntryCurrentRowIndex(ENTRYNAME_FIELDMAP);
            MainEntityType calMainType = this.getCalMainType();
            MainEntityType srcEntityType = this.getSrcEntityType();
            if (srcEntityType == null || calMainType == null) {
                return;
            }
            String calFieldValue = (String)this.getModel().getValue(COLNAME_CALFIELD, row);
            IDataEntityProperty calProperty = calMainType.findProperty(calFieldValue);
            if (calProperty == null) {
                return;
            }
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(srcEntityType, null, calProperty);
            parameter.setIncludePKField(true);
            TreeNode srcBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter[])new BillTreeBuildParameter[]{parameter});
            this.showSelectFieldForm(srcBillNode, COLNAME_SOURCEFIELDNAME);
        }
    }

    private MainEntityType getCalMainType() {
        DynamicObject calBill = this.getModel().getDataEntity().getDynamicObject(F7_CALBILL);
        if (calBill == null) {
            return null;
        }
        String calEntityTypeNumber = calBill.getString("number");
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)calEntityTypeNumber);
        return calEntityType;
    }

    private MainEntityType getSrcEntityType() {
        DynamicObject sourceBill = this.getModel().getDataEntity().getDynamicObject(F7_SOURCEBILL);
        if (sourceBill == null) {
            return null;
        }
        String srcEntityTypeNumber = sourceBill.getString("number");
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)srcEntityTypeNumber);
        return srcEntityType;
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cal_bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (COLNAME_SOURCEFIELDNAME.equals(sourceFldKey)) {
            MainEntityType mainType = this.getSrcEntityType();
            this.receiveSelectField(mainType, (String)returnData, ENTRYNAME_FIELDMAP, COLNAME_SOURCEFIELDNAME);
        }
    }

    private void receiveSelectField(MainEntityType mainType, String returnPropName, String entityKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        this.getModel().setValue(COLNAME_SOURCEFIELD, (Object)returnPropName, row);
        this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYNAME_FIELDMAP);
        if ("clear".equals(key)) {
            this.getModel().setValue(COLNAME_SOURCEFIELD, (Object)"", row);
            this.getModel().setValue(COLNAME_SOURCEFIELDNAME, (Object)"", row);
        }
        if ("save".equals(key)) {
            this.beforeSave();
        }
        if ("reloadcalbill".equals(key)) {
            this.reloadCalBill();
        }
    }

    private void reloadCalBill() {
        DynamicObject sourceBill = this.getModel().getDataEntity().getDynamicObject(F7_CALBILL);
        if (sourceBill == null) {
            return;
        }
        HashSet<String> oldCalFieldSet = new HashSet<String>(32);
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYNAME_FIELDMAP);
        for (int i = 0; i < coll.size(); ++i) {
            oldCalFieldSet.add((String)((DynamicObject)coll.get(i)).get(COLNAME_CALFIELD));
        }
        String srcEntityTypeNumber = sourceBill.getString("number");
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)srcEntityTypeNumber);
        this.getModel().beginInit();
        HashSet<String> allCalFieldSet = new HashSet<String>(16);
        for (Map.Entry entryItem : srcEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            for (IDataEntityProperty property : entityType.getFields().values()) {
                DynamicProperty prop = (DynamicProperty)property;
                if (this.getUnShowFieldSet().contains(prop.getName())) continue;
                if (!oldCalFieldSet.contains(prop.getName())) {
                    int row = this.getModel().createNewEntryRow(ENTRYNAME_FIELDMAP);
                    this.getModel().setValue(COLNAME_CALFIELDNAME, (Object)EntityParseHelper.buildPropFullCaption((IDataEntityProperty)property), row);
                    this.getModel().setValue(COLNAME_CALFIELD, (Object)prop.getName(), row);
                }
                allCalFieldSet.add(prop.getName());
            }
        }
        for (String oldField : oldCalFieldSet) {
            if (allCalFieldSet.contains(oldField)) continue;
            for (int i = 0; i < coll.size(); ++i) {
                if (!((DynamicObject)coll.get(i)).get(COLNAME_CALFIELD).equals(oldField)) continue;
                this.getModel().deleteEntryRow(ENTRYNAME_FIELDMAP, i);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYNAME_FIELDMAP);
    }

    private void beforeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().getDataEntity().set("filter_tag", (Object)filterString);
    }

    public void fillFilterGridFields() {
        MainEntityType srcMainType = this.getSrcEntityType();
        this.getView().setEnable(Boolean.TRUE, new String[]{FILTERNAME_FILTERGRID});
        if (srcMainType == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERNAME_FILTERGRID});
            return;
        }
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)srcMainType);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        filterGrid.setEntityNumber(srcMainType.getName());
        filterGrid.setFilterColumns(cols);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String filter = (String)this.getModel().getDataEntity().get("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
            filterGrid.SetValue(filterCondition);
        }
        DynamicObject calbillentity = (DynamicObject)this.getModel().getDataEntity().get(F7_CALBILL);
        DynamicObject sourcebillentity = (DynamicObject)this.getModel().getDataEntity().get(F7_SOURCEBILL);
        if (calbillentity != null) {
            EntityParseHelper.bindColNames((IDataModel)this.getModel(), (String)ENTRYNAME_FIELDMAP, (String)calbillentity.getString("id"), (String)COLNAME_CALFIELD, (String)COLNAME_CALFIELDNAME);
        }
        if (sourcebillentity != null) {
            EntityParseHelper.bindColNames((IDataModel)this.getModel(), (String)ENTRYNAME_FIELDMAP, (String)sourcebillentity.getString("id"), (String)COLNAME_SOURCEFIELD, (String)COLNAME_SOURCEFIELDNAME);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        filterGrid.SetValue(new FilterCondition());
        this.fillFilterGridFields();
    }

    private void srcBillChanged() {
        this.getModel().getDataEntity().set("filter_tag", null);
        int rowCount = this.getModel().getEntryRowCount(ENTRYNAME_FIELDMAP);
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(COLNAME_SOURCEFIELD, (Object)"", i);
            this.getModel().setValue(COLNAME_SOURCEFIELDNAME, (Object)"", i);
        }
        this.getView().updateView();
    }

    private void calBillChanged() {
        DynamicObject sourceBill = this.getModel().getDataEntity().getDynamicObject(F7_CALBILL);
        this.getModel().deleteEntryData(ENTRYNAME_FIELDMAP);
        if (sourceBill == null) {
            return;
        }
        String srcEntityTypeNumber = sourceBill.getString("number");
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)srcEntityTypeNumber);
        this.getModel().beginInit();
        for (Map.Entry entryItem : srcEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            for (IDataEntityProperty property : entityType.getFields().values()) {
                DynamicProperty prop = (DynamicProperty)property;
                if (this.getUnShowFieldSet().contains(prop.getName())) continue;
                int row = this.getModel().createNewEntryRow(ENTRYNAME_FIELDMAP);
                this.getModel().setValue(COLNAME_CALFIELDNAME, (Object)EntityParseHelper.buildPropFullCaption((IDataEntityProperty)property), row);
                this.getModel().setValue(COLNAME_CALFIELD, (Object)prop.getName(), row);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYNAME_FIELDMAP);
    }

    private Set<String> getUnShowFieldSet() {
        HashSet<String> set = new HashSet<String>(64);
        for (String s : unShowCalFields) {
            set.add(s);
        }
        return set;
    }

    private void sourceFieldNameChanged() {
        this.getModel().setValue(COLNAME_SOURCEFIELD, (Object)"");
    }
}

