/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConditionEdit;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.formula.excel.FormulaException;
import kd.bos.servicehelper.MetadataServiceHelper;

public class CalConditionEditUIPlugin
extends ConditionEdit {
    private static String ENTITYNUMBER = null;

    public void afterCreateNewData(EventObject e) {
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CRCondition formulaObj = (CRCondition)this.deserialize(conditonJson);
        this.setFormulaObj((CRFormula)formulaObj);
        ENTITYNUMBER = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        if (StringUtils.isBlank((CharSequence)ENTITYNUMBER)) {
            return;
        }
        this.initFilterCondition(ENTITYNUMBER);
        FilterCondition filterCondition = formulaObj.getFilterCondition();
        String filterJson = filterCondition == null ? SerializationUtils.toJsonString((Object)new FilterCondition()) : SerializationUtils.toJsonString((Object)filterCondition);
        if (!StringUtils.isBlank((CharSequence)filterJson)) {
            this.setDataFilter(filterJson);
        }
    }

    public void click(EventObject evt) {
        try {
            Control ctlSource = (Control)evt.getSource();
            if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
                this.checkOutEntry();
            } else {
                super.click(evt);
            }
        }
        catch (Throwable e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
    }

    private void checkOutEntry() {
        String conditonJson = "";
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.getFormulaObj(formulaObj);
        try {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%1$s", (String)"CalConditionEditUIPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return;
        }
        catch (Throwable exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%1$s", (String)"CalConditionEditUIPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), exp.getMessage()));
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
        this.getView().close();
    }

    private void initFilterCondition(String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl("ffiltergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView("ffiltergrid");
    }

    private void setDataFilter(String dataFilter) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)dataFilter, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.SetValue(filterCondition);
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        if (StringUtils.isBlank((CharSequence)ENTITYNUMBER)) {
            return tranExpr;
        }
        MainEntityType mainType = null;
        mainType = MetadataServiceHelper.getDataEntityType((String)ENTITYNUMBER);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            String[] arg9999 = new String[]{"", ""};
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"CalConditionEditUIPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }
}

