/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.formplugin.setting.CalSettingPlugin;

public class CalCostEstimateSettingPlugin
extends AbstractFormPlugin {
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_CLOSE = "btn_close";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initExpenseStandard();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_CLOSE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (BTN_SAVE.equals(key)) {
            this.saveSettings();
        } else if (BTN_CLOSE.equals(key)) {
            this.getView().close();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof ComboEdit && "esstandards".equals(((ComboEdit)source).getKey())) {
            this.esStandardsPostBack(e);
        }
    }

    protected void saveSettings() {
        IDataModel model = this.getModel();
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String newEsstandard = model.getValue("esstandards").toString();
        String oldEsstandard = setting.getString("esstandards");
        if (StringUtils.isNotBlank((CharSequence)oldEsstandard)) {
            String[] oldEsstandards = oldEsstandard.split(",");
            List<String> newEsstandardList = Arrays.asList(newEsstandard.split(","));
            QFilter esstandardFilter = QFilter.of((String)"1<>1", (Object[])new Object[0]);
            for (String old : oldEsstandards) {
                if (StringUtils.isBlank((CharSequence)old) || newEsstandardList.contains(old)) continue;
                esstandardFilter.or("expenseentity.estimatestandard", "=", (Object)old);
            }
            DynamicObjectCollection esstandardCol = QueryServiceHelper.query((String)"cal_costestimatebill", (String)"expenseentity.estimatestandard", (QFilter[])new QFilter[]{esstandardFilter}, null);
            if (esstandardCol.size() > 0) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)CalSettingPlugin.class.getName(), (String)"cal_costestimatebill", (String)"expenseentity.estimatestandard as estimatestandard", null, null);
                String[] groupByArrs = new String[]{"estimatestandard"};
                dataSet = dataSet.groupBy(groupByArrs).finish();
                ArrayList<String> allBillList = new ArrayList<String>(16);
                while (dataSet.hasNext()) {
                    String val = dataSet.next().getString("estimatestandard");
                    allBillList.add(val);
                }
                ArrayList<String> loserList = new ArrayList<String>();
                MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdetail");
                for (String s : allBillList) {
                    if (newEsstandardList.contains(s)) continue;
                    String loser = entitytype.getProperty(s).getDisplayName().toString();
                    loserList.add(loser);
                }
                if (!loserList.isEmpty()) {
                    String content = String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u53d6\u6d88\u7684\u52fe\u9009\u9879\u4ecd\u5728\u4f7f\u7528 ,\u8bf7\u4fdd\u7559: %1$s", (String)"CalCostEstimateSettingPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), ((Object)loserList).toString());
                    throw new KDBizException(content);
                }
            }
        }
        setting.set("esstandards", model.getValue("esstandards"));
        setting.set("expensebilltype", model.getValue("expensebilltype"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setting});
        IFormView view = this.getView();
        view.returnDataToParent((Object)Boolean.TRUE);
        view.close();
    }

    protected void initModel(EventObject e) {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        FormDataModel model = (FormDataModel)e.getSource();
        model.setValue("esstandards", setting.get("esstandards"));
        model.setValue("expensebilltype", setting.get("expensebilltype"));
    }

    protected void initExpenseStandard() {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdetail");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (!(pro instanceof AmountProp) && !(pro instanceof QtyProp)) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), pro.getName());
            items.add(item);
        }
        if (items.isEmpty()) {
            return;
        }
        ComboEdit co = (ComboEdit)this.getView().getControl("esstandards");
        co.setComboItems(items);
    }

    private void esStandardsPostBack(BeforeFieldPostBackEvent e) {
        String newDimension = (String)e.getValue();
        List<String> newEsstandardList = Arrays.asList(newDimension.split(","));
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String autoEsStandard = setting.getString("autoesstandard");
        if (!StringUtils.isEmpty((CharSequence)autoEsStandard) && !newEsstandardList.contains(autoEsStandard)) {
            e.setCancel(true);
            this.getView().updateView("esstandards");
            String loserStr = ((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)"cal_costdetail").getProperties().get((Object)autoEsStandard)).getDisplayName().getLocaleValue();
            String content = String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u53d6\u6d88\u7684\u52fe\u9009\u9879\u5728\u81ea\u52a8\u6682\u4f30\u5206\u644a\u6807\u51c6\u4e2d\u88ab\u4f7f\u7528\uff0c\u8bf7\u5148\u53d6\u6d88\u516c\u5171\u914d\u7f6e-\u300b\u81ea\u52a8\u6682\u4f30\u5206\u644a\u6807\u51c6\uff1a%1$s", (String)"CalCostEstimateSettingPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), loserStr);
            this.getView().showTipNotification(content);
        }
    }
}

