/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CalFilterConfigPlugin
extends AbstractFormPlugin {
    private static final String FILTERNAME_FILTERGRID = "filtergrid";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter formShowParameter = (BaseShowParameter)e.getFormShowParameter();
        BillOperationStatus formStatus = formShowParameter.getBillStatus();
        if (BillOperationStatus.VIEW.equals((Object)formStatus)) {
            formShowParameter.setBillStatus(BillOperationStatus.EDIT);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String filter = (String)this.getModel().getDataEntity().get("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        filterGrid.SetValue(new FilterCondition());
        this.fillFilterGridFields();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("entity".equals(key)) {
            this.srcBillChanged();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.beforeSave();
        }
    }

    public void fillFilterGridFields() {
        String entity = (String)this.getModel().getValue("entity_id");
        if (StringUtils.isEmpty((CharSequence)entity)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERNAME_FILTERGRID});
            return;
        }
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)entity);
        this.getView().setEnable(Boolean.TRUE, new String[]{FILTERNAME_FILTERGRID});
        if (srcMainType == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERNAME_FILTERGRID});
            return;
        }
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)srcMainType);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        filterGrid.setEntityNumber(srcMainType.getName());
        filterGrid.setFilterColumns(cols);
    }

    private void srcBillChanged() {
        this.getModel().getDataEntity().set("filter_tag", null);
        this.getView().updateView();
    }

    private void beforeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERNAME_FILTERGRID);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().getDataEntity().set("filter_tag", (Object)filterString);
    }
}

