/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalGroupDiffBillSettingPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDiffBillFields();
        this.refreshEntryFields();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("groupdims".equals(propertyName)) {
            this.setCsType(e);
            this.refreshEntryFields();
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        if (e.getItemKey().equals("bar_save")) {
            this.refreshEntryFields();
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            IDataModel model = this.getModel();
            DynamicObject bizentityObject = (DynamicObject)model.getValue("bizentityobject");
            HashSet<DynamicObject> orgDyms = new HashSet<DynamicObject>(16);
            DynamicObjectCollection orgEntrys = model.getEntryEntity("orgentry");
            if (orgEntrys != null && !orgEntrys.isEmpty()) {
                for (DynamicObject orgEntry : orgEntrys) {
                    DynamicObject org = orgEntry.getDynamicObject("org");
                    if (org == null) continue;
                    orgDyms.add(org);
                }
            }
            QFilter q = new QFilter("bizentityobject", "=", (Object)bizentityObject.getString("number"));
            q.and("bizType", "=", (Object)((String)model.getValue("biztype")));
            q.and("id", "!=", (Object)((Long)model.getValue("id")));
            DataSet infos = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_groupdiffbill_setting", (String)"orgentry.org as org", (QFilter[])q.toArray(), null);
            HashSet<Long> existOrgIds = new HashSet<Long>(16);
            boolean isExistEmptyEntry = false;
            for (Row row : infos) {
                Long existOrgId = row.getLong("org");
                if (existOrgId == null || existOrgId.compareTo(0L) == 0) {
                    isExistEmptyEntry = true;
                    continue;
                }
                existOrgIds.add(row.getLong("org"));
            }
            if (orgDyms.isEmpty()) {
                if (isExistEmptyEntry) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u201c%1$s\u201d\u4e0b\u9002\u7528\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u914d\u7f6e\u3002", (String)"CalGroupDiffBillSettingPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]), bizentityObject.getString("name")));
                    e.setCancel(true);
                }
                return;
            }
            if (existOrgIds.isEmpty()) {
                return;
            }
            StringBuilder orgNumBuild = new StringBuilder();
            for (DynamicObject orgDym : orgDyms) {
                if (!existOrgIds.contains(orgDym.getLong("id"))) continue;
                orgNumBuild.append(orgDym.getString("number"));
                orgNumBuild.append(',');
            }
            if (orgNumBuild.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u201c%1$s\u201d\u4e0b\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u914d\u7f6e\u3002", (String)"CalGroupDiffBillSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), bizentityObject.getString("name"), CommonUtils.trimComma((String)orgNumBuild.toString())));
                e.setCancel(true);
            }
        }
    }

    private void refreshEntryFields() {
        IDataModel model = this.getModel();
        model.deleteEntryData("entry");
        Object obj = model.getValue("groupdims");
        if (obj != null) {
            String groupDims = (String)obj;
            StringBuilder reBuildDims = new StringBuilder();
            for (String dim : groupDims.split(",")) {
                if ("".equals(dim) || "null".equals(dim)) continue;
                reBuildDims.append(dim);
                reBuildDims.append(',');
            }
            groupDims = reBuildDims.toString();
            if (!"".equals(groupDims)) {
                MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill");
                String[] groupDimArray = CommonUtils.trimComma((String)groupDims).split(",");
                model.batchCreateNewEntryRow("entry", groupDimArray.length);
                int i = 0;
                for (String groupDim : groupDimArray) {
                    model.setValue("groupfield", (Object)groupDim, i);
                    model.setValue("groupfieldname", (Object)entitytype.findProperty(groupDim).getDisplayName(), i);
                    ++i;
                }
            }
        }
        this.getView().updateView("entry");
    }

    private void initDiffBillFields() {
        ArrayList<String> list = new ArrayList<String>();
        List<ComboItem> items = this.getAdjustBillComBo(list);
        ComboEdit comBo = (ComboEdit)this.getView().getControl("groupdims");
        comBo.setComboItems(items);
    }

    private List<ComboItem> getAdjustBillComBo(List<String> list) {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        Set<String> hideFileds = this.getHideGroupfields();
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (hideFileds.contains(pro.getName()) || !(pro instanceof BasedataProp) && !(pro instanceof TextProp) && !(pro instanceof ComboProp)) continue;
            String proName = pro.getName();
            ComboItem item = new ComboItem(pro.getDisplayName(), proName);
            items.add(item);
        }
        EntityType entryentity = (EntityType)entitytype.getAllEntities().get("entryentity");
        for (IDataEntityProperty pro : entryentity.getProperties()) {
            if (hideFileds.contains(pro.getName()) || !(pro instanceof BasedataProp) && !(pro instanceof TextProp) && !(pro instanceof ComboProp) && !(pro instanceof BooleanProp)) continue;
            String proName = pro.getName();
            ComboItem item = new ComboItem(pro.getDisplayName(), proName);
            items.add(item);
        }
        return items;
    }

    private Set<String> getHideGroupfields() {
        HashSet<String> hideFileds = new HashSet<String>(16);
        hideFileds.add("billno");
        hideFileds.add("billstatus");
        hideFileds.add("creator");
        hideFileds.add("modifier");
        hideFileds.add("auditor");
        hideFileds.add("calorg");
        hideFileds.add("org");
        hideFileds.add("entrystatus");
        hideFileds.add("ecalstatus");
        hideFileds.add("calstatus");
        hideFileds.add("costdomainkey");
        hideFileds.add("invbillnum");
        hideFileds.add("srcbillnum");
        hideFileds.add("material");
        hideFileds.add("costaccount");
        hideFileds.add("subentryentity_json");
        hideFileds.add("biztype");
        hideFileds.add("vouchernum");
        hideFileds.add("lastupdateuser");
        hideFileds.add("createtype");
        hideFileds.add("currency");
        hideFileds.add("srcbilltype");
        hideFileds.add("invbizentityobject");
        hideFileds.add("srcbizentityobject");
        hideFileds.add("queuetype");
        hideFileds.add("period");
        hideFileds.add("billcretype");
        hideFileds.add("billsrctype");
        hideFileds.add("groupdiffbillid");
        hideFileds.add("groupdiffbillnum");
        hideFileds.add("noupdatecalfields");
        hideFileds.add("checkstrikeaccount");
        hideFileds.add("isupdatecost");
        hideFileds.add("isvoucher");
        return hideFileds;
    }

    private void setCsType(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        model.beginInit();
        ChangeData changeData = e.getChangeSet()[0];
        String newDims = String.valueOf(changeData.getNewValue());
        String oldDims = String.valueOf(changeData.getOldValue());
        if (oldDims.contains("custsupplier") && oldDims.contains("cstype")) {
            if (!newDims.contains("cstype")) {
                newDims = newDims.replace("custsupplier,", "");
            } else if (!newDims.contains("custsupplier")) {
                newDims = newDims.replace("cstype,", "");
            }
        } else if (newDims.contains("cstype")) {
            newDims = newDims + "custsupplier,";
        } else if (newDims.contains("custsupplier")) {
            newDims = newDims + "cstype,";
        }
        model.setDataChanged(false);
        if (",".equals(newDims)) {
            model.setValue("groupdims", null);
        } else {
            model.setValue("groupdims", (Object)newDims);
        }
        this.getView().updateView("groupdims");
        model.endInit();
    }
}

