/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;

public class CalLogReExecuteTask
extends AbstractTask {
    private String runningLogOverTime_param = "runninglogovertime";
    private String entity_param = "entity";
    private String errorType_param = "errortype";
    private String actionName_param = "actionname";
    private String day_param = "day";
    private String bookDate_day_param = "bookdateday";
    private String batch_param = "batch";
    private String retrytimes_param = "retrytimes";

    public void execute(RequestContext requestContext, Map<String, Object> arg) throws KDException {
        String dayStr;
        boolean isBizFinInt;
        String entity = (String)arg.get(this.entity_param);
        String runStatus = (String)arg.get(this.errorType_param);
        String actionName = (String)arg.get(this.actionName_param);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        runStatus = runStatus + "," + "2";
        filters.add(new QFilter("success", "in", (Object)runStatus.split(",")));
        if (StringUtils.isNotEmpty((CharSequence)actionName)) {
            filters.add(new QFilter("actionname", "in", (Object)actionName.split(",")));
        }
        if (isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005")) {
            filters.add(new QFilter("actionname", "not in", (Object)new String[]{ActionEnum.AUDIT.getValue(), ActionEnum.UN_AUDIT.getValue()}));
        }
        int day = (dayStr = (String)arg.get(this.day_param)) == null ? 7 : Integer.parseInt(dayStr);
        Calendar c = Calendar.getInstance();
        Date endDate = new Date();
        c.setTime(endDate);
        c.add(5, -day);
        Date startDate = c.getTime();
        QFilter dateFilter = new QFilter("exetime", ">=", (Object)startDate);
        dateFilter.and(new QFilter("exetime", "<=", (Object)endDate));
        filters.add(dateFilter);
        Boolean filterBookDate = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.REEXCUTE_LOG_FILTER_BOOKDATE);
        if (filterBookDate.booleanValue()) {
            String bookDateDayStr = (String)arg.get(this.bookDate_day_param);
            int bookDateDay = StringUtils.isEmpty((CharSequence)bookDateDayStr) ? 40 : Integer.parseInt(bookDateDayStr);
            Calendar bookDateCalendar = Calendar.getInstance();
            bookDateCalendar.setTime(endDate);
            bookDateCalendar.add(5, -bookDateDay);
            Date startBookDate = bookDateCalendar.getTime();
            QFilter bookDateFilter = new QFilter("bookdate", ">=", (Object)startBookDate);
            bookDateFilter.and(new QFilter("bookdate", "<=", (Object)endDate));
            filters.add(bookDateFilter);
        }
        int overTime = 50;
        String overTimeStr = (String)arg.get(this.runningLogOverTime_param);
        if (overTimeStr != null) {
            overTime = Integer.parseInt(overTimeStr);
        }
        String retryTimesStr = (String)arg.get(this.retrytimes_param);
        Integer realTimeRetryTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.SYNC_AUTO_RETRYTIMES);
        if (retryTimesStr != null) {
            int retryTimes = Integer.parseInt(retryTimesStr);
            realTimeRetryTimes = realTimeRetryTimes + retryTimes;
        }
        dateFilter.and(new QFilter("times", "<=", (Object)realTimeRetryTimes));
        Date curDate = TimeServiceHelper.now();
        String batchStr = (String)arg.get(this.batch_param);
        int batch = batchStr == null ? 100 : Integer.parseInt(batchStr);
        HashMap<Object, Date> runningLogIdExeTimeMap = new HashMap<Object, Date>(16);
        HashSet<Object> executeLogIds = new HashSet<Object>(batch);
        try (DataSet logDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"id,success,exetime", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : logDs) {
                Date exeTime = row.getDate("exetime");
                boolean isExpire = this.isExpire(curDate.getTime(), exeTime.getTime(), overTime);
                if ("2".equals(row.getString("success")) && isExpire) {
                    runningLogIdExeTimeMap.put(row.get("id"), exeTime);
                    continue;
                }
                executeLogIds.add(row.get("id"));
            }
        }
        this.batchExecute(entity, batch, executeLogIds, "excute");
        this.batchExecute(entity, batch, runningLogIdExeTimeMap.keySet(), "republish");
    }

    private void batchExecute(String entity, int batch, Set<Object> executeLogIds, String opKey) {
        HashSet<Object> tmpLogIds = new HashSet<Object>(batch);
        for (Object item : executeLogIds) {
            tmpLogIds.add(item);
            if (tmpLogIds.size() < batch) continue;
            this.execute(entity, tmpLogIds, opKey);
            tmpLogIds.clear();
        }
        if (tmpLogIds.size() > 0) {
            this.execute(entity, tmpLogIds, opKey);
        }
    }

    private void execute(String entity, Set<Object> executeLogIds, String opKey) {
        if (executeLogIds.size() < 1) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationServiceHelper.executeOperate((String)opKey, (String)entity, (Object[])executeLogIds.toArray(), (OperateOption)option);
    }

    private boolean isExpire(long curTime, Long exeTime, int expireTime) {
        if (exeTime == null) {
            return true;
        }
        return (curTime - exeTime) / 1000L / 60L >= (long)expireTime;
    }
}

