/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CalNewReqBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addF7Listener(this, "materials", "orderbills");
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        Long supplierId = (Long)paramMap.get("supplierid");
        Long orderId = (Long)paramMap.get("orderid");
        Object startDate = paramMap.get("startdate");
        Object endDate = paramMap.get("enddate");
        this.getModel().setValue("supplier", (Object)supplierId);
        this.getModel().setValue("orderbills", (Object)new Long[]{orderId});
        if (startDate != null && endDate != null) {
            this.getModel().setValue("startdate", startDate);
            this.getModel().setValue("enddate", endDate);
        }
        Date maxDate = (Date)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParams().get("maxdate")), Date.class);
        DateRangeEdit dateControl = (DateRangeEdit)this.getView().getControl("bookdate");
        dateControl.setMaxDate(maxDate);
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            if ("btncancel".equals(((Button)evt.getSource()).getKey())) {
                this.getView().close();
            } else if ("btnok".equals(((Button)evt.getSource()).getKey())) {
                Date startDate = (Date)this.getModel().getValue("startdate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                Long supplierId = (Long)this.getModel().getValue("supplier_id");
                HashSet<Long> orderIds = new HashSet<Long>(16);
                for (Object order : (DynamicObjectCollection)this.getModel().getValue("orderbills")) {
                    orderIds.add(order.getDynamicObject("fbasedataid").getLong("id"));
                }
                HashSet<Long> matIds = new HashSet<Long>(16);
                if (this.getModel().getValue("materials") != null) {
                    for (DynamicObject mat : (DynamicObjectCollection)this.getModel().getValue("materials")) {
                        matIds.add(mat.getDynamicObject("fbasedataid").getLong("id"));
                    }
                }
                HashSet<String> reqBillNos = new HashSet<String>(16);
                String billNoStr = (String)this.getModel().getValue("reqbillnos");
                if (StringUtils.isEmpty((String)billNoStr)) {
                    billNoStr = (String)this.getModel().getValue("reqbillnos_tag");
                }
                if (StringUtils.isNotEmpty((String)billNoStr)) {
                    reqBillNos.addAll(Arrays.asList(billNoStr.split("\\s+|[\\r\\n]+")));
                }
                QFilter reqBillQ = new QFilter("supplier", "=", (Object)supplierId);
                reqBillQ.and("bookdate", ">", (Object)startDate);
                reqBillQ.and("bookdate", "<=", (Object)endDate);
                reqBillQ.and("billstatus", "=", (Object)"C");
                reqBillQ.and("billentry.mainbillid", "in", orderIds);
                reqBillQ.and("billentry.osunverifybaseqty", ">", (Object)BigDecimal.ZERO);
                if (!matIds.isEmpty()) {
                    reqBillQ.and("billentry.material.masterid", "in", matIds);
                } else {
                    Object defaultMatIds = this.getView().getFormShowParameter().getCustomParams().get("matids");
                    reqBillQ.and("billentry.material.masterid", "in", defaultMatIds);
                }
                if (!reqBillNos.isEmpty()) {
                    reqBillQ.and("billno", "in", reqBillNos);
                }
                reqBillQ.and("billentry.id", "not in", this.getView().getFormShowParameter().getCustomParams().get("reqentryids"));
                DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"im_osmaterialreqoutbill", (String)"billno,billentry.id as entryid,id", (QFilter[])reqBillQ.toArray());
                if (reqBills.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u59d4\u5916\u91c7\u8d2d\u9886\u6599\u5355\u3002", (String)"CalNewReqBillPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap paramMap = new HashMap(16);
                HashSet<Long> reqBillEntryIds = new HashSet<Long>(16);
                HashSet<Long> reqBillIds = new HashSet<Long>(16);
                for (DynamicObject reqBill : reqBills) {
                    reqBillIds.add(reqBill.getLong("id"));
                    reqBillEntryIds.add(reqBill.getLong("entryid"));
                }
                paramMap.put("id", reqBillIds);
                paramMap.put("entryid", reqBillEntryIds);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(paramMap));
                this.getView().close();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("materials".equals(key)) {
            Object defaultMatIds = this.getView().getFormShowParameter().getCustomParams().get("matids");
            QFilter q = new QFilter("id", "in", defaultMatIds);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        } else if ("orderbills".equals(key)) {
            Long supplierId = (Long)this.getModel().getValue("supplier_id");
            QFilter q = new QFilter("providersupplier", "=", (Object)supplierId);
            Object startDate = this.getModel().getValue("startdate");
            Object endDate = this.getModel().getValue("enddate");
            if (startDate != null && endDate != null) {
                q.and("biztime", ">", startDate);
                q.and("biztime", "<=", endDate);
            }
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        Object newValue = data.getNewValue();
        switch (proName) {
            case "enddate": {
                if (newValue == null) {
                    return;
                }
                Date newDate = (Date)newValue;
                Date maxDate = (Date)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParams().get("maxdate")), Date.class);
                if (!newDate.after(maxDate)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u622a\u6b62\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5165\u5e93\u5355\u5f53\u524d\u671f\u95f4\u6700\u540e\u4e00\u5929[%1$s]\u3002", (String)"CalNewReqBillPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(maxDate)));
                this.getModel().beginInit();
                this.getModel().setValue("enddate", null);
                this.getModel().endInit();
                break;
            }
        }
    }
}

