/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.PermissionHelper;

public class CalPolicyQuickAddition
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addF7Listener(this, "glaccount");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("glaccount".equals(key)) {
            this.getModel().setValue("number", (Object)"");
            if (this.getModel().getValue("glaccount") == null) {
                return;
            }
            String accountNum = ((DynamicObject)this.getModel().getValue("glaccount")).getString("number");
            this.getModel().setValue("number", (Object)accountNum);
        }
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button) {
            if ("btncancel".equals(((Button)evt.getSource()).getKey())) {
                this.getView().close();
            } else if ("btnok".equals(((Button)evt.getSource()).getKey())) {
                String errMsg;
                String valMsg = this.doValidate();
                if (!StringUtils.isEmpty((String)valMsg)) {
                    this.getView().showTipNotification(valMsg);
                    return;
                }
                DynamicObject policyInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_bd_calpolicy");
                policyInfo.set("number", (Object)((String)this.getModel().getValue("number")));
                IDataEntityProperty nameProPerty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)"cal_bd_calpolicy").getAllFields().get("name");
                policyInfo.set(nameProPerty, this.getModel().getValue("name"));
                DynamicObject glAccountDym = (DynamicObject)this.getModel().getValue("glaccount");
                policyInfo.set("accounttable_id", (Object)glAccountDym.getDynamicObject("accounttable").getLong("id"));
                policyInfo.set("exratetable_id", (Object)glAccountDym.getDynamicObject("exratetable").getLong("id"));
                policyInfo.set("periodtype_id", (Object)glAccountDym.getDynamicObject("periodtype").getLong("id"));
                policyInfo.set("currency_id", (Object)glAccountDym.getDynamicObject("basecurrency").getLong("id"));
                policyInfo.set("convertmode", (Object)"A");
                policyInfo.set("enable", (Object)"1");
                policyInfo.set("status", (Object)"C");
                Date date = TimeServiceHelper.now();
                policyInfo.set("createtime", (Object)date);
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                policyInfo.set("creator_id", (Object)userId);
                policyInfo.set("calbycostelement", (Object)((Boolean)this.getModel().getValue("calbycostelement")));
                policyInfo.set("supporttaxamt", (Object)((Boolean)this.getModel().getValue("supporttaxamt")));
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cal_bd_calpolicy", (DynamicObject[])new DynamicObject[]{policyInfo}, (OperateOption)option);
                if (!result.isSuccess() && !StringUtils.isEmpty((String)(errMsg = result.getMessage()))) {
                    this.getView().showErrorNotification(errMsg);
                    return;
                }
                List errors = result.getAllErrorOrValidateInfo();
                if (!errors.isEmpty()) {
                    StringBuilder msg = new StringBuilder();
                    for (IOperateInfo error : errors) {
                        OperateInfo operror = (OperateInfo)error;
                        msg.append(operror.getMessage()).append('\n');
                    }
                    this.getView().showErrorNotification(msg.toString());
                } else {
                    this.getView().returnDataToParent((Object)"btnok");
                    this.getView().close();
                }
            }
        }
    }

    private String doValidate() {
        String number = (String)this.getModel().getValue("number");
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        QFilter q = new QFilter("number", "=", (Object)number);
        q.or("name", "=", (Object)name);
        boolean isSameNum = false;
        boolean isSameName = false;
        DataSet calPolicyDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_calpolicy", (String)"number,name", (QFilter[])q.toArray(), null);
        for (Row row : calPolicyDs) {
            String policyNum = row.getString("number");
            String policyName = row.getString("name");
            if (policyNum.equals(number)) {
                isSameNum = true;
            }
            if (!policyName.equals(name)) continue;
            isSameName = true;
        }
        String tips = null;
        if (isSameNum && isSameName) {
            tips = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\u5747\u5df2\u5b58\u5728\u3002", (String)"CalPolicyQuickAddition_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        } else if (isSameNum) {
            tips = String.format(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u503c \u201c%1$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"CalPolicyQuickAddition_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), number);
        } else if (isSameName) {
            tips = String.format(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c \u201c%1$s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"CalPolicyQuickAddition_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), name);
        }
        return tips;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Long userId;
        Boolean ishasPrm;
        String key = e.getProperty().getName();
        if ("glaccount".equals(key) && !(ishasPrm = Boolean.valueOf(PermissionHelper.ishasPerm((Long)(userId = Long.valueOf(RequestContext.get().getUserId())), (String)"gl_accountbook", (String)"47150e89000000ac"))).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u603b\u8d26\u4f1a\u8ba1\u8d26\u7c3f\u7684\u67e5\u8be2\u6743\u9650\uff0c\u4e0d\u80fd\u9009\u62e9\u603b\u8d26\u4f1a\u8ba1\u8d26\u7c3f\uff01", (String)"CalPolicyQuickAddition_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }
}

