/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;

public class CalSettingPlugin
extends AbstractFormPlugin
implements ClickListener {
    private String[] STORAGE_ORG_RELATION = new String[]{"storageorgunit"};
    private String[] WAREHOUSE_RELATION = new String[]{"storageorgunit", "warehouse"};
    private String[] LOCATION_RELATION = new String[]{"storageorgunit", "warehouse", "location"};
    private String[] OWNER_RELATION = new String[]{"owner", "ownertype"};
    private String[] STORAGE_ORG_REMOVE = new String[]{"storageorgunit", "warehouse", "location"};
    private String[] WAREHOUSE_REMOVE = new String[]{"warehouse", "location"};
    private String[] LOCATION_REMOVE = new String[]{"location"};
    private String GROUP_COL = "calgroupcols";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter params = (BaseShowParameter)e.getSource();
        params.setPkId((Object)683799445774680063L);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterBindData(EventObject e) {
        this.initExpenseStandard();
        this.initAutoEsStandard();
        this.initDivideBasisControl();
        this.initCalDimensionControl();
        this.initCostRecordExtFields();
        this.initCalGroupCols();
    }

    private void initCalGroupCols() {
        ArrayList<String> list = new ArrayList<String>();
        List<ComboItem> items = this.getCostRecordComBo(list);
        ComboEdit co = (ComboEdit)this.getView().getControl("calgroupcols");
        co.setComboItems(items);
    }

    private void initCostRecordExtFields() {
        ArrayList<String> list = new ArrayList<String>();
        List<ComboItem> items = this.getCostRecordComBo(list);
        ComboEdit co = (ComboEdit)this.getView().getControl("costrecordextcols");
        co.setComboItems(items);
    }

    private void initCalDimensionControl() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("assist");
        list.add("lot");
        List<ComboItem> items = this.getCalBalanceComBo(list);
        ComboEdit co = (ComboEdit)this.getView().getControl("caldimensioncols");
        co.setComboItems(items);
    }

    private void initDivideBasisControl() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("calorg");
        list.add("owner");
        list.add("storageorgunit");
        list.add("warehouse");
        list.add("location");
        List<ComboItem> items = this.getCalBalanceComBo(list);
        ComboEdit co = (ComboEdit)this.getView().getControl("dividebasiscols");
        co.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if ("caldimensioncols".equals(propertyName)) {
            this.doCalDimensionChanged(e);
        } else if ("esstandards".equals(propertyName)) {
            this.initAutoEsStandard();
        } else if ("calgroupcols".equals(propertyName)) {
            this.solveStorageAndOwnerInfo(e);
        }
    }

    private void solveStorageAndOwnerInfo(PropertyChangedArgs e) {
        String[] split;
        String groupColValue;
        Object groupCol = this.getModel().getValue(this.GROUP_COL);
        String string = groupColValue = groupCol == null ? "" : String.valueOf(groupCol);
        if (StringUtils.isEmpty((CharSequence)groupColValue)) {
            return;
        }
        HashSet<String> groupChooseValueList = new HashSet<String>(16);
        for (String s : split = groupColValue.split(",")) {
            if (StringUtils.isEmpty((CharSequence)s)) continue;
            groupChooseValueList.add(s);
        }
        List<String> currentRemove = this.removeInfo(e);
        this.addStorageInfo(groupChooseValueList);
        if (!currentRemove.isEmpty()) {
            this.removeStorageInfo(currentRemove, groupChooseValueList);
        }
        this.addOwnerInfo(groupChooseValueList);
        if (!currentRemove.isEmpty()) {
            this.removeOwnerInfo(currentRemove, groupChooseValueList);
        }
        String chosenGroupCol = this.getGroupColJson(groupChooseValueList);
        this.getModel().setValue(this.GROUP_COL, (Object)chosenGroupCol);
    }

    private String getGroupColJson(Collection<String> groupChooseValueList) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> groupChooseTmp = new ArrayList<String>(groupChooseValueList);
        for (int i = 0; i < groupChooseTmp.size(); ++i) {
            if (i == groupChooseTmp.size() - 1) {
                sb.append((String)groupChooseTmp.get(i));
                continue;
            }
            sb.append((String)groupChooseTmp.get(i)).append(",");
        }
        return sb.toString();
    }

    private void removeStorageInfo(List<String> currentRemove, Set<String> groupChooseValueList) {
        if (currentRemove.contains("storageorgunit") && !groupChooseValueList.contains("warehouse") && !groupChooseValueList.contains("location")) {
            List<String> storage = Stream.of(this.STORAGE_ORG_REMOVE).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, storage);
        }
        if (currentRemove.contains("warehouse") && !groupChooseValueList.contains("location")) {
            List<String> warehouse = Stream.of(this.WAREHOUSE_REMOVE).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, warehouse);
        }
        if (currentRemove.contains("location")) {
            List<String> location = Stream.of(this.LOCATION_REMOVE).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, location);
        }
    }

    private void addStorageInfo(Set<String> groupChooseValueList) {
        if (groupChooseValueList == null || groupChooseValueList.isEmpty()) {
            return;
        }
        if (groupChooseValueList.contains("storageorgunit")) {
            List<String> storage = Stream.of(this.STORAGE_ORG_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, storage);
        }
        if (groupChooseValueList.contains("warehouse")) {
            List<String> warehouse = Stream.of(this.WAREHOUSE_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, warehouse);
        }
        if (groupChooseValueList.contains("location")) {
            List<String> location = Stream.of(this.LOCATION_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, location);
        }
    }

    private void addOwnerInfo(Set<String> groupChooseValueList) {
        if (groupChooseValueList == null || groupChooseValueList.isEmpty()) {
            return;
        }
        if (groupChooseValueList.contains("owner") || groupChooseValueList.contains("ownertype")) {
            List<String> owner = Stream.of(this.OWNER_RELATION).collect(Collectors.toList());
            this.addChoose(groupChooseValueList, owner);
        }
    }

    private void removeOwnerInfo(List<String> currentRemove, Set<String> groupChooseValueList) {
        if (groupChooseValueList == null || groupChooseValueList.isEmpty()) {
            return;
        }
        if (currentRemove.contains("owner") || currentRemove.contains("ownertype")) {
            List<String> owner = Stream.of(this.OWNER_RELATION).collect(Collectors.toList());
            this.removeChoose(groupChooseValueList, owner);
        }
    }

    private void addChoose(Set<String> groupChooseValueList, List<String> waitAddColList) {
        if (waitAddColList == null || waitAddColList.isEmpty()) {
            return;
        }
        groupChooseValueList.addAll(waitAddColList);
    }

    private void removeChoose(Set<String> groupChooseValueList, List<String> waitDeleteColList) {
        if (waitDeleteColList.isEmpty()) {
            return;
        }
        groupChooseValueList.removeAll(waitDeleteColList);
    }

    private List<String> removeInfo(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        String oldvalue = (String)data.getOldValue();
        String newvalue = (String)data.getNewValue();
        if (oldvalue == null || newvalue == null) {
            return new ArrayList<String>(1);
        }
        String[] oldValue = oldvalue.split(",");
        String[] newValue = newvalue.split(",");
        ArrayList<String> oldList = new ArrayList<String>(Arrays.asList(oldValue));
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(newValue));
        newList.retainAll(oldList);
        oldList.removeAll(newList);
        return oldList;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof ComboEdit && "esstandards".equals(((ComboEdit)source).getKey())) {
            this.esStandardsPostBack(e);
        }
        if (!(source instanceof MulComboEdit)) {
            return;
        }
        MulComboEdit comboEdit = (MulComboEdit)source;
        String key = comboEdit.getFieldKey();
        if ("dividebasiscols".equals(key)) {
            String oldvalue = (String)this.getModel().getValue("dividebasiscols");
            String newvalue = (String)e.getValue();
            oldvalue = oldvalue == null ? "" : oldvalue;
            newvalue = newvalue == null ? "" : newvalue;
            String[] oldvalueArr = oldvalue.split(",");
            List<String> newvalueArr = Arrays.asList(newvalue.split(","));
            QFilter divFilter = new QFilter("1", "!=", (Object)1);
            for (String oldDiv : oldvalueArr) {
                if (!StringUtils.isNotEmpty((CharSequence)oldDiv) || newvalueArr.contains(oldDiv)) continue;
                divFilter.or("dividebasis", "like", (Object)("%" + oldDiv + "%"));
            }
            HashSet<String> divNames = new HashSet<String>(16);
            try (DataSet divDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_dividebasis", (String)"name", (QFilter[])divFilter.toArray(), null);){
                for (Row row : divDataSet) {
                    divNames.add(row.getString("name"));
                }
            }
            if (!divNames.isEmpty()) {
                e.setCancel(true);
                this.getView().updateView("dividebasiscols");
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5212\u5206\u4f9d\u636e\u53d6\u6d88\u7684\u52fe\u9009\u9879\u5728\u5212\u5206\u4f9d\u636e{0}\u4e2d\u88ab\u4f7f\u7528\uff0c\u8bf7\u5148\u5728\u5212\u5206\u4f9d\u636e\u5217\u8868\u5220\u9664\u540e\u518d\u53d6\u6d88\u52fe\u9009\u3002", (String)"CalSettingPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", divNames));
                this.getView().showTipNotification(msg);
            }
        }
    }

    private void doCalDimensionChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String newDimension = String.valueOf(changeData.getNewValue());
        String oldDimension = String.valueOf(changeData.getOldValue());
        if (StringUtils.isNotBlank((CharSequence)oldDimension) && oldDimension.length() > 2) {
            String[] oldDimensions = oldDimension.split(",");
            List<String> newDimensions = Arrays.asList(newDimension.split(","));
            QFilter dimensionFilter = new QFilter("1", "!=", (Object)1);
            for (String oldDim : oldDimensions) {
                if (StringUtils.isBlank((CharSequence)oldDim) || newDimensions.contains(oldDim)) continue;
                dimensionFilter.or("caldimension", "like", (Object)("%" + oldDim + "%"));
            }
            DynamicObjectCollection dimensionCol = QueryServiceHelper.query((String)"kd.fi.cal.formplugin.setting.CalSettingPlugin", (String)"cal_bd_caldimension", (String)"caldimension", (QFilter[])new QFilter[]{dimensionFilter}, null);
            if (dimensionCol.size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u53d6\u6d88\u7684\u52fe\u9009\u9879\u4ecd\u5728\u4f7f\u7528\uff0c\u8bf7\u5148\u5728\u6838\u7b97\u7ef4\u5ea6\u5217\u8868\u5220\u9664\u540e\u518d\u53d6\u6d88\u52fe\u9009\u3002", (String)"CalSettingPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<ComboItem> getCalBalanceComBo(final List<String> list) {
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)balanceEntity);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            String proName;
            if (!(pro instanceof BasedataProp) && !(pro instanceof TextProp) || "material".equals(proName = pro.getName()) || "calrange".equals(proName) || "caldimension".equals(proName) || "costaccount".equals(proName) || "periodid".equals(proName) || "seqnum".equals(proName) || "keycol".equals(proName) || "stocktype".equals(proName) || "currency".equals(proName) || "baseunit".equals(proName) || "costelement".equals(proName) || "costsubelement".equals(proName) || "accsys".equals(proName) || "calpolicy".equals(proName)) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), proName);
            items.add(item);
        }
        if (items.isEmpty()) {
            return items;
        }
        if (!list.isEmpty()) {
            items.sort(new Comparator<ComboItem>(){

                @Override
                public int compare(ComboItem o1, ComboItem o2) {
                    String name1 = o1.getValue();
                    String name2 = o2.getValue();
                    if (list.indexOf(name2) == -1 && list.indexOf(name1) >= 0) {
                        return -1;
                    }
                    if (list.indexOf(name1) == -1 && list.indexOf(name2) >= 0) {
                        return 1;
                    }
                    if (list.indexOf(name1) < list.indexOf(name2)) {
                        return -1;
                    }
                    if (list.indexOf(name1) > list.indexOf(name2)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        return items;
    }

    private List<ComboItem> getCostRecordComBo(List<String> list) {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            String proName;
            if (pro instanceof DecimalProp || pro instanceof UserProp || !(pro instanceof BasedataProp) && !(pro instanceof TextProp) && !(pro instanceof ComboProp) || "costcenterorg".equals(proName = pro.getName())) continue;
            ComboItem item = new ComboItem(pro.getDisplayName(), proName);
            items.add(item);
        }
        EntityType entryentity = (EntityType)entitytype.getAllEntities().get("entry");
        for (IDataEntityProperty pro : entryentity.getProperties()) {
            if (pro instanceof DecimalProp || !(pro instanceof BasedataProp) && !(pro instanceof TextProp) && !(pro instanceof ComboProp)) continue;
            String proName = pro.getName();
            ComboItem item = new ComboItem(pro.getDisplayName(), proName);
            items.add(item);
        }
        if (items.isEmpty()) {
            return items;
        }
        return items;
    }

    protected void initExpenseStandard() {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdetail");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (IDataEntityProperty pro : entitytype.getProperties()) {
            if (!(pro instanceof DecimalProp) && !(pro instanceof LongProp) && !(pro instanceof IntegerProp)) continue;
            LocaleString displayName = pro.getDisplayName();
            String name = pro.getName();
            if (displayName == null || "writeoffid".equals(name) || "bizbillentryid".equals(name) || "calentryid".equals(name)) continue;
            ComboItem item = new ComboItem(displayName, pro.getName());
            items.add(item);
        }
        if (items.isEmpty()) {
            return;
        }
        ComboEdit co = (ComboEdit)this.getView().getControl("esstandards");
        co.setComboItems(items);
    }

    private void esStandardsPostBack(BeforeFieldPostBackEvent e) {
        String newDimension = (String)e.getValue();
        List<String> newEsstandardList = Arrays.asList(newDimension.split(","));
        String autoEsStandard = (String)this.getModel().getValue("autoesstandard");
        if (!StringUtils.isEmpty((CharSequence)autoEsStandard) && !newEsstandardList.contains(autoEsStandard)) {
            e.setCancel(true);
            this.getView().updateView("esstandards");
            String loserStr = ((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)"cal_costdetail").getProperties().get((Object)autoEsStandard)).getDisplayName().getLocaleValue();
            String content = String.format(ResManager.loadKDString((String)"\u5206\u644a\u6807\u51c6\u53d6\u6d88\u7684\u52fe\u9009\u9879\u5728\u81ea\u52a8\u6682\u4f30\u5206\u644a\u6807\u51c6\u4e2d\u88ab\u4f7f\u7528\uff0c\u8bf7\u5148\u53d6\u6d88\u81ea\u52a8\u6682\u4f30\u5206\u644a\u6807\u51c6\uff1a%1$s", (String)"CalCostEstimateSettingPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]), loserStr);
            this.getView().showTipNotification(content);
        }
    }

    private void initAutoEsStandard() {
        ComboEdit co = (ComboEdit)this.getView().getControl("autoesstandard");
        if (co == null) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String esStandards = (String)this.getModel().getValue("esStandards");
        if (esStandards != null) {
            String[] esStandardArr = esStandards.split(",");
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cal_costdetail").getProperties();
            for (String esStandard : esStandardArr) {
                if (esStandard.isEmpty() || !properties.containsKey((Object)esStandard)) continue;
                ComboItem item = new ComboItem(((IDataEntityProperty)properties.get((Object)esStandard)).getDisplayName(), esStandard);
                items.add(item);
            }
        }
        co.setComboItems(items);
    }
}

