/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.bizfinint.BizFinIntHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.WriteOffServerHelper;

public class CalSyncRecordPlugin
extends AbstractListPlugin {
    private boolean isFirstInitFilterByMainPage = false;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isFirstInitFilterByMainPage = true;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (this.isFirstInitFilterByMainPage) {
            this.mainPageFilterInit(filterColumns);
            this.isFirstInitFilterByMainPage = false;
        }
    }

    private void mainPageFilterInit(List<FilterColumn> filterColumns) {
        for (int i = filterColumns.size() - 1; i >= 0; --i) {
            FilterColumn filterColumn = filterColumns.get(i);
            CommonFilterColumn schemeFilterColumn = (CommonFilterColumn)filterColumn;
            String schemeFilterColumnName = schemeFilterColumn.getFieldName();
            String defaultOrgId = null;
            if (!"org.name".equals(schemeFilterColumnName)) continue;
            List orgList = schemeFilterColumn.getComboItems();
            Long orgId = RequestContext.get().getOrgId();
            if (orgId == null || orgId == 0L) {
                return;
            }
            boolean notContains = true;
            for (ComboItem comboItem : orgList) {
                String id = comboItem.getValue();
                if (defaultOrgId == null) {
                    defaultOrgId = String.valueOf(id);
                }
                if (!orgId.toString().equals(id)) continue;
                notContains = false;
                defaultOrgId = orgId.toString();
                break;
            }
            if (notContains) {
                ComboItem comboItem;
                DynamicObject org;
                List orgIds = PermissionHelper.getUserPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)((ListView)this.getView()).getBillFormId(), (String)"47150e89000000ac");
                if (orgIds != null && orgIds.contains(RequestContext.get().getOrgId())) {
                    org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
                    comboItem = new ComboItem(new LocaleString(org.getString("name")), orgId.toString());
                    orgList.add(comboItem);
                    schemeFilterColumn.setComboItems(orgList);
                    defaultOrgId = String.valueOf(RequestContext.get().getOrgId());
                }
                if (orgIds == null) {
                    org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
                    comboItem = new ComboItem(new LocaleString(org.getString("name")), orgId.toString());
                    orgList.add(comboItem);
                    schemeFilterColumn.setComboItems(orgList);
                    defaultOrgId = orgId.toString();
                }
            }
            if (defaultOrgId == null) continue;
            schemeFilterColumn.setDefaultValue(defaultOrgId);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("bizbillnumber")) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkId = billList.getFocusRowPkId();
            args.setCancel(true);
            String entityName = ((ListView)this.getView()).getBillFormId();
            DynamicObject selectRowEntry = QueryServiceHelper.queryOne((String)entityName, (String)"bizentityobject,bizbillid,org", (QFilter[])new QFilter("id", "=", pkId).toArray());
            if (selectRowEntry == null) {
                return;
            }
            Long bizbillId = selectRowEntry.getLong("bizbillid");
            String formId = selectRowEntry.getString("bizentityobject");
            if (bizbillId == null || formId == null) {
                return;
            }
            if ("ap_verifyrecord".equals(formId) || "ar_verifyrecord".equals(formId) || "im_mdc_omwrfrecord".equals(formId) || "im_oswfrecord".equals(formId)) {
                Long orgId = selectRowEntry.getLong("org");
                formId = WriteOffServerHelper.getNewRecordEntityNum((Long)orgId, (String)formId);
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId(formId);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("id", "=", (Object)bizbillId));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.addLinkQueryPkId((Object)bizbillId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(formId);
                showParameter.setPkId((Object)bizbillId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("batchsync".equals(key)) {
            new BizFinIntHelper().checkBizFinIntParam();
            this.batchSync();
        } else if ("stopsyncbill".equals(key)) {
            this.isStopSyncbill(true);
        } else if ("startsyncbill".equals(key)) {
            this.isStopSyncbill(false);
        } else if ("closelog".equals(key)) {
            this.checkClose(e);
        } else if ("uncloselog".equals(key)) {
            this.checkAndUnClose(e);
        } else if ("stoplog".equals(key)) {
            this.stopLog(e);
        }
    }

    private void stopLog(AfterDoOperationEventArgs e) {
        DynamicObject[] synLogs;
        Object[] ids = this.getSelectedIds();
        if (ids.length == 0) {
            return;
        }
        DLockInfo lockInfo = DLock.getLockInfo((String)"fi-cal-billsynclock");
        if (lockInfo != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540e\u53f0\u540c\u6b65\u8fd8\u5728\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5237\u65b0\u6216\u7a0d\u5019\u91cd\u8bd5\u3002", (String)"CalSyncRecordPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        QFilter synLogQ = new QFilter("id", "in", (Object)ids);
        String entityName = ((ListView)this.getView()).getBillFormId();
        for (DynamicObject log : synLogs = BusinessDataServiceHelper.load((String)entityName, (String)"log,log_tag,success", (QFilter[])new QFilter[]{synLogQ})) {
            if ("2".equals(log.getString("success"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u8bb0\u5f55\u5b58\u5728\u8fd0\u884c\u72b6\u6001\u4e0d\u662f\u8fd0\u884c\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalSyncRecordPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        String logStr = ResManager.loadKDString((String)"\u540e\u53f0\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u6267\u884c\u3002", (String)"CalSyncRecordPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        for (DynamicObject log : synLogs) {
            log.set("success", (Object)"4");
            log.set("log", (Object)logStr);
            log.set("log_tag", (Object)logStr);
        }
        SaveServiceHelper.save((DynamicObject[])synLogs);
        this.getView().invokeOperation("refresh");
    }

    private void checkAndUnClose(AfterDoOperationEventArgs e) {
        DynamicObject[] synLogs;
        Object[] ids = this.getSelectedIds();
        if (ids.length == 0) {
            return;
        }
        String entityName = ((ListView)this.getView()).getBillFormId();
        for (DynamicObject log : synLogs = BusinessDataServiceHelper.load((String)entityName, (String)"isclose,closereason,success", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)})) {
            if (log.getBoolean("isclose") && "5".equals(log.getString("success"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u8bb0\u5f55\u5b58\u5728\u975e\u8b66\u544a\u7c7b\u6216\u662f\u5426\u5173\u95ed\u4e3a\u5426\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalSyncRecordPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject log : synLogs) {
            log.set("isclose", (Object)"0");
            log.set("closereason", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])synLogs);
        this.getView().invokeOperation("refresh");
    }

    private void checkClose(AfterDoOperationEventArgs e) {
        Object[] ids = this.getSelectedIds();
        if (ids.length == 0) {
            return;
        }
        String entityName = ((ListView)this.getView()).getBillFormId();
        DynamicObjectCollection synLogs = QueryServiceHelper.query((String)entityName, (String)"id,isclose,success", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        for (DynamicObject log : synLogs) {
            if (!log.getBoolean("isclose") && "5".equals(log.getString("success"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u8bb0\u5f55\u5b58\u5728\u975e\u8b66\u544a\u7c7b\u6216\u662f\u5426\u5173\u95ed\u4e3a\u662f\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalSyncRecordPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cal_closesynlogreason");
        parameter.setCustomParam("billIds", (Object)ids);
        parameter.setCustomParam("entityName", (Object)entityName);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closelog"));
        this.getView().showForm(parameter);
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return selectedRows.getPrimaryKeyValues();
    }

    private void isStopSyncbill(boolean isStopSync) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cal_syncbizbillset");
        parameter.setCustomParam("isstopsync", (Object)isStopSync);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (isStopSync) {
            parameter.setCaption(ResManager.loadKDString((String)"\u505c\u6b62\u670d\u52a1\u8bbe\u7f6e", (String)"CalSyncRecordPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u542f\u52a8\u670d\u52a1\u8bbe\u7f6e", (String)"CalSyncRecordPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(parameter);
    }

    private void batchSync() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cal_syncpanel");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "syncpanel"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("syncpanel".equals(sourceFldKey)) {
            if ("btnok".equals(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u7533\u8bf7\u5df2\u6392\u961f\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8bb0\u5f55\u8ddf\u8e2a\u3002", (String)"CalSyncRecordPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        } else if ("closelog".equals(sourceFldKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

