/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.out.FIFOPeriodDataCalculate;
import kd.fi.cal.common.util.CommonUtils;

public class CalSystemCtrlConfirmListPlugin
extends AbstractFormPlugin {
    private static final String CONFIRM_SUCCESS = "confirm_success";
    private static final String CONFIRM_FAIL = "confirm_fail";
    private static final String CONFIRM_FAIL_DATA = "confirm_fail_data";
    private static final String CONFIRM_FAIL_DETAIL = "confirm_fail_detail";
    private static final String RESULT_PAGE_SUCCESS = "cal_calperiod_success";
    private static final String RESULT_PAGE_PART_SUCCESS = "cal_calperiod_partsucc";
    private static final int BATCHSIZE = 1000;

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map showAList = (Map)customParams.get(CONFIRM_FAIL_DATA);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("calorg", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("ignoreexp", (DataType)DataType.BooleanType)});
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("calorg");
        fields.add("costaccount");
        fields.add("ignoreexp");
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        if (showAList != null && !showAList.isEmpty()) {
            for (Map.Entry entry : showAList.entrySet()) {
                Long orgId = Long.parseLong((String)entry.getKey());
                Map costAccountAndErrCode = (Map)entry.getValue();
                Long costAccountId = null;
                String errCode = null;
                for (Map.Entry costAccountAndErrCodeEntry : costAccountAndErrCode.entrySet()) {
                    costAccountId = Long.parseLong((String)costAccountAndErrCodeEntry.getKey());
                    errCode = (String)costAccountAndErrCodeEntry.getValue();
                }
                list.add(new Object[]{orgId, costAccountId, errCode});
            }
        }
        DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(list.iterator(), rowMeta);
        this.loadConfirmData(dataSet, fields);
    }

    private void loadConfirmData(DataSet dataSet, Set<String> fields) {
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getGroupTableValueSetter(fields);
        for (Row row : dataSet) {
            vs.addRow(this.getGroupVsRowArray(row, fields));
            int rowCount = vs.getCount();
            if (rowCount < 1000) continue;
            model.batchCreateNewEntryRow("entryentity", vs);
            vs = this.getGroupTableValueSetter(fields);
        }
        int rowCount = vs.getCount();
        if (rowCount != 0) {
            model.batchCreateNewEntryRow("entryentity", vs);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Object[] getGroupVsRowArray(Row row, Set<String> fieldsList) {
        Object[] result = new Object[fieldsList.size()];
        int index = 0;
        for (String field : fieldsList) {
            result[index++] = row.get(field);
        }
        return result;
    }

    private TableValueSetter getGroupTableValueSetter(Set<String> fields) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        this.getModel().deleteEntryData("entryentity");
        for (String field : fields) {
            vs.addField(field, new Object[0]);
        }
        return vs;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("batchselect".equals(itemKey)) {
            this.changeCheck(true);
        } else if ("batchclose".equals(itemKey)) {
            this.changeCheck(false);
        } else if ("btnok".equals(itemKey)) {
            this.confirmResult();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("confirmrs".equals(operateKey)) {
            this.confirmResult();
        }
    }

    private void changeCheck(boolean open) {
        DynamicObjectCollection checkEntry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject item : checkEntry) {
            item.set("ignoreexp", (Object)open);
        }
        this.getView().updateView("entryentity");
    }

    private void confirmResult() {
        String page;
        DynamicObjectCollection confirmEntry = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> confirmSucc = new HashSet<Long>(16);
        HashSet<Long> confirmFail = new HashSet<Long>(16);
        HashMap<String, Map<Integer, List<Object>>> errInfoMap = new HashMap<String, Map<Integer, List<Object>>>(16);
        for (DynamicObject row : confirmEntry) {
            long costaccount = row.getDynamicObject("costaccount").getLong("id");
            long calorg = row.getDynamicObject("calorg").getLong("id");
            boolean ignoreExp = row.getBoolean("ignoreexp");
            if (ignoreExp) {
                confirmSucc.add(costaccount);
                continue;
            }
            confirmFail.add(costaccount);
            String errMsg = ResManager.loadKDString((String)"\u5bf9\u8d26\u4e0d\u5e73", (String)"CalSystemCtrlEditUIPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.putErrInfo(errInfoMap, calorg, costaccount, errMsg, 8, "cal_sysctrlentity", null);
        }
        HashMap<Long, DynamicObject> cacheCSIdAndCostAccount = new HashMap<Long, DynamicObject>(16);
        long curUserId = RequestContext.get().getCurrUserId();
        if (!errInfoMap.isEmpty()) {
            this.insertOrUpdateErrPeriodSettingLog(errInfoMap, curUserId);
        }
        if (!confirmSucc.isEmpty()) {
            this.insertOrIgnoreSuccPeriodSettingLog(confirmSucc, curUserId, cacheCSIdAndCostAccount);
            this.initFinish(confirmSucc);
            this.initBalance(confirmSucc);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List successCostAccounts = (List)customParams.get(CONFIRM_SUCCESS);
        List failCostAccounts = (List)customParams.get(CONFIRM_FAIL);
        String failDetail = (String)customParams.get(CONFIRM_FAIL_DETAIL);
        HashSet<Long> successCostAccount = new HashSet<Long>(successCostAccounts);
        HashSet<Long> failCostAccount = new HashSet<Long>(failCostAccounts);
        successCostAccount.addAll(confirmSucc);
        failCostAccount.addAll(confirmFail);
        String string = page = failCostAccount.isEmpty() ? RESULT_PAGE_SUCCESS : RESULT_PAGE_PART_SUCCESS;
        if (StringUtils.isEmpty((String)failDetail)) {
            failDetail = this.createErrDetail(errInfoMap, cacheCSIdAndCostAccount);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put(CONFIRM_SUCCESS, new ArrayList(successCostAccount));
        returnMap.put(CONFIRM_FAIL, new ArrayList(failCostAccount));
        returnMap.put("page", page);
        returnMap.put(CONFIRM_FAIL_DETAIL, failDetail);
        returnMap.put("confirm_operation", "confirm");
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    private void insertOrUpdateErrPeriodSettingLog(Map<String, Map<Integer, List<Object>>> errInfoMap, long curUserId) {
        HashSet<DynamicObject[]> orgIds = new HashSet<DynamicObject[]>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
            String orgAndCostAccount = entry.getKey();
            String[] orgIdAndCostAccountId = orgAndCostAccount.split("#");
            DynamicObject[] orgId = Long.valueOf(Long.parseLong(orgIdAndCostAccountId[0]));
            Long costAccountId = Long.parseLong(orgIdAndCostAccountId[1]);
            orgIds.add(orgId);
            costAccountIds.add(costAccountId);
        }
        HashMap<String, DynamicObject> existLogMap = new HashMap<String, DynamicObject>(16);
        if (!orgIds.isEmpty() || !costAccountIds.isEmpty()) {
            DynamicObject[] existLogs;
            QFilter costAccountFilter = new QFilter("costaccount", "in", costAccountIds);
            QFilter successFilter = new QFilter("issuccess", "=", (Object)"0");
            for (DynamicObject existLog : existLogs = BusinessDataServiceHelper.load((String)"cal_periodsettinglog", (String)"id,calorg,costaccount,operation,issuccess,operationtime,operationuser,log,log_tag,faillink,linkbillobject,linkids,linkids_tag,errortype", (QFilter[])new QFilter[]{costAccountFilter, successFilter}, null)) {
                long costAccountId = existLog.getDynamicObject("costaccount").getLong("id");
                Integer errorType = existLog.getInt("errortype");
                String key = costAccountId + "#" + errorType;
                existLogMap.put(key, existLog);
            }
        }
        ArrayList<DynamicObject> insert = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> update = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
            String orgAndCostAccount = entry.getKey();
            Map<Integer, List<Object>> info = entry.getValue();
            String[] orgIdAndCostAccountId = orgAndCostAccount.split("#");
            Long orgId = Long.parseLong(orgIdAndCostAccountId[0]);
            Long costAccountId = Long.parseLong(orgIdAndCostAccountId[1]);
            for (Map.Entry<Integer, List<Object>> errorTypeAndLogData : info.entrySet()) {
                int curErrorType;
                String content;
                String curLog;
                DynamicObject periodSettingLog;
                Integer errorType = errorTypeAndLogData.getKey();
                List<Object> logData = errorTypeAndLogData.getValue();
                String curKey = costAccountId + "#" + errorType;
                if (existLogMap.containsKey(curKey)) {
                    periodSettingLog = (DynamicObject)existLogMap.get(curKey);
                    periodSettingLog.set("operationtime", (Object)TimeServiceHelper.now());
                    periodSettingLog.set("operationuser", (Object)curUserId);
                    String string = curLog = logData.get(0) == null ? "" : (String)logData.get(0);
                    if (curLog.length() > 250) {
                        curLog = curLog.substring(0, 250);
                    }
                    periodSettingLog.set("log", (Object)curLog);
                    periodSettingLog.set("log_tag", logData.get(0));
                    periodSettingLog.set("linkbillobject", logData.get(1));
                    periodSettingLog.set("linkids_tag", logData.get(2));
                    content = "";
                    curErrorType = (Integer)logData.get(3);
                    if (8 != curErrorType) {
                        content = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CalSystemCtrlEditUIPlugin_28", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    }
                    periodSettingLog.set("faillink", (Object)content);
                    update.add(periodSettingLog);
                    continue;
                }
                periodSettingLog = BusinessDataServiceHelper.newDynamicObject((String)"cal_periodsettinglog");
                periodSettingLog.set("calorg", (Object)orgId);
                periodSettingLog.set("costaccount", (Object)costAccountId);
                periodSettingLog.set("operation", (Object)"1");
                periodSettingLog.set("issuccess", (Object)"0");
                periodSettingLog.set("operationtime", (Object)TimeServiceHelper.now());
                periodSettingLog.set("operationuser", (Object)curUserId);
                String string = curLog = logData.get(0) == null ? "" : (String)logData.get(0);
                if (curLog.length() > 250) {
                    curLog = curLog.substring(0, 250);
                }
                periodSettingLog.set("log", (Object)curLog);
                periodSettingLog.set("log_tag", logData.get(0));
                periodSettingLog.set("linkbillobject", logData.get(1));
                periodSettingLog.set("linkids_tag", logData.get(2));
                periodSettingLog.set("errortype", logData.get(3));
                content = "";
                curErrorType = (Integer)logData.get(3);
                if (8 != curErrorType) {
                    content = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CalSystemCtrlEditUIPlugin_28", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                }
                periodSettingLog.set("faillink", (Object)content);
                insert.add(periodSettingLog);
            }
        }
        SaveServiceHelper.save((DynamicObject[])insert.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])update.toArray(new DynamicObject[0]));
    }

    public void putErrInfo(Map<String, Map<Integer, List<Object>>> errInfoMap, Long orgId, Long costAccountId, String errMsg, int errorType, String linkObject, List<Object> linkIds) {
        String key = orgId + "#" + costAccountId;
        Map<Integer, List<Object>> errorTypeAndLogData = errInfoMap.get(key);
        if (errorTypeAndLogData == null) {
            errorTypeAndLogData = new HashMap<Integer, List<Object>>(16);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(errMsg);
            info.add(linkObject);
            info.add(linkIds);
            info.add(errorType);
            errorTypeAndLogData.put(errorType, info);
            errInfoMap.put(key, errorTypeAndLogData);
        } else {
            List<Object> logData = errorTypeAndLogData.get(errorType);
            logData.set(0, errMsg);
            logData.set(1, linkObject);
            logData.set(2, linkIds);
        }
    }

    private void insertOrIgnoreSuccPeriodSettingLog(Set<Long> successCostAccount, Long curUserId, Map<Long, DynamicObject> cacheCSIdAndCostAccount) {
        this.cacheCostAccountId(cacheCSIdAndCostAccount, successCostAccount);
        ArrayList<DynamicObject> succLogs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> existSucctLogs = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> existLogMap = new HashMap<String, DynamicObject>(16);
        QFilter costAccountFilter = new QFilter("costaccount", "in", successCostAccount);
        QFilter successFilter = new QFilter("issuccess", "=", (Object)"1");
        DynamicObject[] existLogs = BusinessDataServiceHelper.load((String)"cal_periodsettinglog", (String)"id,calorg,costaccount,operation,issuccess,operationtime,operationuser,log,log_tag,faillink,linkbillobject,linkids,linkids_tag,errortype", (QFilter[])new QFilter[]{costAccountFilter, successFilter}, null);
        for (DynamicObject existLog : existLogs) {
            long costAccountId = existLog.getDynamicObject("costaccount").getLong("id");
            Integer errorType = existLog.getInt("errortype");
            String key = costAccountId + "#" + errorType;
            existLogMap.put(key, existLog);
        }
        for (Long costAccountId : successCostAccount) {
            int operation = 0;
            String log = ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            String curKey = costAccountId + "#" + operation;
            if (existLogMap.containsKey(curKey)) {
                DynamicObject existLog = (DynamicObject)existLogMap.get(curKey);
                existLog.set("operationtime", (Object)TimeServiceHelper.now());
                existLog.set("operationuser", (Object)curUserId);
                existLog.set("log", (Object)log);
                existLog.set("log_tag", (Object)log);
                existSucctLogs.add(existLog);
                continue;
            }
            DynamicObject costAccountObject = cacheCSIdAndCostAccount.get(costAccountId);
            Long orgId = costAccountObject.getDynamicObject("calorg").getLong("id");
            DynamicObject periodSettingLog = BusinessDataServiceHelper.newDynamicObject((String)"cal_periodsettinglog");
            periodSettingLog.set("calorg", (Object)orgId);
            periodSettingLog.set("costaccount", (Object)costAccountId);
            periodSettingLog.set("operation", (Object)"1");
            periodSettingLog.set("issuccess", (Object)"1");
            periodSettingLog.set("operationtime", (Object)TimeServiceHelper.now());
            periodSettingLog.set("operationuser", (Object)curUserId);
            periodSettingLog.set("log", (Object)log);
            periodSettingLog.set("log_tag", (Object)log);
            periodSettingLog.set("linkbillobject", (Object)"");
            periodSettingLog.set("linkids", null);
            periodSettingLog.set("errortype", (Object)operation);
            periodSettingLog.set("faillink", (Object)"");
            succLogs.add(periodSettingLog);
        }
        SaveServiceHelper.save((DynamicObject[])succLogs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])existSucctLogs.toArray(new DynamicObject[0]));
    }

    private void cacheCostAccountId(Map<Long, DynamicObject> cacheCSIdAndCostAccount, Set<Long> selectedCostAccountIds) {
        if (!selectedCostAccountIds.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", selectedCostAccountIds);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject[] costAccountDynamic = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id,name,calorg,calorg.name,calsystem,calpolicy", (QFilter[])new QFilter[]{idFilter, enableFilter}, null);
            if (costAccountDynamic != null) {
                for (DynamicObject costAccountObject : costAccountDynamic) {
                    long id = costAccountObject.getLong("id");
                    cacheCSIdAndCostAccount.put(id, costAccountObject);
                }
            }
        }
    }

    private String createErrDetail(Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Long, DynamicObject> csIdAndCostAccount) {
        StringBuilder all = new StringBuilder();
        if (errInfoMap.isEmpty()) {
            return all.toString();
        }
        if (csIdAndCostAccount.isEmpty()) {
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
                String key = entry.getKey();
                String[] orgAndCostAccount = key.split("#");
                Long costAccountId = Long.parseLong(orgAndCostAccount[1]);
                costAccountIds.add(costAccountId);
            }
            this.cacheCostAccountId(csIdAndCostAccount, costAccountIds);
        }
        for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
            String key = entry.getKey();
            String[] orgAndCostAccount = key.split("#");
            Long costAccountId = Long.parseLong(orgAndCostAccount[1]);
            StringBuilder sb = new StringBuilder();
            Map<Integer, List<Object>> costAccountAndLog = entry.getValue();
            for (Map.Entry<Integer, List<Object>> costAccountAndLogEntry : costAccountAndLog.entrySet()) {
                List<Object> log = costAccountAndLogEntry.getValue();
                DynamicObject costAccountObject = csIdAndCostAccount.get(costAccountId);
                String costAccountName = costAccountObject.getString("name");
                String orgName = costAccountObject.getString("calorg.name");
                sb.append(orgName).append(costAccountName).append(log.get(0));
            }
            all.append((CharSequence)sb).append("\r\n");
        }
        return all.substring(0, all.length() - 2);
    }

    private void initBalance(Set<Long> costAccountIds) {
        if (!costAccountIds.isEmpty()) {
            for (Long costAccountId : costAccountIds) {
                new FIFOPeriodDataCalculate(costAccountId.longValue(), new HashSet(1)).calBeginData4EndInit();
            }
        }
    }

    private void initFinish(Set<Long> successCostAccount) {
        if (successCostAccount.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long costAccountId : successCostAccount) {
            params.add(new Object[]{costAccountId});
        }
        String sql = "update t_cal_systemctrlentry set fcurrentperiodid = fstartperiodid,fisenabled = '1' where fcostaccountid = ? ";
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, params);
    }
}

