/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.ReconciliationParam;
import kd.fi.cal.business.calculate.out.FIFOPeriodDataCalculate;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.BalanceDistinctValidatorHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.formplugin.setting.accountparams.ShowAccountParamsModifyViewHelper;

public class CalSystemCtrlEditUIPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        DynamicObject dbInfo = this.loadInfo();
        if (dbInfo == null) {
            String orgID = this.getCalOrgID();
            DynamicObjectCollection costAccountColl = this.getCostAccount(orgID);
            this.addEntrys(costAccountColl);
        } else {
            BillModel model = (BillModel)this.getModel();
            model.setPKValue(dbInfo.get("id"));
            model.load(dbInfo.get("id"));
        }
    }

    private String getCalOrgID() {
        if (this.getModel().getDataEntity().getDynamicObject("org") != null) {
            return this.getModel().getDataEntity().getDynamicObject("org").getPkValue().toString();
        }
        return "0";
    }

    public void registerListener(EventObject e) {
        BasedataEdit startperiod = (BasedataEdit)this.getControl("startperiod");
        startperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    private DynamicObject loadInfo() {
        String orgID = this.getCalOrgID();
        QFilter qs = new QFilter("org.id", "=", (Object)Long.valueOf(orgID));
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id", (QFilter[])new QFilter[]{qs});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String key = e.getItemKey();
        if ("btninit".equals(key) || "btnuninit".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            int[] indexs = entryGrid.getSelectRows();
            if (indexs == null || indexs.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"CalSystemCtrlEditUIPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        } else if ("bar_save".equals(key)) {
            Set<Object> notSetAccountParamsCostAccountIds;
            Object org = this.getModel().getValue("org");
            if (org != null) {
                Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
                int hasPermissin = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"10", (String)"/KIUHEXROK3D", (String)"cal_sysctrlentity", (String)"47156aff000000ac");
                if (hasPermissin == 0) {
                    return;
                }
            }
            if ((notSetAccountParamsCostAccountIds = this.getNotSetAccountParamsCostAccountIds()).isEmpty()) {
                String successMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_70", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(successMsg);
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_save", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9700\u8981\u8bbe\u7f6e\u8d26\u7c3f\u7ea7\u53c2\u6570\uff0c\u662f\u5426\u73b0\u5728\u8bbe\u7f6e\uff1f", (String)"CalSystemCtrlEditUIPlugin_68", (String)"fi-cal-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    public void afterBindData(EventObject e) {
        int rowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < rowCount; ++i) {
            Object isenabled = this.getModel().getValue("isenabled", i);
            if (!Boolean.parseBoolean(isenabled.toString())) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"startperiod"});
        }
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"org"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("startperiod".equals(key)) {
            this.startPeriodChanged(e);
        }
    }

    private void startPeriodChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject oldObject = (DynamicObject)changeSet[0].getOldValue();
        if (oldObject == null) {
            return;
        }
        DynamicObject entryEntity = changeSet[0].getDataEntity();
        DynamicObject costaccount = entryEntity.getDynamicObject("costaccount");
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        QFilter balanceStockFilter = new QFilter("calorg", "=", (Object)orgId);
        balanceStockFilter.and("costaccount", "=", costaccount.getPkValue());
        balanceStockFilter.and("period", "!=", (Object)0);
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        DynamicObjectCollection calBalanceCol = QueryServiceHelper.query((String)balanceEntity, (String)"id", (QFilter[])new QFilter[]{balanceStockFilter});
        if (calBalanceCol.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u5728\u6838\u7b97\u4f59\u989d\u8868\u5b58\u5728\u6536\u53d1\u6570\u636e\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u7528\u671f\u95f4\u3002", (String)"CalSystemCtrlEditUIPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        QFilter balanceInitFilter = new QFilter("calorg", "=", (Object)orgId);
        balanceInitFilter.and("costaccount", "=", costaccount.getPkValue());
        balanceInitFilter.and("period", "=", (Object)0);
        DynamicObjectCollection calBalanceInitCol = QueryServiceHelper.query((String)balanceEntity, (String)"id", (QFilter[])new QFilter[]{balanceInitFilter});
        if (calBalanceInitCol.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u5728\u6838\u7b97\u4f59\u989d\u8868\u5b58\u5728\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u518d\u4fee\u6539\u542f\u7528\u671f\u95f4\u3002", (String)"CalSystemCtrlEditUIPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if ("synaccount".equals(key)) {
            this.sysAccount();
        } else if ("edituiinit".equals(key)) {
            this.distinctValidator();
            this.doBizService();
        } else if ("edituiuninit".equals(key)) {
            this.initBalanceCheck(false);
            this.afterInitBalace(false);
        } else if ("save".equals(key) && e.getOperationResult().isSuccess()) {
            e.getOperationResult().setShowMessage(false);
        }
    }

    private void distinctValidator() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        int[] indexs = entryGrid.getSelectRows();
        if (indexs == null || indexs.length == 0) {
            return;
        }
        int indexLen = indexs.length;
        HashSet<Long> costAccountIds = new HashSet<Long>(indexLen);
        HashMap<Long, Long> costAcc2Period = new HashMap<Long, Long>(indexLen);
        for (int rowIndex : indexs) {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            Boolean isenabled = (Boolean)this.getModel().getValue("isenabled", rowIndex);
            DynamicObject period = (DynamicObject)this.getModel().getValue("startperiod", rowIndex);
            if (costaccount == null || isenabled.booleanValue() || period == null) continue;
            Long costaccountid = costaccount.getLong("id");
            costAccountIds.add(costaccountid);
            costAcc2Period.put(costaccountid, period.getLong("id"));
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B");
        statusFilter.or(new QFilter("billstatus", "=", (Object)"A"));
        QFilter cosAccPeriodFilter = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        for (Map.Entry entry : costAcc2Period.entrySet()) {
            QFilter filter = new QFilter("costaccount", "=", entry.getKey());
            filter.and("period", "=", entry.getValue());
            cosAccPeriodFilter.or(filter);
        }
        DynamicObjectCollection initCalColl = QueryServiceHelper.query((String)"cal_initbill", (String)"id,costaccount.name,period", (QFilter[])new QFilter[]{statusFilter, cosAccPeriodFilter});
        HashSet<String> verifyFailAcc = new HashSet<String>(8);
        for (Object initCal : initCalColl) {
            verifyFailAcc.add(initCal.getString("costaccount.name"));
        }
        if (!verifyFailAcc.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String costAccName : verifyFailAcc) {
                sb.append(costAccName).append(",");
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String costAcc = sb.toString();
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7:%1$s\u4e0b\u7684\u6210\u672c\u8d26\u7c3f%2$s\u5728\u542f\u7528\u671f\u95f4\u5185\u8fd8\u5b58\u5728\u672a\u5ba1\u6838\u72b6\u6001\u7684\u521d\u59cb\u6838\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_66", (String)"fi-cal-formplugin", (Object[])new Object[0]), org.getString("name"), costAcc.substring(0, costAcc.length() - 1));
            throw new KDBizException(errorMsg);
        }
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (!costAccountIds.isEmpty() && !isNewBalance) {
            BalanceDistinctValidatorHelper helper = new BalanceDistinctValidatorHelper(costAccountIds);
            helper.mergeDuplicateDimensions();
            helper.distinctValidator();
        }
    }

    private void doBizService() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgid = org.getLong("id");
        int[] indexs = entryGrid.getSelectRows();
        if (indexs == null || indexs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"CalSystemCtrlEditUIPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < indexs.length; ++i) {
            int rowIndex = indexs[i];
            DynamicObject period = (DynamicObject)this.getModel().getValue("startperiod", rowIndex);
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            Long costaccountid = costaccount.getLong("id");
            if (period == null) {
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u7684\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u672a\u7ef4\u62a4\u542f\u7528\u671f\u95f4\u4fe1\u606f\u3002", (String)"CalSystemCtrlEditUIPlugin_67", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(msg, org.getString("name"), costaccount.getString("name")));
            }
            Long periodid = period.getLong("id");
            ReconciliationParam param = new ReconciliationParam();
            param.setPeriodId(periodid);
            param.setAppNumber("cal");
            param.setBizBookId(costaccountid);
            param.setOrgId(orgid);
            param.setInit(true);
            QFilter filter = new QFilter("costaccount", "=", (Object)costaccountid);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"cal_accountparams", (String)"endinitcheck,endcalinvcheck", (QFilter[])new QFilter[]{filter});
            if (dy == null) {
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u521d\u59cb\u5316>\u521d\u59cb\u5316\u914d\u7f6e>\u8d26\u7c3f\u7ea7\u53c2\u6570\u8bbe\u7f6e\u201d\u754c\u9762\uff0c\u914d\u7f6e\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u7684\u5bf9\u5e94\u53c2\u6570\u3002", (String)"CalSystemCtrlEditUIPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]), costaccount.getString("name"));
                throw new KDBizException(errorMsg);
            }
            if (dy.getString("endinitcheck").equals("B")) {
                this.conditionSix(costaccountid, orgid, dy.getString("endcalinvcheck"), costaccount.getString("name"), period);
                this.initBalanceCheck1(true, rowIndex);
                this.afterInitBalace1(true, rowIndex);
                continue;
            }
            this.conditionSix(costaccountid, orgid, dy.getString("endcalinvcheck"), costaccount.getString("name"), period);
            String code = "";
            String openParam = "";
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
            }
            catch (KDBizException e) {
                if (e.getArgs().length > 0) {
                    openParam = e.getArgs()[0].toString();
                }
                ErrorCode ec = e.getErrorCode();
                code = ec.getCode();
            }
            if ("2".equals(code)) {
                String endinitcheck = dy.getString("endinitcheck");
                if (endinitcheck.equals("A")) {
                    String loadKDString = ResManager.loadKDString((String)"\u5b58\u5728\u5bf9\u8d26\u4e0d\u5e73\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8fd8\u8981\u7ed3\u675f\u521d\u59cb\u5316\uff1f", (String)"CalSystemCtrlEditUIPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("callbackId", (IFormPlugin)this);
                    JSONObject json = new JSONObject();
                    json.put(String.valueOf(rowIndex), (Object)openParam);
                    this.getView().showConfirm(loadKDString, null, MessageBoxOptions.YesNo, null, callBackListener, null, SerializationUtils.toJsonString((Object)json));
                    continue;
                }
                if (!endinitcheck.equals("C")) continue;
                FormShowParameter parame = new FormShowParameter();
                parame.setFormId("frm_reconciliation_rst_fst");
                parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parame.setCustomParam("model", (Object)openParam);
                this.getView().showForm(parame);
                continue;
            }
            this.initBalanceCheck1(true, rowIndex);
            this.afterInitBalace1(true, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("callbackId")) {
            MessageBoxResult result = e.getResult();
            String customVaule = e.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            Set keySet = map.keySet();
            String index = "";
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String string;
                index = string = (String)iterator.next();
            }
            if (MessageBoxResult.No.equals((Object)result)) {
                FormShowParameter parame = new FormShowParameter();
                parame.setFormId("ai_reconciliation_rst_fst");
                parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parame.setCustomParam("model", map.get(index));
                this.getView().showForm(parame);
            } else {
                this.initBalanceCheck1(true, Integer.parseInt(index));
                this.afterInitBalace1(true, Integer.parseInt(index));
            }
        }
        String value = e.getResultValue();
        if (MessageBoxResult.Yes.name().equals(value)) {
            key = e.getCallBackId();
            if ("bar_save".equals(key)) {
                this.showBatchAddParamsView();
            }
        } else if (MessageBoxResult.Cancel.name().equals(value) && "bar_save".equals(key = e.getCallBackId())) {
            String successMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_70", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(successMsg);
        }
    }

    private void showBatchAddParamsView() {
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"/KIUHEXROK3D", (String)"cal_accountparams", (String)"47156aff000000ac");
        if (!hasPermission) {
            String successMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_70", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(successMsg);
            String failMsg = ResManager.loadKDString((String)"\u65e0\u201c\u8d26\u7c3f\u7ea7\u53c2\u6570\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"CalSystemCtrlEditUIPlugin_69", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(failMsg);
            return;
        }
        Set<Object> notSetAccountParamsCostAccountIds = this.getNotSetAccountParamsCostAccountIds();
        StringBuilder builder = new StringBuilder();
        for (Object id : notSetAccountParamsCostAccountIds) {
            builder.append(id);
            builder.append(",");
        }
        String caption = ResManager.loadKDString((String)"\u65b0\u589e", (String)"CalAccountParamsListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        ShowAccountParamsModifyViewHelper.showModifyView("batchadd", caption, builder.toString(), (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_70", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(msg);
    }

    private Set<Object> getNotSetAccountParamsCostAccountIds() {
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        for (DynamicObject entry : entrys) {
            DynamicObject costAccount = entry.getDynamicObject("costaccount");
            if (costAccount == null) continue;
            costAccountIds.add(costAccount.getPkValue());
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"cal_accountparams", (String)"costaccount", (QFilter[])new QFilter("costaccount", "in", costAccountIds).toArray());
        for (DynamicObject dynamicObject : col) {
            costAccountIds.remove(dynamicObject.get("costaccount"));
        }
        return costAccountIds;
    }

    private void afterInitBalace(boolean isInit) {
        boolean isEnable = !isInit;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        int[] indexs = entryGrid.getSelectRows();
        for (int i = 0; i < indexs.length; ++i) {
            int rowIndex = indexs[i];
            this.getView().setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"startperiod"});
            if (isInit) {
                this.getModel().setValue("currentperiod", this.getModel().getValue("startperiod", rowIndex), rowIndex);
                this.getView().updateView("currentperiod", rowIndex);
                continue;
            }
            this.getModel().setValue("currentperiod", null, rowIndex);
            this.getView().updateView("currentperiod", rowIndex);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cal_sysctrlentity", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
        result.setShowMessage(false);
    }

    private void afterInitBalace1(boolean isInit, int rowIndex) {
        boolean isEnable = !isInit;
        this.getView().setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"startperiod"});
        this.getModel().setValue("currentperiod", this.getModel().getValue("startperiod", rowIndex), rowIndex);
        this.getView().updateView("currentperiod", rowIndex);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cal_sysctrlentity", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
        result.setShowMessage(false);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
        new FIFOPeriodDataCalculate(costAccount.getLong("id"), new HashSet(1)).calBeginData4EndInit();
    }

    private void initBalanceCheck(boolean isInit) {
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8bb0\u5f55", (String)"CalSystemCtrlEditUIPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        int[] indexs = entryGrid.getSelectRows();
        if (indexs == null || indexs.length == 0) {
            return;
        }
        for (int i = 0; i < indexs.length; ++i) {
            DynamicObject startperiod;
            String content;
            int rowIndex = indexs[i];
            boolean isenabled = this.getModel().getEntryRowEntity("entry", rowIndex).getBoolean("isenabled");
            int row = rowIndex + 1;
            if (isInit && isenabled) {
                content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_34", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
                throw new KDBizException(content);
            }
            if (!isInit && !isenabled) {
                content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u672a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_31", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
                throw new KDBizException(content);
            }
            if (isInit) {
                startperiod = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("startperiod");
                if (startperiod == null) {
                    String content2 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
                    throw new KDBizException(content2);
                }
            } else if (!isInit) {
                startperiod = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("startperiod");
                DynamicObject currentperiod = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("currentperiod");
                if (currentperiod != null && !startperiod.getString("number").equals(currentperiod.getString("number"))) {
                    String content3 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_33", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
                    throw new KDBizException(content3);
                }
            }
            this.getModel().setValue("isenabled", (Object)isInit, rowIndex);
        }
    }

    private void initBalanceCheck1(boolean isInit, int rowIndex) {
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8bb0\u5f55", (String)"CalSystemCtrlEditUIPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        boolean isenabled = this.getModel().getEntryRowEntity("entry", rowIndex).getBoolean("isenabled");
        int row = rowIndex + 1;
        if (isInit && isenabled) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_34", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
            throw new KDBizException(content);
        }
        if (!isInit && !isenabled) {
            String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u672a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_31", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
            throw new KDBizException(content);
        }
        if (isInit) {
            DynamicObject startperiod = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("startperiod");
            if (startperiod == null) {
                String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_32", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
                throw new KDBizException(content);
            }
        } else if (!isInit) {
            DynamicObject startperiod = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("startperiod");
            DynamicObject currentperiod = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("currentperiod");
            if (currentperiod != null && !startperiod.getString("number").equals(currentperiod.getString("number"))) {
                String content = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bb0\u5f55\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_33", (String)"fi-cal-formplugin", (Object[])new Object[0]), row);
                throw new KDBizException(content);
            }
        }
        this.getModel().setValue("isenabled", (Object)isInit, rowIndex);
    }

    private void sysAccount() {
        String orgID = this.getCalOrgID();
        DynamicObjectCollection coll = this.getCostAccount(orgID);
        HashMap<String, String> accountMap = new HashMap<String, String>(16);
        HashSet<String> accountSet = new HashSet<String>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject info = (DynamicObject)coll.get(i);
            accountMap.put(info.get("id").toString(), info.get("calpolicy.id").toString());
            accountSet.add(info.get("id").toString());
        }
        Object infoID = this.getModel().getDataEntity().getPkValue();
        DynamicObject Info2 = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)"id,entry.costaccount,entry.startperiod,entry.currentperiod", (QFilter[])new QFilter[]{new QFilter("id", "=", infoID)});
        if (Info2 == null) {
            return;
        }
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        DynamicObjectCollection entrys = Info2.getDynamicObjectCollection("entry");
        for (int j = 0; j < entrys.size(); ++j) {
            DynamicObject entry = (DynamicObject)entrys.get(j);
            if (entry.get("costaccount") == null || entry.get("costaccount.id") == null) {
                removeList.add(j);
                continue;
            }
            String accountID = entry.get("costaccount.id").toString();
            if (!accountSet.contains(accountID.toString())) {
                removeList.add(j);
                continue;
            }
            accountSet.remove(accountID);
        }
        int[] delIndxe = new int[removeList.size()];
        for (int i = 0; i < delIndxe.length; ++i) {
            delIndxe[i] = (Integer)removeList.get(i);
        }
        this.getModel().deleteEntryRows("entry", delIndxe);
        for (String id : accountSet) {
            int rowIndex = this.getModel().createNewEntryRow("entry");
            this.getModel().setValue("costaccount", (Object)id, rowIndex);
            this.getModel().setValue("calpolicy", accountMap.get(id), rowIndex);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"synaccount"});
    }

    private void addEntrys(DynamicObjectCollection costAccountColl) {
        IDataModel model = this.getModel();
        int costAccountCount = costAccountColl.size();
        if (costAccountCount == 0) {
            return;
        }
        int[] entryRows = model.batchCreateNewEntryRow("entry", costAccountCount);
        for (int i = 0; i < costAccountCount; ++i) {
            DynamicObject costAccountInfo = (DynamicObject)costAccountColl.get(i);
            model.setValue("costaccount", costAccountInfo.get("id"), entryRows[i]);
            model.setValue("calpolicy", costAccountInfo.get("calpolicy.id"), entryRows[i]);
        }
    }

    private DynamicObjectCollection getCostAccount(String orgID) {
        QFilter qs = new QFilter("calorg.id", "=", (Object)Long.valueOf(orgID));
        qs.and(new QFilter("enable", "=", (Object)"1"));
        return QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.id", (QFilter[])new QFilter[]{qs});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        int rowIndex = event.getRow();
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("startperiod".equals(sourceID)) {
            DynamicObject calpolicy = this.getModel().getEntryRowEntity("entry", rowIndex).getDynamicObject("calpolicy");
            if (calpolicy == null) {
                return;
            }
            Object periodTypeID = calpolicy.get("periodtype.id");
            QFilter qf = new QFilter("periodtype", "=", periodTypeID);
            showParameter.getListFilterParameter().setFilter(qf);
        }
    }

    private void conditionSix(Long costAccountId, Long orgId, String endcalinvcheck, String costAccountName, DynamicObject startPeriodDynamic) {
        DataSet ediffqty;
        List invOrgIds;
        boolean isNewPeriodInvBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        int periodNumber = 0;
        if (startPeriodDynamic != null) {
            Long startPeriodId = startPeriodDynamic.getLong("id");
            DynamicObject peirod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)startPeriodId).toArray());
            periodNumber = peirod.getInt("periodyear") * 100 + peirod.getInt("periodnumber");
        }
        invOrgIds = (invOrgIds = OrgHelper.getStorageOrgUnitByCalOrg((Long)orgId)) == null ? new ArrayList(0) : invOrgIds;
        List<Long> ownerIds = Arrays.asList(AccountingSysHelper.getOwners((Long)costAccountId));
        ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>();
        OrmInput invBgnQtyDataSet = this.getInvBgnQtyDataSet(invOrgIds, periodNumber, isNewPeriodInvBal, ownerIds);
        allBillIOs.add(invBgnQtyDataSet);
        if (!isNewBalance) {
            OrmInput calBalDataSet = this.getCalBalDataSet(invOrgIds, costAccountId, periodNumber, isNewBalance, ownerIds);
            allBillIOs.add(calBalDataSet);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
        unionDataSet.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
        unionDataSet.getRowMeta().getField("invqty").setDataType((DataType)DataType.BigDecimalType);
        unionDataSet.getRowMeta().getField("costaccount").setDataType((DataType)DataType.LongType);
        if (isNewBalance) {
            DataSet newCalBgnDs = this.getNewCalBgnDs(invOrgIds, costAccountId, periodNumber, ownerIds);
            newCalBgnDs.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
            newCalBgnDs.getRowMeta().getField("invqty").setDataType((DataType)DataType.BigDecimalType);
            newCalBgnDs.getRowMeta().getField("costaccount").setDataType((DataType)DataType.LongType);
            unionDataSet = unionDataSet.union(newCalBgnDs);
        }
        if (!(ediffqty = unionDataSet.groupBy(new String[]{"org", "material"}).sum("calqty - invqty", "ediffqty").finish().filter("ediffqty <> 0")).isEmpty() && !StringUtils.isEmpty((String)endcalinvcheck) && "C".equals(endcalinvcheck)) {
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u201c{0}\u201d\u5e93\u5b58\u4e0e\u6838\u7b97\u7684\u671f\u521d\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u67e5\u770b\u5e93\u5b58\u4e0e\u6838\u7b97\u5bf9\u6570\u62a5\u8868\u3002", (String)"CalSystemCtrlEditUIPlugin_72", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
            throw new KDBizException(errorMsg);
        }
    }

    protected DataSet getNewCalBgnDs(List<Long> invOrgIds, Long costAccount, int periodNumber, List<Long> ownerIds) {
        QFilter filter = new QFilter("storageorgunit", "in", invOrgIds);
        filter.and(new QFilter("owner", "in", ownerIds));
        QFilter periodf = new QFilter("period", "<", (Object)periodNumber);
        periodf.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        filter.and(periodf);
        filter.and(new QFilter("costaccount", "=", (Object)costAccount));
        String dimStr = CalBalanceModelHelper.getDimFields((boolean)false);
        String selects = dimStr + ",material.number,baseqty_bal,baseunit";
        DataSet calBalDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "getCalBgnDs"), (String)"cal_bal", (String)selects, (QFilter[])new QFilter[]{filter}, null);
        ArrayList<String> groupDims = new ArrayList<String>(Arrays.asList(dimStr.split(",")));
        groupDims.add("baseunit");
        groupDims.add("storageorgunit");
        String selectFields = "storageorgunit as org, material,0 as invqty,baseqty_bal as calqty,costaccount";
        calBalDs = calBalDs.groupBy(groupDims.toArray(new String[0])).max("baseqty_bal").finish().select(selectFields);
        return calBalDs;
    }

    protected OrmInput getInvBgnQtyDataSet(List<Long> invOrgIds, int periodNumber, boolean isNewPeriodBal, List<Long> ownerIds) {
        String selectFields = this.getInvBalanceSelector(isNewPeriodBal);
        QFilter filter = new QFilter("org", "in", invOrgIds);
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        filter.and(new QFilter("owner", "in", ownerIds));
        QFilter periodf = new QFilter("period", "<", (Object)periodNumber);
        periodf.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        filter.and(periodf);
        if (!isNewPeriodBal) {
            filter.and(new QFilter("balancetype", "=", (Object)"2"));
        }
        String entityName = "im_invbalance";
        if (isNewPeriodBal) {
            entityName = "im_cal_periodbalance";
        }
        OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + "getInvBalanceDataSet", entityName, selectFields, new QFilter[]{filter});
        return billIO;
    }

    private String getInvBalanceSelector(boolean isNewPeriodBal) {
        StringBuilder sb = new StringBuilder();
        sb.append("org,");
        sb.append("material,");
        if (isNewPeriodBal) {
            sb.append("baseqty_bal as invqty, 0 as calqty, 0L as costaccount");
        } else {
            sb.append("endbaseqty as invqty, 0 as calqty, 0L as costaccount");
        }
        return sb.toString();
    }

    protected OrmInput getCalBalDataSet(List<Long> invOrgIds, Long costAccount, int periodNumber, boolean isNewCalBal, List<Long> ownerIds) {
        String balTableName;
        QFilter filter = new QFilter("storageorgunit", "in", invOrgIds);
        filter.and("costaccount", "=", (Object)costAccount);
        filter.and(new QFilter("owner", "in", ownerIds));
        filter.and("period", "<", (Object)periodNumber);
        filter.and("endperiod", ">=", (Object)periodNumber);
        String curField = "storageorgunit as org, material,0 as invqty ";
        if (isNewCalBal) {
            balTableName = "cal_bal";
            curField = curField + ",baseqty_bal as calqty,costaccount";
        } else {
            balTableName = "cal_balance";
            curField = curField + ",periodendqty as calqty,costaccount";
        }
        RowMeta rowMeta = ORM.create().createRowMeta(balTableName, curField);
        rowMeta.getField("invqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("calqty").setDataType((DataType)DataType.BigDecimalType);
        OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName(), balTableName, curField, new QFilter[]{filter}, rowMeta);
        return billIO;
    }
}

