/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CalSystemCtrlListProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(CalSystemCtrlListProcessPlugin.class);
    private static final String BATCH_OPERATION = "system_edit_operation";
    private static final String BATCH_PROCESS_TITLE = "system_edit_processtitle";
    private static final String CONFIRM_PAGE = "cal_calperiod_confirm";
    private static final String RESULT_PAGE_SUCCESS = "cal_calperiod_success";
    private static final String RESULT_PAGE_PART_SUCCESS = "cal_calperiod_partsucc";
    private static final String CONFIRM_SUCCESS = "confirm_success";
    private static final String CONFIRM_FAIL = "confirm_fail";
    private static final String CONFIRM_FAIL_DATA = "confirm_fail_data";
    private static final String CONFIRM_FAIL_DETAIL = "confirm_fail_detail";
    private static final String CONFIRM_OPERATION = "confirm_operation";
    private static final String SYS_EXCEPTION = "cal_sys_exception";
    private static final String PROCESS_BAR = "progressbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROCESS_BAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROCESS_BAR);
        progressBar.start();
    }

    public void afterCreateNewData(EventObject e) {
        Map allParam = this.getView().getFormShowParameter().getCustomParams();
        Object title = allParam.get(BATCH_PROCESS_TITLE);
        if (title != null) {
            Label label = (Label)this.getControl("markword");
            label.setText(title.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("cancel".equals(key)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgress(ProgressEvent progressEvent) {
        IAppCache iAppCache = AppCache.get((String)"cal");
        String infoMsgKey = (String)iAppCache.get("CalSystemCtrlListUIPlugin_InfoMsgKey", String.class);
        logger.info("CalSystemCtrlListProcessPlugin redis key " + infoMsgKey);
        if (StringUtils.isEmpty((String)infoMsgKey)) {
            return;
        }
        Map allParam = (Map)iAppCache.get(infoMsgKey, Map.class);
        logger.info("CalSystemCtrlListProcessPlugin redis result" + allParam);
        String calSystemCtrlListError = (String)iAppCache.get("CalSystemCtrlList_error", String.class);
        if (progressEvent.getProgress() == 0) {
            progressEvent.setProgress(15);
        }
        if (!StringUtils.isEmpty((String)calSystemCtrlListError)) {
            HashMap<String, String> returnMap = new HashMap<String, String>(16);
            returnMap.put(CONFIRM_SUCCESS, null);
            returnMap.put(CONFIRM_FAIL, null);
            returnMap.put(CONFIRM_FAIL_DATA, null);
            returnMap.put("page", RESULT_PAGE_SUCCESS);
            returnMap.put(CONFIRM_FAIL_DETAIL, null);
            returnMap.put(CONFIRM_OPERATION, null);
            returnMap.put(SYS_EXCEPTION, calSystemCtrlListError);
            this.getView().returnDataToParent(returnMap);
            progressEvent.setProgress(100);
            this.getView().close();
            return;
        }
        if (allParam != null && !allParam.isEmpty() && (allParam.get(CONFIRM_SUCCESS) != null && !((List)allParam.get(CONFIRM_SUCCESS)).isEmpty() || allParam.get(CONFIRM_FAIL) != null && !((List)allParam.get(CONFIRM_FAIL)).isEmpty() || allParam.get(CONFIRM_FAIL_DETAIL) != null)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROCESS_BAR);
            progressEvent.setProgress(35);
            bar.stop();
            String curOperation = (String)allParam.get(BATCH_OPERATION);
            List successCostAccount = allParam.get(CONFIRM_SUCCESS) == null ? new ArrayList(16) : (List)allParam.get(CONFIRM_SUCCESS);
            List failCostAccount = allParam.get(CONFIRM_FAIL) == null ? new ArrayList(16) : (List)allParam.get(CONFIRM_FAIL);
            Map showAList = allParam.get(CONFIRM_FAIL_DATA) == null ? new HashMap(16) : (Map)allParam.get(CONFIRM_FAIL_DATA);
            String errDetail = allParam.get(CONFIRM_FAIL_DETAIL) == null ? "" : (String)allParam.get(CONFIRM_FAIL_DETAIL);
            try {
                progressEvent.setProgress(50);
                String page = !showAList.isEmpty() ? CONFIRM_PAGE : (failCostAccount.isEmpty() ? RESULT_PAGE_SUCCESS : RESULT_PAGE_PART_SUCCESS);
                HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
                returnMap.put(CONFIRM_SUCCESS, successCostAccount);
                returnMap.put(CONFIRM_FAIL, failCostAccount);
                returnMap.put(CONFIRM_FAIL_DATA, showAList);
                returnMap.put("page", page);
                returnMap.put(CONFIRM_FAIL_DETAIL, errDetail);
                returnMap.put(CONFIRM_OPERATION, curOperation);
                this.getView().returnDataToParent(returnMap);
                progressEvent.setProgress(100);
            }
            catch (Throwable e) {
                logger.error("systemctrlprocess-error : ", e);
                bar.stop();
            }
            finally {
                progressEvent.setProgress(100);
                this.getView().close();
            }
        }
    }
}

