/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.ReconciliationParam;
import kd.fi.cal.business.calculate.out.FIFOPeriodDataCalculate;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.BalanceDistinctValidatorHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.formplugin.setting.CalSystemCtrlHelper;
import kd.fi.cal.formplugin.setting.accountparams.ShowAccountParamsModifyViewHelper;

public class CalSystemCtrlListUIPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CalSystemCtrlListUIPlugin.class);
    private static final String PAGE_PARAM_FIRST_SNAPSHOT = CalSystemCtrlHelper.PAGE_PARAM_FIRST_SNAPSHOT;
    private static final String BATCH_SET_PAGE = "cal_calperiod_batchset";
    private static final String BATCH_PROCESS_PAGE = "cal_calperiod_progress";
    private static final String BATCH_OPERATION = "system_edit_operation";
    private static final String BATCH_PROCESS_TITLE = "system_edit_processtitle";
    private static final String ACTION_BATCH_SET = "system_edit_batch_set_call_back";
    private static final String ACTION_AFTER_INIT = "AFTER_INIT";
    private static final String ACTION_AFTER_UNINIT = "AFTER_UNINIT";
    private static final String ACTION_AFTER_CONFIRM = "AFTER_CONFIRM";
    private static final String CONFIRM_SUCCESS = "confirm_success";
    private static final String CONFIRM_FAIL = "confirm_fail";
    private static final String CONFIRM_FAIL_DATA = "confirm_fail_data";
    private static final String CONFIRM_FAIL_DETAIL = "confirm_fail_detail";
    private static final int SUCC_INIT = 0;
    private static final int SUCC_UNINIT = 1;
    private static final int ERROR_CONDITION_ONE = 2;
    private static final int ERROR_CONDITION_TWO = 3;
    private static final int ERROR_CONDITION_THREE_PRE = 4;
    private static final int ERROR_CONDITION_THREE_SUF = 5;
    private static final int ERROR_CONDITION_FOUR = 6;
    private static final int ERROR_CONDITION_FIVE = 7;
    private static final int ERROR_CONDITION_SIX = 8;
    private static final int ERROR_CONDITION_SEVEN = 9;
    private static final int ERROR_CONDITION_EIGHT = 10;
    private static final int ERROR_CONDITION_NINE = 11;
    private static final int ERROR_CONDITION_TEN = 12;
    private static final String CONFIRM_PAGE = "cal_calperiod_confirm";
    private static final String RESULT_PAGE_SUCCESS = "cal_calperiod_success";
    private static final String RESULT_PAGE_PART_SUCCESS = "cal_calperiod_partsucc";
    private static final String REDIS_KEY_PART_ONE = "redis_cal_systemctrl_key_one";
    public static final String NOT_SET_ACCOUNT_PARAMS_COST_ACCOUNT_IDS = "notSetAccountParamsCostAccountIds";
    private static final String SPFAIL = "SPFAIL";

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String key = event.getOperateKey();
        if ("batchset".equals(key)) {
            this.linkBatchSet(this.validateSet());
        } else if ("initbatch".equals(key)) {
            List<Object> selectedIds = this.getSelectedData();
            this.linkBatchInvoke("init", selectedIds);
        } else if ("uninitbatch".equals(key)) {
            List<Object> selectedIds = this.getSelectedData();
            this.linkBatchInvoke("uninit", selectedIds);
        } else if ("batchlog".equals(key)) {
            this.linkLog();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection selectedRows;
        Object[] indexs;
        String key = evt.getItemKey();
        if (("initbatch".equals(key) || "uninitbatch".equals(key)) && ((indexs = (selectedRows = this.getSelectedRows()).getPrimaryKeyValues()) == null || indexs.length == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"CalSystemCtrlEditUIPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private List<Object> getSelectedData() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] indexs = selectedRows.getPrimaryKeyValues();
        return Arrays.asList(indexs);
    }

    private void linkBatchSet(Set<Long> costAccountIds) {
        if (costAccountIds.isEmpty()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] indexs = selectedRows.getPrimaryKeyValues();
        showParameter.setAppId("cal");
        showParameter.setFormId(BATCH_SET_PAGE);
        showParameter.setCustomParam(PAGE_PARAM_FIRST_SNAPSHOT, costAccountIds);
        showParameter.setCustomParam("selected_or_not", (Object)(indexs != null && indexs.length != 0 ? 1 : 0));
        showParameter.setCaption(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u6279\u91cf\u8bbe\u7f6e", (String)"CalSystemCtrlEditUIPlugin_73", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_BATCH_SET));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "system_edit_batch_set_call_back": {
                List<Long> failCostAccountBatch;
                Map paramBatch = e.getReturnData() == null ? new HashMap(16) : (Map)e.getReturnData();
                String errMsgBatch = paramBatch.get("cal_calperiod_errmsg") == null ? "" : (String)paramBatch.get("cal_calperiod_errmsg");
                ArrayList<Long> successCostAccountBatch = paramBatch.get(CONFIRM_SUCCESS) == null ? new ArrayList(16) : (List)paramBatch.get(CONFIRM_SUCCESS);
                List list = failCostAccountBatch = paramBatch.get(CONFIRM_FAIL) == null ? new ArrayList(16) : (List)paramBatch.get(CONFIRM_FAIL);
                if (!failCostAccountBatch.isEmpty()) {
                    String page = RESULT_PAGE_PART_SUCCESS;
                    this.linkResultPage(successCostAccountBatch, failCostAccountBatch, page, errMsgBatch, "batchset");
                } else {
                    List costAccountIds = (List)paramBatch.get(CONFIRM_SUCCESS);
                    if (costAccountIds != null && !costAccountIds.isEmpty()) {
                        StringBuilder builder = new StringBuilder();
                        for (Object costAccountId : costAccountIds) {
                            builder.append(costAccountId);
                            builder.append(",");
                        }
                        this.getPageCache().put(NOT_SET_ACCOUNT_PARAMS_COST_ACCOUNT_IDS, builder.toString());
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("setAccountParams", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u9700\u8981\u8bbe\u7f6e\u8d26\u7c3f\u7ea7\u53c2\u6570\uff0c\u662f\u5426\u73b0\u5728\u8bbe\u7f6e\uff1f", (String)"CalSystemCtrlEditUIPlugin_68", (String)"fi-cal-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "cal_result_callback": {
                String errMsg;
                Map param = e.getReturnData() == null ? new HashMap(16) : (Map)e.getReturnData();
                List failCostAccountIds = param.get(CONFIRM_FAIL) == null ? new ArrayList(1) : (List)param.get(CONFIRM_FAIL);
                String operation = param.get("operation") == null ? "" : (String)param.get("operation");
                String string = errMsg = param.get("cal_calperiod_errmsg") == null ? "" : (String)param.get("cal_calperiod_errmsg");
                if ("batchset".equals(operation)) {
                    if (!StringUtils.isEmpty((String)errMsg)) {
                        String[] errorInfos = errMsg.split("\\r\\n");
                        OperationResult operationResult = new OperationResult();
                        for (String errorInfoMsg : errorInfos) {
                            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                            operateErrorInfo.setEntityKey(this.getView().getEntityId());
                            operateErrorInfo.setMessage(errorInfoMsg);
                            operateErrorInfo.setEntityKey("cal_periodsettinglog");
                            operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                            operateErrorInfo.setErrorCode("audit");
                            operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u6279\u91cf\u8bbe\u7f6e", (String)"CalSystemCtrlEditUIPlugin_54", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                            operationResult.addErrorInfo(operateErrorInfo);
                        }
                        FormShowParameter parameter = new FormShowParameter();
                        this.getPageCache().put("operationresult", DataEntitySerializer.serializerToString((Object)operationResult));
                        parameter.getOpenStyle().setTargetKey(actionId);
                        parameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
                        parameter.setStatus(OperationStatus.EDIT);
                        parameter.getOpenStyle().setShowType(ShowType.Modal);
                        parameter.setCustomParam("pkNumbers", new HashMap(16));
                        parameter.setFormId("ide_showoperationresult");
                        this.getView().showForm(parameter);
                    }
                } else if (!failCostAccountIds.isEmpty()) {
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setShowFilter(false);
                    showParameter.setShowQuickFilter(false);
                    LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                    HashSet<Long> pkIds = new HashSet<Long>(16);
                    DynamicObjectCollection errLogInfos = QueryServiceHelper.query((String)"cal_periodsettinglog", (String)"id", (QFilter[])new QFilter[]{new QFilter("costaccount", "in", failCostAccountIds)});
                    for (DynamicObject errLogInfo : errLogInfos) {
                        long id = errLogInfo.getLong("id");
                        if (id == 0L || !pkIds.add(id)) continue;
                        linkQueryPkIdCollection.addLinkQueryPkId((Object)id);
                    }
                    showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                    showParameter.setBillFormId("cal_periodsettinglog");
                    showParameter.setAppId("cal");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "AFTER_INIT": 
            case "AFTER_UNINIT": 
            case "AFTER_CONFIRM": {
                String sysException;
                Map returnData = e.getReturnData() == null ? new HashMap(16) : (Map)e.getReturnData();
                ArrayList<Long> successCostAccount = returnData.get(CONFIRM_SUCCESS) == null ? new ArrayList(16) : (List)returnData.get(CONFIRM_SUCCESS);
                ArrayList<Long> failCostAccount = returnData.get(CONFIRM_FAIL) == null ? new ArrayList(16) : (List)returnData.get(CONFIRM_FAIL);
                Map<Long, Map<Long, String>> showAList = returnData.get(CONFIRM_FAIL_DATA) == null ? new HashMap(16) : (Map)returnData.get(CONFIRM_FAIL_DATA);
                String page = returnData.get("page") == null ? "" : (String)returnData.get("page");
                String errDetail = returnData.get(CONFIRM_FAIL_DETAIL) == null ? "" : (String)returnData.get(CONFIRM_FAIL_DETAIL);
                String operationConfirm = returnData.get("confirm_operation") == null ? "" : (String)returnData.get("confirm_operation");
                String string = sysException = returnData.get("cal_sys_exception") == null ? "" : (String)returnData.get("cal_sys_exception");
                if (!StringUtils.isEmpty((String)sysException)) {
                    this.getView().showErrorNotification(sysException);
                    break;
                }
                if (!showAList.isEmpty()) {
                    this.linkShowConfirmPage(successCostAccount, failCostAccount, showAList, page, errDetail);
                    break;
                }
                if (!StringUtils.isEmpty((String)errDetail) && errDetail.contains(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u521d\u59cb\u5316\u5bf9\u8d26\u53c2\u6570\u3002", (String)"CalSystemCtrlEditUIPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]))) {
                    if (failCostAccount == null || failCostAccount.isEmpty()) break;
                    StringBuilder builder = new StringBuilder();
                    for (Object e2 : failCostAccount) {
                        builder.append(e2);
                        builder.append(",");
                    }
                    this.getPageCache().put(NOT_SET_ACCOUNT_PARAMS_COST_ACCOUNT_IDS, builder.toString());
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("setAccountParams", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9700\u8981\u8bbe\u7f6e\u8d26\u7c3f\u7ea7\u53c2\u6570\uff0c\u662f\u5426\u73b0\u5728\u8bbe\u7f6e\uff1f", (String)"CalSystemCtrlEditUIPlugin_68", (String)"fi-cal-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                this.linkResultPage(successCostAccount, failCostAccount, page, errDetail, operationConfirm);
                break;
            }
            case "batchadd": {
                String batchAddResult = e.getReturnData() == null ? "" : (String)e.getReturnData();
                String expectResult = ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"CalAccountParamsModifyPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                if (!expectResult.equals(batchAddResult)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7ea7\u53c2\u6570\u4fdd\u5b58\u6210\u529f", (String)"CalSystemCtrlEditUIPlugin_74", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void linkBatchInvoke(String operation, List<Object> selectedIds) {
        if (selectedIds.isEmpty()) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        String pageId = this.getView().getPageId();
        String key = currUserId + pageId + REDIS_KEY_PART_ONE;
        IAppCache iAppCache = AppCache.get((String)"cal");
        iAppCache.remove("CalSystemCtrlList_error");
        iAppCache.remove(key);
        ThreadPools.executeOnceIncludeRequestContext((String)(((Object)((Object)this)).getClass().getName() + "loadDataByFilter"), () -> {
            try {
                Map<String, Object> dataMap = this.doInit(selectedIds, operation);
                iAppCache.put(key, dataMap);
                iAppCache.put("CalSystemCtrlListUIPlugin_InfoMsgKey", (Object)key);
                logger.info("CalSystemCtrlList_start key " + key);
            }
            catch (Throwable e) {
                logger.error("\u6838\u7b97\u671f\u95f4\u6279\u91cf\u521d\u59cb\u5316\u5f02\u5e38", e);
                String message = e.getMessage();
                if (!StringUtils.isEmpty((String)message) && message.length() > 255) {
                    message = message.substring(0, 250);
                }
                iAppCache.put("CalSystemCtrlList_error", (Object)message);
                HashMap<String, String> returnMap = new HashMap<String, String>(16);
                returnMap.put(CONFIRM_SUCCESS, null);
                returnMap.put(CONFIRM_FAIL, null);
                returnMap.put(CONFIRM_FAIL_DATA, null);
                returnMap.put("page", CONFIRM_PAGE);
                returnMap.put(CONFIRM_FAIL_DETAIL, null);
                returnMap.put(BATCH_OPERATION, operation);
                iAppCache.put(key, returnMap);
            }
        });
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("cal");
        showParameter.setFormId(BATCH_PROCESS_PAGE);
        showParameter.setCustomParam("redis_cal_systemctrl_key_two", (Object)this.getView().getPageId());
        showParameter.setCustomParam(BATCH_PROCESS_TITLE, (Object)ResManager.loadKDString((String)"\u6b63\u5728\u68c0\u67e5\u57fa\u7840\u6761\u4ef6\u662f\u5426\u6ee1\u8db3\u3002", (String)"CalSystemCtrlEditUIPlugin_20", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String callBack = null;
        String title = "";
        if ("init".equals(operation)) {
            callBack = ACTION_AFTER_INIT;
            title = ResManager.loadKDString((String)"\u6279\u91cf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_21", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        } else if ("uninit".equals(operation)) {
            callBack = ACTION_AFTER_UNINIT;
            title = ResManager.loadKDString((String)"\u6279\u91cf\u53cd\u7ed3\u675f\u521d\u59cb\u5316", (String)"CalSystemCtrlEditUIPlugin_44", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        }
        showParameter.setCaption(title);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBack));
        this.getView().showForm(showParameter);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> doInit(List<Object> selectedIds, String operation) {
        void var17_21;
        String curOperation = operation;
        HashMap<Long, DynamicObject> csIdAndPeriodSetting = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> csIdAndCostAccount = new HashMap<Long, DynamicObject>(16);
        HashMap<String, Map<Integer, List<Object>>> errInfoMap = new HashMap<String, Map<Integer, List<Object>>>(16);
        HashMap<String, Map<Long, Map<Long, Long>>> markOrgAndCostAccountAndStartPeriod = new HashMap<String, Map<Long, Map<Long, Long>>>(16);
        HashSet<Long> uninitSuccCostAccountIds = new HashSet<Long>(16);
        HashMap<Integer, String> errNotificationMap = new HashMap<Integer, String>(16);
        errNotificationMap.put(2, ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4\u672a\u8bbe\u7f6e\u3002", (String)"CalSystemCtrlEditUIPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(3, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316", (String)"CalSystemCtrlEditUIPlugin_23", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(4, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u521d\u59cb\u6838\u7b97\u5355\u3002", (String)"CalSystemCtrlEditUIPlugin_24", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(5, ResManager.loadKDString((String)"\u7b49", (String)"CalSystemCtrlEditUIPlugin_25", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(6, ResManager.loadKDString((String)"\u5b58\u5728\u4f59\u989d\u8868\u540c\u4e00\u7ef4\u5ea6\u91cd\u590d\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u3002", (String)"CalSystemCtrlEditUIPlugin_26", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(7, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u521d\u59cb\u5316\u5bf9\u8d26\u53c2\u6570\u3002", (String)"CalSystemCtrlEditUIPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(12, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u521d\u59cb\u5316\u5bf9\u8d26\u53c2\u6570\u3002", (String)"CalSystemCtrlEditUIPlugin_27", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(8, ResManager.loadKDString((String)"\u5bf9\u8d26\u4e0d\u5e73", (String)"CalSystemCtrlEditUIPlugin_35", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(9, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u2260\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_36", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(10, ResManager.loadKDString((String)"\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u53cd\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlEditUIPlugin_43", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        errNotificationMap.put(11, ResManager.loadKDString((String)"\u5e93\u5b58\u4e0e\u6838\u7b97\u7684\u671f\u521d\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"CalSystemCtrlEditUIPlugin_71", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        long curUserId = RequestContext.get().getCurrUserId();
        HashMap<Long, Map<Long, String>> showAList = new HashMap<Long, Map<Long, String>>(16);
        HashSet<Long> successCostAccount = new HashSet<Long>(16);
        HashSet<Long> failCostAccount = new HashSet<Long>(16);
        HashMap<Long, Long> conditionSixFailCsIdOrgId = new HashMap<Long, Long>();
        if ("init".equals(curOperation)) {
            this.preInit(selectedIds, markOrgAndCostAccountAndStartPeriod, csIdAndPeriodSetting, csIdAndCostAccount, errInfoMap, errNotificationMap, conditionSixFailCsIdOrgId);
            for (Map.Entry entry : markOrgAndCostAccountAndStartPeriod.entrySet()) {
                String level = (String)entry.getKey();
                if ("B".equals(level)) {
                    for (Map.Entry orgAndCostAccountAndStartPeriod : ((Map)entry.getValue()).entrySet()) {
                        Map costAccountAndStartPeriod = (Map)orgAndCostAccountAndStartPeriod.getValue();
                        for (Map.Entry costAccountAndStartPeriodEntry : costAccountAndStartPeriod.entrySet()) {
                            Long costAccountId = (Long)costAccountAndStartPeriodEntry.getKey();
                            successCostAccount.add(costAccountId);
                        }
                    }
                    continue;
                }
                for (Map.Entry orgAndCostAccountAndStartPeriod : ((Map)entry.getValue()).entrySet()) {
                    Long orgId = (Long)orgAndCostAccountAndStartPeriod.getKey();
                    Map csMap = (Map)orgAndCostAccountAndStartPeriod.getValue();
                    for (Map.Entry csEntry : csMap.entrySet()) {
                        Long costAccountId = (Long)csEntry.getKey();
                        Long startPeriodId = (Long)csEntry.getValue();
                        String code = "";
                        try {
                            ReconciliationParam param = new ReconciliationParam();
                            param.setPeriodId(startPeriodId);
                            param.setAppNumber("cal");
                            param.setBizBookId(costAccountId);
                            param.setOrgId(orgId);
                            param.setInit(true);
                            DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
                        }
                        catch (KDBizException e) {
                            if (e.getArgs().length > 0) {
                                // empty if block
                            }
                            ErrorCode ec = e.getErrorCode();
                            code = ec.getCode();
                        }
                        if ("A".equals(level)) {
                            if ("2".equals(code)) {
                                this.putA(showAList, orgId, costAccountId, code);
                                continue;
                            }
                            successCostAccount.add(costAccountId);
                            continue;
                        }
                        if ("2".equals(code)) {
                            failCostAccount.add(costAccountId);
                            this.putErrInfo(errInfoMap, orgId, costAccountId, (String)errNotificationMap.get(8), 8, "cal_sysctrlentity", null);
                            continue;
                        }
                        successCostAccount.add(costAccountId);
                    }
                }
            }
        } else if ("uninit".equals(curOperation)) {
            this.preUninit(selectedIds, uninitSuccCostAccountIds, csIdAndCostAccount, errInfoMap, errNotificationMap);
            successCostAccount.addAll(uninitSuccCostAccountIds);
        }
        for (String string : errInfoMap.keySet()) {
            String[] orgAndCostAccount = string.split("#");
            long costAccountId = Long.parseLong(orgAndCostAccount[1]);
            failCostAccount.add(costAccountId);
        }
        String errDetail = this.createErrDetail(errInfoMap, csIdAndCostAccount);
        if (!errInfoMap.isEmpty()) {
            this.insertOrUpdateErrPeriodSettingLog(errInfoMap, curUserId, operation);
        }
        if (!successCostAccount.isEmpty()) {
            this.insertOrIgnoreSuccPeriodSettingLog(successCostAccount, csIdAndCostAccount, curUserId, curOperation);
        }
        if (!successCostAccount.isEmpty() && "init".equals(curOperation)) {
            this.initFinish(successCostAccount);
            this.initBalance(successCostAccount);
        }
        if ("uninit".equals(curOperation)) {
            // empty if block
        }
        if (!showAList.isEmpty()) {
            String string = CONFIRM_PAGE;
        } else {
            String string = failCostAccount.isEmpty() ? RESULT_PAGE_SUCCESS : RESULT_PAGE_PART_SUCCESS;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put(CONFIRM_SUCCESS, successCostAccount);
        returnMap.put(CONFIRM_FAIL, failCostAccount);
        returnMap.put(CONFIRM_FAIL_DATA, showAList);
        returnMap.put("page", var17_21);
        returnMap.put(CONFIRM_FAIL_DETAIL, errDetail);
        returnMap.put(BATCH_OPERATION, curOperation);
        returnMap.put(SPFAIL, !conditionSixFailCsIdOrgId.isEmpty());
        return returnMap;
    }

    private void initBalance(Set<Long> costAccountIds) {
        if (!costAccountIds.isEmpty()) {
            for (Long costAccountId : costAccountIds) {
                new FIFOPeriodDataCalculate(costAccountId.longValue(), new HashSet(1)).calBeginData4EndInit();
            }
        }
    }

    private void putA(Map<Long, Map<Long, String>> showAList, Long orgId, Long costAccountId, String code) {
        Map<Long, String> showACostAccounts = showAList.get(orgId);
        if (showACostAccounts == null) {
            showACostAccounts = new HashMap<Long, String>(16);
            showACostAccounts.put(costAccountId, code);
            showAList.put(orgId, showACostAccounts);
        } else {
            showACostAccounts.put(costAccountId, code);
        }
    }

    private void cacheCostAccountId(Map<Long, DynamicObject> cacheCSIdAndCostAccount, Set<Long> selectedCostAccountIds) {
        if (!selectedCostAccountIds.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", selectedCostAccountIds);
            DynamicObject[] costAccountDynamic = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id,name,calorg,calorg.name,calsystem,calpolicy", (QFilter[])new QFilter[]{idFilter}, null);
            if (costAccountDynamic != null) {
                for (DynamicObject costAccountObject : costAccountDynamic) {
                    long id = costAccountObject.getLong("id");
                    cacheCSIdAndCostAccount.put(id, costAccountObject);
                }
            }
        }
    }

    private void insertOrUpdateErrPeriodSettingLog(Map<String, Map<Integer, List<Object>>> errInfoMap, long curUserId, String operation) {
        HashSet<DynamicObject[]> orgIds = new HashSet<DynamicObject[]>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
            String orgAndCostAccount = entry.getKey();
            String[] orgIdAndCostAccountId = orgAndCostAccount.split("#");
            DynamicObject[] orgId = Long.valueOf(Long.parseLong(orgIdAndCostAccountId[0]));
            Long costAccountId = Long.parseLong(orgIdAndCostAccountId[1]);
            orgIds.add(orgId);
            costAccountIds.add(costAccountId);
        }
        HashMap<String, DynamicObject> existLogMap = new HashMap<String, DynamicObject>(16);
        if (!orgIds.isEmpty() || !costAccountIds.isEmpty()) {
            DynamicObject[] existLogs;
            QFilter costAccountFilter = new QFilter("costaccount", "in", costAccountIds);
            QFilter successFilter = new QFilter("issuccess", "=", (Object)"0");
            for (DynamicObject existLog : existLogs = BusinessDataServiceHelper.load((String)"cal_periodsettinglog", (String)"id,calorg,costaccount,operation,issuccess,operationtime,operationuser,log,log_tag,faillink,linkbillobject,linkids,linkids_tag,errortype", (QFilter[])new QFilter[]{costAccountFilter, successFilter}, null)) {
                long costAccountId = existLog.getDynamicObject("costaccount").getLong("id");
                Integer errorType = existLog.getInt("errortype");
                String key = costAccountId + "#" + errorType;
                existLogMap.put(key, existLog);
            }
        }
        ArrayList<DynamicObject> insert = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> update = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
            String orgAndCostAccount = entry.getKey();
            Map<Integer, List<Object>> info = entry.getValue();
            String[] orgIdAndCostAccountId = orgAndCostAccount.split("#");
            Long orgId = Long.parseLong(orgIdAndCostAccountId[0]);
            Long costAccountId = Long.parseLong(orgIdAndCostAccountId[1]);
            for (Map.Entry<Integer, List<Object>> errorTypeAndLogData : info.entrySet()) {
                String linkIds;
                String curLog;
                DynamicObject periodSettingLog;
                Integer errorType = errorTypeAndLogData.getKey();
                List<Object> logData = errorTypeAndLogData.getValue();
                String curKey = costAccountId + "#" + errorType;
                int operationCode = 0;
                switch (operation) {
                    case "init": {
                        operationCode = 1;
                        break;
                    }
                    case "uninit": {
                        operationCode = 2;
                    }
                }
                if (existLogMap.containsKey(curKey)) {
                    periodSettingLog = (DynamicObject)existLogMap.get(curKey);
                    periodSettingLog.set("operationtime", (Object)TimeServiceHelper.now());
                    periodSettingLog.set("operationuser", (Object)curUserId);
                    String string = curLog = logData.get(0) == null ? "" : (String)logData.get(0);
                    if (curLog.length() > 250) {
                        curLog = curLog.substring(0, 250);
                    }
                    periodSettingLog.set("log", (Object)curLog);
                    periodSettingLog.set("log_tag", logData.get(0));
                    periodSettingLog.set("linkbillobject", logData.get(1));
                    linkIds = logData.get(2) == null ? "" : SerializationUtils.toJsonString((Object)logData.get(2));
                    periodSettingLog.set("linkids_tag", (Object)linkIds);
                    periodSettingLog.set("errortype", logData.get(3));
                    periodSettingLog.set("operation", (Object)operationCode);
                    update.add(periodSettingLog);
                    continue;
                }
                periodSettingLog = BusinessDataServiceHelper.newDynamicObject((String)"cal_periodsettinglog");
                periodSettingLog.set("calorg", (Object)orgId);
                periodSettingLog.set("costaccount", (Object)costAccountId);
                periodSettingLog.set("issuccess", (Object)"0");
                periodSettingLog.set("operationtime", (Object)TimeServiceHelper.now());
                periodSettingLog.set("operationuser", (Object)curUserId);
                String string = curLog = logData.get(0) == null ? "" : (String)logData.get(0);
                if (curLog.length() > 250) {
                    curLog = curLog.substring(0, 250);
                }
                periodSettingLog.set("log", (Object)curLog);
                periodSettingLog.set("log_tag", logData.get(0));
                periodSettingLog.set("linkbillobject", logData.get(1));
                linkIds = logData.get(2) == null ? "" : SerializationUtils.toJsonString((Object)logData.get(2));
                periodSettingLog.set("linkids_tag", (Object)linkIds);
                periodSettingLog.set("errortype", logData.get(3));
                periodSettingLog.set("faillink", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CalSystemCtrlEditUIPlugin_28", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                periodSettingLog.set("operation", (Object)operationCode);
                insert.add(periodSettingLog);
            }
        }
        SaveServiceHelper.save((DynamicObject[])insert.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])update.toArray(new DynamicObject[0]));
    }

    private void conditionThree(Set<Long> selectedCostAccountIds, Map<Integer, String> errNotificationMap, Map<String, Map<Integer, List<Object>>> errInfoMap) {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"A");
        statusFilter.or(new QFilter("billstatus", "=", (Object)"B"));
        QFilter costAccountAndStartPeriodFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        if (!selectedCostAccountIds.isEmpty()) {
            costAccountAndStartPeriodFilter.and(new QFilter("costaccount", "in", selectedCostAccountIds));
        }
        HashMap<String, HashSet<String>> groupBillNoMap = new HashMap<String, HashSet<String>>(16);
        HashMap<String, HashSet<Long>> groupBillIdsMap = new HashMap<String, HashSet<Long>>(16);
        DynamicObjectCollection initCalColl = QueryServiceHelper.query((String)"cal_initbill", (String)"id,calorg,costaccount,costaccount.name,period,billno", (QFilter[])new QFilter[]{statusFilter, costAccountAndStartPeriodFilter});
        for (DynamicObject init : initCalColl) {
            Long id = init.getLong("id");
            Long orgId = init.getLong("calorg");
            Long costAccountId = init.getLong("costaccount");
            String billno = init.getString("billno");
            String key = orgId + "#" + costAccountId;
            HashSet<String> billNos = (HashSet<String>)groupBillNoMap.get(key);
            if (billNos == null) {
                billNos = new HashSet<String>(16);
                billNos.add(billno);
                groupBillNoMap.put(key, billNos);
            } else {
                billNos.add(billno);
            }
            HashSet<Long> initIds = (HashSet<Long>)groupBillIdsMap.get(key);
            if (initIds == null) {
                initIds = new HashSet<Long>(16);
                initIds.add(id);
                groupBillIdsMap.put(key, initIds);
                continue;
            }
            initIds.add(id);
        }
        for (Map.Entry entry : groupBillNoMap.entrySet()) {
            String orgAndCostAccount = (String)entry.getKey();
            Set billNos = (Set)entry.getValue();
            Long orgId = Long.parseLong(orgAndCostAccount.split("#")[0]);
            Long costAccountId = Long.parseLong(orgAndCostAccount.split("#")[1]);
            String errMsg = null;
            if (!billNos.isEmpty()) {
                String pre = errNotificationMap.get(4);
                String suffix = errNotificationMap.get(5);
                StringBuilder sb = new StringBuilder();
                for (String billNo : billNos) {
                    sb.append(billNo).append(",");
                }
                String content = sb.substring(0, sb.length() - 1);
                if (content.length() > 200) {
                    content = content.substring(0, 200);
                }
                errMsg = pre.concat(content).concat(suffix);
            }
            ArrayList<Object> initIds = new ArrayList<Object>((Collection)groupBillIdsMap.get(orgAndCostAccount));
            this.putErrInfo(errInfoMap, orgId, costAccountId, errMsg, 4, "cal_initbill", initIds);
        }
    }

    private void conditionFour(Set<Long> selectedCostAccountIds, Map<Integer, String> errNotificationMap, Map<String, Map<Integer, List<Object>>> errInfoMap) {
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (!selectedCostAccountIds.isEmpty() && !isNewBalance) {
            BalanceDistinctValidatorHelper helper = new BalanceDistinctValidatorHelper(selectedCostAccountIds);
            helper.mergeDuplicateDimensions();
            Map errOrgAndCostAccount = helper.distinctValidatorReturnError();
            if (errOrgAndCostAccount != null && !errOrgAndCostAccount.isEmpty()) {
                for (Map.Entry entry : errOrgAndCostAccount.entrySet()) {
                    Long orgId = (Long)entry.getKey();
                    Set calCostAccountIds = (Set)entry.getValue();
                    for (Long calCostAccountId : calCostAccountIds) {
                        this.putErrInfo(errInfoMap, orgId, calCostAccountId, errNotificationMap.get(6), 6, null, null);
                    }
                }
            }
        }
    }

    private void conditionFive(Set<Long> selectedCostAccountIds, Map<Integer, String> errNotificationMap, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Long, DynamicObject> cacheCSIdAndCostAccount, Map<Long, DynamicObject> csIdAndParamSetting) {
        QFilter filter = new QFilter("costaccount", "in", selectedCostAccountIds);
        DynamicObjectCollection calAccountParamSettings = QueryServiceHelper.query((String)"cal_accountparams", (String)"costaccount,endinitcheck,endcalinvcheck", (QFilter[])new QFilter[]{filter});
        HashSet<Long> hasAccountSettingCostId = new HashSet<Long>(16);
        for (DynamicObject calAccountParamSetting : calAccountParamSettings) {
            Long costAccountId = calAccountParamSetting.getLong("costaccount");
            if (selectedCostAccountIds.contains(costAccountId)) {
                hasAccountSettingCostId.add(costAccountId);
            }
            csIdAndParamSetting.put(costAccountId, calAccountParamSetting);
        }
        for (Long selectedCostAccountId : selectedCostAccountIds) {
            long orgId;
            DynamicObject costAccountDynamicObject = cacheCSIdAndCostAccount.get(selectedCostAccountId);
            long l = orgId = costAccountDynamicObject == null || costAccountDynamicObject.getDynamicObject("calorg") == null ? 0L : costAccountDynamicObject.getDynamicObject("calorg").getLong("id");
            if (!hasAccountSettingCostId.isEmpty() && hasAccountSettingCostId.contains(selectedCostAccountId)) continue;
            this.putErrInfo(errInfoMap, orgId, selectedCostAccountId, errNotificationMap.get(7), 7, "cal_accountparams", null);
        }
    }

    private void conditionSix(Set<Long> selectedCostAccountIds, Map<Integer, String> errNotificationMap, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Long, DynamicObject> csIdAndParamSetting, DynamicObject[] selectedSysCtrDynamic, Map<Long, Long> conditionSixFailOrgCsId) {
        boolean isNewPeriodInvBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        for (DynamicObject selectedSysCtr : selectedSysCtrDynamic) {
            long orgId = selectedSysCtr.getDynamicObject("org").getLong("id");
            DynamicObjectCollection entrys = selectedSysCtr.getDynamicObjectCollection("entry");
            List invOrgIds = OrgHelper.getStorageOrgUnitByCalOrg((Long)orgId);
            invOrgIds = invOrgIds == null ? new ArrayList(0) : invOrgIds;
            HashSet<Long> set = new HashSet<Long>(selectedCostAccountIds.size());
            for (DynamicObject entry : entrys) {
                String endcalinvcheck;
                DynamicObject costSettingParam;
                DataSet ediffqty;
                long costAccountId = entry.getDynamicObject("costaccount").getLong("id");
                List<Long> ownerIds = Arrays.asList(AccountingSysHelper.getOwners((Long)costAccountId));
                int periodNumber = 0;
                DynamicObject startPeriodDynamic = PeriodHelper.getSysCtrlEntity((Long)costAccountId);
                if (startPeriodDynamic != null) {
                    Long startPeriodId = startPeriodDynamic.getLong("startperiod.id");
                    DynamicObject peirod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)startPeriodId).toArray());
                    periodNumber = peirod.getInt("periodyear") * 100 + peirod.getInt("periodnumber");
                }
                if (set.contains(costAccountId)) continue;
                set.add(costAccountId);
                Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>();
                OrmInput invBgnQtyDataSet = this.getInvBgnQtyDataSet(invOrgIds, periodNumber, isNewPeriodInvBal, ownerIds);
                allBillIOs.add(invBgnQtyDataSet);
                DataSet unionDataSet = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
                unionDataSet.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
                unionDataSet.getRowMeta().getField("invqty").setDataType((DataType)DataType.BigDecimalType);
                unionDataSet.getRowMeta().getField("costaccount").setDataType((DataType)DataType.LongType);
                allBillIOs = new ArrayList();
                if (!isNewBalance) {
                    OrmInput calBalDataSet = this.getCalBalDataSet(invOrgIds, costAccountId, periodNumber, isNewBalance, ownerIds);
                    allBillIOs.add(calBalDataSet);
                    DataSet calBgnDs = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
                    unionDataSet.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
                    unionDataSet.getRowMeta().getField("invqty").setDataType((DataType)DataType.BigDecimalType);
                    unionDataSet.getRowMeta().getField("costaccount").setDataType((DataType)DataType.LongType);
                    unionDataSet = unionDataSet.union(calBgnDs);
                } else {
                    DataSet newCalBgnDs = this.getNewCalBgnDs(invOrgIds, costAccountId, periodNumber, ownerIds);
                    unionDataSet.getRowMeta().getField("calqty").setDataType((DataType)DataType.BigDecimalType);
                    unionDataSet.getRowMeta().getField("invqty").setDataType((DataType)DataType.BigDecimalType);
                    unionDataSet.getRowMeta().getField("costaccount").setDataType((DataType)DataType.LongType);
                    unionDataSet = unionDataSet.union(newCalBgnDs);
                }
                if ((ediffqty = unionDataSet.groupBy(new String[]{"org", "material"}).sum("calqty - invqty", "ediffqty").finish().filter("ediffqty <> 0")).isEmpty()) continue;
                if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_DEBUG_MODEL).booleanValue()) {
                    for (Row row : ediffqty.copy()) {
                        WriteLogHelper.writeInfoLog((Log)logger, (String)"calsystem_inv_cal_bal_not_equal : {}", (Object[])new Object[]{row.getLong("org") + " : " + row.getLong("material") + " : " + row.getBigDecimal("ediffqty")});
                    }
                }
                if ((costSettingParam = csIdAndParamSetting.get(costAccountId)) == null || "A".equals(endcalinvcheck = costSettingParam.getString("endcalinvcheck")) || "B".equals(endcalinvcheck)) continue;
                conditionSixFailOrgCsId.put(costAccountId, orgId);
                ArrayList<Object> linkedObjects = new ArrayList<Object>();
                linkedObjects.add(orgId + "#" + costAccountId);
                this.putErrInfo(errInfoMap, orgId, costAccountId, errNotificationMap.get(11), 11, "cal_invaccount_newrpt", linkedObjects);
            }
        }
    }

    private void putErrInfo(Map<String, Map<Integer, List<Object>>> errInfoMap, Long orgId, Long costAccountId, String errMsg, int errorType, String linkObject, List<Object> linkIds) {
        String key = orgId + "#" + costAccountId;
        Map<Integer, List<Object>> errorTypeAndLogData = errInfoMap.get(key);
        if (errorTypeAndLogData == null) {
            errorTypeAndLogData = new HashMap<Integer, List<Object>>(16);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(errMsg);
            info.add(linkObject);
            info.add(linkIds);
            info.add(errorType);
            errorTypeAndLogData.put(errorType, info);
            errInfoMap.put(key, errorTypeAndLogData);
        } else {
            List<Object> logData = errorTypeAndLogData.get(errorType);
            if (logData == null) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(0, errMsg);
                info.add(1, linkObject);
                info.add(2, linkIds);
                info.add(3, errorType);
                errorTypeAndLogData.put(errorType, info);
            } else {
                logData.set(0, errMsg);
                logData.set(1, linkObject);
                logData.set(2, linkIds);
            }
        }
    }

    private void filterFail(Set<Long> selectedCostAccountIds, Map<String, Map<Integer, List<Object>>> errInfoMap) {
        HashSet<Long> retain = new HashSet<Long>(selectedCostAccountIds);
        HashSet<Long> errCostAccounts = new HashSet<Long>(16);
        Set<String> errOrgAndCostAccounts = errInfoMap.keySet();
        for (String errOrgAndCostAccount : errOrgAndCostAccounts) {
            String[] errOrgAndCostAccountStr = errOrgAndCostAccount.split("#");
            errCostAccounts.add(Long.parseLong(errOrgAndCostAccountStr[1]));
        }
        retain.retainAll(errCostAccounts);
        selectedCostAccountIds.removeAll(retain);
    }

    private void filterFail(Set<Long> selectedCostAccountIds, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Long, DynamicObject> csIdAndParamSetting, Map<Long, DynamicObject> cacheCSIdAndSettingEntry, Map<Long, DynamicObject> cacheCSIdAndCostAccount, Map<String, Map<Long, Map<Long, Long>>> markOrgAndCostAccountAndStartPeriod) {
        HashSet<Long> retain = new HashSet<Long>(selectedCostAccountIds);
        HashSet<Long> errCostAccounts = new HashSet<Long>(16);
        Set<String> errOrgAndCostAccounts = errInfoMap.keySet();
        for (String errOrgAndCostAccount : errOrgAndCostAccounts) {
            String[] errOrgAndCostAccountStr = errOrgAndCostAccount.split("#");
            errCostAccounts.add(Long.parseLong(errOrgAndCostAccountStr[1]));
        }
        retain.retainAll(errCostAccounts);
        selectedCostAccountIds.removeAll(retain);
        for (Long legalCostAccountId : selectedCostAccountIds) {
            DynamicObject paramSetting = csIdAndParamSetting.get(legalCostAccountId);
            if (paramSetting == null) continue;
            String checkLevel = paramSetting.getString("endinitcheck");
            Map<Long, Map<Long, Long>> orgAndCSAndStartPeriod = markOrgAndCostAccountAndStartPeriod.get(checkLevel);
            if (orgAndCSAndStartPeriod == null) {
                orgAndCSAndStartPeriod = new HashMap<Long, Map<Long, Long>>(16);
                HashMap<Long, Long> csAndStartPeriod = new HashMap<Long, Long>(16);
                long startPeriod = cacheCSIdAndSettingEntry.get(legalCostAccountId).getDynamicObject("startperiod").getLong("id");
                csAndStartPeriod.put(legalCostAccountId, startPeriod);
                long calorg = cacheCSIdAndCostAccount.get(legalCostAccountId).getDynamicObject("calorg").getLong("id");
                orgAndCSAndStartPeriod.put(calorg, csAndStartPeriod);
                markOrgAndCostAccountAndStartPeriod.put(checkLevel, orgAndCSAndStartPeriod);
                continue;
            }
            long calorg = cacheCSIdAndCostAccount.get(legalCostAccountId).getDynamicObject("calorg").getLong("id");
            long startPeriod = cacheCSIdAndSettingEntry.get(legalCostAccountId).getDynamicObject("startperiod").getLong("id");
            Map<Long, Long> csAndStartPeriod = orgAndCSAndStartPeriod.get(calorg);
            if (csAndStartPeriod != null && !csAndStartPeriod.isEmpty()) {
                csAndStartPeriod.put(legalCostAccountId, startPeriod);
                continue;
            }
            csAndStartPeriod = new HashMap<Long, Long>(16);
            csAndStartPeriod.put(legalCostAccountId, startPeriod);
            orgAndCSAndStartPeriod.put(calorg, csAndStartPeriod);
        }
    }

    private void preInit(List<Object> selectedIds, Map<String, Map<Long, Map<Long, Long>>> markOrgAndCostAccountAndStartPeriod, Map<Long, DynamicObject> cacheCSIdAndSetting, Map<Long, DynamicObject> cacheCSIdAndCostAccount, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Integer, String> errNotificationMap, Map<Long, Long> conditionSixFailCsIdOrgId) {
        this.validateInit(selectedIds, markOrgAndCostAccountAndStartPeriod, cacheCSIdAndSetting, cacheCSIdAndCostAccount, errInfoMap, errNotificationMap, conditionSixFailCsIdOrgId);
        this.readyInit(markOrgAndCostAccountAndStartPeriod);
    }

    private Map<String, Map<Long, Map<Long, Long>>> validateInit(List<Object> ids, Map<String, Map<Long, Map<Long, Long>>> markOrgAndCostAccountAndStartPeriod, Map<Long, DynamicObject> cacheCSIdAndSettingEntry, Map<Long, DynamicObject> cacheCSIdAndCostAccount, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Integer, String> errNotificationMap, Map<Long, Long> conditionSixFailCsIdOrgId) {
        DynamicObject[] selectedData;
        HashSet<Long> selectedCostAccountIds = new HashSet<Long>(16);
        QFilter periodFilter = new QFilter("id", "in", ids);
        for (DynamicObject row : selectedData = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)"id,org,entry.costaccount,entry.startperiod,entry.currentperiod,entry.isenabled", (QFilter[])new QFilter[]{periodFilter}, null)) {
            Long orgId = row.getDynamicObject("org").getLong("id");
            Long curId = row.getLong("id");
            DynamicObjectCollection entrys = row.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                ArrayList<Object> linkIds;
                Long costAccountId = entry.getDynamicObject("costaccount") == null ? 0L : entry.getDynamicObject("costaccount").getLong("id");
                Long startPeriodId = entry.getDynamicObject("startperiod") == null ? 0L : entry.getDynamicObject("startperiod").getLong("id");
                Long currentPeriodId = entry.getDynamicObject("currentperiod") == null ? 0L : entry.getDynamicObject("currentperiod").getLong("id");
                Boolean isenabled = entry.getBoolean("isenabled");
                if (startPeriodId == null || startPeriodId == 0L) {
                    linkIds = new ArrayList<Object>(16);
                    linkIds.add(curId);
                    this.putErrInfo(errInfoMap, orgId, costAccountId, errNotificationMap.get(2), 2, "cal_sysctrlentity", linkIds);
                }
                if (isenabled.booleanValue() && currentPeriodId != null && currentPeriodId != 0L) {
                    linkIds = new ArrayList(16);
                    linkIds.add(curId);
                    this.putErrInfo(errInfoMap, orgId, costAccountId, errNotificationMap.get(3), 2, "cal_sysctrlentity", linkIds);
                }
                selectedCostAccountIds.add(costAccountId);
                cacheCSIdAndSettingEntry.put(costAccountId, entry);
            }
        }
        this.cacheCostAccountId(cacheCSIdAndCostAccount, selectedCostAccountIds);
        HashMap<Long, DynamicObject> csIdAndParamSetting = new HashMap<Long, DynamicObject>(16);
        this.conditionThree(selectedCostAccountIds, errNotificationMap, errInfoMap);
        this.conditionFour(selectedCostAccountIds, errNotificationMap, errInfoMap);
        this.conditionFive(selectedCostAccountIds, errNotificationMap, errInfoMap, cacheCSIdAndCostAccount, csIdAndParamSetting);
        this.conditionSix(selectedCostAccountIds, errNotificationMap, errInfoMap, csIdAndParamSetting, selectedData, conditionSixFailCsIdOrgId);
        long curUserId = RequestContext.get().getCurrUserId();
        List userPermOrgs = PermissionHelper.getUserPermOrgs((Long)curUserId, (String)"cal_periodsettinglog", (String)"47156aff000000ac");
        if (userPermOrgs == null) {
            // empty if block
        }
        this.filterFail(selectedCostAccountIds, errInfoMap, csIdAndParamSetting, cacheCSIdAndSettingEntry, cacheCSIdAndCostAccount, markOrgAndCostAccountAndStartPeriod);
        return markOrgAndCostAccountAndStartPeriod;
    }

    private void readyInit(Map<String, Map<Long, Map<Long, Long>>> markOrgAndCostAccountAndStartPeriod) {
        Map<Object, Object> bLevel = new HashMap(16);
        for (Map.Entry<String, Map<Long, Map<Long, Long>>> entry : markOrgAndCostAccountAndStartPeriod.entrySet()) {
            String level = entry.getKey();
            Map<Long, Map<Long, Long>> orgAndCostAccountAndStartPeriod = entry.getValue();
            if (!"B".equals(level)) continue;
            bLevel = orgAndCostAccountAndStartPeriod;
        }
        if (!bLevel.isEmpty()) {
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            for (Map.Entry entry : bLevel.entrySet()) {
                Map costAccountAndStartPeriod = (Map)entry.getValue();
                for (Map.Entry csEntry : costAccountAndStartPeriod.entrySet()) {
                    Long costAccountId = (Long)csEntry.getKey();
                    costAccountIds.add(costAccountId);
                }
            }
            this.initFinish(costAccountIds);
        }
    }

    private void uninitFinish(Set<Long> successCostAccount) {
        if (successCostAccount.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long costAccountId : successCostAccount) {
            params.add(new Object[]{costAccountId});
        }
        String sql = "update t_cal_systemctrlentry set fcurrentperiodid = 0,fisenabled = '0' where fcostaccountid = ? ";
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, params);
    }

    private void initFinish(Set<Long> successCostAccount) {
        if (successCostAccount.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long costAccountId : successCostAccount) {
            params.add(new Object[]{costAccountId});
        }
        String sql = "update t_cal_systemctrlentry set fcurrentperiodid = fstartperiodid,fisenabled = '1' where fcostaccountid = ? ";
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, params);
    }

    private void insertOrIgnoreSuccPeriodSettingLog(Set<Long> successCostAccount, Map<Long, DynamicObject> csIdAndCostAccount, Long curUserId, String curOperation) {
        ArrayList<DynamicObject> succLogs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> existSucctLogs = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> existLogMap = new HashMap<String, DynamicObject>(16);
        QFilter costAccountFilter = new QFilter("costaccount", "in", successCostAccount);
        QFilter successFilter = new QFilter("issuccess", "=", (Object)"1");
        DynamicObject[] existLogs = BusinessDataServiceHelper.load((String)"cal_periodsettinglog", (String)"id,calorg,costaccount,operation,issuccess,operationtime,operationuser,log,log_tag,faillink,linkbillobject,linkids,linkids_tag,errortype", (QFilter[])new QFilter[]{costAccountFilter, successFilter}, null);
        for (DynamicObject existLog : existLogs) {
            long costAccountId = existLog.getDynamicObject("costaccount").getLong("id");
            Integer errorType = existLog.getInt("errortype");
            String key = costAccountId + "#" + errorType;
            existLogMap.put(key, existLog);
        }
        for (Long costAccountId : successCostAccount) {
            int operation = -1;
            String log = "";
            if ("init".equals(curOperation)) {
                operation = 0;
                log = ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_37", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            } else if ("uninit".equals(curOperation)) {
                operation = 1;
                log = ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"CalSystemCtrlEditUIPlugin_38", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            }
            String curKey = costAccountId + "#" + operation;
            if (operation == -1 || existLogMap.containsKey(curKey)) {
                DynamicObject existLog = (DynamicObject)existLogMap.get(curKey);
                existLog.set("operationtime", (Object)TimeServiceHelper.now());
                existLog.set("operationuser", (Object)curUserId);
                existLog.set("log_tag", (Object)log);
                existSucctLogs.add(existLog);
                continue;
            }
            DynamicObject costAccountObject = csIdAndCostAccount.get(costAccountId);
            Long orgId = costAccountObject.getDynamicObject("calorg").getLong("id");
            DynamicObject periodSettingLog = BusinessDataServiceHelper.newDynamicObject((String)"cal_periodsettinglog");
            periodSettingLog.set("calorg", (Object)orgId);
            periodSettingLog.set("costaccount", (Object)costAccountId);
            periodSettingLog.set("operation", (Object)"1");
            periodSettingLog.set("issuccess", (Object)"1");
            periodSettingLog.set("operationtime", (Object)TimeServiceHelper.now());
            periodSettingLog.set("operationuser", (Object)curUserId);
            periodSettingLog.set("log", (Object)log);
            periodSettingLog.set("log_tag", (Object)log);
            periodSettingLog.set("linkbillobject", (Object)"");
            periodSettingLog.set("linkids", null);
            periodSettingLog.set("errortype", (Object)operation);
            periodSettingLog.set("faillink", (Object)"");
            succLogs.add(periodSettingLog);
        }
        SaveServiceHelper.save((DynamicObject[])succLogs.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])existSucctLogs.toArray(new DynamicObject[0]));
    }

    private String createErrDetail(Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Long, DynamicObject> csIdAndCostAccount) {
        StringBuilder all = new StringBuilder();
        if (errInfoMap.isEmpty()) {
            return all.toString();
        }
        for (Map.Entry<String, Map<Integer, List<Object>>> entry : errInfoMap.entrySet()) {
            String key = entry.getKey();
            String[] orgAndCostAccount = key.split("#");
            Long costAccountId = Long.parseLong(orgAndCostAccount[1]);
            StringBuilder sb = new StringBuilder();
            Map<Integer, List<Object>> costAccountAndLog = entry.getValue();
            for (Map.Entry<Integer, List<Object>> costAccountAndLogEntry : costAccountAndLog.entrySet()) {
                List<Object> log = costAccountAndLogEntry.getValue();
                DynamicObject costAccountObject = csIdAndCostAccount.get(costAccountId);
                String costAccountName = costAccountObject.getString("name");
                String orgName = costAccountObject.getString("calorg.name");
                sb.append(orgName).append(costAccountName).append("  \uff1a ").append(log.get(0));
            }
            all.append((CharSequence)sb).append("\r\n");
        }
        return all.substring(0, all.length() - 2);
    }

    private void preUninit(List<Object> selectedIds, Set<Long> costAccountIds, Map<Long, DynamicObject> csIdAndCostAccount, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Integer, String> errNotificationMap) {
        this.validateUninit(selectedIds, costAccountIds, csIdAndCostAccount, errInfoMap, errNotificationMap);
        this.readyUninit(costAccountIds);
    }

    private void validateUninit(List<Object> selectedIds, Set<Long> costAccountIds, Map<Long, DynamicObject> cacheCSIdAndCostAccount, Map<String, Map<Integer, List<Object>>> errInfoMap, Map<Integer, String> errNotificationMap) {
        QFilter periodFilter = new QFilter("id", "in", selectedIds);
        DynamicObject[] selectedData = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)"id,org,entry.costaccount,entry.startperiod,entry.currentperiod,entry.isenabled", (QFilter[])new QFilter[]{periodFilter}, null);
        HashSet<Long> selectedCostAccountIds = new HashSet<Long>(16);
        for (DynamicObject row : selectedData) {
            Long orgId = row.getDynamicObject("org").getLong("id");
            Long curId = row.getLong("id");
            DynamicObjectCollection entrys = row.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                ArrayList<Object> linkIds;
                Long costAccountId = entry.getDynamicObject("costaccount") == null ? 0L : entry.getDynamicObject("costaccount").getLong("id");
                Long startPeriodId = entry.getDynamicObject("startperiod") == null ? 0L : entry.getDynamicObject("startperiod").getLong("id");
                Long currentPeriodId = entry.getDynamicObject("currentperiod") == null ? 0L : entry.getDynamicObject("currentperiod").getLong("id");
                Boolean isenabled = entry.getBoolean("isenabled");
                selectedCostAccountIds.add(costAccountId);
                if (!isenabled.booleanValue()) {
                    linkIds = new ArrayList<Object>(16);
                    linkIds.add(curId);
                    this.putErrInfo(errInfoMap, orgId, costAccountId, errNotificationMap.get(10), 10, "cal_sysctrlentity", linkIds);
                }
                if (startPeriodId == null || startPeriodId == 0L || currentPeriodId != null && currentPeriodId != 0L && !startPeriodId.equals(currentPeriodId)) {
                    linkIds = new ArrayList(16);
                    linkIds.add(curId);
                    this.putErrInfo(errInfoMap, orgId, costAccountId, errNotificationMap.get(9), 9, "cal_sysctrlentity", linkIds);
                }
                costAccountIds.add(costAccountId);
            }
        }
        this.cacheCostAccountId(cacheCSIdAndCostAccount, selectedCostAccountIds);
        this.filterFail(costAccountIds, errInfoMap);
    }

    private void readyUninit(Set<Long> costAccountIds) {
        this.uninitFinish(costAccountIds);
    }

    private void linkLog() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] indexs = selectedRows.getPrimaryKeyValues();
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        if (indexs != null && indexs.length != 0) {
            QFilter periodFilter = new QFilter("id", "in", Arrays.asList(indexs));
            DynamicObject[] selectedData = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)"id,org.name,org,entry.costaccount,entry.startperiod,entry.currentperiod,entry.isenabled", (QFilter[])new QFilter[]{periodFilter}, null);
            HashMap<Long, DynamicObject> orgIdAndHeadDynamic = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, DynamicObjectCollection> orgIdAndEntryDynamic = new HashMap<Long, DynamicObjectCollection>(16);
            for (DynamicObject row : selectedData) {
                long orgId = row.getDynamicObject("org").getLong("id");
                DynamicObject org = row.getDynamicObject("org");
                orgIdAndHeadDynamic.put(orgId, org);
                DynamicObjectCollection entrys = row.getDynamicObjectCollection("entry");
                orgIdAndEntryDynamic.put(orgId, entrys);
            }
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            List permOrgs = PermissionHelper.getUserPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"cal_periodsettinglog", (String)"47150e89000000ac");
            if (permOrgs != null) {
                Set orgIds = orgIdAndHeadDynamic.keySet();
                HashSet copyForValidate = new HashSet(orgIds);
                copyForValidate.retainAll(permOrgs);
                if (copyForValidate.isEmpty() && !orgIds.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry e : orgIdAndHeadDynamic.entrySet()) {
                        DynamicObject orgDynamic = (DynamicObject)e.getValue();
                        if (orgDynamic == null) continue;
                        sb.append(orgDynamic.getString("name")).append(",");
                    }
                    String curContent = "";
                    if (sb.length() > 0) {
                        curContent = sb.substring(0, sb.length() - 1);
                    }
                    String warn = ResManager.loadKDString((String)"\u4f60\u65e0\u201c%1$S\u201d\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u65e5\u5fd7\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"CalSystemCtrlEditUIPlugin_55", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                    String content = String.format(warn, curContent);
                    this.getView().showTipNotification(content);
                    return;
                }
                for (Long legalOrgId : copyForValidate) {
                    DynamicObjectCollection entrys = (DynamicObjectCollection)orgIdAndEntryDynamic.get(legalOrgId);
                    for (DynamicObject entry : entrys) {
                        costAccountIds.add(entry.getDynamicObject("costaccount") == null ? 0L : entry.getDynamicObject("costaccount").getLong("id"));
                    }
                }
            } else {
                for (DynamicObjectCollection entrys : orgIdAndEntryDynamic.values()) {
                    for (DynamicObject entry : entrys) {
                        DynamicObject costaccountDynamic = entry.getDynamicObject("costaccount");
                        costAccountIds.add(costaccountDynamic == null ? 0L : costaccountDynamic.getLong("id"));
                    }
                }
            }
            HashSet<Long> pkIds = new HashSet<Long>(16);
            DynamicObjectCollection errLogInfos = QueryServiceHelper.query((String)"cal_periodsettinglog", (String)"id", (QFilter[])new QFilter[]{new QFilter("costaccount", "in", costAccountIds)});
            for (DynamicObject errLogInfo : errLogInfos) {
                long id = errLogInfo.getLong("id");
                if (id == 0L || !pkIds.add(id)) continue;
                linkQueryPkIdCollection.addLinkQueryPkId((Object)id);
            }
            showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        }
        showParameter.setBillFormId("cal_periodsettinglog");
        showParameter.setAppId("cal");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Set<Long> validateSet() {
        String content;
        StringBuilder sb;
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] indexs = selectedRows.getPrimaryKeyValues();
        Set<Object> costAccounts = new HashSet(16);
        HashSet<Long> calOrgs = new HashSet<Long>(16);
        HashMap<Long, String> orgAndName = new HashMap<Long, String>(16);
        HashMap<Long, String> csAndName = new HashMap<Long, String>(16);
        HashSet<Long> selectedPermOrgs = new HashSet<Long>(16);
        HashSet<Long> selectedCostAccounts = new HashSet<Long>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        List userPermOrgs = PermissionHelper.getUserPermOrgs((Long)currUserId, (String)"cal_sysctrlentity", (String)"47156aff000000ac");
        if (indexs == null || indexs.length == 0) {
            if (userPermOrgs == null || userPermOrgs.isEmpty()) {
                costAccounts = this.getAllCostAccount();
            } else {
                for (Long orgId : userPermOrgs) {
                    calOrgs.add(orgId);
                }
                this.getCostAccount(costAccounts, calOrgs);
            }
        } else {
            sb = new StringBuilder();
            boolean error = false;
            HashSet<Object> selectedIds = new HashSet<Object>(16);
            for (Object index : indexs) {
                selectedIds.add(index);
            }
            QFilter periodFilter = new QFilter("id", "in", selectedIds);
            DynamicObject[] selectedData = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)"id,org,entry.costaccount,entry.startperiod,entry.currentperiod,entry.isenabled", (QFilter[])new QFilter[]{periodFilter}, null);
            for (DynamicObject row : selectedData) {
                Long orgId = row.getDynamicObject("org") == null ? 0L : row.getDynamicObject("org").getLong("id");
                orgAndName.put(orgId, row.getDynamicObject("org") == null ? "" : row.getDynamicObject("org").getString("name"));
                selectedPermOrgs.add(orgId);
                DynamicObjectCollection entrys = row.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    Long costAccountId = entry.getDynamicObject("costaccount") == null ? 0L : entry.getDynamicObject("costaccount").getLong("id");
                    String costAccountName = entry.getDynamicObject("costaccount") == null ? "" : entry.getDynamicObject("costaccount").getString("name");
                    csAndName.put(costAccountId, costAccountName);
                    selectedCostAccounts.add(costAccountId);
                }
            }
            if (userPermOrgs == null) {
                error = false;
                for (Long selectedPermOrg : selectedPermOrgs) {
                    calOrgs.add(selectedPermOrg);
                }
            }
            if (userPermOrgs != null && userPermOrgs.size() != 0) {
                for (Long selectPermOrg : selectedPermOrgs) {
                    if (!userPermOrgs.contains(selectPermOrg)) {
                        if (!error) {
                            error = true;
                        }
                        sb.append((String)orgAndName.get(selectPermOrg)).append(",");
                        continue;
                    }
                    calOrgs.add(selectPermOrg);
                }
            }
            if (!calOrgs.isEmpty()) {
                this.getCostAccount(costAccounts, calOrgs);
            }
            if (error && sb.length() != 0) {
                content = sb.toString().substring(0, sb.length() - 1);
                String warn = ResManager.loadKDString((String)"\u4f60\u65e0\u201c%1$S\u201d\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"CalSystemCtrlEditUIPlugin_49", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                String errMsg = String.format(warn, content);
                throw new KDBizException(errMsg);
            }
        }
        if (costAccounts != null && !costAccounts.isEmpty()) {
            HashSet<Long> existCostAccountIds = new HashSet<Long>(16);
            QFilter costAccountFilter = new QFilter("entry.costaccount", "in", costAccounts);
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,org,entry.costaccount,entry.startperiod,entry.currentperiod,entry.isenabled", (QFilter[])new QFilter[]{costAccountFilter}, null);
            boolean hasLegalData = false;
            for (Object row : rows) {
                existCostAccountIds.add(row.getLong("entry.costaccount"));
                boolean initFinish = row.getBoolean("entry.isenabled");
                if (initFinish) continue;
                hasLegalData = true;
                break;
            }
            if (existCostAccountIds.size() == costAccounts.size() && !hasLegalData) {
                if (!selectedCostAccounts.isEmpty() && !costAccounts.isEmpty()) {
                    selectedCostAccounts.removeAll(costAccounts);
                    if (!selectedCostAccounts.isEmpty()) {
                        StringBuilder disableStringBuilder = new StringBuilder();
                        for (Long selectedCostAccount : selectedCostAccounts) {
                            String csName = (String)csAndName.get(selectedCostAccount);
                            disableStringBuilder.append(csName).append(",");
                        }
                        content = "";
                        if (disableStringBuilder.length() > 0) {
                            content = disableStringBuilder.substring(0, disableStringBuilder.length() - 1);
                        }
                        String errMsg = String.format(ResManager.loadKDString((String)"\u8d26\u7c3f%1$s\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u5230\u7f16\u8f91\u754c\u9762\u70b9\u51fb\u201c\u540c\u6b65\u8d26\u7c3f\u201d\uff0c\u66f4\u65b0\u6700\u65b0\u6570\u636e\u3002", (String)"CalSystemCtrlEditUIPlugin_57", (String)"fi-cal-formplugin", (Object[])new Object[0]), content);
                        throw new KDBizException(errMsg);
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5df2\u5168\u90e8\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CalSystemCtrlEditUIPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5df2\u5168\u90e8\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CalSystemCtrlEditUIPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        }
        if (costAccounts == null || costAccounts.size() == 0) {
            if (indexs == null || indexs.length == 0) {
                ResManager.loadKDString((String)"\u6ca1\u6709\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"CalSystemCtrlEditUIPlugin_56", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            } else if (!orgAndName.isEmpty()) {
                sb = new StringBuilder();
                for (String orgName : orgAndName.values()) {
                    sb.append(orgName).append(",");
                }
                String content2 = "";
                if (sb.length() > 0) {
                    content2 = sb.substring(0, sb.length() - 1);
                }
                String warn = ResManager.loadKDString((String)"\u4f60\u65e0\u201c%1$S\u201d\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"CalSystemCtrlEditUIPlugin_49", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                String errMsg = String.format(warn, content2);
                throw new KDBizException(errMsg);
            }
        }
        return costAccounts;
    }

    private void getCostAccount(Set<Long> costAccountIds, Set<Long> orgIds) {
        QFilter qs = new QFilter("calorg.id", "in", orgIds);
        qs.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg.id,id,calpolicy.id", (QFilter[])new QFilter[]{qs});
        if (costAccounts == null || costAccounts.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5df2\u5168\u90e8\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CalSystemCtrlEditUIPlugin_18", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject costAccount : costAccounts) {
            long costAccountId = costAccount.getLong("id");
            costAccountIds.add(costAccountId);
        }
    }

    private Set<Long> getAllCostAccount() {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
        QFilter stateFilter = new QFilter("enable", "=", (Object)"1");
        DataSet allCostAccount = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])new QFilter[]{q, stateFilter}, null);
        for (Row row : allCostAccount) {
            Long costAccountId = row.getLong("id");
            costAccountIds.add(costAccountId);
        }
        return costAccountIds;
    }

    private void linkShowConfirmPage(List<Long> successCostAccounts, List<Long> failCostAccounts, Map<Long, Map<Long, String>> showAList, String page, String errDetail) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("cal");
        showParameter.setFormId(page);
        showParameter.setCustomParam(CONFIRM_SUCCESS, successCostAccounts);
        showParameter.setCustomParam(CONFIRM_FAIL, failCostAccounts);
        showParameter.setCustomParam(CONFIRM_FAIL_DATA, showAList);
        showParameter.setCustomParam(CONFIRM_FAIL_DETAIL, (Object)errDetail);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_AFTER_CONFIRM));
        this.getView().showForm(showParameter);
    }

    private void linkResultPage(List<Long> successCostAccounts, List<Long> failCostAccounts, String page, String errDetail, String operation) {
        if (StringUtils.isEmpty((String)page)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("cal");
        showParameter.setFormId(page);
        showParameter.setCustomParam(CONFIRM_SUCCESS, successCostAccounts);
        showParameter.setCustomParam(CONFIRM_FAIL, failCostAccounts);
        showParameter.setCustomParam(CONFIRM_FAIL_DETAIL, (Object)errDetail);
        String title = "";
        switch (operation) {
            case "init": 
            case "confirm": {
                title = ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u63d0\u793a\u3002", (String)"CalSystemCtrlEditUIPlugin_41", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                break;
            }
            case "uninit": {
                title = ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u63d0\u793a\u3002", (String)"CalSystemCtrlEditUIPlugin_42", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                break;
            }
            case "batchset": {
                title = ResManager.loadKDString((String)"\u6279\u91cf\u8bbe\u7f6e\u63d0\u793a", (String)"CalSystemCtrlEditUIPlugin_52", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            }
        }
        showParameter.setCustomParam("confirm_operation", (Object)operation);
        showParameter.setCaption(title);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "cal_result_callback"));
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        super.confirmCallBack(e);
        String value = e.getResultValue();
        if (MessageBoxResult.Yes.name().equals(value) && "setAccountParams".equals(key = e.getCallBackId())) {
            this.showBatchAddParamsView();
        }
    }

    private void showBatchAddParamsView() {
        String s = this.getPageCache().get(NOT_SET_ACCOUNT_PARAMS_COST_ACCOUNT_IDS);
        String caption = ResManager.loadKDString((String)"\u65b0\u589e", (String)"CalAccountParamsListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        ShowAccountParamsModifyViewHelper.showModifyView("batchadd", caption, s, (AbstractFormPlugin)this);
    }

    protected OrmInput getInvBgnQtyDataSet(List<Long> invOrgs, int periodNumber, boolean isNewPeriodBal, List<Long> ownerIds) {
        String selectFields = this.getInvBalanceSelector(isNewPeriodBal);
        QFilter filter = new QFilter("org", "in", invOrgs);
        filter.and(new QFilter("owner", "in", ownerIds));
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        QFilter periodf = new QFilter("period", "<", (Object)periodNumber);
        periodf.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        filter.and(periodf);
        if (!isNewPeriodBal) {
            filter.and(new QFilter("balancetype", "=", (Object)"2"));
        }
        String entityName = "im_invbalance";
        if (isNewPeriodBal) {
            entityName = "im_cal_periodbalance";
        }
        OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + "getInvBalanceDataSet", entityName, selectFields, new QFilter[]{filter});
        return billIO;
    }

    protected DataSet getNewCalBgnDs(List<Long> invOrgIds, Long costAccount, int periodNumber, List<Long> ownerIds) {
        QFilter filter = new QFilter("storageorgunit", "in", invOrgIds);
        filter.and(new QFilter("owner", "in", ownerIds));
        QFilter periodf = new QFilter("period", "<", (Object)periodNumber);
        periodf.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        filter.and(periodf);
        filter.and(new QFilter("costaccount", "=", (Object)costAccount));
        String dimStr = CalBalanceModelHelper.getDimFields((boolean)false);
        String selects = dimStr + ",material.number,baseqty_bal,baseunit";
        DataSet calBalDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "getCalBgnDs"), (String)"cal_bal", (String)selects, (QFilter[])new QFilter[]{filter}, null);
        ArrayList<String> groupDims = new ArrayList<String>(Arrays.asList(dimStr.split(",")));
        groupDims.add("baseunit");
        groupDims.add("storageorgunit");
        String selectFields = "storageorgunit as org, material,0 as invqty,baseqty_bal as calqty,costaccount";
        calBalDs = calBalDs.groupBy(groupDims.toArray(new String[0])).max("baseqty_bal").finish().select(selectFields);
        return calBalDs;
    }

    protected DataSet getInvBgnQtyDataSet(Long orgId, Long period, boolean isNewPeriodBal) {
        String selectFields = this.getInvBalanceSelector(isNewPeriodBal);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        QFilter periodf = new QFilter("period", "<", (Object)period);
        periodf.and(new QFilter("endperiod", ">=", (Object)period));
        filter.and(periodf);
        if (!isNewPeriodBal) {
            filter.and(new QFilter("balancetype", "=", (Object)"2"));
        }
        String entityName = "im_invbalance";
        if (isNewPeriodBal) {
            entityName = "im_cal_periodbalance";
        }
        DataSet billIO = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "getInvBalanceDataSet"), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        return billIO;
    }

    private String getInvBalanceSelector(boolean isNewPeriodBal) {
        StringBuilder sb = new StringBuilder();
        sb.append("org,");
        sb.append("material,");
        if (isNewPeriodBal) {
            sb.append("baseqty_bal as invqty, 0 as calqty, 0L as costaccount");
        } else {
            sb.append("endbaseqty as invqty, 0 as calqty, 0L as costaccount");
        }
        return sb.toString();
    }

    protected OrmInput getCalBalDataSet(List<Long> invOrgIds, Long costAccount, int periodNumber, boolean isNewCalBal, List<Long> ownerIds) {
        QFilter filter = new QFilter("storageorgunit", "in", invOrgIds);
        filter.and(new QFilter("owner", "in", ownerIds));
        filter.and("costaccount", "=", (Object)costAccount);
        filter.and("period", "<", (Object)periodNumber);
        filter.and("endperiod", ">=", (Object)periodNumber);
        String curField = "storageorgunit as org, material,0 as invqty,periodendqty as calqty,costaccount";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_balance", curField);
        rowMeta.getField("invqty").setDataType((DataType)DataType.BigDecimalType);
        OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_balance", curField, new QFilter[]{filter}, rowMeta);
        return billIO;
    }

    protected DataSet getInitBillDataSet(Long orgId, Long costAccount, Long period, boolean query) {
        QFilter filter = new QFilter("calorg", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccount);
        filter.and(new QFilter("period", "=", (Object)period));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet billIO = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "getInvBalanceDataSet"), (String)"cal_initbill", (String)"calorg as org,entryentity.material as material,0 as invqty,entryentity.baseqty as calqty,costaccount", (QFilter[])new QFilter[]{filter}, null);
        return billIO;
    }
}

