/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.formplugin.setting.accountparams.ShowAccountParamsModifyViewHelper;

public class CalSystemCtrlLogListPlugin
extends AbstractListPlugin {
    private static final String CAL_ACCOUNT_PARAMSETTING_CALLBACK = "callback_log_cal_accountparamssetting";
    private static final String CAL_PARAM_SETTING_PK = "753692010191415296";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection allRowCollection = list.getCurrentListAllRowCollection();
        int selectRowIndex = args.getRowIndex();
        int pageRows = list.getEntryState().getPageRows();
        int pageIndex = list.getEntryState().getCurrentPageIndex();
        if (pageIndex > 1) {
            selectRowIndex -= pageRows * (pageIndex - 1);
        }
        Object selectEntryPkId = allRowCollection.get(selectRowIndex).getPrimaryKeyValue();
        DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)selectEntryPkId, (String)"cal_periodsettinglog", (String)"id,calorg,costaccount,linkbillobject,linkids,linkids_tag,log");
        String log = billInfo.getString("log");
        String billObject = billInfo.getString("linkbillobject");
        String billIds = billInfo.getString("linkids_tag");
        String errorMsg = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0e\u6838\u7b97\u7684\u671f\u521d\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"CalSystemCtrlEditUIPlugin_71", (String)"fi-cal-formplugin", (Object[])new Object[0]);
        if (!StringUtils.isEmpty((String)log) && errorMsg.equals(log)) {
            if (StringUtils.isEmpty((String)billIds)) {
                return;
            }
            List linkIds = SerializationUtils.fromJsonStringToList((String)billIds, String.class);
            if (linkIds == null) {
                return;
            }
            for (Object linkId : linkIds) {
                String orgAndCostAccountId = (String)linkId;
                if (StringUtils.isEmpty((String)orgAndCostAccountId)) {
                    return;
                }
                String[] split = orgAndCostAccountId.split("#");
                Long orgId = Long.valueOf(split[0]);
                Long costAccountId = Long.valueOf(split[1]);
                ReportQueryParam queryParam = new ReportQueryParam();
                FilterInfo filterInfo = new FilterInfo();
                DynamicObject costaccountDynamic = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_bd_costaccount"));
                costaccountDynamic.set("id", (Object)costAccountId);
                filterInfo.addFilterItem("costaccount", (Object)costaccountDynamic);
                DynamicObject calOrgDynamic = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
                calOrgDynamic.set("id", (Object)orgId);
                DynamicObjectCollection calOrgcoll = new DynamicObjectCollection();
                calOrgcoll.add((Object)calOrgDynamic);
                filterInfo.addFilterItem("mulstorageorg", (Object)calOrgcoll);
                QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                qFilter.and("entry.costaccount", "=", (Object)costAccountId);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org,entry.costaccount,entry.startperiod,entry.currentperiod", (QFilter[])new QFilter[]{qFilter}, null);
                if (query == null || query.size() == 0) {
                    return;
                }
                DynamicObject entry = (DynamicObject)query.get(0);
                Long startperiodId = entry.getLong("entry.startperiod");
                Date[] periodStartAndEndTime = PeriodHelper.getPeriodStartAndEndTime((Long)startperiodId);
                Date enddate = periodStartAndEndTime[1];
                filterInfo.addFilterItem("enddate", (Object)enddate);
                filterInfo.addFilterItem("isonlydiff", (Object)Boolean.TRUE);
                queryParam.setFilter(filterInfo);
                ReportShowParameter showParameter = new ReportShowParameter();
                showParameter.setFormId(billObject);
                showParameter.setQueryParam(queryParam);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("cal_accountparams".equals(billObject)) {
            String caption = ResManager.loadKDString((String)"\u65b0\u589e", (String)"CalAccountParamsListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]);
            ShowAccountParamsModifyViewHelper.showModifyView("batchadd", caption, billInfo.getString("costaccount_id"), (AbstractFormPlugin)this);
        } else {
            if (StringUtils.isEmpty((String)billIds)) {
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            HashSet<Long> ids = new HashSet<Long>(16);
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            List linkIds = SerializationUtils.fromJsonStringToList((String)billIds, Long.TYPE);
            for (Object linkId : linkIds) {
                Long id = (Long)linkId;
                if (id == 0L) continue;
                linkQueryPkIdCollection.addLinkQueryPkId((Object)id);
                ids.add(id);
            }
            if (ids.isEmpty()) {
                return;
            }
            QFilter filter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setBillFormId(billObject);
            showParameter.setAppId("cal");
            showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }
}

