/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.setting;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;

public class ChangeEstimatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billno"});
        this.addF7Listener(this, "costaccount", "calorg", "period");
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "billno".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showStoragebillnos(key);
        }
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_changeestimate");
        if (calOrgId != null && calOrgId != 0L) {
            String nowchargetype;
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged();
            }
            if ((nowchargetype = (String)ParamsHelper.getAppParam((long)calOrgId, (String)"dischargetype")) != null) {
                this.getModel().setValue("nowchargetype", (Object)nowchargetype);
            } else {
                this.getModel().setValue("nowchargetype", null);
            }
        }
        this.getModel().setValue("bizentityobject", (Object)new Object[]{((DynamicObject)CommonSettingHelper.getSettingObj().getDynamicObjectCollection("purbiztype").get(0)).get("fbasedataid_id")});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("calorg".equals(key)) {
            this.calOrgChanged();
        } else if ("period".equals(key)) {
            this.periodChange();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("calorg".equals(key)) {
            this.beforeF7Select4Calorg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("period".equals(key)) {
            this.beforeF7Select4Period(e);
        }
    }

    private void beforeF7Select4Calorg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_transactiondetailrpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg != null) {
            q = new QFilter("calorg", "=", calOrg.getPkValue());
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void calOrgChanged() {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getModel().setValue("nowchargetype", null);
            this.getModel().setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
            String nowchargetype = (String)ParamsHelper.getAppParam((long)((Long)calOrg.getPkValue()), (String)"dischargetype");
            if (nowchargetype != null) {
                this.getModel().setValue("nowchargetype", (Object)nowchargetype);
            } else {
                this.getModel().setValue("nowchargetype", null);
            }
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        this.getModel().setValue("period", period == null ? period : period.getPkValue());
        this.periodChange();
    }

    private void periodChange() {
        this.getModel().setValue("starttime", null);
        this.getModel().setValue("endtime", null);
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
        if (period != null) {
            this.getModel().setValue("starttime", (Object)period.getDate("begindate"));
            this.getModel().setValue("endtime", (Object)period.getDate("enddate"));
        }
        this.getView().updateView("starttime");
        this.getView().updateView("endtime");
    }

    private void showStoragebillnos(String actionId) {
        IFormView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("cal_billnos");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", " ");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }
}

